/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.opensearch.plugin.websocket;

import de.virtimo.bpc.opensearch.plugin.utils.StringUtil;
import de.virtimo.bpc.opensearch.plugin.websocket.WebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.WebsocketMessageException;
import de.virtimo.bpc.opensearch.plugin.websocket.message.BroadcastToAllExceptSenderWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.BroadcastToAllWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.BroadcastToWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.BroadcastWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.IndexCreatedWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.IndexDeletedWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.IndexOperationWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.PlainTextWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.ServerLoadedModulesWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.ServerStateInfoWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.SetAsMasterServerWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.WebsocketMessageForFrontendSession;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.logging.Loggers;

public class WebsocketMessageFactory {
    private static final Logger LOG = Loggers.getLogger(WebsocketMessageFactory.class, (String[])new String[]{"os-bpc-plugin"});

    public static WebsocketMessage create(String msg) {
        if (StringUtil.isNullOrEmpty((String)msg)) {
            return null;
        }
        try {
            if (BroadcastToAllExceptSenderWebsocketMessage.canBeCreatedFromMessage(msg)) {
                return BroadcastToAllExceptSenderWebsocketMessage.createFromMessage(msg);
            }
            if (BroadcastToAllWebsocketMessage.canBeCreatedFromMessage(msg)) {
                return BroadcastToAllWebsocketMessage.createFromMessage(msg);
            }
            if (BroadcastToWebsocketMessage.canBeCreatedFromMessage(msg)) {
                return BroadcastToWebsocketMessage.createFromMessage(msg);
            }
            if (BroadcastWebsocketMessage.canBeCreatedFromMessage(msg)) {
                return BroadcastWebsocketMessage.createFromMessage(msg);
            }
            if (IndexCreatedWebsocketMessage.canBeCreatedFromMessage(msg)) {
                return IndexCreatedWebsocketMessage.createFromMessage(msg);
            }
            if (IndexDeletedWebsocketMessage.canBeCreatedFromMessage(msg)) {
                return IndexDeletedWebsocketMessage.createFromMessage(msg);
            }
            if (IndexOperationWebsocketMessage.canBeCreatedFromMessage(msg)) {
                return IndexOperationWebsocketMessage.createFromMessage(msg);
            }
            if (ServerLoadedModulesWebsocketMessage.canBeCreatedFromMessage(msg)) {
                return ServerLoadedModulesWebsocketMessage.createFromMessage(msg);
            }
            if (ServerStateInfoWebsocketMessage.canBeCreatedFromMessage(msg)) {
                return ServerStateInfoWebsocketMessage.createFromMessage(msg);
            }
            if (SetAsMasterServerWebsocketMessage.canBeCreatedFromMessage(msg)) {
                return SetAsMasterServerWebsocketMessage.createFromMessage(msg);
            }
            if (WebsocketMessageForFrontendSession.canBeCreatedFromMessage(msg)) {
                return WebsocketMessageForFrontendSession.createFromMessage(msg);
            }
            return new PlainTextWebsocketMessage(msg);
        }
        catch (WebsocketMessageException ex) {
            LOG.error("Failed to create a WebsocketMessage instance.", (Throwable)ex);
            return null;
        }
    }
}

