/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.module.analysis.datasource;

import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.api.service.HttpProxyService;
import de.virtimo.bpc.module.analysis.datasource.DataSource;
import de.virtimo.bpc.util.StreamUtil;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;

public class Inubit
implements DataSource {
    private final HttpProxyService httpProxyService;
    private final UserSession userSession;
    private final HttpHeaders httpHeaders;

    public Inubit(HttpProxyService httpProxyService, UserSession userSession, HttpHeaders httpHeaders) {
        this.httpProxyService = httpProxyService;
        this.userSession = userSession;
        this.httpHeaders = httpHeaders;
    }

    @Override
    public String getData(Map dataSetConfig, Map variables) throws Exception {
        String inubitReportId = (String)dataSetConfig.get("inubit_reportId");
        String inubitConnectionId = (String)dataSetConfig.get("inubit_connectionId");
        inubitReportId = URLEncoder.encode(inubitReportId, StandardCharsets.UTF_8.toString());
        Object inubitReportApi = "/ibis/rest/report/reportdata/" + inubitReportId + "?userType=processEngineUser";
        Response response = this.httpProxyService.doGet(inubitConnectionId, (String)(inubitReportApi = this.applyVariable((String)inubitReportApi, variables)), null, null, this.httpHeaders, this.userSession, false);
        String result = this.isResponseCompressed(response) ? new String(StreamUtil.unzip((InputStream)((InputStream)response.getEntity())), StandardCharsets.UTF_8) : (String)response.readEntity(String.class);
        return result;
    }

    private boolean isResponseCompressed(Response response) {
        return response.getHeaderString("Content-Encoding").equals("gzip");
    }

    private String applyVariable(String url, Map variables) throws UnsupportedEncodingException {
        url = url.concat("&");
        for (Map.Entry entry : variables.entrySet()) {
            String key = URLEncoder.encode((String)entry.getKey(), StandardCharsets.UTF_8.toString());
            String value = URLEncoder.encode((String)((List)entry.getValue()).get(0), StandardCharsets.UTF_8.toString());
            url = url.concat(key + "=" + value + "&");
        }
        return url;
    }
}

