/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.api;

import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import java.lang.reflect.Field;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class BpcServicesTracker<T>
implements AutoCloseable {
    private static final Logger LOG = Logger.getLogger(BpcServicesTracker.class.getName());
    private final BundleContext bundleContext;
    private final Class<T> typeParameterClass;
    private final String filter;
    private ServiceTracker serviceTracker;
    private T _service;

    public static void stopAll(Object from) {
        if (from != null) {
            BpcServicesTracker.stopAll(from, from.getClass());
        }
    }

    public static void stopAll(Object from, Class<?> clazz) {
        if (from != null && clazz != null) {
            for (Field field : clazz.getDeclaredFields()) {
                field.setAccessible(true);
                try {
                    Object fieldValue = field.get(from);
                    if (!(fieldValue instanceof BpcServicesTracker)) continue;
                    BpcServicesTracker bpcServicesTracker = (BpcServicesTracker)fieldValue;
                    bpcServicesTracker.stop();
                }
                catch (Exception ex) {
                    LOG.log(Level.SEVERE, "Failed to stop the bpc services tracker: " + field + " (" + from + ")");
                }
            }
        }
    }

    public BpcServicesTracker(BundleContext bundleContext, Class<T> typeParameterClass, String filter) {
        LOG.finest("BpcServicesTracker bundleContext=" + bundleContext + ", typeParameterClass=" + typeParameterClass + ", filter=" + filter);
        this.bundleContext = bundleContext;
        this.typeParameterClass = typeParameterClass;
        this.filter = filter;
        this.start();
    }

    public BpcServicesTracker(BundleContext bundleContext, Class<T> typeParameterClass) {
        this(bundleContext, typeParameterClass, null);
    }

    public void start() {
        LOG.finest(this.typeParameterClass.getName() + ": start");
        if (this.serviceTracker == null) {
            this.serviceTracker = this.createServiceTracker(this.bundleContext);
            this.serviceTracker.open();
        }
    }

    public boolean isStopped() {
        LOG.finest(this.typeParameterClass.getName() + ": isStopped");
        return this.serviceTracker == null;
    }

    public void stop() {
        LOG.finest(this.typeParameterClass.getName() + ": stop");
        if (this.serviceTracker != null) {
            try {
                this.serviceTracker.close();
            }
            catch (RuntimeException ex) {
                LOG.log(Level.SEVERE, this.typeParameterClass.getName() + ": Could not close the service tracker");
            }
            finally {
                this.serviceTracker = null;
            }
        }
    }

    @Override
    public void close() {
        LOG.finest(this.typeParameterClass.getName() + ": close");
        this.stop();
    }

    private ServiceTracker createServiceTracker(BundleContext bundleContext) {
        String listenerFilter = "(objectClass=" + this.typeParameterClass.getName() + ")";
        if (this.filter != null && this.filter.length() > 0) {
            listenerFilter = "(&" + listenerFilter + "(" + this.filter + "))";
        }
        try {
            Filter serviceFilter = bundleContext.createFilter(listenerFilter);
            return new ServiceTracker(bundleContext, serviceFilter, null){

                public Object addingService(ServiceReference reference) {
                    Object service = this.context.getService(reference);
                    BpcServicesTracker.this._service = service;
                    return service;
                }

                public void removedService(ServiceReference reference, Object service) {
                    BpcServicesTracker.this._service = null;
                    this.context.ungetService(reference);
                }
            };
        }
        catch (InvalidSyntaxException e) {
            IllegalArgumentException iae = new IllegalArgumentException("unexpected InvalidSyntaxException: " + e.getMessage());
            iae.initCause(e);
            throw iae;
        }
    }

    @NotNull
    public T getService() throws ServiceNotFoundException {
        return this.getService(30L);
    }

    @NotNull
    public T getService(long timeoutInSeconds) throws ServiceNotFoundException {
        if (this._service == null) {
            ServiceTracker localServiceTracker = this.serviceTracker;
            if (localServiceTracker == null) {
                throw new ServiceNotFoundException(this.typeParameterClass);
            }
            try {
                this._service = localServiceTracker.waitForService(timeoutInSeconds * 1000L);
            }
            catch (InterruptedException e) {
                throw new ServiceNotFoundException(this.typeParameterClass);
            }
        }
        if (this._service == null) {
            throw new ServiceNotFoundException(this.typeParameterClass);
        }
        return this._service;
    }
}

