/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.api.opensearch;

import de.virtimo.bpc.api.service.OpenSearchService;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.opensearch.OpenSearchException;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.search.SearchScrollRequest;
import org.opensearch.client.RequestOptions;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.search.SearchHits;

public class SearchScrollIterator
implements Iterator<SearchHits>,
AutoCloseable {
    public static final TimeValue KEEP_ALIVE = TimeValue.timeValueMinutes(1L);
    public final OpenSearchService oss;
    public final SearchRequest searchRequest;
    private SearchResponse lastResponse;
    private long totalHitsCount;
    private long scrolledByHits;

    public SearchScrollIterator(OpenSearchService oss, SearchRequest searchRequest) {
        this.oss = oss;
        this.searchRequest = searchRequest;
    }

    @Override
    public boolean hasNext() {
        if (this.lastResponse == null) {
            return true;
        }
        if (this.scrolledByHits >= this.totalHitsCount) {
            return false;
        }
        return this.lastResponse.getHits().getHits().length > 0;
    }

    public long getTotalHitsCount() {
        return this.totalHitsCount;
    }

    @Override
    public SearchHits next() throws OpenSearchException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        try {
            if (this.lastResponse == null) {
                this.lastResponse = this.getInitialResponse();
                this.totalHitsCount = this.extractTotalHitsCount(this.lastResponse);
            } else {
                this.lastResponse = this.getNextResponse();
            }
            this.scrolledByHits += this.extractHitsCount(this.lastResponse);
        }
        catch (IOException e) {
            throw new OpenSearchException(e);
        }
        return this.lastResponse.getHits();
    }

    private long extractTotalHitsCount(SearchResponse response) {
        if (response == null || response.getHits() == null || response.getHits().getTotalHits() == null) {
            return 0L;
        }
        return response.getHits().getTotalHits().value;
    }

    private long extractHitsCount(SearchResponse response) {
        if (response == null || response.getHits() == null || response.getHits().getHits() == null) {
            return 0L;
        }
        return response.getHits().getHits().length;
    }

    private SearchResponse getInitialResponse() throws IOException {
        SearchRequest initialSearchRequest = new SearchRequest(this.searchRequest).scroll(KEEP_ALIVE);
        return this.oss.getClient().search(initialSearchRequest, RequestOptions.DEFAULT);
    }

    private SearchResponse getNextResponse() throws IOException {
        SearchScrollRequest scrollRequest = new SearchScrollRequest(this.lastResponse.getScrollId()).scroll(KEEP_ALIVE);
        return this.oss.getClient().scroll(scrollRequest, RequestOptions.DEFAULT);
    }

    @Override
    public void close() {
        this.oss.releaseScrollId(this.lastResponse);
    }
}

