/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.api.opensearch.querybuilder;

import de.virtimo.bpc.api.opensearch.querybuilder.BpcDataFilter;
import de.virtimo.bpc.api.opensearch.querybuilder.BpcIndexMapping;
import de.virtimo.bpc.util.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.opensearch.index.query.AbstractQueryBuilder;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.Operator;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.index.query.QueryStringQueryBuilder;
import org.opensearch.index.query.RangeQueryBuilder;

public class BpcQueryBuilder {
    private static final Logger LOG = Logger.getLogger(BpcQueryBuilder.class.getName());
    private final List<QueryBuilder> queries = new ArrayList<QueryBuilder>();

    public BpcQueryBuilder() {
    }

    @Deprecated(since="4.1.10", forRemoval=true)
    public BpcQueryBuilder(String index) {
    }

    public BpcQueryBuilder addSkipPercolatorDocumentsQuery() {
        return this.addQueryBuilder(this.getSkipPercolatorDocumentsQuery());
    }

    public BpcQueryBuilder addStringBasedQuery(String query) {
        if (!StringUtil.isNullOrEmpty(query)) {
            return this.addQueryBuilder(this.getStringBasedQuery(query));
        }
        return this;
    }

    public BpcQueryBuilder addQueriesForFilters(String filtersAsJsonArray, BpcIndexMapping indexMapping, String timeZoneId) {
        if (!StringUtil.isNullOrEmpty(filtersAsJsonArray)) {
            try {
                List<BpcDataFilter> filters = BpcDataFilter.fromJsonArray(filtersAsJsonArray);
                return this.addQueryBuilders(this.getQueriesForFilters(filters, indexMapping, timeZoneId));
            }
            catch (Exception ex) {
                LOG.log(Level.SEVERE, "Parsing a JSON filters string to a BpcDataFilter list failed.", ex);
            }
        }
        return this;
    }

    public BpcQueryBuilder addQueriesForFilters(List<BpcDataFilter> filters, BpcIndexMapping indexMapping, String timeZoneId) {
        return this.addQueryBuilders(this.getQueriesForFilters(filters, indexMapping, timeZoneId));
    }

    public BpcQueryBuilder addQueryForFilter(BpcDataFilter filter, BpcIndexMapping indexMapping, String timeZoneId) {
        return this.addQueryBuilder(this.getQueryForFilter(filter, indexMapping, timeZoneId));
    }

    public BpcQueryBuilder addDateRangeQuery(String dateField, String startDate, String endDate, String timeZoneId) {
        return this.addQueryBuilder(this.getDateRangeQuery(dateField, startDate, endDate, timeZoneId));
    }

    public BpcQueryBuilder addQueryBuilders(List<QueryBuilder> queryBuilders) {
        if (queryBuilders != null) {
            this.queries.addAll(queryBuilders);
        }
        return this;
    }

    public BpcQueryBuilder addQueryBuilder(QueryBuilder query) {
        if (query != null) {
            this.queries.add(query);
        }
        return this;
    }

    public QueryBuilder buildAsBoolMustQuery() {
        LOG.info("buildAsBoolMustQuery");
        BoolQueryBuilder finalQuery = QueryBuilders.boolQuery();
        if (!this.queries.isEmpty()) {
            for (QueryBuilder qb : this.queries) {
                finalQuery.must(qb);
            }
        }
        return finalQuery;
    }

    public QueryBuilder buildAsBoolFilterQuery() {
        LOG.info("buildAsBoolFilterQuery");
        BoolQueryBuilder finalQuery = QueryBuilders.boolQuery();
        if (!this.queries.isEmpty()) {
            BoolQueryBuilder bqb = QueryBuilders.boolQuery();
            for (QueryBuilder qb : this.queries) {
                bqb.must(qb);
            }
            finalQuery.filter(bqb);
        }
        return finalQuery;
    }

    private QueryBuilder getStringBasedQuery(String query) {
        LOG.info("getStringBasedQuery query=" + query);
        QueryStringQueryBuilder result = null;
        if (!StringUtil.isNullOrEmpty(query)) {
            result = QueryBuilders.queryStringQuery(query).defaultOperator(Operator.AND);
        }
        return result;
    }

    private List<QueryBuilder> getQueriesForFilters(List<BpcDataFilter> filters, BpcIndexMapping indexMapping, String timezoneId) {
        LOG.fine("getQueriesForFilters filters=" + filters + ", indexMapping=..., timezoneId=" + timezoneId);
        ArrayList<QueryBuilder> result = new ArrayList<QueryBuilder>();
        if (filters != null) {
            for (BpcDataFilter filter : filters) {
                result.add(this.getQueryForFilter(filter, indexMapping, timezoneId));
            }
        }
        return result;
    }

    private QueryBuilder getQueryForFilter(BpcDataFilter filter, BpcIndexMapping indexMapping, String timeZoneId) {
        QueryBuilder query;
        LOG.fine("getQueryForFilter filter=" + filter + ", indexMapping=..., timeZoneId=" + timeZoneId);
        boolean forcedInvert = false;
        if (Arrays.asList("gt", "gte", "lt", "lte", ">", ">=", "<", "<=").contains(filter.getOperator().toLowerCase())) {
            query = this.createRangeQuery(indexMapping, filter.getProperty(), filter.getValue(), filter.getOperator(), timeZoneId);
            LOG.fine("add range query: " + query);
        } else if (filter.getOperator().equalsIgnoreCase("term")) {
            query = QueryBuilders.termQuery(filter.getProperty(), filter.getValue());
            LOG.fine("add term query: " + query);
        } else {
            Object property = filter.getProperty();
            String fieldType = indexMapping.getFieldType((String)property);
            boolean textField = fieldType.equalsIgnoreCase("text") || fieldType.equalsIgnoreCase("keyword");
            boolean booleanField = fieldType.equalsIgnoreCase("boolean");
            boolean numberField = fieldType.equalsIgnoreCase("unsigned_long") || fieldType.equalsIgnoreCase("long") || fieldType.equalsIgnoreCase("integer") || fieldType.equalsIgnoreCase("short") || fieldType.equalsIgnoreCase("byte");
            String source = filter.getSource();
            if (source != null && source.length() > 0 && indexMapping.hasMultiField((String)property, source)) {
                property = (String)property + "." + source;
            }
            if (booleanField) {
                query = QueryBuilders.termQuery((String)property, filter.getValueAsBoolean());
            } else if (filter.hasMultiValues()) {
                if (numberField) {
                    query = QueryBuilders.termQuery((String)property, 1);
                    if (!filter.isBooleanTrueFilter() && !filter.isInvert()) {
                        forcedInvert = true;
                    }
                } else {
                    BoolQueryBuilder multiQuery = QueryBuilders.boolQuery();
                    for (String val : filter.getValues()) {
                        if (textField) {
                            multiQuery.should(this.createTextQuery((String)property, val, source, filter.getOperator()));
                            continue;
                        }
                        multiQuery.should(QueryBuilders.termQuery((String)property, val));
                    }
                    query = multiQuery;
                }
            } else if (textField) {
                query = this.createTextQuery((String)property, filter.getValue(), source, filter.getOperator());
            } else {
                LOG.info("create a simple term query for type " + fieldType + " with property = value");
                query = QueryBuilders.termQuery((String)property, filter.getValue());
            }
        }
        if (filter.isInvert() || forcedInvert) {
            query = QueryBuilders.boolQuery().mustNot(query);
        }
        return query;
    }

    private QueryBuilder createRangeQuery(BpcIndexMapping indexMapping, String property, String value, String operator, String timeZoneId) {
        LOG.finest("createRangeQuery indexMapping=..., property=" + property + " value=..., operator=" + operator + ", timeZoneId=" + timeZoneId);
        RangeQueryBuilder rangeQueryBuilder = QueryBuilders.rangeQuery(property);
        if (!StringUtil.isNullOrEmpty(timeZoneId) && indexMapping.getFieldType(property).equals("date")) {
            rangeQueryBuilder.timeZone(timeZoneId);
        }
        switch (operator) {
            case "gt": 
            case ">": {
                rangeQueryBuilder.gt(value);
                break;
            }
            case "gte": 
            case ">=": {
                rangeQueryBuilder.gte(value);
                break;
            }
            case "lt": 
            case "<": {
                rangeQueryBuilder.lt(value);
                break;
            }
            case "lte": 
            case "<=": {
                rangeQueryBuilder.lte(value);
            }
        }
        return rangeQueryBuilder;
    }

    private QueryBuilder createTextQuery(String property, String value, String source, String operator) {
        LOG.info("createTextQuery property=" + property + ", value=" + (String)value + ", source=" + source + ", operator=" + operator);
        AbstractQueryBuilder q = null;
        if (source == null || !source.equalsIgnoreCase("raw")) {
            value = ((String)value).toLowerCase();
        }
        if (operator.equalsIgnoreCase("=*") && !((String)value).endsWith("*")) {
            value = (String)value + "*";
        }
        if (operator.equalsIgnoreCase("=*") && !((String)value).startsWith("*")) {
            value = "*" + (String)value;
        }
        LOG.info("Using as text query value: " + (String)value);
        if (((String)value).equals("*!*") || ((String)value).equals("!")) {
            q = QueryBuilders.boolQuery().should(QueryBuilders.boolQuery().mustNot(QueryBuilders.existsQuery(property))).should(QueryBuilders.termsQuery(property, ""));
        } else if (((String)value).startsWith("*!")) {
            q = QueryBuilders.boolQuery().mustNot(QueryBuilders.wildcardQuery(property, ((String)value).substring(2)));
        } else {
            q = QueryBuilders.wildcardQuery(property, (String)value);
            LOG.fine("add  query: " + q);
        }
        return q;
    }

    private QueryBuilder getDateRangeQuery(String dateField, String startDate, String endDate, String timezoneId) {
        LOG.finest("getDateRangeQuery dateField=" + dateField + ", startDate=" + startDate + ", endDate=" + endDate + ", timezoneId=" + timezoneId);
        RangeQueryBuilder dateRangeQuery = null;
        if (!StringUtil.isNullOrEmpty(dateField) && !StringUtil.isNullOrEmpty(timezoneId)) {
            if (!StringUtil.isNullOrEmpty(startDate) && !StringUtil.isNullOrEmpty(endDate)) {
                dateRangeQuery = QueryBuilders.rangeQuery(dateField).gte(startDate).lte(endDate).timeZone(timezoneId).format("yyyy-MM-dd HH:mm:ss||strict_date_optional_time||epoch_millis");
            }
            if (StringUtil.isNullOrEmpty(startDate) && !StringUtil.isNullOrEmpty(endDate)) {
                dateRangeQuery = QueryBuilders.rangeQuery(dateField).lt(endDate).timeZone(timezoneId).format("yyyy-MM-dd HH:mm:ss||strict_date_optional_time||epoch_millis");
            }
            if (!StringUtil.isNullOrEmpty(startDate) && StringUtil.isNullOrEmpty(endDate)) {
                dateRangeQuery = QueryBuilders.rangeQuery(dateField).gt(startDate).timeZone(timezoneId).format("yyyy-MM-dd HH:mm:ss||strict_date_optional_time||epoch_millis");
            }
        }
        return dateRangeQuery;
    }

    private QueryBuilder getSkipPercolatorDocumentsQuery() {
        LOG.finest("getSkipPercolatorDocumentsQuery");
        return QueryBuilders.boolQuery().mustNot(QueryBuilders.existsQuery("_percolator_query"));
    }
}

