/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core;

import de.virtimo.bpc.util.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.Dictionary;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.cm.Configuration;

public abstract class AbstractBundleBasedConfiguration {
    private static final Logger LOG = Logger.getLogger(AbstractBundleBasedConfiguration.class.getName());
    private static final Object UNPROCESSED_PROPERTIES_LOCK = new Object();
    private Dictionary<String, Object> unprocessedProperties;
    private static final Object PROCESSED_PROPERTIES_LOCK = new Object();
    private Dictionary<String, Object> processedProperties;

    protected abstract Configuration getConfiguration();

    protected abstract Properties getDefaultProperties();

    protected Properties loadResourceProperties(String fileName) throws IOException {
        try (InputStream resourceStream = FrameworkUtil.getBundle(this.getClass()).getResource(fileName).openStream();){
            Properties bundleProperties = new Properties();
            bundleProperties.load(resourceStream);
            Properties properties = bundleProperties;
            return properties;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearCaches() {
        LOG.fine("clearCaches");
        Object object = UNPROCESSED_PROPERTIES_LOCK;
        synchronized (object) {
            this.unprocessedProperties = null;
        }
        object = PROCESSED_PROPERTIES_LOCK;
        synchronized (object) {
            this.processedProperties = null;
        }
    }

    private Dictionary<String, Object> getUnprocessedProperties() {
        if (this.unprocessedProperties == null) {
            this.unprocessedProperties = this.getConfiguration().getProperties();
        }
        return this.unprocessedProperties;
    }

    private Dictionary<String, Object> getProcessedProperties() {
        if (this.processedProperties == null) {
            this.processedProperties = this.getConfiguration().getProcessedProperties(null);
        }
        return this.processedProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean existsUnprocessedSystemProperty(String systemPropertyName) {
        Object object = UNPROCESSED_PROPERTIES_LOCK;
        synchronized (object) {
            if (this.getConfiguration() != null && !StringUtil.isNullOrEmpty(systemPropertyName)) {
                return this.getUnprocessedProperties().get(systemPropertyName) != null;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean existsSystemProperty(String systemPropertyName) {
        Object object = PROCESSED_PROPERTIES_LOCK;
        synchronized (object) {
            if (this.getConfiguration() != null && !StringUtil.isNullOrEmpty(systemPropertyName)) {
                return this.getProcessedProperties().get(systemPropertyName) != null;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getUnprocessedSystemPropertyValueAsBoolean(String systemPropertyName, boolean defaultValue) {
        Object object = UNPROCESSED_PROPERTIES_LOCK;
        synchronized (object) {
            return this.getSystemPropertyValueAsBoolean(this.getUnprocessedProperties(), systemPropertyName, defaultValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getSystemPropertyValueAsBoolean(String systemPropertyName, boolean defaultValue) {
        Object object = PROCESSED_PROPERTIES_LOCK;
        synchronized (object) {
            return this.getSystemPropertyValueAsBoolean(this.getProcessedProperties(), systemPropertyName, defaultValue);
        }
    }

    private boolean getSystemPropertyValueAsBoolean(Dictionary<String, Object> configProps, String systemPropertyName, boolean defaultValue) {
        String defaultPropertyValue;
        Boolean result = null;
        Object valueObject = null;
        try {
            valueObject = configProps.get(systemPropertyName);
            if (valueObject != null) {
                result = valueObject instanceof String ? Boolean.valueOf(Boolean.parseBoolean((String)valueObject)) : Boolean.valueOf((Boolean)valueObject);
            }
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, "Failed to get the system configuration property value of '" + systemPropertyName + "' as 'boolean': " + valueObject + ". Going to use the default config value.", ex);
        }
        if (result == null && !StringUtil.isNullOrEmpty(defaultPropertyValue = this.getDefaultProperties().getProperty(systemPropertyName))) {
            try {
                result = Boolean.parseBoolean(defaultPropertyValue);
            }
            catch (Exception ex) {
                LOG.warning("Failed using the default system configuration property value of '" + systemPropertyName + "' as 'boolean': " + defaultPropertyValue + ". Going to use the given default config value.");
            }
        }
        if (result == null) {
            result = defaultValue;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getUnprocessedSystemPropertyValueAsInt(String systemPropertyName, int defaultValue) {
        Object object = UNPROCESSED_PROPERTIES_LOCK;
        synchronized (object) {
            return this.getSystemPropertyValueAsInt(this.getUnprocessedProperties(), systemPropertyName, defaultValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSystemPropertyValueAsInt(String systemPropertyName, int defaultValue) {
        Object object = PROCESSED_PROPERTIES_LOCK;
        synchronized (object) {
            return this.getSystemPropertyValueAsInt(this.getProcessedProperties(), systemPropertyName, defaultValue);
        }
    }

    private int getSystemPropertyValueAsInt(Dictionary<String, Object> configProps, String systemPropertyName, int defaultValue) {
        String defaultPropertyValue;
        Integer result = null;
        Object valueObject = null;
        try {
            valueObject = configProps.get(systemPropertyName);
            if (valueObject != null) {
                result = valueObject instanceof String ? Integer.valueOf(Integer.parseInt((String)valueObject)) : (valueObject instanceof Number ? Integer.valueOf(((Number)valueObject).intValue()) : Integer.valueOf((Integer)valueObject));
            }
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, "Failed to get the system configuration property value of '" + systemPropertyName + "' as 'int': " + valueObject + ". Going to use the default config value.", ex);
        }
        if (result == null && !StringUtil.isNullOrEmpty(defaultPropertyValue = this.getDefaultProperties().getProperty(systemPropertyName))) {
            try {
                result = Integer.parseInt(defaultPropertyValue);
            }
            catch (Exception ex) {
                LOG.warning("Failed using the default system configuration property value of '" + systemPropertyName + "' as 'int': " + defaultPropertyValue + ". Going to use the given default config value.");
            }
        }
        if (result == null) {
            result = defaultValue;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getUnprocessedSystemPropertyValueAsLong(String systemPropertyName, long defaultValue) {
        Object object = UNPROCESSED_PROPERTIES_LOCK;
        synchronized (object) {
            return this.getSystemPropertyValueAsLong(this.getUnprocessedProperties(), systemPropertyName, defaultValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSystemPropertyValueAsLong(String systemPropertyName, long defaultValue) {
        Object object = PROCESSED_PROPERTIES_LOCK;
        synchronized (object) {
            return this.getSystemPropertyValueAsLong(this.getProcessedProperties(), systemPropertyName, defaultValue);
        }
    }

    private long getSystemPropertyValueAsLong(Dictionary<String, Object> configProps, String systemPropertyName, long defaultValue) {
        String defaultPropertyValue;
        Long result = null;
        Object valueObject = null;
        try {
            valueObject = configProps.get(systemPropertyName);
            if (valueObject != null) {
                result = valueObject instanceof String ? Long.valueOf(Long.parseLong((String)valueObject)) : (valueObject instanceof Number ? Long.valueOf(((Number)valueObject).longValue()) : Long.valueOf((Long)valueObject));
            }
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, "Failed to get the system configuration property value of '" + systemPropertyName + "' as 'long': " + valueObject + ". Going to use the default config value.", ex);
        }
        if (result == null && !StringUtil.isNullOrEmpty(defaultPropertyValue = this.getDefaultProperties().getProperty(systemPropertyName))) {
            try {
                result = Long.parseLong(defaultPropertyValue);
            }
            catch (Exception ex) {
                LOG.warning("Failed using the default system configuration property value of '" + systemPropertyName + "' as 'long': " + defaultPropertyValue + ". Going to use the given default config value.");
            }
        }
        if (result == null) {
            result = defaultValue;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUnprocessedSystemPropertyValueAsString(String systemPropertyName, String defaultValue) {
        Object object = UNPROCESSED_PROPERTIES_LOCK;
        synchronized (object) {
            return this.getSystemPropertyValueAsString(this.getUnprocessedProperties(), systemPropertyName, defaultValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSystemPropertyValueAsString(String systemPropertyName, String defaultValue) {
        Object object = PROCESSED_PROPERTIES_LOCK;
        synchronized (object) {
            return this.getSystemPropertyValueAsString(this.getProcessedProperties(), systemPropertyName, defaultValue);
        }
    }

    private String getSystemPropertyValueAsString(Dictionary<String, Object> configProps, String systemPropertyName, String defaultValue) {
        String defaultPropertyValue;
        String result = null;
        Object valueObject = null;
        try {
            valueObject = configProps.get(systemPropertyName);
            if (valueObject != null) {
                result = valueObject instanceof String ? (String)valueObject : String.valueOf(valueObject);
            }
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, "Failed to get the system configuration property value of '" + systemPropertyName + "' as 'string'" + valueObject + ". Going to use the default config value.", ex);
        }
        if (result == null && (defaultPropertyValue = this.getDefaultProperties().getProperty(systemPropertyName)) != null) {
            result = defaultPropertyValue;
        }
        if (result == null) {
            result = defaultValue;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSystemPropertyValueAsString(String systemPropertyName, String value) throws IOException {
        Object object = UNPROCESSED_PROPERTIES_LOCK;
        synchronized (object) {
            Configuration configuration = this.getConfiguration();
            Dictionary properties = configuration.getProperties();
            properties.put(systemPropertyName, value);
            configuration.update(properties);
            this.unprocessedProperties = null;
        }
    }

    public void setSystemPropertyValue(String systemPropertyName, String value) throws IOException {
        this.setSystemPropertyValueAsString(systemPropertyName, value);
    }

    public void setSystemPropertyValue(String systemPropertyName, Boolean value) throws IOException {
        this.setSystemPropertyValueAsString(systemPropertyName, String.valueOf(value));
    }

    public void setSystemPropertyValue(String systemPropertyName, Integer value) throws IOException {
        this.setSystemPropertyValueAsString(systemPropertyName, String.valueOf(value));
    }

    public void setSystemPropertyValue(String systemPropertyName, Long value) throws IOException {
        this.setSystemPropertyValueAsString(systemPropertyName, String.valueOf(value));
    }

    public void setSystemPropertyValue(String systemPropertyName, Float value) throws IOException {
        this.setSystemPropertyValueAsString(systemPropertyName, String.valueOf(value));
    }
}

