/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core;

import com.fasterxml.jackson.core.JsonProcessingException;
import de.virtimo.bpc.api.AbstractEventHandler;
import de.virtimo.bpc.api.ClientSessionManager;
import de.virtimo.bpc.api.EventFilter;
import de.virtimo.bpc.api.InstantiableModule;
import de.virtimo.bpc.api.Module;
import de.virtimo.bpc.api.ModuleInstance;
import de.virtimo.bpc.api.ModuleManager;
import de.virtimo.bpc.api.Setting;
import de.virtimo.bpc.api.WebsocketRecipients;
import de.virtimo.bpc.api.auth.ClientSession;
import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.api.exception.ModuleNotFoundException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.core.notification.Notification;
import de.virtimo.bpc.core.resource.response.UserSessionBasedModuleConfigImpl;
import de.virtimo.bpc.core.utils.EventUtil;
import de.virtimo.bpc.util.JsonUtil;
import de.virtimo.bpc.util.StringUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.service.event.Event;

public class CatchAllBpcEventsHandler
extends AbstractEventHandler {
    private static final Logger LOG = Logger.getLogger(CatchAllBpcEventsHandler.class.getName());
    private final List<EventFilter> blacklistEventFilters;
    private final ClientSessionManager clientSessionManager;
    private final ModuleManager moduleManager;

    public CatchAllBpcEventsHandler(ClientSessionManager clientSessionManager, ModuleManager moduleManager) {
        this.clientSessionManager = clientSessionManager;
        this.moduleManager = moduleManager;
        this.blacklistEventFilters = new ArrayList<EventFilter>();
    }

    @Override
    protected boolean canProcessEvent(Event event) {
        return !this.isBlacklistedEvent(event);
    }

    public void addBlacklistFilter(EventFilter eventFilter) {
        this.blacklistEventFilters.add(eventFilter);
    }

    private boolean isBlacklistedEvent(Event event) {
        for (EventFilter eventFilter : this.blacklistEventFilters) {
            if (!eventFilter.isBlacklisted(event)) continue;
            LOG.info("isBlacklistedEvent event=" + event);
            return true;
        }
        return false;
    }

    @Override
    protected void processEvent(Event event) {
        LOG.info(this.getClass().getSimpleName() + ".processEvent event=...");
        try {
            String message = EventUtil.eventAsJsonString(event);
            Map<String, Object> messageMap = JsonUtil.getInstance().jsonStringAsMap(message);
            Map eventProperties = (Map)messageMap.get("properties");
            Object websocketRecipientsObject = eventProperties.get("_websocketRecipients");
            if (websocketRecipientsObject instanceof Map) {
                Map websocketRecipientsMap = (Map)websocketRecipientsObject;
                WebsocketRecipients websocketRecipients = new WebsocketRecipients(websocketRecipientsMap);
                eventProperties.remove("_websocketRecipients");
                message = JsonUtil.getInstance().convertPojoToJsonString(messageMap);
                this.clientSessionManager.broadcastMessage(message, websocketRecipients);
            } else {
                switch (event.getTopic()) {
                    case "de/virtimo/bpc/core/Configuration/moduleDeleted": {
                        this.accessRightsRestrictedModuleDeletedBroadcastMessage(event);
                        break;
                    }
                    case "de/virtimo/bpc/core/Configuration/moduleUpdated": {
                        this.accessRightsRestrictedModuleCreatedOrUpdatedBroadcastMessage(event);
                        break;
                    }
                    case "de/virtimo/bpc/core/Configuration/moduleInstanceCreated": {
                        this.accessRightsRestrictedModuleCreatedOrUpdatedBroadcastMessage(event);
                        break;
                    }
                    case "de/virtimo/bpc/core/notification/notificationAdded": {
                        this.accessRightsRestrictedNotificationCreatedOrUpdatedOrDeletedBroadcastMessage(event);
                        break;
                    }
                    case "de/virtimo/bpc/core/notification/notificationUpdated": {
                        this.accessRightsRestrictedNotificationCreatedOrUpdatedOrDeletedBroadcastMessage(event);
                        break;
                    }
                    case "de/virtimo/bpc/core/notification/notificationDeleted": {
                        this.accessRightsRestrictedNotificationCreatedOrUpdatedOrDeletedBroadcastMessage(event);
                        break;
                    }
                    default: {
                        this.clientSessionManager.broadcastMessage(message);
                    }
                }
            }
        }
        catch (ServiceNotFoundException ex) {
            LOG.warning(this.getClass().getSimpleName() + ".processEvent : Did not get the required services to broadcast messages");
        }
        catch (IOException ex) {
            LOG.log(Level.WARNING, this.getClass().getSimpleName() + ".processEvent : Failed to serialize an Event to JSON. Using the standard Java serialization as fallback.", ex);
            this.clientSessionManager.broadcastMessage(event.toString());
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, this.getClass().getSimpleName() + ".processEvent : Failed to broadcast the event.", ex);
        }
    }

    private Event modifyModuleCreatedOrUpdatedEventToRespectAccessRights(Event event, UserSession userSession) {
        HashMap<String, Object> modifiedProps = new HashMap<String, Object>();
        for (String propertyName : event.getPropertyNames()) {
            Object propertyValue = event.getProperty(propertyName);
            if ("setting".equals(propertyName) && propertyValue instanceof List) {
                List settings = (List)propertyValue;
                List<Setting> modifiedSettings = UserSessionBasedModuleConfigImpl.getFilteredSettingList(userSession, settings, false);
                modifiedProps.put(propertyName, modifiedSettings);
                continue;
            }
            modifiedProps.put(propertyName, propertyValue);
        }
        return new Event(event.getTopic(), modifiedProps);
    }

    private void accessRightsRestrictedModuleCreatedOrUpdatedBroadcastMessage(Event event) throws ServiceNotFoundException, JsonProcessingException {
        LOG.info("accessRightsRestrictedModuleCreatedOrUpdatedBroadcastMessage event=...");
        String moduleId = (String)event.getProperty("moduleId");
        String instanceId = (String)event.getProperty("moduleInstanceId");
        try {
            Module module = this.moduleManager.getModuleById(moduleId);
            for (ClientSession clientSession : this.clientSessionManager.getAllSessions()) {
                InstantiableModule instantiableModule;
                ModuleInstance moduleInstance;
                UserSession userSession = clientSession.getUserSession();
                if (userSession == null || !userSession.hasLoadModuleRight(moduleId)) continue;
                if (StringUtil.isNullOrEmpty(instanceId) || instanceId.equals("noinstance")) {
                    Event modifiedEvent = this.modifyModuleCreatedOrUpdatedEventToRespectAccessRights(event, userSession);
                    this.clientSessionManager.sendByWebsocket(clientSession, EventUtil.eventAsJsonString(modifiedEvent, userSession, this.moduleManager));
                    continue;
                }
                if (!(module instanceof InstantiableModule) || !userSession.hasUseModuleInstanceRight(moduleInstance = (instantiableModule = (InstantiableModule)module).getModuleInstance(instanceId))) continue;
                Event modifiedEvent = this.modifyModuleCreatedOrUpdatedEventToRespectAccessRights(event, userSession);
                this.clientSessionManager.sendByWebsocket(clientSession, EventUtil.eventAsJsonString(modifiedEvent, userSession, this.moduleManager));
            }
        }
        catch (ModuleNotFoundException e) {
            LOG.log(Level.WARNING, "Failed to get the module with the ID '" + moduleId + "' to broadcast messages.");
        }
    }

    private void accessRightsRestrictedNotificationCreatedOrUpdatedOrDeletedBroadcastMessage(Event event) throws ServiceNotFoundException, JsonProcessingException {
        LOG.info("accessRightsRestrictedNotificationCreatedOrUpdatedOrDeletedBroadcastMessage event=...");
        Notification notification = (Notification)event.getProperty("notification");
        if (notification != null) {
            for (ClientSession clientSession : this.clientSessionManager.getAllSessions()) {
                UserSession userSession = clientSession.getUserSession();
                if (userSession == null || !notification.hasAccessRight(userSession)) continue;
                this.clientSessionManager.sendByWebsocket(clientSession, EventUtil.eventAsJsonString(event));
            }
        }
    }

    private void accessRightsRestrictedModuleDeletedBroadcastMessage(Event event) throws ServiceNotFoundException, JsonProcessingException {
        LOG.info("accessRightsRestrictedModuleDeletedBroadcastMessage event=...");
        String moduleId = (String)event.getProperty("moduleId");
        ModuleInstance moduleInstance = (ModuleInstance)event.getProperty("moduleInstance");
        try {
            Module module = this.moduleManager.getModuleById(moduleId);
            for (ClientSession clientSession : this.clientSessionManager.getAllSessions()) {
                UserSession userSession = clientSession.getUserSession();
                if (userSession == null || !userSession.hasLoadModuleRight(module)) continue;
                if (moduleInstance == null) {
                    this.clientSessionManager.sendByWebsocket(clientSession, EventUtil.eventAsJsonString(event, userSession, this.moduleManager));
                    continue;
                }
                if (!userSession.hasUseModuleInstanceRight(moduleInstance)) continue;
                this.clientSessionManager.sendByWebsocket(clientSession, EventUtil.eventAsJsonString(event, userSession, this.moduleManager));
            }
        }
        catch (ModuleNotFoundException e) {
            LOG.log(Level.WARNING, "Failed to get the module with the ID '" + moduleId + "' to broadcast messages.");
        }
    }
}

