/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.auth;

import de.virtimo.bpc.api.auth.InactiveOrganisation;
import de.virtimo.bpc.api.auth.Organisation;
import de.virtimo.bpc.api.auth.Right;
import de.virtimo.bpc.api.auth.Role;
import de.virtimo.bpc.core.auth.AbstractUserSession;
import de.virtimo.bpc.core.auth.OrganisationFactory;
import de.virtimo.bpc.core.auth.RightFactory;
import de.virtimo.bpc.core.auth.RolesFactory;
import de.virtimo.bpc.util.UUIDGenerator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class UserSessionImpl
extends AbstractUserSession {
    private static final Logger LOG = Logger.getLogger(UserSessionImpl.class.getName());
    private final String sessionId;
    private final String firstName;
    private final String lastName;
    private final String loginName;
    private final String email;
    private final Date expirationDate;

    private UserSessionImpl(UserSessionImplBuilder builder) {
        this.sessionId = builder.sessionId;
        this.firstName = builder.firstName;
        this.lastName = builder.lastName;
        this.loginName = builder.loginName;
        this.email = builder.email;
        this.expirationDate = builder.expirationDate;
        this.organisations.addAll(builder.organisations);
        this.inactiveOrganisations.addAll(builder.inactiveOrganisations);
        this.roles.addAll(builder.roles);
        this.rights.addAll(builder.rights);
        this.principals.putAll(builder.principals);
        this.customData.putAll(builder.customData);
        this.sensitiveCustomData.putAll(builder.sensitiveCustomData);
    }

    @Override
    public String getSessionId() {
        return this.sessionId;
    }

    @Override
    public String getFirstName() {
        return this.firstName;
    }

    @Override
    public String getLastName() {
        return this.lastName;
    }

    @Override
    public String getLoginName() {
        return this.loginName;
    }

    @Override
    public String getEmail() {
        return this.email;
    }

    @Override
    public Date getExpirationDate() {
        return this.expirationDate;
    }

    @Override
    public String toString() {
        return this.getLastName() + ", " + this.getFirstName() + " - " + this.getSessionId();
    }

    public static class UserSessionImplBuilder {
        private String sessionId = UUIDGenerator.randomUUID();
        private String firstName;
        private String lastName;
        private String loginName;
        private String email;
        private Date expirationDate;
        private final Set<Organisation> organisations = new HashSet<Organisation>();
        private final Set<InactiveOrganisation> inactiveOrganisations = new HashSet<InactiveOrganisation>();
        private final Set<Role> roles = new HashSet<Role>();
        private final Set<Right> rights = new HashSet<Right>();
        private final Map<String, List<String>> principals = new HashMap<String, List<String>>();
        private final Map<String, Object> customData = new HashMap<String, Object>();
        private final Map<String, Object> sensitiveCustomData = new HashMap<String, Object>();

        private UserSessionImplBuilder() {
        }

        public static UserSessionImplBuilder newInstance() {
            return new UserSessionImplBuilder();
        }

        public UserSessionImplBuilder withSessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public UserSessionImplBuilder withFirstName(String firstName) {
            this.firstName = firstName;
            return this;
        }

        public UserSessionImplBuilder withLastName(String lastName) {
            this.lastName = lastName;
            return this;
        }

        public UserSessionImplBuilder withLoginName(String loginName) {
            this.loginName = loginName;
            return this;
        }

        public UserSessionImplBuilder withEmail(String email) {
            this.email = email;
            return this;
        }

        public UserSessionImplBuilder withExpirationDate(Date expirationDate) {
            this.expirationDate = expirationDate;
            return this;
        }

        public UserSessionImplBuilder withOrganisations(String ... organisations) {
            if (organisations != null) {
                for (String organisation : organisations) {
                    this.organisations.add(OrganisationFactory.getOrganisation(organisation));
                }
            }
            return this;
        }

        public UserSessionImplBuilder withOrganisations(Set<Organisation> organisations) {
            if (organisations != null) {
                this.organisations.addAll(organisations);
            }
            return this;
        }

        public UserSessionImplBuilder withInactiveOrganisations(String ... inactiveOrganisations) {
            if (inactiveOrganisations != null) {
                for (String inactiveOrganisation : inactiveOrganisations) {
                    this.inactiveOrganisations.add(OrganisationFactory.getInactiveOrganisation(inactiveOrganisation));
                }
            }
            return this;
        }

        public UserSessionImplBuilder withInactiveOrganisations(Set<InactiveOrganisation> inactiveOrganisations) {
            if (inactiveOrganisations != null) {
                this.inactiveOrganisations.addAll(inactiveOrganisations);
            }
            return this;
        }

        public UserSessionImplBuilder withRoles(String ... roles) {
            if (roles != null) {
                for (String role : roles) {
                    this.roles.add(RolesFactory.getRole(role));
                }
            }
            return this;
        }

        public UserSessionImplBuilder withRoles(Set<Role> roles) {
            if (roles != null) {
                this.roles.addAll(roles);
            }
            return this;
        }

        public UserSessionImplBuilder withRights(String ... rights) {
            if (rights != null) {
                for (String right : rights) {
                    this.rights.add(RightFactory.getRight(right));
                }
            }
            return this;
        }

        public UserSessionImplBuilder withRights(Set<Right> rights) {
            if (rights != null) {
                this.rights.addAll(rights);
            }
            return this;
        }

        public UserSessionImplBuilder withPrincipals(Map<String, List<String>> principals) {
            if (principals != null) {
                this.principals.putAll(principals);
            }
            return this;
        }

        public UserSessionImplBuilder withCustomData(Map<String, Object> customData) {
            if (customData != null) {
                this.customData.putAll(customData);
            }
            return this;
        }

        public UserSessionImplBuilder withSensitiveCustomData(Map<String, Object> sensitiveCustomData) {
            if (sensitiveCustomData != null) {
                this.sensitiveCustomData.putAll(sensitiveCustomData);
            }
            return this;
        }

        public UserSessionImplBuilder clearOrganisations() {
            this.organisations.clear();
            return this;
        }

        public UserSessionImplBuilder clearInactiveOrganisations() {
            this.inactiveOrganisations.clear();
            return this;
        }

        public UserSessionImpl build() {
            return new UserSessionImpl(this);
        }
    }
}

