/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.auth.oidc;

import de.virtimo.bpc.core.auth.oidc.OidcUriPattern;
import de.virtimo.bpc.util.StringUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OidcUri {
    private final URI single;
    private final List<OidcUriPattern> patterns;

    public OidcUri(Object value) throws URISyntaxException {
        if (value instanceof List) {
            this.single = null;
            this.patterns = this.createOidcRedirectPatterns((List)value);
        } else {
            this.single = new URI(value.toString().trim());
            this.patterns = null;
        }
    }

    public Set<URI> getURIs() {
        HashSet<URI> result = new HashSet<URI>();
        if (this.single != null) {
            result.add(this.single);
        } else if (this.patterns != null) {
            for (OidcUriPattern pattern : this.patterns) {
                result.add(pattern.getURI());
            }
        }
        return result;
    }

    private List<OidcUriPattern> createOidcRedirectPatterns(List<?> patterns) throws URISyntaxException {
        ArrayList<OidcUriPattern> result = new ArrayList<OidcUriPattern>();
        for (Object patternObject : patterns) {
            Map patternMap;
            if (!(patternObject instanceof Map) || !(patternMap = (Map)patternObject).containsKey("pattern") || !patternMap.containsKey("uri")) continue;
            result.add(new OidcUriPattern(patternMap.get("pattern").toString(), patternMap.get("uri").toString()));
        }
        return result;
    }

    public URI getURIforRequestUrl(String url) {
        if (this.patterns != null) {
            if (!StringUtil.isNullOrEmpty(url)) {
                for (OidcUriPattern pattern : this.patterns) {
                    if (!url.matches(pattern.getRegEx())) continue;
                    return pattern.getURI();
                }
            }
        } else {
            return this.single;
        }
        return null;
    }
}

