/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.fewrapper;

import de.virtimo.bpc.api.ModuleConfiguration;
import de.virtimo.bpc.api.ModuleInstance;
import de.virtimo.bpc.api.ModuleManager;
import de.virtimo.bpc.core.fewrapper.FeWrapperModuleInstance;
import de.virtimo.bpc.module.AbstractInstantiableModule;
import de.virtimo.bpc.module.ModuleConfigurationBuilder;
import de.virtimo.bpc.util.StringUtil;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.Bundle;

public class FeWrapperModule
extends AbstractInstantiableModule {
    private static final Logger LOG = Logger.getLogger(FeWrapperModule.class.getName());
    private final Bundle frontendBundle;
    private final String id;
    private final String name;
    private final String[] supportedInstanceTypes;

    public FeWrapperModule(ModuleManager moduleManager, Bundle frontendBundle) {
        super(moduleManager);
        LOG.log(Level.FINEST, "FeWrapperModule");
        if (!FeWrapperModule.isFeOnlyBundle(frontendBundle).booleanValue()) {
            LOG.log(Level.SEVERE, "Missing Bundle header BPC-Bundle-Type=fe-only");
            throw new IllegalArgumentException("Bundle is no BPC Frontend only bundle: " + frontendBundle.getSymbolicName());
        }
        this.id = frontendBundle.getHeaders().get("BPC-Bundle-Id") != null ? (String)frontendBundle.getHeaders().get("BPC-Bundle-Id") : String.valueOf(frontendBundle.getBundleId());
        LOG.log(Level.FINEST, "ID: " + this.id);
        this.name = frontendBundle.getHeaders().get("Bundle-Name") != null ? String.valueOf(frontendBundle.getHeaders().get("Bundle-Name")) : frontendBundle.getSymbolicName();
        LOG.log(Level.FINEST, "Name: " + this.name);
        if (frontendBundle.getHeaders().get("BPC-Instance-Types") != null) {
            this.supportedInstanceTypes = String.valueOf(frontendBundle.getHeaders().get("BPC-Instance-Types")).split(",");
            LOG.log(Level.FINEST, "Found some instance types:" + Arrays.toString(this.supportedInstanceTypes));
        } else {
            this.supportedInstanceTypes = null;
        }
        this.frontendBundle = frontendBundle;
        this.setModuleBundle(frontendBundle);
    }

    @Override
    public ModuleConfiguration getDefaultConfiguration() {
        LOG.log(Level.FINEST, "getDefaultConfiguration");
        return ModuleConfigurationBuilder.newInstance().withModuleId(this.getModuleId()).addSettingsFromFile(this.getModuleBundle(), "resources/defaults/default_module_settings.json").build();
    }

    @Override
    public String getModuleId() {
        LOG.log(Level.FINEST, "getModuleId");
        return this.id;
    }

    @Override
    public String getModuleName() {
        LOG.log(Level.FINEST, "getModuleName");
        return this.name;
    }

    @Override
    public ModuleConfiguration getDefaultInstanceConfiguration() {
        LOG.log(Level.FINEST, "getDefaultInstanceConfiguration");
        return ModuleConfigurationBuilder.newInstance().withModuleId(this.getModuleId()).withInstanceId(null).addSettingsFromFile(this.getModuleBundle(), "resources/defaults/default_instance_settings.json").build();
    }

    @Override
    public ModuleConfiguration getDefaultInstanceConfiguration(String instanceType) {
        LOG.log(Level.FINEST, "getDefaultInstanceConfiguration instanceType=" + instanceType);
        Object settingsFilePath = StringUtil.isNullOrEmpty(instanceType) || "none".equalsIgnoreCase(instanceType) ? "resources/defaults/default_instance_settings.json" : "resources/defaults/default_instance_settings_" + instanceType + ".json";
        return ModuleConfigurationBuilder.newInstance().withModuleId(this.getModuleId()).withInstanceId(null).withInstanceType(instanceType).addSettingsFromFile(this.getModuleBundle(), (String)settingsFilePath).build();
    }

    @Override
    public Class<? extends ModuleInstance> getModuleInstanceClass() {
        LOG.log(Level.FINEST, "getModuleInstanceClass");
        return FeWrapperModuleInstance.class;
    }

    @Override
    public String[] getSupportedInstanceTypes() {
        LOG.log(Level.FINEST, "getSupportedInstanceTypes");
        return this.supportedInstanceTypes;
    }

    public static Boolean isFeOnlyBundle(Bundle bundle) {
        LOG.log(Level.FINEST, "isFeOnlyBundle");
        if (bundle == null) {
            return false;
        }
        return "fe-only".equalsIgnoreCase(String.valueOf(bundle.getHeaders().get("BPC-Bundle-Type")));
    }
}

