/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.httpproxy;

import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ErrorResponse;
import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.api.exception.ModuleInstanceNotFoundException;
import de.virtimo.bpc.api.exception.ModuleNotFoundException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.service.ErrorResponseService;
import de.virtimo.bpc.api.service.HttpProxyService;
import de.virtimo.bpc.core.auth.CsrfTokenException;
import de.virtimo.bpc.core.auth.CsrfTokenService;
import de.virtimo.bpc.jaxrs.ApiResponse;
import de.virtimo.bpc.jaxrs.ApiResponses;
import de.virtimo.bpc.jaxrs.BpcUserSessionRequired;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.Encoded;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.osgi.framework.BundleContext;

@Path(value="httpProxy")
public class HttpProxyEndpoint {
    private static final Logger LOG = Logger.getLogger(HttpProxyEndpoint.class.getName());
    private final BundleContext bundleContext;
    private BpcServicesTracker<HttpProxyService> httpProxyServiceTracker;
    private BpcServicesTracker<ErrorResponseService> errorResponseServiceTracker;
    private BpcServicesTracker<CsrfTokenService> csrfTokenServiceTracker;

    public HttpProxyEndpoint(BundleContext bundleContext) {
        LOG.info("HttpProxyEndpoint bundleContext=" + bundleContext);
        this.bundleContext = bundleContext;
    }

    public void onStartup() {
        LOG.info("onStartup");
        this.httpProxyServiceTracker = new BpcServicesTracker<HttpProxyService>(this.bundleContext, HttpProxyService.class);
        this.errorResponseServiceTracker = new BpcServicesTracker<ErrorResponseService>(this.bundleContext, ErrorResponseService.class);
        this.csrfTokenServiceTracker = new BpcServicesTracker<CsrfTokenService>(this.bundleContext, CsrfTokenService.class);
    }

    public void onShutdown() {
        LOG.info("onShutdown");
        BpcServicesTracker.stopAll(this);
    }

    private void checkCsrfToken(HttpServletRequest req, UserSession userSession, String instanceId) throws CsrfTokenException, ServiceNotFoundException, ModuleNotFoundException, ModuleInstanceNotFoundException {
        LOG.log(Level.FINEST, "checkCsrfToken req=..., instanceId=" + instanceId);
        if (this.httpProxyServiceTracker.getService().getConfig(instanceId).getSettingValue("checkCsrfToken").asBoolean(true) && !this.csrfTokenServiceTracker.getService().isValidRequest(req, userSession)) {
            throw new CsrfTokenException();
        }
    }

    @GET
    @Path(value="/{instanceId}{targetPath: (/.*)?}")
    @BpcUserSessionRequired(skipCsrfCheck="true")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="One of the used services is not available"), @ApiResponse(responseCode="404", description="The backend connections module is not available"), @ApiResponse(responseCode="404", description="The backend connections module instance is not available"), @ApiResponse(responseCode="500", description="General problem with the backend system"), @ApiResponse(responseCode="503", description="Connection to backend system refused"), @ApiResponse(responseCode="504", description="Connection to backend system timed out")})
    public Response proxyGet(@PathParam(value="instanceId") String instanceId, @PathParam(value="targetPath") @Encoded @DefaultValue(value="") String targetPath, @QueryParam(value="targetUrl") @DefaultValue(value="") String targetUrl, @QueryParam(value="forceJson") @DefaultValue(value="false") boolean forceJson, @Context HttpServletRequest req, @Context UriInfo uriInfo, @Context UserSession userSession, @Context HttpHeaders headers) {
        LOG.log(Level.FINEST, "proxyGet : proxyInstanceId={1} uriInfo={0} ", new Object[]{uriInfo, instanceId});
        try {
            this.checkCsrfToken(req, userSession, instanceId);
            return this.httpProxyServiceTracker.getService().doGet(instanceId, targetPath, targetUrl, uriInfo, headers, userSession, forceJson);
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, "Exception backend connection: ", ex);
            return ErrorResponse.forException(ex).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @POST
    @Path(value="/{instanceId}{targetPath: (/.*)?}")
    @BpcUserSessionRequired(skipCsrfCheck="true")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="One of the used services is not available"), @ApiResponse(responseCode="404", description="The backend connections module is not available"), @ApiResponse(responseCode="404", description="The backend connections module instance is not available"), @ApiResponse(responseCode="500", description="General problem with the backend system"), @ApiResponse(responseCode="503", description="Connection to backend system refused"), @ApiResponse(responseCode="504", description="Connection to backend system timed out")})
    public Response proxyPost(@PathParam(value="instanceId") String instanceId, @PathParam(value="targetPath") @Encoded @DefaultValue(value="") String targetPath, @QueryParam(value="targetUrl") String targetUrl, @DefaultValue(value="false") @QueryParam(value="forceJson") boolean forceJson, @Context HttpServletRequest req, @Context HttpHeaders headers, @Context UriInfo uriInfo, @Context UserSession userSession, byte[] body) {
        LOG.log(Level.FINEST, "proxyPost : proxyInstanceId={1} uriInfo={0} ", new Object[]{uriInfo, instanceId});
        try {
            this.checkCsrfToken(req, userSession, instanceId);
            return this.httpProxyServiceTracker.getService().doPost(instanceId, targetPath, targetUrl, uriInfo, headers, userSession, body, forceJson);
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, "Exception backend connection: ", ex);
            return ErrorResponse.forException(ex).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @PUT
    @Path(value="/{instanceId}{targetPath: (/.*)?}")
    @BpcUserSessionRequired(skipCsrfCheck="true")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="One of the used services is not available"), @ApiResponse(responseCode="404", description="The backend connections module is not available"), @ApiResponse(responseCode="404", description="The backend connections module instance is not available"), @ApiResponse(responseCode="500", description="General problem with the backend system"), @ApiResponse(responseCode="503", description="Connection to backend system refused"), @ApiResponse(responseCode="504", description="Connection to backend system timed out")})
    public Response proxyPut(@PathParam(value="instanceId") String instanceId, @PathParam(value="targetPath") @Encoded @DefaultValue(value="") String targetPath, @QueryParam(value="targetUrl") String targetUrl, @DefaultValue(value="false") @QueryParam(value="forceJson") boolean forceJson, @Context HttpServletRequest req, @Context HttpHeaders headers, @Context UriInfo uriInfo, @Context UserSession userSession, byte[] body) {
        LOG.log(Level.FINEST, "proxyPut : proxyInstanceId={1} uriInfo={0} ", new Object[]{uriInfo, instanceId});
        try {
            this.checkCsrfToken(req, userSession, instanceId);
            return this.httpProxyServiceTracker.getService().doPut(instanceId, targetPath, targetUrl, uriInfo, headers, userSession, body, forceJson);
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, "Exception backend connection: ", ex);
            return ErrorResponse.forException(ex).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @DELETE
    @Path(value="/{instanceId}{targetPath: (/.*)?}")
    @BpcUserSessionRequired(skipCsrfCheck="true")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="One of the used services is not available"), @ApiResponse(responseCode="404", description="The backend connections module is not available"), @ApiResponse(responseCode="404", description="The backend connections module instance is not available"), @ApiResponse(responseCode="500", description="General problem with the backend system"), @ApiResponse(responseCode="503", description="Connection to backend system refused"), @ApiResponse(responseCode="504", description="Connection to backend system timed out")})
    public Response proxyDelete(@PathParam(value="instanceId") String instanceId, @PathParam(value="targetPath") @Encoded @DefaultValue(value="") String targetPath, @QueryParam(value="targetUrl") String targetUrl, @DefaultValue(value="false") @QueryParam(value="forceJson") boolean forceJson, @Context HttpServletRequest req, @Context HttpHeaders headers, @Context UriInfo uriInfo, @Context UserSession userSession) {
        LOG.log(Level.FINEST, "proxyDelete : proxyInstanceId={1} uriInfo={0} ", new Object[]{uriInfo, instanceId});
        try {
            this.checkCsrfToken(req, userSession, instanceId);
            return this.httpProxyServiceTracker.getService().doDelete(instanceId, targetPath, targetUrl, uriInfo, headers, userSession, forceJson);
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, "Exception backend connection: ", ex);
            return ErrorResponse.forException(ex).usingTracker(this.errorResponseServiceTracker).build();
        }
    }
}

