/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.lookupjoins;

import de.virtimo.bpc.api.exception.OpenSearchRelatedException;
import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.util.MapUtil;
import de.virtimo.bpc.util.StringUtil;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.opensearch.OpenSearchException;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.search.SearchType;
import org.opensearch.client.RequestOptions;
import org.opensearch.client.RestHighLevelClient;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.search.SearchHit;
import org.opensearch.search.builder.SearchSourceBuilder;

public class LookupJoin {
    private static final Logger LOG = Logger.getLogger(LookupJoin.class.getName());
    private static final Map<String, Object> NotFound = new HashMap<String, Object>();
    private String keyField;
    private String keyFieldValuesSeparator;
    private String lookupIndex;
    private String lookupKeyField;
    private String resultFieldsPrefix;
    private String[] resultFieldsIncluded;
    private String[] resultFieldsExcluded;
    private boolean cachingEnabled;
    private Map<Object, Map<String, Object>> cache;

    public LookupJoin(Map<String, Object> lookupJoinConfig) {
        this.keyField = MapUtil.getValueAsString(lookupJoinConfig, "keyField", null);
        this.keyFieldValuesSeparator = MapUtil.getValueAsString(lookupJoinConfig, "keyFieldValuesSeparator", null);
        this.lookupIndex = MapUtil.getValueAsString(lookupJoinConfig, "lookupIndex", null);
        this.lookupKeyField = MapUtil.getValueAsString(lookupJoinConfig, "lookupKeyField", null);
        this.resultFieldsPrefix = MapUtil.getValueAsString(lookupJoinConfig, "resultFieldsPrefix", null);
        this.resultFieldsIncluded = MapUtil.getValueAsStringArray(lookupJoinConfig, "resultFieldsIncluded", null);
        this.resultFieldsExcluded = MapUtil.getValueAsStringArray(lookupJoinConfig, "resultFieldsExcluded", null);
        this.cachingEnabled = MapUtil.getValueAsBoolean(lookupJoinConfig, "caching", true);
        this.cache = new HashMap<Object, Map<String, Object>>();
    }

    public void clearCache() {
        LOG.fine("clearCache");
        this.cache.clear();
    }

    public String getKeyField() {
        return this.keyField;
    }

    public boolean isMultiValueKeyField() {
        return !StringUtil.isNullOrEmpty(this.keyFieldValuesSeparator);
    }

    public String getKeyFieldValuesSeparator() {
        return this.keyFieldValuesSeparator;
    }

    public String getLookupIndex() {
        return this.lookupIndex;
    }

    public String getLookupKeyField() {
        return this.lookupKeyField;
    }

    public String getResultFieldsPrefix() {
        return this.resultFieldsPrefix;
    }

    public String getResultFieldName(String fieldName) {
        return this.resultFieldsPrefix + fieldName;
    }

    public Map<String, Object> getAlreadyPrefixedLookupData(OpenSearchService oss, Object keyValue) throws OpenSearchRelatedException {
        LOG.fine("getAlreadyPrefixedLookupData oss=..., keyValue=" + keyValue);
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (this.isMultiValueKeyField()) {
            List<String> values = StringUtil.explode((String)keyValue, this.keyFieldValuesSeparator);
            if (values != null) {
                boolean previousLookupDataNotFound = false;
                for (String value : values) {
                    Map<String, Object> lookupData = this.getLookupData(oss, value);
                    if (!lookupData.isEmpty()) {
                        if (previousLookupDataNotFound) {
                            lookupData.forEach((lookupDataKey, lookupDataValue) -> {
                                String resultFieldName = this.getResultFieldName((String)lookupDataKey);
                                Object existingResultFieldValueObject = result.get(resultFieldName);
                                if (existingResultFieldValueObject == null) {
                                    result.put(resultFieldName, this.keyFieldValuesSeparator);
                                } else {
                                    result.put(resultFieldName, existingResultFieldValueObject + this.keyFieldValuesSeparator);
                                }
                            });
                        }
                        previousLookupDataNotFound = false;
                        lookupData.forEach((lookupDataKey, lookupDataValue) -> {
                            String resultFieldName = this.getResultFieldName((String)lookupDataKey);
                            String resultFieldValueAsString = lookupDataValue == null ? null : lookupDataValue.toString();
                            Object existingResultFieldValueObject = result.get(resultFieldName);
                            if (existingResultFieldValueObject == null) {
                                result.put(resultFieldName, resultFieldValueAsString);
                            } else {
                                result.put(resultFieldName, existingResultFieldValueObject + this.keyFieldValuesSeparator + resultFieldValueAsString);
                            }
                        });
                        continue;
                    }
                    previousLookupDataNotFound = true;
                }
            }
        } else {
            Map<String, Object> lookupData = this.getLookupData(oss, keyValue);
            if (!lookupData.isEmpty()) {
                lookupData.forEach((lookupDataKey, lookupDataValue) -> {
                    String resultFieldName = this.getResultFieldName((String)lookupDataKey);
                    result.put(resultFieldName, lookupDataValue);
                });
            }
        }
        return result;
    }

    private Map<String, Object> getLookupData(OpenSearchService oss, Object keyValue) throws OpenSearchRelatedException {
        Map<String, Object> cachedResult;
        LOG.fine("getLookupData keyValue:" + keyValue);
        if (keyValue == null) {
            return NotFound;
        }
        if (this.cachingEnabled && (cachedResult = this.cache.get(keyValue)) != null) {
            if (cachedResult.size() == 0) {
                LOG.fine(keyValue + ": No cached result found");
                return NotFound;
            }
            LOG.fine(keyValue + ": Returning cached result: " + cachedResult);
            return cachedResult;
        }
        try {
            RestHighLevelClient osClient = oss.getClient();
            SearchRequest searchReq = new SearchRequest().indices(this.lookupIndex).source(new SearchSourceBuilder().from(0).size(2).query(QueryBuilders.constantScoreQuery(QueryBuilders.termQuery(this.lookupKeyField, keyValue))).fetchSource(this.resultFieldsIncluded, this.resultFieldsExcluded)).searchType(SearchType.DEFAULT);
            SearchResponse response = osClient.search(searchReq, RequestOptions.DEFAULT);
            SearchHit[] hits = response.getHits().getHits();
            Map<String, Object> result = null;
            if (hits == null || hits.length == 0) {
                LOG.fine(keyValue + ": No lookup document found. " + this);
            } else if (hits.length > 1) {
                LOG.log(Level.SEVERE, keyValue + ": No unique lookup document found. They must be unique. " + this);
            } else {
                result = hits[0].getSourceAsMap();
                LOG.fine(keyValue + ": Found the lookup document: " + result);
            }
            if (this.cachingEnabled) {
                if (result == null) {
                    LOG.fine(keyValue + ": Caching the 'Not found' result");
                    this.cache.put(keyValue, NotFound);
                } else {
                    LOG.fine(keyValue + ": Caching the found result: " + result);
                    this.cache.put(keyValue, result);
                }
            }
            return result == null ? NotFound : result;
        }
        catch (IOException ex) {
            throw new OpenSearchRelatedException(ex);
        }
        catch (OpenSearchException ex) {
            throw new OpenSearchRelatedException(ex);
        }
    }

    public String toString() {
        return "LookupJoin{keyField='" + this.keyField + "', keyFieldValuesSeparator='" + this.keyFieldValuesSeparator + "', lookupIndex='" + this.lookupIndex + "', lookupKeyField='" + this.lookupKeyField + "', resultFieldsPrefix='" + this.resultFieldsPrefix + "', resultFieldsIncluded=" + Arrays.toString(this.resultFieldsIncluded) + ", resultFieldsExcluded=" + Arrays.toString(this.resultFieldsExcluded) + ", cachingEnabled=" + this.cachingEnabled + "}";
    }
}

