/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.lookupjoins;

import de.virtimo.bpc.api.AbstractBackendModuleLoadedEventHandler;
import de.virtimo.bpc.api.AbstractEventHandler;
import de.virtimo.bpc.api.AbstractMaintenanceModeAcknowledgeEventHandler;
import de.virtimo.bpc.api.AbstractSettingsUpdatedEventHandler;
import de.virtimo.bpc.api.BpcService;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.EventRegistration;
import de.virtimo.bpc.api.Module;
import de.virtimo.bpc.api.ModuleInstance;
import de.virtimo.bpc.api.ModuleManager;
import de.virtimo.bpc.api.Percolator;
import de.virtimo.bpc.api.PercolatorsManager;
import de.virtimo.bpc.api.exception.JsonGenerationException;
import de.virtimo.bpc.api.exception.LogServiceSettingsException;
import de.virtimo.bpc.api.exception.ModuleInstanceNotFoundException;
import de.virtimo.bpc.api.exception.ModuleNotFoundException;
import de.virtimo.bpc.api.exception.OpenSearchRelatedException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.opensearch.SearchScrollIterator;
import de.virtimo.bpc.api.opensearch.plugin.OpenSearchBpcPluginManager;
import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.core.CoreModule;
import de.virtimo.bpc.core.exception.CoreErrorCode;
import de.virtimo.bpc.core.lookupjoins.LookupJoin;
import de.virtimo.bpc.core.lookupjoins.LookupJoinUpdaterData;
import de.virtimo.bpc.core.lookupjoins.LookupJoins;
import de.virtimo.bpc.core.lookupjoins.LookupJoinsException;
import de.virtimo.bpc.core.lookupjoins.LookupJoinsManager;
import de.virtimo.bpc.core.lookupjoins.LookupJoinsUpdater;
import de.virtimo.bpc.core.opensearch.XContentBuilderUtil;
import de.virtimo.bpc.core.percolators.PercolatorsProcessorImpl;
import de.virtimo.bpc.core.replicator.ReplicationJob;
import de.virtimo.bpc.core.replicator.ReplicationJobNotFoundException;
import de.virtimo.bpc.core.replicator.ReplicationManager;
import de.virtimo.bpc.logservice.LogServiceModule;
import de.virtimo.bpc.logservice.LogServiceModuleInstance;
import de.virtimo.bpc.opensearch.plugin.dto.FilterDTO;
import de.virtimo.bpc.opensearch.plugin.dto.FiltersDTO;
import de.virtimo.bpc.opensearch.plugin.dto.IndexOperationDTO;
import de.virtimo.bpc.util.MapUtil;
import de.virtimo.bpc.util.ThreadFactoryWithNamePrefix;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.opensearch.OpenSearchException;
import org.opensearch.action.bulk.BulkRequest;
import org.opensearch.action.bulk.BulkResponse;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.client.RequestOptions;
import org.opensearch.client.RestHighLevelClient;
import org.opensearch.client.indices.PutMappingRequest;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.search.SearchHit;
import org.opensearch.search.SearchHits;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.osgi.framework.BundleContext;
import org.osgi.service.event.Event;

public class LookupJoinsManagerImpl
implements LookupJoinsManager,
BpcService {
    private static final Logger LOG = Logger.getLogger(LookupJoinsManager.class.getName());
    private final BundleContext bundleContext;
    private final BpcServicesTracker<ReplicationManager> replicationManagerTracker;
    private final BpcServicesTracker<OpenSearchService> openSearchServiceTracker;
    private final BpcServicesTracker<ModuleManager> moduleManagerTracker;
    private final BpcServicesTracker<OpenSearchBpcPluginManager> openSearchBpcPluginManagerTracker;
    private final BpcServicesTracker<PercolatorsManager> percolatorsManagerTracker;
    private final EventRegistration eventRegistration;
    private final ExecutorService executorService;
    private final Map<String, Future<Boolean>> lookupJoinsUpdates;
    private final ExecutorService informClientsExecutorService;

    public LookupJoinsManagerImpl(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.executorService = Executors.newFixedThreadPool(1, new ThreadFactoryWithNamePrefix("bpc-core-lookupjoins-updater"));
        this.lookupJoinsUpdates = new HashMap<String, Future<Boolean>>();
        this.informClientsExecutorService = Executors.newFixedThreadPool(1, new ThreadFactoryWithNamePrefix("bpc-core-lookupjoins-clients-informer"));
        this.replicationManagerTracker = new BpcServicesTracker<ReplicationManager>(bundleContext, ReplicationManager.class);
        this.openSearchServiceTracker = new BpcServicesTracker<OpenSearchService>(bundleContext, OpenSearchService.class);
        this.moduleManagerTracker = new BpcServicesTracker<ModuleManager>(bundleContext, ModuleManager.class);
        this.openSearchBpcPluginManagerTracker = new BpcServicesTracker<OpenSearchBpcPluginManager>(bundleContext, OpenSearchBpcPluginManager.class);
        this.percolatorsManagerTracker = new BpcServicesTracker<PercolatorsManager>(bundleContext, PercolatorsManager.class);
        this.eventRegistration = new EventRegistration(bundleContext);
        this.eventRegistration.forBackendModuleLoadedEvents("replication", new ReplicationModuleLoadedEventHandler());
        this.eventRegistration.forBackendModuleLoadedEvents("logservice", new LogServiceModuleLoadedEventHandler());
        this.eventRegistration.forMaintenanceModeAcknowledgeEvents(new MaintenanceModeChangedEventHandler(bundleContext));
        this.eventRegistration.forServerModeChangedEvents(new MasterOrSlaveModeChangedEventHandler());
        this.eventRegistration.forModuleInstanceCreatedEvents("replication", "none", new ReplicationModuleInstanceCreatedEventHandler());
        this.eventRegistration.forModuleInstanceUpdatedEvents("replication", "none", new ReplicationModuleInstanceUpdatedEventHandler());
        this.eventRegistration.forModuleInstanceDeletedEvents("replication", "none", new ReplicationModuleInstanceDeletedEventHandler());
        this.eventRegistration.forModuleInstanceCreatedEvents("logservice", "none", new LogServiceModuleInstanceCreatedEventHandler());
        this.eventRegistration.forModuleInstanceUpdatedEvents("logservice", "none", new LogServiceModuleInstanceUpdatedEventHandler());
        this.eventRegistration.forModuleInstanceDeletedEvents("logservice", "none", new LogServiceModuleInstanceDeletedEventHandler());
    }

    @Override
    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    @Override
    public void shutdownService() {
        LOG.info("shutdownService");
        if (this.executorService != null) {
            try {
                this.executorService.shutdownNow();
                this.executorService.awaitTermination(30L, TimeUnit.SECONDS);
            }
            catch (Throwable t) {
                LOG.log(Level.SEVERE, "Failed to shutdown the lookup joins executor thread pool.");
            }
        }
        if (this.informClientsExecutorService != null) {
            this.informClientsExecutorService.shutdown();
        }
        BpcServicesTracker.stopAll(this);
        this.eventRegistration.unregisterAllEventHandler();
    }

    @Override
    public void clearLookupJoinCaches() throws ServiceNotFoundException {
        LOG.info("clearLookupJoinCaches");
        for (ReplicationJob replicationJob : this.replicationManagerTracker.getService().getJobs()) {
            replicationJob.getLookupJoins().clearCaches();
        }
        try {
            LogServiceModule logServiceModule = this.moduleManagerTracker.getService().getModuleByClass(LogServiceModule.class);
            for (ModuleInstance moduleInstance : logServiceModule.getModuleInstances().values()) {
                LogServiceModuleInstance logServiceModuleInstance = (LogServiceModuleInstance)moduleInstance;
                logServiceModuleInstance.getLookupJoins().clearCaches();
            }
        }
        catch (ModuleNotFoundException ex) {
            LOG.warning("Failed to clear the lookup join caches of the '" + LogServiceModule.class.getSimpleName() + "'. The module is not loaded at the moment.");
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public void refreshAllLookupJoins() throws InterruptedException, LookupJoinsException, ServiceNotFoundException, OpenSearchRelatedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void refreshLookupJoinsOfReplicationJob(String replicationJobId) throws InterruptedException, ReplicationJobNotFoundException, ServiceNotFoundException, OpenSearchRelatedException {
        LOG.info("refreshLookupJoinsOfReplicationJob replicationJobId:" + replicationJobId);
        ReplicationJob replicationJob = this.replicationManagerTracker.getService().getReplicationJobById(replicationJobId);
        LookupJoinUpdaterData updaterData = new LookupJoinUpdaterData(replicationJob.getTarget().getIndex(), replicationJob.getLookupJoins(), replicationJob.getLookupJoins().getKeyFields());
        this.refreshLookupJoins(updaterData);
    }

    @Override
    public void refreshLookupJoinsOfLogService(String logServiceId) throws InterruptedException, ModuleNotFoundException, ModuleInstanceNotFoundException, LookupJoinsException, ServiceNotFoundException, OpenSearchRelatedException {
        LOG.info("refreshLookupJoinsOfLogService logServiceId:" + logServiceId);
        LogServiceModuleInstance logServiceModuleInstance = (LogServiceModuleInstance)this.moduleManagerTracker.getService().getModuleByClass(LogServiceModule.class).getModuleInstanceById(logServiceId);
        if (!logServiceModuleInstance.isOpenSearchLoggingEnabled()) {
            throw new LookupJoinsException((ErrorCode)CoreErrorCode.LOOKUP_JOIN_OPENSEARCH_LOGGING_DISABLED, "Lookup joins refresh failed. The Log Service with the ID '${logServiceId}' does not use OpenSearch logging.", MapUtil.mapOf("logServiceId", logServiceId));
        }
        LookupJoins lookupJoins = logServiceModuleInstance.getLookupJoins();
        if (!lookupJoins.hasEntries()) {
            throw new LookupJoinsException((ErrorCode)CoreErrorCode.LOOKUP_JOIN_SETTING_INVALID, "Lookup joins refresh failed. The Log Service with the ID '${logServiceId}' has no lookup joins.", MapUtil.mapOf("logServiceId", logServiceId));
        }
        try {
            LogServiceModuleInstance.OpenSearchConfig openSearchConfig = logServiceModuleInstance.getOpenSearchConfig();
            if (openSearchConfig.parent != null) {
                LookupJoinUpdaterData parentUpdaterData = new LookupJoinUpdaterData(openSearchConfig.parent.index, lookupJoins, lookupJoins.getKeyFields());
                this.refreshLookupJoins(parentUpdaterData);
            }
            if (openSearchConfig.child != null) {
                LookupJoinUpdaterData childUpdaterData = new LookupJoinUpdaterData(openSearchConfig.child.index, lookupJoins, lookupJoins.getKeyFields());
                this.refreshLookupJoins(childUpdaterData);
            }
        }
        catch (LogServiceSettingsException ex) {
            throw new LookupJoinsException((ErrorCode)CoreErrorCode.LOOKUP_JOIN_SETTING_INVALID, "Lookup joins refresh failed. The OpenSearch settings of the Log Service with the ID '${instanceId}' are invalid.", MapUtil.mapOf("instanceId", logServiceId), (Throwable)ex);
        }
    }

    private void addDynamicTemplatesMapping(OpenSearchService oss, String index) {
        LOG.info("addDynamicTemplatesMapping oss=..., index=" + index);
        Map<String, Object> currentMapping = oss.getMapping(index);
        if (!oss.hasDynamicTemplatesMapping(currentMapping)) {
            try {
                List defaultDynamicTemplates = oss.getDefaultDynamicTemplates();
                XContentBuilder mappingBuilder = XContentFactory.jsonBuilder().prettyPrint();
                mappingBuilder.startObject();
                XContentBuilderUtil.addExistingMapping(mappingBuilder, currentMapping);
                XContentBuilderUtil.addDynamicTemplatesMapping(mappingBuilder, defaultDynamicTemplates);
                mappingBuilder.endObject();
                this.doIndexMappingUpdate(oss, index, mappingBuilder);
            }
            catch (OpenSearchRelatedException | IOException ex) {
                LOG.log(Level.SEVERE, "Could not create the dynamic template mapping of the index '" + index + "'", ex);
            }
        }
    }

    private void doIndexMappingUpdate(OpenSearchService oss, String index, XContentBuilder mappingBuilder) throws OpenSearchRelatedException {
        try {
            PutMappingRequest putMappingRequest = new PutMappingRequest(index).source(mappingBuilder);
            oss.getClient().indices().putMapping(putMappingRequest, RequestOptions.DEFAULT);
        }
        catch (IOException ex) {
            throw new OpenSearchRelatedException(ex);
        }
        catch (OpenSearchException ex) {
            throw new OpenSearchRelatedException(ex);
        }
    }

    @Override
    public void refreshLookupJoins(LookupJoinUpdaterData updaterData) throws InterruptedException, ServiceNotFoundException, OpenSearchRelatedException {
        LOG.info("refreshLookupJoins updaterData:" + updaterData);
        if (updaterData == null) {
            LOG.info("Nothing to do");
            return;
        }
        final String osIndex = updaterData.getIndex();
        LookupJoins lookupJoins = updaterData.getLookupJoins();
        Set<String> keyFields = updaterData.getKeyFields();
        if (keyFields == null || keyFields.isEmpty()) {
            LOG.info("Nothing to do");
            return;
        }
        lookupJoins.clearCaches(keyFields);
        try {
            final OpenSearchService oss = this.openSearchServiceTracker.getService();
            final PercolatorsManager percolatorsManager = this.percolatorsManagerTracker.getService();
            RestHighLevelClient osClient = oss.getClient();
            this.addDynamicTemplatesMapping(oss, osIndex);
            Set<Percolator> percolatorsFromIndex = percolatorsManager.getAllValidPercolatorsFromIndex(oss, osIndex);
            final PercolatorsProcessorImpl percolatorsProcessor = new PercolatorsProcessorImpl(oss, osIndex, percolatorsFromIndex);
            SearchRequest searchReq = new SearchRequest().indices(osIndex).source(new SearchSourceBuilder().size(500).query(QueryBuilders.matchAllQuery()));
            BulkRequest bulkRequest = new BulkRequest().timeout(TimeValue.timeValueSeconds(60L));
            try (SearchScrollIterator searchScrollIterator = new SearchScrollIterator(oss, searchReq);){
                while (searchScrollIterator.hasNext()) {
                    SearchHits searchHits = searchScrollIterator.next();
                    for (SearchHit hit : searchHits) {
                        Map<String, Object> sourceValues = hit.getSourceAsMap();
                        boolean documentUpdateNecessary = false;
                        for (String keyField : keyFields) {
                            LOG.finest("Processing key field: " + keyField);
                            LookupJoin lookupJoin = lookupJoins.getLookupJoinByKeyField(keyField);
                            Map<String, Object> oldLookupValues = MapUtil.getEntriesWithKeyPrefix(sourceValues, lookupJoin.getResultFieldsPrefix());
                            if (sourceValues.containsKey(keyField)) {
                                Object columnValue = sourceValues.get(keyField);
                                Map<String, Object> newLookupValues = lookupJoin.getAlreadyPrefixedLookupData(oss, columnValue);
                                LOG.finest("oldLookupValues: " + oldLookupValues);
                                LOG.finest("newLookupValues: " + newLookupValues);
                                if (!oldLookupValues.equals(newLookupValues)) {
                                    LOG.finest("new and old lookup values are different, must be updated");
                                    documentUpdateNecessary = true;
                                    for (String oldKeyField : oldLookupValues.keySet()) {
                                        sourceValues.remove(oldKeyField);
                                    }
                                    sourceValues.putAll(newLookupValues);
                                    continue;
                                }
                                LOG.finest("Great, the old and new lookup values are identical");
                                continue;
                            }
                            LOG.finest("Did not find old lookup values");
                            for (String oldKeyField : oldLookupValues.keySet()) {
                                if (sourceValues.remove(oldKeyField) == null) continue;
                                documentUpdateNecessary = true;
                            }
                        }
                        if (documentUpdateNecessary) {
                            LOG.finest("The document must be updated: " + hit);
                            bulkRequest.add(((IndexRequest)new IndexRequest().index(osIndex)).id(hit.getId()).source(sourceValues, (MediaType)XContentType.JSON));
                        } else {
                            LOG.finest("Nothing to do, the document is already up to date: " + hit);
                        }
                        if (bulkRequest.numberOfActions() <= 250) continue;
                        BulkResponse bulkResponse = osClient.bulk(bulkRequest, RequestOptions.DEFAULT);
                        LOG.info("Refreshed lookup joins indexed {" + bulkRequest.numberOfActions() + "}, hasFailures: {" + bulkResponse.hasFailures() + "}");
                        percolatorsProcessor.keepDatabaseIDsFromBulkResponse(bulkResponse);
                        bulkRequest = new BulkRequest().timeout(TimeValue.timeValueSeconds(60L));
                    }
                }
            }
            if (bulkRequest.numberOfActions() > 0) {
                BulkResponse bulkResponse = osClient.bulk(bulkRequest, RequestOptions.DEFAULT);
                LOG.info("Refreshed lookup joins indexed {" + bulkRequest.numberOfActions() + "}, hasFailures: {" + bulkResponse.hasFailures() + "}");
                percolatorsProcessor.keepDatabaseIDsFromBulkResponse(bulkResponse);
            }
            percolatorsProcessor.process();
            FutureTask<Exception> informClientsFutureTask = new FutureTask<Exception>(new Callable<Exception>(){

                @Override
                public Exception call() {
                    try {
                        percolatorsManager.informClientsAboutReplicatedData(oss, osIndex, percolatorsProcessor);
                        return null;
                    }
                    catch (Exception ex) {
                        LOG.log(Level.SEVERE, ex.getMessage(), ex);
                        return ex;
                    }
                }
            });
            this.informClientsExecutorService.execute(informClientsFutureTask);
        }
        catch (IOException ex) {
            throw new OpenSearchRelatedException(ex);
        }
        catch (OpenSearchException ex) {
            throw new OpenSearchRelatedException(ex);
        }
    }

    private synchronized void unregisterFromOpenSearchChanges() throws ServiceNotFoundException, JsonGenerationException {
        LOG.info("unregisterFromOpenSearchChanges");
        OpenSearchService openSearchService = this.openSearchServiceTracker.getService();
        OpenSearchBpcPluginManager openSearchBpcPluginManager = this.openSearchBpcPluginManagerTracker.getService();
        openSearchBpcPluginManager.unregisterAllFilters(openSearchService);
    }

    private synchronized void registerForOpenSearchChanges() throws ServiceNotFoundException, JsonGenerationException {
        LOG.info("registerForOpenSearchChanges");
        OpenSearchBpcPluginManager openSearchBpcPluginManager = this.openSearchBpcPluginManagerTracker.getService();
        FiltersDTO filtersToRegister = new FiltersDTO();
        for (ReplicationJob job : this.replicationManagerTracker.getService().getJobs()) {
            this.addLookupJoinsToFiltersToRegisterContainer(job.getLookupJoins(), filtersToRegister);
        }
        try {
            LogServiceModule logServiceModule = this.moduleManagerTracker.getService().getModuleByClass(LogServiceModule.class);
            for (ModuleInstance moduleInstance : logServiceModule.getModuleInstances().values()) {
                LogServiceModuleInstance logServiceModuleInstance = (LogServiceModuleInstance)moduleInstance;
                if (!logServiceModuleInstance.isOpenSearchLoggingEnabled()) continue;
                this.addLookupJoinsToFiltersToRegisterContainer(logServiceModuleInstance.getLookupJoins(), filtersToRegister);
            }
        }
        catch (ModuleNotFoundException ex) {
            LOG.warning("Failed to register the used '" + LogServiceModule.class.getSimpleName() + "' indices for OpenSearch changes. The module is not loaded at the moment. Gets registered when loaded.");
        }
        LOG.info("Filters to register: " + filtersToRegister);
        openSearchBpcPluginManager.registerFilters(filtersToRegister);
    }

    private void addLookupJoinsToFiltersToRegisterContainer(LookupJoins lookupJoins, FiltersDTO filtersToRegister) {
        LOG.info("addLookupJoinsToFiltersToRegisterContainer lookupJoins=..., filtersToRegister=...");
        if (lookupJoins != null && lookupJoins.hasEntries()) {
            for (LookupJoin lookupJoin : lookupJoins.getEntries()) {
                FilterDTO filterToRegister = new FilterDTO(lookupJoin.getLookupIndex(), true);
                filtersToRegister.addFilter(filterToRegister);
            }
        }
    }

    @Override
    public void handleOpenSearchBpcPluginIndexOperation(IndexOperationDTO indexOperation) throws ServiceNotFoundException {
        LOG.fine("handleOpenSearchBpcPluginIndexOperation indexOperation=" + indexOperation);
        Set indexAndAliasNames = indexOperation.getIndexAndAliasNames();
        ArrayList<LookupJoinUpdaterData> updaterDatas = new ArrayList<LookupJoinUpdaterData>();
        for (ReplicationJob replicationJob : this.replicationManagerTracker.getService().getJobs()) {
            List<LookupJoin> relatedLookupJoinEntries;
            LookupJoins lookupJoins = replicationJob.getLookupJoins();
            if (lookupJoins == null || !lookupJoins.hasEntries() || (relatedLookupJoinEntries = lookupJoins.getLookupJoinsByLookupIndex(indexAndAliasNames)) == null || relatedLookupJoinEntries.isEmpty()) continue;
            LookupJoinUpdaterData updaterData = new LookupJoinUpdaterData(replicationJob.getTarget().getIndex(), lookupJoins, LookupJoins.getKeyFields(relatedLookupJoinEntries));
            updaterDatas.add(updaterData);
        }
        try {
            LogServiceModule logServiceModule = this.moduleManagerTracker.getService().getModuleByClass(LogServiceModule.class);
            for (ModuleInstance moduleInstance : logServiceModule.getModuleInstances().values()) {
                List<LookupJoin> relatedLookupJoinEntries;
                LookupJoins lookupJoins;
                LogServiceModuleInstance logServiceModuleInstance = (LogServiceModuleInstance)moduleInstance;
                if (!logServiceModuleInstance.isOpenSearchLoggingEnabled() || !(lookupJoins = logServiceModuleInstance.getLookupJoins()).hasEntries() || (relatedLookupJoinEntries = lookupJoins.getLookupJoinsByLookupIndex(indexAndAliasNames)) == null || relatedLookupJoinEntries.isEmpty()) continue;
                try {
                    LogServiceModuleInstance.OpenSearchConfig openSearchConfig = logServiceModuleInstance.getOpenSearchConfig();
                    boolean childProcessingEnabled = openSearchConfig.child != null;
                    LookupJoinUpdaterData parentUpdaterData = new LookupJoinUpdaterData(openSearchConfig.parent.index, lookupJoins, LookupJoins.getKeyFields(relatedLookupJoinEntries));
                    updaterDatas.add(parentUpdaterData);
                    if (!childProcessingEnabled) continue;
                    LookupJoinUpdaterData childUpdaterData = new LookupJoinUpdaterData(openSearchConfig.child.index, lookupJoins, LookupJoins.getKeyFields(relatedLookupJoinEntries));
                    updaterDatas.add(childUpdaterData);
                }
                catch (LogServiceSettingsException e) {
                    LOG.log(Level.SEVERE, "Could not get the OpenSearch settings.", e);
                }
            }
        }
        catch (ModuleNotFoundException ex) {
            LOG.warning("Skipping '" + LogServiceModule.class.getSimpleName() + "' indices related events until the module is loaded.");
        }
        for (LookupJoinUpdaterData lookupJoinUpdaterData : updaterDatas) {
            LOG.info("Loookup joins to refresh: " + lookupJoinUpdaterData);
            Future<Boolean> lookupJoinUpdaterFuture = this.lookupJoinsUpdates.get(lookupJoinUpdaterData.getIndex());
            if (lookupJoinUpdaterFuture != null && !lookupJoinUpdaterFuture.isDone()) {
                lookupJoinUpdaterFuture.cancel(true);
            }
            Future<Boolean> futureUpdate = this.executorService.submit(new LookupJoinsUpdater(this, lookupJoinUpdaterData));
            this.lookupJoinsUpdates.put(lookupJoinUpdaterData.getIndex(), futureUpdate);
        }
    }

    private boolean isMasterServer() {
        LOG.fine("isMasterServer");
        try {
            return this.moduleManagerTracker.getService().getModuleByClass(CoreModule.class).isMasterServer();
        }
        catch (ModuleNotFoundException | ServiceNotFoundException ex) {
            LOG.log(Level.SEVERE, "Having big troubles to get the ModuleManager service and CoreModule.", ex);
            return false;
        }
    }

    private boolean isMaintenanceModeEnabled() {
        LOG.fine("isMaintenanceModeEnabled");
        try {
            return this.moduleManagerTracker.getService().getModuleByClass(CoreModule.class).isMaintenanceModeEnabled();
        }
        catch (ModuleNotFoundException | ServiceNotFoundException ex) {
            LOG.log(Level.SEVERE, "Having big troubles to get the ModuleManager service and CoreModule.", ex);
            return false;
        }
    }

    private void onlyRegisterForOpenSearchChangesWhenNecessary() {
        LOG.info("onlyRegisterForOpenSearchChangesWhenNecessary");
        try {
            if (this.isMasterServer() && !this.isMaintenanceModeEnabled()) {
                this.registerForOpenSearchChanges();
            }
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Failed to register for OpenSearch changes.", ex);
        }
    }

    private class ReplicationModuleLoadedEventHandler
    extends AbstractBackendModuleLoadedEventHandler {
        private ReplicationModuleLoadedEventHandler() {
        }

        @Override
        public void processLoadedModule(Module module) {
            LOG.info(this.getClass().getSimpleName() + ".processLoadedModule module=...");
            LookupJoinsManagerImpl.this.onlyRegisterForOpenSearchChangesWhenNecessary();
        }
    }

    private class LogServiceModuleLoadedEventHandler
    extends AbstractBackendModuleLoadedEventHandler {
        private LogServiceModuleLoadedEventHandler() {
        }

        @Override
        public void processLoadedModule(Module module) {
            LOG.info(this.getClass().getSimpleName() + ".processLoadedModule module=...");
            LookupJoinsManagerImpl.this.onlyRegisterForOpenSearchChangesWhenNecessary();
        }
    }

    private class MaintenanceModeChangedEventHandler
    extends AbstractMaintenanceModeAcknowledgeEventHandler {
        public MaintenanceModeChangedEventHandler(BundleContext bundleContext) {
            super(bundleContext, "_core");
        }

        @Override
        public void processNewMaintenanceMode(boolean enabled) {
            LOG.info(this.getClass().getSimpleName() + ".processNewMaintenanceMode enabled=" + enabled);
            try {
                if (enabled) {
                    LookupJoinsManagerImpl.this.unregisterFromOpenSearchChanges();
                } else if (LookupJoinsManagerImpl.this.isMasterServer()) {
                    LookupJoinsManagerImpl.this.registerForOpenSearchChanges();
                }
            }
            catch (Exception ex) {
                LOG.log(Level.SEVERE, this.getClass().getSimpleName() + ": Failed to process the maintenance mode changed event.", ex);
            }
        }
    }

    private class MasterOrSlaveModeChangedEventHandler
    extends AbstractEventHandler {
        private MasterOrSlaveModeChangedEventHandler() {
        }

        @Override
        protected void processEvent(Event event) {
            LOG.info(this.getClass().getSimpleName() + ".processEvent event=...");
            try {
                Object serverModeObject = event.getProperty("serverMode");
                Object thisServerUUidObject = event.getProperty("thisServerUUID");
                Object masterServerUuidObject = event.getProperty("masterServerUUID");
                if ("master".equals(serverModeObject)) {
                    if (!LookupJoinsManagerImpl.this.isMaintenanceModeEnabled()) {
                        LookupJoinsManagerImpl.this.registerForOpenSearchChanges();
                    }
                } else if ("slave".equals(serverModeObject)) {
                    LookupJoinsManagerImpl.this.unregisterFromOpenSearchChanges();
                } else {
                    LOG.log(Level.SEVERE, this.getClass().getSimpleName() + ": Please inform the BPC developers that an unknown 'serverMode' property value is used: " + serverModeObject);
                }
            }
            catch (Exception ex) {
                LOG.log(Level.SEVERE, this.getClass().getSimpleName() + ": Failed to process the set as master or slave mode changed event.", ex);
            }
        }
    }

    private class ReplicationModuleInstanceCreatedEventHandler
    extends AbstractEventHandler {
        private ReplicationModuleInstanceCreatedEventHandler() {
        }

        @Override
        protected void processEvent(Event event) {
            LOG.info(this.getClass().getSimpleName() + ".processEvent event=...");
            LookupJoinsManagerImpl.this.onlyRegisterForOpenSearchChangesWhenNecessary();
        }
    }

    private class ReplicationModuleInstanceUpdatedEventHandler
    extends AbstractSettingsUpdatedEventHandler {
        private ReplicationModuleInstanceUpdatedEventHandler() {
        }

        @Override
        protected boolean canProcessEvent(Event event) {
            return this.isModuleUpdatedEventOfSettings(event, Arrays.asList("join"));
        }

        @Override
        public void processEvent(Event event) {
            LOG.info(this.getClass().getSimpleName() + ".processEvent event=...");
            LookupJoinsManagerImpl.this.onlyRegisterForOpenSearchChangesWhenNecessary();
        }
    }

    private class ReplicationModuleInstanceDeletedEventHandler
    extends AbstractEventHandler {
        private ReplicationModuleInstanceDeletedEventHandler() {
        }

        @Override
        protected void processEvent(Event event) {
            LOG.info(this.getClass().getSimpleName() + ".processEvent event=...");
            LookupJoinsManagerImpl.this.onlyRegisterForOpenSearchChangesWhenNecessary();
        }
    }

    private class LogServiceModuleInstanceCreatedEventHandler
    extends AbstractEventHandler {
        private LogServiceModuleInstanceCreatedEventHandler() {
        }

        @Override
        protected void processEvent(Event event) {
            LOG.info(this.getClass().getSimpleName() + ".processEvent event=...");
            LookupJoinsManagerImpl.this.onlyRegisterForOpenSearchChangesWhenNecessary();
        }
    }

    private class LogServiceModuleInstanceUpdatedEventHandler
    extends AbstractSettingsUpdatedEventHandler {
        private LogServiceModuleInstanceUpdatedEventHandler() {
        }

        @Override
        protected boolean canProcessEvent(Event event) {
            return this.isModuleUpdatedEventOfSettings(event, Arrays.asList("joins"));
        }

        @Override
        public void processEvent(Event event) {
            LOG.info(this.getClass().getSimpleName() + ".processEvent event=...");
            LookupJoinsManagerImpl.this.onlyRegisterForOpenSearchChangesWhenNecessary();
        }
    }

    private class LogServiceModuleInstanceDeletedEventHandler
    extends AbstractEventHandler {
        private LogServiceModuleInstanceDeletedEventHandler() {
        }

        @Override
        protected void processEvent(Event event) {
            LOG.info(this.getClass().getSimpleName() + ".processEvent event=...");
            LookupJoinsManagerImpl.this.onlyRegisterForOpenSearchChangesWhenNecessary();
        }
    }
}

