/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.notification;

import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ErrorResponse;
import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.api.exception.MaintenanceModeEnabledException;
import de.virtimo.bpc.api.service.ErrorResponseService;
import de.virtimo.bpc.core.notification.Notification;
import de.virtimo.bpc.core.notification.NotificationData;
import de.virtimo.bpc.core.notification.NotificationManager;
import de.virtimo.bpc.core.notification.NotificationNotFoundException;
import de.virtimo.bpc.core.notification.Notifications;
import de.virtimo.bpc.jaxrs.ApiResponse;
import de.virtimo.bpc.jaxrs.ApiResponses;
import de.virtimo.bpc.jaxrs.BpcRoleOrRightRequired;
import de.virtimo.bpc.jaxrs.BpcUserSessionRequired;
import java.time.ZonedDateTime;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.osgi.framework.BundleContext;

@Path(value="notification")
public class NotificationEndpoint {
    private static final Logger LOG = Logger.getLogger(NotificationEndpoint.class.getName());
    private final BundleContext bundleContext;
    private BpcServicesTracker<NotificationManager> notificationManagerTracker;
    private BpcServicesTracker<ErrorResponseService> errorResponseServiceTracker;

    public NotificationEndpoint(BundleContext bundleContext) {
        LOG.info("NotificationEndpoint bundleContext=" + bundleContext);
        this.bundleContext = bundleContext;
    }

    public void onStartup() {
        LOG.info("onStartup");
        this.notificationManagerTracker = new BpcServicesTracker<NotificationManager>(this.bundleContext, NotificationManager.class);
        this.errorResponseServiceTracker = new BpcServicesTracker<ErrorResponseService>(this.bundleContext, ErrorResponseService.class);
    }

    public void onShutdown() {
        LOG.info("onShutdown");
        BpcServicesTracker.stopAll(this);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @BpcRoleOrRightRequired(role="NOTIFICATION_ADMIN", right="NOTIFICATION_ADD", message="Not allowed to add notifications")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Required service was not found"), @ApiResponse(responseCode="500", description="Unexpected backend error"), @ApiResponse(responseCode="503", description="Maintenance mode is active")})
    public Response addNotification(@Context HttpHeaders hh, @Context UserSession userSession, NotificationData postData) {
        LOG.info("addNotification");
        try {
            NotificationManager notificationManager = this.notificationManagerTracker.getService();
            Notification notification = new Notification.Builder(postData).date(ZonedDateTime.now()).originator(postData.originator == null ? userSession.getLoginName() : postData.originator).build();
            Notification addedNotification = notificationManager.addNotification(notification);
            return Response.ok((Object)addedNotification).build();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Failed to add notification.", ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @PUT
    @Path(value="/{notificationId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @BpcRoleOrRightRequired(role="NOTIFICATION_ADMIN", right="NOTIFICATION_UPDATE", message="Not allowed to update notifications")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Required service was not found"), @ApiResponse(responseCode="500", description="Unexpected backend error"), @ApiResponse(responseCode="503", description="Maintenance mode is active")})
    public Response updateNotification(@PathParam(value="notificationId") String notificationId, @Context HttpHeaders hh, @Context UserSession userSession, NotificationData postData) {
        LOG.info("updateNotification notificationId=" + notificationId);
        try {
            NotificationManager notificationManager = this.notificationManagerTracker.getService();
            Notification notification = new Notification.Builder(postData).id(notificationId).date(ZonedDateTime.now()).originator(postData.originator == null ? userSession.getLoginName() : postData.originator).build();
            Notification updatedNotification = notificationManager.updateNotification(notification);
            return Response.ok((Object)updatedNotification).build();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Failed to update notification.", ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @DELETE
    @Path(value="/{notificationId}")
    @Produces(value={"application/json"})
    @BpcRoleOrRightRequired(role="NOTIFICATION_ADMIN", right="NOTIFICATION_DELETE", message="Not allowed to delete notifications")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Required service was not found"), @ApiResponse(responseCode="404", description="Requested notification was not found"), @ApiResponse(responseCode="500", description="Unexpected backend error"), @ApiResponse(responseCode="503", description="Maintenance mode is active")})
    public Response deleteNotification(@PathParam(value="notificationId") String notificationId, @Context HttpHeaders hh, @Context UserSession userSession) {
        LOG.info("deleteNotification notificationId=" + notificationId);
        try {
            NotificationManager notificationManager = this.notificationManagerTracker.getService();
            Notification deletedNotification = notificationManager.deleteNotificationById(notificationId);
            return Response.ok((Object)deletedNotification).build();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Failed to delete notification.", ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @GET
    @Path(value="/{notificationId}")
    @Produces(value={"application/json"})
    @BpcUserSessionRequired
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Required service was not found"), @ApiResponse(responseCode="404", description="Requested notification was not found or no access rights"), @ApiResponse(responseCode="500", description="Unexpected backend error"), @ApiResponse(responseCode="503", description="Maintenance mode is active")})
    public Response getNotification(@PathParam(value="notificationId") String notificationId, @Context HttpHeaders hh, @Context UserSession userSession) {
        LOG.info("getNotification notificationId=" + notificationId);
        try {
            NotificationManager notificationManager = this.notificationManagerTracker.getService();
            Notification notification = notificationManager.getNotification(notificationId);
            if (notification != null && notification.hasAccessRight(userSession)) {
                return Response.ok((Object)notification).build();
            }
            throw new NotificationNotFoundException(notificationId);
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Failed to get notification.", ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @BpcUserSessionRequired
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Required service was not found"), @ApiResponse(responseCode="500", description="Unexpected backend error"), @ApiResponse(responseCode="503", description="Maintenance mode is active")})
    public Response getNotifications(@QueryParam(value="start") @DefaultValue(value="0") Integer start, @QueryParam(value="limit") @DefaultValue(value="1000") Integer limit, @Context HttpHeaders hh, @Context UserSession userSession) {
        LOG.info("getNotifications");
        try {
            NotificationManager notificationManager = this.notificationManagerTracker.getService();
            Notifications notifications = notificationManager.getNotifications(userSession, start, limit);
            return Response.ok((Object)notifications).build();
        }
        catch (MaintenanceModeEnabledException ex) {
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Failed to get notifications.", ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }
}

