/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.opensearch.migration;

import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.core.opensearch.migration.AllSearchHitsMigration;
import de.virtimo.bpc.core.opensearch.migration.IndexToMigrate;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.client.RestHighLevelClient;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.search.SearchHit;

public class BpcConfigurationIndexMigrationFromModelVersion16To17
extends AllSearchHitsMigration {
    private static final Logger LOG = Logger.getLogger(BpcConfigurationIndexMigrationFromModelVersion16To17.class.getName());

    public BpcConfigurationIndexMigrationFromModelVersion16To17(OpenSearchService oss) {
        super(oss, 17);
    }

    @Override
    public List<IndexRequest> migrateSearchHit(RestHighLevelClient osClient, IndexToMigrate oldIndex, IndexToMigrate newIndex, SearchHit hit) {
        Map<String, Object> sourceValues = hit.getSourceAsMap();
        if ("_core".equals(sourceValues.get("moduleId"))) {
            String oldSettingName = (String)sourceValues.get("name");
            Map<String, String> settingsToRename = Map.of("esIndexCreationSettings", "indexCreationSettings", "esTemplates", "indexTemplates", "esDynamicTemplates", "indexDynamicTemplates");
            if (settingsToRename.containsKey(oldSettingName)) {
                String newSettingName = settingsToRename.get(oldSettingName);
                String newId = this.createSettingId((String)sourceValues.get("moduleId"), (String)sourceValues.get("instanceId"), newSettingName);
                sourceValues.put("id", newId);
                sourceValues.put("name", newSettingName);
                return Collections.singletonList(new IndexRequest(newIndex.getName()).id(newId).source(sourceValues, (MediaType)XContentType.JSON));
            }
        }
        return Collections.singletonList(new IndexRequest(newIndex.getName()).id(hit.getId()).source(sourceValues, (MediaType)XContentType.JSON));
    }

    private String createSettingId(String moduleId, String instanceId, String settingName) {
        return moduleId + "_" + instanceId + "_" + settingName;
    }
}

