/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.percolators;

import de.virtimo.bpc.api.Percolator;
import java.util.Objects;

public class PercolatorImpl
implements Percolator {
    private static final String UID_PREFIX = "_percolator";
    private static final String SEPARATOR = "@@@";
    private final String index;
    private final String uid;

    public PercolatorImpl(String index, String percolatorUID) {
        this.index = index;
        this.uid = percolatorUID;
    }

    public PercolatorImpl(String index, String serverUUID, String sessionId, String componentId, String customId) {
        this.index = index;
        this.uid = "_percolator@@@" + serverUUID + SEPARATOR + sessionId + SEPARATOR + componentId + SEPARATOR + customId;
    }

    @Override
    public boolean isValid() {
        return this.uid != null && this.uid.startsWith(UID_PREFIX) && this.uid.split(SEPARATOR).length == 5;
    }

    @Override
    public String getIndex() {
        return this.index;
    }

    @Override
    public String getServerUUID() {
        String[] parts = this.uid.split(SEPARATOR);
        if (parts.length == 5) {
            return parts[1];
        }
        return null;
    }

    @Override
    public String getSessionId() {
        String[] parts = this.uid.split(SEPARATOR);
        if (parts.length == 5) {
            return parts[2];
        }
        return null;
    }

    @Override
    public String getComponentId() {
        String[] parts = this.uid.split(SEPARATOR);
        if (parts.length == 5) {
            return parts[3];
        }
        return null;
    }

    @Override
    public String getCustomId() {
        String[] parts = this.uid.split(SEPARATOR);
        if (parts.length == 5) {
            return parts[4];
        }
        return null;
    }

    @Override
    public String getUID() {
        return this.uid;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PercolatorImpl that = (PercolatorImpl)o;
        return this.index.equals(that.index) && this.uid.equals(that.uid);
    }

    public int hashCode() {
        return Objects.hash(this.index, this.uid);
    }

    public String toString() {
        return "Percolator{index='" + this.index + "', uid='" + this.uid + "'}";
    }
}

