/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.performance.resource;

import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ErrorResponse;
import de.virtimo.bpc.api.exception.MaintenanceModeEnabledException;
import de.virtimo.bpc.api.service.ErrorResponseService;
import de.virtimo.bpc.core.performance.PerformanceMeasurementManager;
import de.virtimo.bpc.jaxrs.ApiResponse;
import de.virtimo.bpc.jaxrs.ApiResponses;
import de.virtimo.bpc.jaxrs.BpcUserSessionRequired;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;
import org.osgi.framework.BundleContext;

@Path(value="/performance")
public class PerformanceMeasurementEndpoint {
    private static final Logger LOG = Logger.getLogger(PerformanceMeasurementEndpoint.class.getName());
    private final BundleContext bundleContext;
    private BpcServicesTracker<PerformanceMeasurementManager> performanceMeasurementManagerTracker;
    private BpcServicesTracker<ErrorResponseService> errorResponseServiceTracker;

    public PerformanceMeasurementEndpoint(BundleContext bundleContext) {
        LOG.info("PerformanceMeasurementEndpoint bundleContext=" + bundleContext);
        this.bundleContext = bundleContext;
    }

    public void onStartup() {
        LOG.info("onStartup");
        this.performanceMeasurementManagerTracker = new BpcServicesTracker<PerformanceMeasurementManager>(this.bundleContext, PerformanceMeasurementManager.class);
        this.errorResponseServiceTracker = new BpcServicesTracker<ErrorResponseService>(this.bundleContext, ErrorResponseService.class);
    }

    public void onShutdown() {
        LOG.info("onShutdown");
        BpcServicesTracker.stopAll(this);
    }

    @POST
    @Path(value="/{sessionId}")
    @BpcUserSessionRequired
    @ApiResponses(value={@ApiResponse(responseCode="204", description="No content")})
    public Response savePerformanceData(@PathParam(value="sessionId") String sessionId, @HeaderParam(value="user-agent") String userAgent, List<Map<String, Object>> measurements) {
        LOG.log(Level.FINEST, "savePerformanceData");
        try {
            this.performanceMeasurementManagerTracker.getService().savePerformanceData(sessionId, userAgent, measurements);
            return Response.noContent().build();
        }
        catch (MaintenanceModeEnabledException ex) {
            return ErrorResponse.forException(ex).usingTracker(this.errorResponseServiceTracker).build();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Failed to save measurement", ex);
            return ErrorResponse.forException(ex).usingTracker(this.errorResponseServiceTracker).build();
        }
    }
}

