/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.replicator;

import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.exception.OpenSearchRelatedException;
import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.core.exception.CoreErrorCode;
import de.virtimo.bpc.core.opensearch.XContentBuilderUtil;
import de.virtimo.bpc.core.replicator.ReplicationJobException;
import de.virtimo.bpc.core.replicator.ReplicationTarget;
import de.virtimo.bpc.util.MapUtil;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.TreeMap;
import java.util.logging.Logger;
import org.opensearch.OpenSearchException;
import org.opensearch.client.RequestOptions;
import org.opensearch.client.indices.PutMappingRequest;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.core.xcontent.XContentBuilder;

public class OpenSearchIndexMappingUpdater {
    private static final Logger LOG = Logger.getLogger(OpenSearchIndexMappingUpdater.class.getName());
    private final String loggingPrefix;
    private final ReplicationTarget target;
    private Integer indexMappingPreparedHashCode;

    public OpenSearchIndexMappingUpdater(String loggingPrefix, ReplicationTarget target) {
        this.loggingPrefix = loggingPrefix;
        this.target = target;
        this.indexMappingPreparedHashCode = null;
    }

    public void reset() {
        LOG.info(this.loggingPrefix + ": reset");
        this.indexMappingPreparedHashCode = null;
    }

    public void using(OpenSearchService oss, ResultSet rs) throws ReplicationJobException, OpenSearchRelatedException {
        LOG.info(this.loggingPrefix + ": using oss=..., rs=...");
        Integer dbColumnsHashCode = this.getDatabaseColumnsHashCode(rs);
        if (this.indexMappingPreparedHashCode == null || !this.indexMappingPreparedHashCode.equals(dbColumnsHashCode)) {
            this.prepareIndexMapping(oss, rs);
            oss.prepareAttachmentsPipeline(this.target.getIndex());
            this.indexMappingPreparedHashCode = dbColumnsHashCode;
        }
    }

    private Integer getDatabaseColumnsHashCode(ResultSet rs) {
        LOG.fine(this.loggingPrefix + ": getDatabaseColumnsHashCode rs=...");
        try {
            TreeMap<String, Integer> hashParts = new TreeMap<String, Integer>();
            ResultSetMetaData rsmd = rs.getMetaData();
            int colCount = rsmd.getColumnCount();
            for (int i = 1; i <= colCount; ++i) {
                hashParts.put(rsmd.getColumnName(i), rsmd.getColumnType(i));
            }
            StringBuilder hash = new StringBuilder();
            hashParts.forEach((columnName, columnType) -> hash.append((String)columnName).append("=").append(columnType).append("|"));
            return hash.toString().hashCode();
        }
        catch (Exception e) {
            LOG.warning(this.loggingPrefix + ": Could not create the database columns hash");
            return null;
        }
    }

    private void prepareIndexMapping(OpenSearchService oss, ResultSet rs) throws ReplicationJobException {
        LOG.fine(this.loggingPrefix + ": prepareIndexMapping oss=..., rs=...");
        try {
            LOG.fine(this.loggingPrefix + ": prepareIndexMapping : " + this.target);
            XContentBuilder mappingBuilder = XContentFactory.jsonBuilder().prettyPrint();
            mappingBuilder.startObject();
            if (this.target.hasDynamicTemplates()) {
                XContentBuilderUtil.addDynamicTemplatesMapping(mappingBuilder, this.target.getDynamicTemplates());
            } else {
                XContentBuilderUtil.addDynamicTemplatesMapping(mappingBuilder, oss.getDefaultDynamicTemplates());
            }
            this.addPropertiesMapping(mappingBuilder, rs);
            mappingBuilder.endObject();
            this.doIndexMappingUpdate(oss, this.target.getIndex(), mappingBuilder);
        }
        catch (OpenSearchRelatedException | IOException | SQLException ex) {
            throw new ReplicationJobException((ErrorCode)CoreErrorCode.REPLICATION_JOB_INDEX_PREPARATION_FAILED, "Failed to prepare the mapping of index '${index}'.", MapUtil.mapOf("index", this.target.getIndex()), (Throwable)ex);
        }
    }

    private void addPropertiesMapping(XContentBuilder mappingBuilder, ResultSet rs) throws IOException, SQLException {
        LOG.fine(this.loggingPrefix + ": addPropertiesMapping mappingBuilder=..., rs=...");
        mappingBuilder.startObject("properties");
        mappingBuilder.startObject("_percolator_query").field("type", "percolator").endObject();
        ResultSetMetaData rsmd = rs.getMetaData();
        int colCount = rsmd.getColumnCount();
        for (int i = 1; i <= colCount; ++i) {
            String dbColumnName = rsmd.getColumnName(i);
            int dbColumnType = rsmd.getColumnType(i);
            String openSearchFieldName = this.target.getDbColumnNamesToOpenSearchFieldNamesConverter().convert(dbColumnName);
            switch (dbColumnType) {
                case -4: 
                case -3: 
                case -2: 
                case 2004: {
                    mappingBuilder.startObject(openSearchFieldName).field("type", "binary").endObject();
                }
            }
        }
        mappingBuilder.endObject();
    }

    private void doIndexMappingUpdate(OpenSearchService oss, String index, XContentBuilder mappingBuilder) throws OpenSearchRelatedException {
        LOG.fine(this.loggingPrefix + ": doIndexMappingUpdate oss=..., index=" + index + ", mappingBuilder=" + mappingBuilder);
        try {
            PutMappingRequest putMappingRequest = new PutMappingRequest(index).source(mappingBuilder);
            oss.getClient().indices().putMapping(putMappingRequest, RequestOptions.DEFAULT);
        }
        catch (IOException ex) {
            throw new OpenSearchRelatedException(ex);
        }
        catch (OpenSearchException ex) {
            throw new OpenSearchRelatedException(ex);
        }
    }
}

