/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.replicator.consistency;

import de.virtimo.bpc.api.exception.OpenSearchRelatedException;
import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.core.replicator.ReplicationJob;
import de.virtimo.bpc.core.replicator.ReplicationSource;
import de.virtimo.bpc.core.replicator.ReplicationTarget;
import de.virtimo.bpc.core.replicator.consistency.ConsistencyCheckDatabaseHandler;
import de.virtimo.bpc.core.replicator.consistency.ConsistencyCheckOpenSearchHandler;
import de.virtimo.bpc.core.replicator.consistency.ConsistencyCheckResult;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.logging.Logger;
import javax.sql.DataSource;

public class ConsistencyCheckTask {
    private static final Logger LOG = Logger.getLogger(ConsistencyCheckTask.class.getName());
    private ReplicationJob replicationJob;
    private DataSource dataSource;
    private OpenSearchService oss;
    private String loggingPrefix;
    private ReplicationSource source;
    private ReplicationTarget target;

    private ConsistencyCheckTask() {
    }

    public ConsistencyCheckTask(ReplicationJob replicationJob, DataSource dataSource, OpenSearchService oss) {
        this.replicationJob = replicationJob;
        this.dataSource = dataSource;
        this.oss = oss;
        this.loggingPrefix = replicationJob.getId();
        this.source = replicationJob.getSource();
        this.target = replicationJob.getTarget();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConsistencyCheckResult process() throws SQLException, OpenSearchRelatedException {
        LOG.info(this.loggingPrefix + ": process");
        long start = System.currentTimeMillis();
        try {
            ConsistencyCheckOpenSearchHandler osHandler = new ConsistencyCheckOpenSearchHandler(this.oss, this.target.getIndex(), this.source.getLastUpdateColumn(), this.loggingPrefix);
            ConsistencyCheckDatabaseHandler dbHandler = new ConsistencyCheckDatabaseHandler(this.dataSource, this.source.getTable(), this.source.getLastUpdateColumn(), this.source.getLastUpdateColumnTimeZoneCalendar(), this.loggingPrefix);
            Instant lowerDateLimit = this.replicationJob.getSettings().getReplicationStartDateAsDate().toInstant();
            LOG.info(this.loggingPrefix + ": lower date limit: " + lowerDateLimit);
            Instant upperDateLimit = osHandler.getUpperTargetDate();
            LOG.info(this.loggingPrefix + ": upper date limit: " + upperDateLimit);
            if (upperDateLimit == null) {
                LOG.info(this.loggingPrefix + ": Could not perform the consistency check without an upper date limit from the OpenSearch documents");
                ConsistencyCheckResult consistencyCheckResult = new ConsistencyCheckResult(-1L, -1L);
                return consistencyCheckResult;
            }
            long numberOfSourceRows = dbHandler.countRecords(Timestamp.from(lowerDateLimit), Timestamp.from(upperDateLimit));
            LOG.info(this.loggingPrefix + ": numberOfSourceRows ......: " + numberOfSourceRows);
            long numberOfTargetDocuments = osHandler.countDocuments(lowerDateLimit, upperDateLimit);
            LOG.info(this.loggingPrefix + ": numberOfTargetDocuments .: " + numberOfTargetDocuments);
            ConsistencyCheckResult consistencyCheckResult = new ConsistencyCheckResult(numberOfSourceRows, numberOfTargetDocuments);
            return consistencyCheckResult;
        }
        finally {
            LOG.fine(this.loggingPrefix + ": process time: " + (System.currentTimeMillis() - start) + "ms");
        }
    }
}

