/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.resource;

import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.jaxrs.annotation.JacksonFeatures;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ClientSessionManager;
import de.virtimo.bpc.api.CoreBundleConfiguration;
import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.ErrorResponse;
import de.virtimo.bpc.api.ModuleManager;
import de.virtimo.bpc.api.SystemException;
import de.virtimo.bpc.api.auditlog.UserAuditLog;
import de.virtimo.bpc.api.auth.ClientSession;
import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.api.auth.idp.IdentityProvider;
import de.virtimo.bpc.api.auth.idp.UserFlowIdentityProvider;
import de.virtimo.bpc.api.exception.IdentityProviderException;
import de.virtimo.bpc.api.exception.ModuleInstanceNotFoundException;
import de.virtimo.bpc.api.exception.ModuleNotFoundException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.identityManagement.IdentityManagerException;
import de.virtimo.bpc.api.service.ErrorResponseService;
import de.virtimo.bpc.core.CoreModule;
import de.virtimo.bpc.core.auth.IdentityProviderConfiguration;
import de.virtimo.bpc.core.auth.PasswordValidatorImpl;
import de.virtimo.bpc.core.auth.UserIdentification;
import de.virtimo.bpc.core.auth.idp.HttpUserSessionRequest;
import de.virtimo.bpc.core.auth.oidc.KeycloakIdentityProvider;
import de.virtimo.bpc.core.auth.oidc.OidcIdentityProvider;
import de.virtimo.bpc.core.exception.CoreErrorCode;
import de.virtimo.bpc.core.license.LicenseService;
import de.virtimo.bpc.core.resource.BpcCookieCreator;
import de.virtimo.bpc.core.resource.CookiesList;
import de.virtimo.bpc.jaxrs.ApiResponse;
import de.virtimo.bpc.jaxrs.ApiResponses;
import de.virtimo.bpc.jaxrs.BpcEndpoint;
import de.virtimo.bpc.jaxrs.BpcRoleOrRightRequired;
import de.virtimo.bpc.jaxrs.BpcUserSessionRequired;
import de.virtimo.bpc.util.BpcTrustStore;
import de.virtimo.bpc.util.MapUtil;
import de.virtimo.bpc.util.SetUtil;
import de.virtimo.bpc.util.StringUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import org.apache.cxf.jaxrs.client.WebClient;
import org.osgi.framework.BundleContext;

@Path(value="authentication")
public class AuthenticationEndpoint {
    private static final Logger LOG = Logger.getLogger(AuthenticationEndpoint.class.getName());
    private static final Logger AUTHENTICATION_LOGGER = Logger.getLogger("authentication");
    private final BundleContext bundleContext;
    private BpcServicesTracker<ModuleManager> moduleManagerTracker;
    private BpcServicesTracker<ClientSessionManager> clientSessionManagerTracker;
    private BpcServicesTracker<CoreBundleConfiguration> coreBundleConfigurationTracker;
    private BpcServicesTracker<LicenseService> licenseServiceTracker;
    private BpcServicesTracker<ErrorResponseService> errorResponseServiceTracker;

    public AuthenticationEndpoint(BundleContext bundleContext) {
        LOG.info("AuthenticationEndpoint bundleContext=" + bundleContext);
        this.bundleContext = bundleContext;
    }

    public void onStartup() {
        LOG.info("onStartup");
        this.moduleManagerTracker = new BpcServicesTracker<ModuleManager>(this.bundleContext, ModuleManager.class);
        this.coreBundleConfigurationTracker = new BpcServicesTracker<CoreBundleConfiguration>(this.bundleContext, CoreBundleConfiguration.class);
        this.clientSessionManagerTracker = new BpcServicesTracker<ClientSessionManager>(this.bundleContext, ClientSessionManager.class);
        this.licenseServiceTracker = new BpcServicesTracker<LicenseService>(this.bundleContext, LicenseService.class);
        this.errorResponseServiceTracker = new BpcServicesTracker<ErrorResponseService>(this.bundleContext, ErrorResponseService.class);
    }

    public void onShutdown() {
        LOG.info("onShutdown");
        BpcServicesTracker.stopAll(this);
    }

    private CoreModule getCoreModule() throws ServiceNotFoundException, ModuleNotFoundException {
        return AuthenticationEndpoint.getCoreModule(this.moduleManagerTracker);
    }

    private static CoreModule getCoreModule(BpcServicesTracker<ModuleManager> moduleManagerTracker) throws ServiceNotFoundException, ModuleNotFoundException {
        return (CoreModule)moduleManagerTracker.getService().getModuleById("_core");
    }

    @Produces(value={"application/json"})
    @GET
    @BpcEndpoint(skipIpPinningCheck=true)
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="401", description="Unauthorized")})
    public Response checkSession(@Context HttpHeaders hh, @Context HttpServletRequest req) {
        LOG.finest("checkSession");
        try {
            IdentityProvider identityProvider = this.getCoreModule().getIdentityProvider();
            if (identityProvider == null) {
                throw new IdentityProviderException((ErrorCode)CoreErrorCode.IDENTITY_PROVIDER_NOT_FOUND, "No identity provider found");
            }
            return this.getUserSession(hh, req, identityProvider, null);
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Check session failed", ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @DELETE
    @BpcEndpoint
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK when no user flow identity provider is in use"), @ApiResponse(responseCode="205", description="OK when a user flow identity provider is in use")})
    public Response destroySession(@Context HttpHeaders httpHeaders, @Context HttpServletRequest servletRequest) {
        LOG.info("destroySession");
        try {
            ClientSessionManager clientSessionManager = this.clientSessionManagerTracker.getService();
            CoreBundleConfiguration coreBundleConfiguration = this.coreBundleConfigurationTracker.getService();
            IdentityProvider identityProvider = this.getCoreModule().getIdentityProvider();
            UserSession userSession = clientSessionManager.getUserSession(servletRequest);
            String sessionId = userSession == null ? null : userSession.getSessionId();
            UserIdentification userIdentification = new UserIdentification(servletRequest, coreBundleConfiguration.getIpPinningCheckHttpHeaderName());
            if (userSession != null) {
                UserAuditLog.info(userSession, "logout", userIdentification.toString());
            }
            if (identityProvider instanceof UserFlowIdentityProvider) {
                UserFlowIdentityProvider userFlowIdentityProvider = (UserFlowIdentityProvider)identityProvider;
                URI logoutUri = userFlowIdentityProvider.createLogoutURI(userSession, servletRequest);
                LOG.log(Level.FINEST, "logoutUri = " + logoutUri);
                if (sessionId != null) {
                    clientSessionManager.removeSession(sessionId, false, identityProvider);
                }
                return Response.status((Response.Status)Response.Status.RESET_CONTENT).cookie(CookiesList.add(this.createDeleteCookie()).asArray()).location(logoutUri).build();
            }
            if (sessionId != null) {
                clientSessionManager.removeSession(sessionId, true, identityProvider);
            }
            return Response.ok().cookie(CookiesList.add(this.createDeleteCookie()).asArray()).build();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Destroying session failed", ex);
            return ErrorResponse.forException(ex).languageFrom(httpHeaders).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @DELETE
    @Path(value="/sessions/all")
    @BpcRoleOrRightRequired(role="USER_ADMIN", right="USER_DELETE_SESSIONS", message="Not allowed to delete all sessions")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    public Response deleteAllSessions(@Context HttpHeaders hh, @Context HttpServletRequest req) {
        LOG.info("deleteAllSessions");
        try {
            ClientSessionManager clientSessionManager = this.clientSessionManagerTracker.getService();
            if (clientSessionManager.getSessionCount() > 0) {
                clientSessionManager.removeAllSessions(true);
            }
            return Response.ok().build();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Deleting all sessions failed", ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @DELETE
    @Path(value="/sessions/{sessionId}")
    @BpcRoleOrRightRequired(role="USER_ADMIN", right="USER_DELETE_SESSIONS", message="Not allowed to delete sessions")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    public Response deleteSession(@PathParam(value="sessionId") String nonHijackableSessionId, @Context HttpHeaders hh, @Context HttpServletRequest req) {
        LOG.info("deleteSession sessionId=...");
        try {
            ClientSessionManager clientSessionManager = this.clientSessionManagerTracker.getService();
            IdentityProvider identityProvider = this.getCoreModule().getIdentityProvider();
            String sessionId = clientSessionManager.getSessionIdFromNonHijackableSessionId(nonHijackableSessionId);
            if (sessionId != null && clientSessionManager.existsSession(sessionId)) {
                clientSessionManager.removeSession(sessionId, true, identityProvider);
            }
            return Response.ok().build();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Deleting session failed", ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    @BpcEndpoint(skipIpPinningCheck=true)
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    public Response login(MultivaluedMap<String, String> formParams, @Context HttpHeaders hh, @Context HttpServletRequest req) {
        LOG.info("login");
        try {
            IdentityProvider identityProvider = this.getCoreModule().getIdentityProvider();
            if (identityProvider == null) {
                throw new IdentityProviderException((ErrorCode)CoreErrorCode.IDENTITY_PROVIDER_NOT_FOUND, "No identity provider found");
            }
            if (identityProvider instanceof UserFlowIdentityProvider) {
                throw new IdentityProviderException((ErrorCode)CoreErrorCode.AUTHENTICATION_FORM_BASED_LOGIN_NOT_SUPPORTED, "CORE_ERROR_IDENTITY_PROVIDER_FORM_BASED_LOGIN_NOT_SUPPORTED");
            }
            return this.getUserSession(hh, req, identityProvider, formParams);
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Login failed", ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @PUT
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    @BpcUserSessionRequired
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    public Response update(@FormParam(value="tenantname") String tenantname, @Context HttpHeaders httpHeaders, @Context HttpServletRequest servletRequest) {
        LOG.info("update");
        try {
            IdentityProvider identityProvider = this.getCoreModule().getIdentityProvider();
            if (identityProvider == null) {
                throw new IdentityProviderException((ErrorCode)CoreErrorCode.IDENTITY_PROVIDER_NOT_FOUND, "No identity provider found");
            }
            ClientSessionManager clientSessionManager = this.clientSessionManagerTracker.getService();
            UserSession userSession = clientSessionManager.getUserSession(servletRequest);
            userSession = identityProvider.updateSession(userSession, tenantname);
            String sessionId = clientSessionManager.getSessionId(servletRequest);
            if (sessionId != null) {
                clientSessionManager.removeSession(sessionId, false, identityProvider);
            }
            if (userSession == null) {
                throw new IdentityProviderException((ErrorCode)CoreErrorCode.AUTHENTICATION_UNAUTHORIZED, "CORE_ERROR_IDENTITY_PROVIDER_CLIENT_SESSION_MISSING");
            }
            clientSessionManager.addSession(userSession.getSessionId(), userSession);
            return Response.ok((Object)userSession).cookie(CookiesList.add(this.createSessionCookie(userSession)).asArray()).build();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "User session update failed", ex);
            return ErrorResponse.forException(ex).languageFrom(httpHeaders).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @PUT
    @Path(value="/language/{lang}")
    @Produces(value={"application/json"})
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcEndpoint
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    public Response setUserLanguage(@PathParam(value="lang") String lang, @Context UserSession userSession, @Context HttpHeaders hh) {
        LOG.info("setUserLanguage lang=" + lang);
        try {
            String currentLocale;
            if (userSession != null && lang != null && !lang.equalsIgnoreCase(currentLocale = (String)userSession.getCustomData().get("locale"))) {
                if (userSession.hasImpersonator()) {
                    return ErrorResponse.forException(new IdentityProviderException((ErrorCode)CoreErrorCode.IDENTITY_PROVIDER_FORBIDDEN, "CORE_ERROR_IDENTITY_PROVIDER_UPDATE_USER_LANGUAGE_AS_IMPERSONATOR")).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
                }
                userSession.getCustomData().put("locale", lang);
                IdentityProvider identityProvider = this.getCoreModule().getIdentityProvider();
                if (identityProvider instanceof KeycloakIdentityProvider) {
                    KeycloakIdentityProvider keycloakIdP = (KeycloakIdentityProvider)identityProvider;
                    keycloakIdP.updateUserLanguage(userSession.getLoginName(), lang);
                }
            }
            return Response.ok().build();
        }
        catch (Exception ex) {
            if (ex instanceof SystemException) {
                LOG.log(Level.SEVERE, "Updating user language failed: " + ((SystemException)ex).asMap(), ex);
            } else {
                LOG.log(Level.SEVERE, "Updating user language failed.", ex);
            }
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @POST
    @Path(value="/reset")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    @BpcEndpoint
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="500", description="Something wrong with the identity provider settings")})
    public Response reset(@Context HttpHeaders hh, byte[] body) {
        LOG.info("reset");
        try {
            return this.forwardToUserSelfService(hh, body);
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Reset failed", ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @POST
    @Path(value="/changepassword")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    @BpcUserSessionRequired
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    public Response changePassword(@Context HttpHeaders httpHeaders, @Context HttpServletRequest servletRequest, byte[] body) {
        LOG.info("changePassword");
        try {
            IdentityProvider identityProvider = this.getCoreModule().getIdentityProvider();
            if (identityProvider == null) {
                throw new IdentityProviderException((ErrorCode)CoreErrorCode.IDENTITY_PROVIDER_NOT_FOUND, "No identity provider found");
            }
            if (identityProvider.canUpdateUserPasswords()) {
                Map<String, Object> formParams = StringUtil.formParamsAsMap(new String(body));
                String userName = (String)formParams.get("username");
                String oldPassword = (String)formParams.get("oldPassword");
                String newPassword = (String)formParams.get("newPassword");
                UserSession userSession = this.clientSessionManagerTracker.getService().getUserSession(servletRequest);
                if (userSession == null || !userSession.getLoginName().equalsIgnoreCase(userName)) {
                    throw new IdentityProviderException((ErrorCode)CoreErrorCode.AUTHENTICATION_UNAUTHORIZED, "CORE_ERROR_IDENTITY_PROVIDER_UPDATE_USER_PASSWORD_ONLY_USER_ITSELF_CAN");
                }
                if (!this.isValidPassword(newPassword)) {
                    throw new IdentityProviderException((ErrorCode)CoreErrorCode.AUTHENTICATION_UNAUTHORIZED, "CORE_ERROR_IDENTITY_PROVIDER_UPDATE_USER_PASSWORD_VALIDATION_FAILED");
                }
                identityProvider.updateUserPassword(userName, oldPassword, newPassword);
                return Response.ok().build();
            }
            return this.forwardToUserSelfService(httpHeaders, body);
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Change password failed", ex);
            return ErrorResponse.forException(ex).languageFrom(httpHeaders).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    private boolean isValidPassword(String password) {
        LOG.info("isValidPassword password=...");
        try {
            PasswordValidatorImpl passwordValidator = new PasswordValidatorImpl(this.getCoreModule().getCurrentIdentityProviderConfiguration());
            return passwordValidator.isValid(password);
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Failed to check the given password.", ex);
            return false;
        }
    }

    @POST
    @Path(value="/{userName}/impersonate")
    @Produces(value={"application/json"})
    @BpcRoleOrRightRequired(right="IDENTITY_MANAGER_USER_IMPERSONATE", role="IDENTITY_MANAGER_ADMIN")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="500", description="No username given"), @ApiResponse(responseCode="500", description="No user session provided"), @ApiResponse(responseCode="500", description="Current identity provider does not support impersonation")})
    public Response impersonateUser(@PathParam(value="userName") String userName, @Context UserSession userSession, @Context HttpHeaders hh, @Context HttpServletRequest req) {
        try {
            if (userName == null) {
                throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "User name missing");
            }
            if (userSession == null) {
                throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "No user session");
            }
            IdentityProvider identityProvider = this.getCoreModule().getIdentityProvider();
            if (!(identityProvider instanceof KeycloakIdentityProvider)) {
                throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "Impersonation is not supported");
            }
            KeycloakIdentityProvider keycloakIdP = (KeycloakIdentityProvider)identityProvider;
            keycloakIdP.refreshTokensWithFocusOnExpiredAccessToken(userSession);
            String currentUserAccessToken = userSession.getSensitiveCustomData().get("oidc.accessToken").toString();
            UserSession impersonatedUserSession = keycloakIdP.impersonateUser(req, currentUserAccessToken, userName);
            impersonatedUserSession.getSensitiveCustomData().put("userIdentificationObject", userSession.getSensitiveCustomData().get("userIdentificationObject"));
            UserAuditLog.info(userSession, "ImpersonateUser", "Impersonation of the user '" + userName + "'.");
            ClientSessionManager clientSessionManager = this.clientSessionManagerTracker.getService();
            clientSessionManager.addSession(impersonatedUserSession.getSessionId(), impersonatedUserSession);
            clientSessionManager.transferWebsocketConnections(userSession, impersonatedUserSession);
            clientSessionManager.removeSession(userSession.getSessionId(), true, identityProvider);
            URI redirectURI = this.getBpcFrontendUrl(req);
            LOG.info("Post user impersonation redirectURI=" + redirectURI);
            return Response.ok((Object)impersonatedUserSession).cookie(CookiesList.add(this.createSessionCookie(impersonatedUserSession)).asArray()).location(redirectURI).build();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "impersonateUser failed", ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    @Path(value="/user/info/{accessTokenType}/token")
    @BpcRoleOrRightRequired(role="USER_ADMIN", right="GET_USER_INFO_BY_TOKEN", message="Not allowed to get user info by token.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="500", description="Access token type missing or not supported"), @ApiResponse(responseCode="500", description="Access token missing"), @ApiResponse(responseCode="500", description="Current identity provider does not support token exchange")})
    public Response getUserInfo(@PathParam(value="accessTokenType") String accessTokenType, @FormParam(value="accessToken") String accessToken, @Context HttpHeaders hh, @Context HttpServletRequest req) {
        LOG.info("getUserInfo accessTokenType=" + accessTokenType + ", accessToken=...");
        try {
            UserSession userSession;
            if (accessTokenType == null) {
                throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "Token type missing");
            }
            if (!SetUtil.setOf("BEARER", "DPOP", "MAC").contains(accessTokenType.toUpperCase())) {
                throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "Invalid token type provided");
            }
            if (accessToken == null) {
                throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "Access token missing");
            }
            IdentityProvider identityProvider = this.getCoreModule().getIdentityProvider();
            if (!(identityProvider instanceof OidcIdentityProvider)) {
                throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "Not supported");
            }
            ClientSessionManager clientSessionManager = this.clientSessionManagerTracker.getService();
            List<UserSession> userSessions = clientSessionManager.findUserSessionBySensitiveCustomData("oidc.accessToken", accessToken);
            if (userSessions.size() == 0) {
                LOG.info("no existing session found for accessToken; create pseudo UserSession");
                userSession = ((OidcIdentityProvider)identityProvider).getUserInfo(req, accessTokenType, accessToken);
            } else {
                if (userSessions.size() > 1) {
                    LOG.warning("found multiple UserSessions for accessToken; use first UserSession and ignore the rest");
                }
                userSession = userSessions.get(0);
            }
            return Response.ok((Object)userSession).build();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "getUserInfo failed", ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response forwardToUserSelfService(HttpHeaders headers, byte[] body) throws ModuleInstanceNotFoundException, ModuleNotFoundException, ServiceNotFoundException, IdentityProviderException, NoSuchAlgorithmException, KeyStoreException {
        LOG.log(Level.FINEST, "forwardToUserSelfService headers=..., body=...");
        IdentityProviderConfiguration idpConfiguration = this.getCoreModule().getCurrentIdentityProviderConfiguration();
        String url = idpConfiguration.getUserSelfServiceUrl();
        if (StringUtil.isNullOrEmpty(url)) {
            throw new IdentityProviderException((ErrorCode)CoreErrorCode.IDENTITY_PROVIDER_CONFIG, "CORE_ERROR_IDENTITY_PROVIDER_SETTING_MISSING", MapUtil.mapOf("field", "identityProvider_ussUrl"));
        }
        try (WebClient webClient = null;){
            webClient = WebClient.create((String)url);
            BpcTrustStore.getInstance().setTo(webClient, false);
            MediaType mediaType = headers.getMediaType();
            if (mediaType != null) {
                Response response = webClient.accept(new String[]{"*"}).headers(headers.getRequestHeaders()).post((Object)Entity.entity((Object)body, (MediaType)mediaType));
                return response;
            }
            Response response = webClient.accept(new String[]{"*"}).headers(headers.getRequestHeaders()).post((Object)Entity.entity((Object)body, (String)""));
            return response;
        }
    }

    private Response getUserSession(HttpHeaders hh, HttpServletRequest httpServletRequest, IdentityProvider identityProvider, MultivaluedMap<String, String> formParams) {
        UserIdentification userIdentification;
        LOG.log(Level.FINEST, "getUserSession hh=..., httpServletRequest=..., identityProvider=..., formParams=...");
        try {
            CoreBundleConfiguration coreBundleConfiguration = this.coreBundleConfigurationTracker.getService();
            userIdentification = new UserIdentification(httpServletRequest, coreBundleConfiguration.getIpPinningCheckHttpHeaderName());
        }
        catch (ServiceNotFoundException ex) {
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
        HttpUserSessionRequest httpUserSessionRequest = new HttpUserSessionRequest(httpServletRequest, formParams);
        try {
            ClientSessionManager clientSessionManager = this.clientSessionManagerTracker.getService();
            UserSession userSession = clientSessionManager.getUserSession(httpServletRequest);
            if (userSession != null) {
                LOG.log(Level.FINEST, "found cached userSession");
                return Response.ok((Object)userSession).cookie(CookiesList.add(this.createSessionCookie(userSession)).asArray()).build();
            }
            LOG.log(Level.FINEST, "no cached userSession found; check IdentityProvider");
            userSession = identityProvider.requestUserSession(httpUserSessionRequest);
            if (userSession == null) {
                throw new SystemException((ErrorCode)CoreErrorCode.AUTHENTICATION_UNAUTHORIZED, "CORE_ERROR_IDENTITY_PROVIDER_AUTHENTICATION_FAILED");
            }
            if (!userSession.getSensitiveCustomData().containsKey("userIdentificationObject")) {
                userSession.getSensitiveCustomData().put("userIdentificationObject", userIdentification);
            }
            if (userSession.hasImpersonator()) {
                UserAuditLog.info(userSession.getImpersonatorUsername(), "ImpersonateUser", "Impersonation of the user '" + userSession.getLoginName() + "'.");
            } else {
                UserAuditLog.info(userSession, "login", userIdentification.toString());
            }
            if (clientSessionManager.getSessionCount() >= this.licenseServiceTracker.getService().getConcurrentUserLimit()) {
                if (userSession.hasRole("bpcadmin")) {
                    for (ClientSession session : clientSessionManager.getAllSessions()) {
                        if (!session.getUserSession().hasRole("bpcadmin")) continue;
                        UserAuditLog.warning(userSession, "logout", "Forced CCU limit logout");
                        clientSessionManager.removeSession(session.getUserSession().getSessionId(), true, identityProvider);
                        break;
                    }
                } else {
                    throw new IdentityProviderException((ErrorCode)CoreErrorCode.AUTHENTICATION_CONCURRENT_USER_LIMIT_REACHED, "AUTHENTICATION_CONCURRENT_USER_LIMIT_REACHED");
                }
            }
            clientSessionManager.addSession(userSession.getSessionId(), userSession);
            CoreModule coreModule = this.moduleManagerTracker.getService().getModuleByClass(CoreModule.class);
            if (!coreModule.isUserAllowedToAccessBPC(userSession)) {
                clientSessionManager.removeSession(userSession.getSessionId(), true, identityProvider);
                throw new IdentityProviderException((ErrorCode)CoreErrorCode.AUTHENTICATION_ROLE_CHECK_FAILED, "AUTHENTICATION_MANDATORY_ROLE_TO_ACCESS_BPC_MISSING");
            }
            return Response.ok((Object)userSession).cookie(CookiesList.add(this.createSessionCookie(userSession)).asArray()).build();
        }
        catch (Exception ex) {
            if (ex instanceof SystemException && ((SystemException)ex).isErrorCode(CoreErrorCode.AUTHENTICATION_UNAUTHORIZED)) {
                LOG.log(Level.WARNING, "Check session failed: " + ex);
            } else {
                LOG.log(Level.SEVERE, "Check session failed", ex);
            }
            if (ex instanceof IdentityProviderException && httpUserSessionRequest.getFormParam("username") != null) {
                AUTHENTICATION_LOGGER.log(Level.WARNING, "user authentication failed - " + userIdentification.toString());
            }
            if (ex instanceof IdentityProviderException && httpUserSessionRequest.getFormParam("username") != null) {
                UserAuditLog.error(httpUserSessionRequest.getFormParam("username"), "login", userIdentification.toString());
            }
            if (ex instanceof IdentityProviderException && identityProvider instanceof UserFlowIdentityProvider) {
                IdentityProviderException idpException = (IdentityProviderException)ex;
                idpException.setLanguage(ErrorResponseService.getBpcLanguage(hh));
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).type("application/json").cookie(CookiesList.add(this.createDeleteCookie()).asArray()).entity(idpException.asErrorResponseMap()).build();
            }
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    private NewCookie createDeleteCookie() {
        LOG.log(Level.FINEST, "createDeleteCookie");
        String bpcCookieName = this.getBpcCookieName();
        String bpcClientPath = AuthenticationEndpoint.getBpcClientPathFromRelatedSetting(this.moduleManagerTracker);
        BpcCookieCreator bpcCookieCreator = new BpcCookieCreator(bpcCookieName, bpcClientPath);
        return bpcCookieCreator.createDeleteCookie();
    }

    private NewCookie createSessionCookie(UserSession userSession) {
        LOG.log(Level.FINEST, "createSessionCookie userSession=...");
        String bpcCookieName = this.getBpcCookieName();
        String bpcClientPath = AuthenticationEndpoint.getBpcClientPathFromRelatedSetting(this.moduleManagerTracker);
        boolean secureBpcCookie = this.isSecureCookieFlagSetInRelatedSetting();
        BpcCookieCreator bpcCookieCreator = new BpcCookieCreator(bpcCookieName, bpcClientPath);
        return bpcCookieCreator.createSessionCookie(userSession, secureBpcCookie);
    }

    private String getBpcCookieName() {
        LOG.log(Level.FINEST, "getBpcCookieName");
        return AuthenticationEndpoint.getBpcCookieName(this.coreBundleConfigurationTracker);
    }

    public static String getBpcCookieName(BpcServicesTracker<CoreBundleConfiguration> coreBundleConfigurationTracker) {
        String bpcCookieName;
        LOG.log(Level.FINEST, "getBpcCookieName coreBundleConfigurationTracker=...");
        try {
            CoreBundleConfiguration coreBundleConfiguration = coreBundleConfigurationTracker.getService();
            bpcCookieName = coreBundleConfiguration.getCookieName();
        }
        catch (ServiceNotFoundException e) {
            LOG.log(Level.SEVERE, "Failed to get coreBundleConfiguration service", e);
            bpcCookieName = "BPC_J_S";
        }
        return bpcCookieName;
    }

    private boolean isSecureCookieFlagSetInRelatedSetting() {
        boolean secure;
        LOG.log(Level.FINEST, "isSecureCookieFlagSetInRelatedSetting");
        try {
            CoreBundleConfiguration coreBundleConfiguration = this.coreBundleConfigurationTracker.getService();
            secure = coreBundleConfiguration.isSecureCookieFlagSet();
            LOG.log(Level.FINEST, "Secure cookie flag: " + secure);
        }
        catch (ServiceNotFoundException e) {
            LOG.log(Level.SEVERE, "Failed to get coreBundleConfiguration service", e);
            secure = false;
        }
        return secure;
    }

    private URI getBpcFrontendUrl(HttpServletRequest req) throws URISyntaxException {
        LOG.log(Level.FINEST, "getBpcFrontendUrl req=" + req);
        String bpcBaseUrl = AuthenticationEndpoint.getBpcBaseUrlFromRelatedSetting(this.moduleManagerTracker);
        String bpcClientPath = AuthenticationEndpoint.getBpcClientPathFromRelatedSetting(this.moduleManagerTracker);
        return new URI(StringUtil.glue(bpcBaseUrl, bpcClientPath, '/'));
    }

    private static String getBpcBaseUrlFromRelatedSetting(BpcServicesTracker<ModuleManager> moduleManagerTracker) {
        String bpcBaseUrl;
        LOG.log(Level.FINEST, "getBpcBaseUrlFromRelatedSetting moduleManagerTracker=...");
        try {
            bpcBaseUrl = (String)AuthenticationEndpoint.getCoreModule(moduleManagerTracker).getConfiguration().getSetting("bpcBaseUrl").getValue();
            LOG.log(Level.FINEST, "Found the 'bpcBaseUrl' value: " + bpcBaseUrl);
        }
        catch (ModuleNotFoundException | ServiceNotFoundException ex) {
            LOG.log(Level.SEVERE, "Failed to get the value of the core setting 'bpcBaseUrl'.", ex);
            bpcBaseUrl = "http://localhost:8181";
        }
        return bpcBaseUrl;
    }

    public static String getBpcClientPathFromRelatedSetting(BpcServicesTracker<ModuleManager> moduleManagerTracker) {
        String bpcClientPath;
        LOG.log(Level.FINEST, "getBpcClientPathFromRelatedSetting moduleManagerTracker=...");
        try {
            bpcClientPath = (String)AuthenticationEndpoint.getCoreModule(moduleManagerTracker).getConfiguration().getSetting("clientPath").getValue();
            LOG.log(Level.FINEST, "Found the 'clientPath' value: " + bpcClientPath);
        }
        catch (ModuleNotFoundException | ServiceNotFoundException ex) {
            LOG.log(Level.SEVERE, "Failed to get the value of the core setting 'clientPath'.", ex);
            bpcClientPath = "/";
        }
        return bpcClientPath;
    }
}

