/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.resource;

import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ErrorResponse;
import de.virtimo.bpc.api.service.ErrorResponseService;
import de.virtimo.bpc.jaxrs.ApiResponse;
import de.virtimo.bpc.jaxrs.ApiResponses;
import de.virtimo.bpc.jaxrs.BpcRoleOrRightRequired;
import de.virtimo.bpc.util.SetUtil;
import de.virtimo.bpc.util.StringUtil;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.apache.karaf.log.core.LogService;
import org.osgi.framework.BundleContext;

@Path(value="loggers")
public class LoggersEndpoint {
    private static final Logger LOG = Logger.getLogger(LoggersEndpoint.class.getName());
    private final BundleContext bundleContext;
    private BpcServicesTracker<LogService> karafLogServiceTracker;
    private BpcServicesTracker<ErrorResponseService> errorResponseServiceTracker;
    private final Set<String> validLogLevels;

    public LoggersEndpoint(BundleContext bundleContext) {
        LOG.info("LoggersEndpoint bundleContext=" + bundleContext);
        this.bundleContext = bundleContext;
        this.validLogLevels = SetUtil.setOf("OFF", "TRACE", "DEBUG", "INFO", "WARN", "ERROR", "FATAL", "DEFAULT");
    }

    public void onStartup() {
        LOG.info("onStartup");
        this.karafLogServiceTracker = new BpcServicesTracker<LogService>(this.bundleContext, LogService.class);
        this.errorResponseServiceTracker = new BpcServicesTracker<ErrorResponseService>(this.bundleContext, ErrorResponseService.class);
    }

    public void onShutdown() {
        LOG.info("onShutdown");
        BpcServicesTracker.stopAll(this);
    }

    @GET
    @Path(value="/all")
    @Produces(value={"application/json"})
    @BpcRoleOrRightRequired(role="LOGGERS_ADMIN", right="LOGGERS_LIST_ALL", message="Not allowed to get a list of all loggers.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    public Response getAllLoggers(@Context HttpHeaders hh) {
        LOG.info("getAllLoggers");
        try {
            LogService karafLogService = this.karafLogServiceTracker.getService();
            Map loggers = karafLogService.getLevel("ALL");
            ArrayList<Map<String, String>> resp = new ArrayList<Map<String, String>>();
            for (String logger : loggers.keySet()) {
                resp.add(Map.of("name", logger, "level", loggers.get(logger)));
            }
            return Response.ok(resp).build();
        }
        catch (Exception ex) {
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @GET
    @Path(value="/levels/valid")
    @Produces(value={"application/json"})
    @BpcRoleOrRightRequired(role="LOGGERS_ADMIN", right="LOGGERS_LIST_VALID_LEVELS", message="Not allowed to get a list of all valid log levels.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    public Response getValidLogLevels(@Context HttpHeaders hh) {
        LOG.info("getValidLogLevels");
        try {
            return Response.ok(this.validLogLevels).build();
        }
        catch (Exception ex) {
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @POST
    @Path(value="/level")
    @Produces(value={"application/json"})
    @BpcRoleOrRightRequired(role="LOGGERS_ADMIN", right="LOGGERS_SET_LEVEL", message="Not allowed to set the log level of a logger.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    public Response setLogLevel(@FormParam(value="logger") String logger, @FormParam(value="level") String level, @Context HttpHeaders hh) {
        LOG.info("setLogLevel");
        try {
            if (StringUtil.isNullOrEmpty(level)) {
                throw new IllegalArgumentException("The path parameter 'level' is not set.");
            }
            if (!this.validLogLevels.contains(level = level.toUpperCase())) {
                throw new IllegalArgumentException("The path parameter value '" + level + "' of 'level' is invalid. Must be one of: " + this.validLogLevels);
            }
            if (StringUtil.isNullOrEmpty(logger)) {
                throw new IllegalArgumentException("The query parameter 'logger' is not set.");
            }
            LogService karafLogService = this.karafLogServiceTracker.getService();
            karafLogService.setLevel(logger, level);
            return Response.ok().build();
        }
        catch (Exception ex) {
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }
}

