/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.resource;

import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.jaxrs.annotation.JacksonFeatures;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ClientSessionManager;
import de.virtimo.bpc.api.CoreBundleConfiguration;
import de.virtimo.bpc.api.ErrorResponse;
import de.virtimo.bpc.api.ModuleManager;
import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.api.db.DatabaseManager;
import de.virtimo.bpc.api.opensearch.plugin.OpenSearchBpcPluginManager;
import de.virtimo.bpc.api.service.ErrorResponseService;
import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.core.CoreModule;
import de.virtimo.bpc.core.license.LicenseService;
import de.virtimo.bpc.core.replicator.ReplicationManager;
import de.virtimo.bpc.core.resource.response.ActiveSessions;
import de.virtimo.bpc.core.resource.response.BpcStatusAdminImpl;
import de.virtimo.bpc.core.resource.response.BpcStatusUserImpl;
import de.virtimo.bpc.core.utils.BpcBundleUtil;
import de.virtimo.bpc.core.utils.RestWebServiceClientFactory;
import de.virtimo.bpc.jaxrs.ApiResponse;
import de.virtimo.bpc.jaxrs.ApiResponses;
import de.virtimo.bpc.jaxrs.BpcEndpoint;
import de.virtimo.bpc.jaxrs.BpcRightRequired;
import de.virtimo.bpc.opensearch.plugin.dto.ConnectedServerDTO;
import java.net.URI;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.client.Client;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.karaf.log.core.LogService;
import org.opensearch.action.admin.cluster.health.ClusterHealthRequest;
import org.opensearch.action.admin.cluster.health.ClusterHealthResponse;
import org.opensearch.client.Node;
import org.opensearch.client.RequestOptions;
import org.opensearch.client.RestHighLevelClient;
import org.opensearch.cluster.health.ClusterHealthStatus;
import org.opensearch.common.unit.TimeValue;
import org.osgi.framework.BundleContext;

@Path(value="status")
public class StatusEndpoint {
    private static final Logger LOG = Logger.getLogger(StatusEndpoint.class.getName());
    private final BundleContext bundleContext;
    private BpcServicesTracker<ClientSessionManager> clientSessionManagerTracker;
    private BpcServicesTracker<ModuleManager> moduleManagerTracker;
    private BpcServicesTracker<OpenSearchService> openSearchServiceTracker;
    private BpcServicesTracker<ReplicationManager> replicationManagerTracker;
    private BpcServicesTracker<DatabaseManager> databaseManagerTracker;
    private BpcServicesTracker<CoreBundleConfiguration> coreBundleConfigurationTracker;
    private BpcServicesTracker<OpenSearchBpcPluginManager> openSearchBpcPluginManagerTracker;
    private BpcServicesTracker<LicenseService> licenseServiceTracker;
    private BpcServicesTracker<ErrorResponseService> errorResponseServiceTracker;
    private BpcServicesTracker<LogService> karafLogServiceTracker;

    public StatusEndpoint(BundleContext bundleContext) {
        LOG.info("StatusEndpoint bundleContext=" + bundleContext);
        this.bundleContext = bundleContext;
    }

    public void onStartup() {
        LOG.info("onStartup");
        this.clientSessionManagerTracker = new BpcServicesTracker<ClientSessionManager>(this.bundleContext, ClientSessionManager.class);
        this.moduleManagerTracker = new BpcServicesTracker<ModuleManager>(this.bundleContext, ModuleManager.class);
        this.openSearchServiceTracker = new BpcServicesTracker<OpenSearchService>(this.bundleContext, OpenSearchService.class);
        this.replicationManagerTracker = new BpcServicesTracker<ReplicationManager>(this.bundleContext, ReplicationManager.class);
        this.databaseManagerTracker = new BpcServicesTracker<DatabaseManager>(this.bundleContext, DatabaseManager.class);
        this.coreBundleConfigurationTracker = new BpcServicesTracker<CoreBundleConfiguration>(this.bundleContext, CoreBundleConfiguration.class);
        this.openSearchBpcPluginManagerTracker = new BpcServicesTracker<OpenSearchBpcPluginManager>(this.bundleContext, OpenSearchBpcPluginManager.class);
        this.licenseServiceTracker = new BpcServicesTracker<LicenseService>(this.bundleContext, LicenseService.class);
        this.errorResponseServiceTracker = new BpcServicesTracker<ErrorResponseService>(this.bundleContext, ErrorResponseService.class);
        this.karafLogServiceTracker = new BpcServicesTracker<LogService>(this.bundleContext, LogService.class);
    }

    public void onShutdown() {
        LOG.info("onShutdown");
        BpcServicesTracker.stopAll(this);
    }

    @GET
    @Produces(value={"application/json"})
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcEndpoint
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    public Response getLocalStatus(@Context HttpHeaders httpHeaders, @Context HttpServletRequest servletRequest) {
        LOG.info("getLocalStatus");
        try {
            ModuleManager moduleManager = this.moduleManagerTracker.getService();
            ClientSessionManager clientSessionManager = this.clientSessionManagerTracker.getService();
            ReplicationManager replicationManager = this.replicationManagerTracker.getService();
            DatabaseManager databaseManager = this.databaseManagerTracker.getService();
            OpenSearchService oss = this.openSearchServiceTracker.getService();
            CoreBundleConfiguration coreBundleConfiguration = this.coreBundleConfigurationTracker.getService();
            OpenSearchBpcPluginManager openSearchBpcPluginManager = this.openSearchBpcPluginManagerTracker.getService();
            LicenseService licenseService = this.licenseServiceTracker.getService();
            LogService karafLogService = this.karafLogServiceTracker.getService();
            UserSession userSession = clientSessionManager.getUserSession(servletRequest);
            if (userSession != null && userSession.hasRole("bpcadmin") || CoreModule.isRequestFromOtherBpcServer(httpHeaders, coreBundleConfiguration, openSearchBpcPluginManager)) {
                return Response.ok((Object)new BpcStatusAdminImpl(this.bundleContext, moduleManager, coreBundleConfiguration, licenseService, clientSessionManager, replicationManager, databaseManager, oss, openSearchBpcPluginManager, karafLogService)).build();
            }
            if (userSession != null) {
                return Response.ok((Object)new BpcStatusUserImpl(this.bundleContext, moduleManager, coreBundleConfiguration, licenseService)).build();
            }
            return Response.ok().build();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Exception while getting the local server status", ex);
            return ErrorResponse.forException(ex).languageFrom(httpHeaders).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Produces(value={"application/json"})
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @Path(value="/server/{serverUUID}")
    @BpcEndpoint
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    public Response getRemoteStatus(@PathParam(value="serverUUID") String serverUUID, @Context UriInfo uriInfo, @Context HttpHeaders httpHeaders, @Context HttpServletRequest servletRequest) {
        Response response;
        block7: {
            LOG.info("getRemoteStatus serverUUID=" + serverUUID);
            ClientSessionManager clientSessionManager = this.clientSessionManagerTracker.getService();
            OpenSearchBpcPluginManager openSearchBpcPluginManager = this.openSearchBpcPluginManagerTracker.getService();
            CoreBundleConfiguration coreBundleConfiguration = this.coreBundleConfigurationTracker.getService();
            UserSession userSession = clientSessionManager.getUserSession(servletRequest);
            if (userSession == null || !userSession.hasRole("bpcadmin")) {
                return Response.ok().build();
            }
            Client client = null;
            try {
                client = RestWebServiceClientFactory.newClient(false);
                ConnectedServerDTO connectedServer = openSearchBpcPluginManager.getConnectedServers().getConnectedServerByUUID(serverUUID);
                String remoteServerUrl = uriInfo.getRequestUri().getScheme() + "://" + connectedServer.getServerStateInfo().getServerAddress() + ":" + connectedServer.getServerStateInfo().getServerHttpPort() + "/cxf/bpc-core/status";
                String remoteServerResponse = (String)client.target(new URI(remoteServerUrl)).request(new String[]{"application/json"}).header("X-Active-Active", (Object)coreBundleConfiguration.getServerUUID()).get(String.class);
                response = Response.ok((Object)remoteServerResponse).build();
                if (client == null) break block7;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        client.close();
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    LOG.log(Level.SEVERE, "Exception while getting the remote server status", ex);
                    return ErrorResponse.forException(ex).languageFrom(httpHeaders).usingTracker(this.errorResponseServiceTracker).build();
                }
            }
            client.close();
        }
        return response;
    }

    @GET
    @Path(value="/health")
    @BpcEndpoint
    @ApiResponses(value={@ApiResponse(responseCode="200", description="When all 3 health status are fine"), @ApiResponse(responseCode="503", description="When not all 3 health status are fine")})
    public Response getHealth(@Context HttpHeaders hh) {
        LOG.info("getHealth");
        try {
            Response bpcStatusResponse = this.getBpcStatus(hh);
            if (bpcStatusResponse.getStatus() != Response.Status.OK.getStatusCode()) {
                return bpcStatusResponse;
            }
            Response maintenanceStatus = this.getMaintenanceStatus(hh);
            if (maintenanceStatus.getStatus() != Response.Status.OK.getStatusCode()) {
                return maintenanceStatus;
            }
            Response openSearchStatusResponse = this.getOpenSearchStatus();
            if (openSearchStatusResponse.getStatus() != Response.Status.OK.getStatusCode()) {
                return openSearchStatusResponse;
            }
            return Response.ok().build();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Exception while getting the health state", ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @GET
    @Path(value="/bpc")
    @BpcEndpoint
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Karaf is running and all BPC modules are not in state 'Resolved' and not in state 'Failure`"), @ApiResponse(responseCode="503", description="At least one BPC module is in state 'Resolved' or 'Failure'")})
    public Response getBpcStatus(@Context HttpHeaders hh) {
        LOG.info("getBpcStatus");
        try {
            if (BpcBundleUtil.areAllBpcBundlesInWorkingState(this.bundleContext)) {
                return Response.ok().build();
            }
            return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).build();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Exception while getting the bpc state", ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @GET
    @Path(value="/maintenance")
    @BpcEndpoint
    @ApiResponses(value={@ApiResponse(responseCode="200", description="BPC is not in maintenance mode"), @ApiResponse(responseCode="503", description="BPC is in maintenance mode")})
    public Response getMaintenanceStatus(@Context HttpHeaders hh) {
        LOG.info("getMaintenanceStatus");
        try {
            CoreModule coreModule = (CoreModule)this.moduleManagerTracker.getService().getModuleById("_core");
            if (coreModule.isMaintenanceModeEnabled()) {
                return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).build();
            }
            return Response.ok().build();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Exception while getting the maintenance mode state", ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @GET
    @Path(value="/opensearch")
    @BpcEndpoint
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="503", description="No connection to OpenSearch"), @ApiResponse(responseCode="503", description="No nodes available"), @ApiResponse(responseCode="503", description="Cluster health status is 'red'")})
    public Response getOpenSearchStatus() {
        LOG.info("getOpenSearchStatus");
        try {
            RestHighLevelClient osClient = this.openSearchServiceTracker.getService().getClient();
            if (osClient == null) {
                LOG.warning("No OpenSearch client available");
                return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).build();
            }
            List<Node> nodes = osClient.getLowLevelClient().getNodes();
            if (nodes == null || nodes.isEmpty()) {
                LOG.warning("No OpenSearch nodes found.");
                return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).build();
            }
            ClusterHealthRequest request = new ClusterHealthRequest();
            request.timeout(TimeValue.timeValueSeconds(30L));
            ClusterHealthResponse healths = osClient.cluster().health(request, RequestOptions.DEFAULT);
            ClusterHealthStatus clusterStatus = healths.getStatus();
            LOG.info("Cluster state: " + clusterStatus);
            if (clusterStatus == ClusterHealthStatus.RED) {
                LOG.warning("OpenSearch cluster in state RED");
                return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).build();
            }
            return Response.ok().build();
        }
        catch (Throwable ex) {
            LOG.log(Level.SEVERE, "Exception while querying the OpenSearch state", ex);
            return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).build();
        }
    }

    @GET
    @Path(value="/sessions")
    @BpcRightRequired(right="getSessionStatus")
    @Produces(value={"application/json"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    public Response getSessionStatus(@Context HttpHeaders hh) {
        LOG.info("getSessionStatus");
        try {
            ClientSessionManager clientSessionManager = this.clientSessionManagerTracker.getService();
            ActiveSessions sessions = new ActiveSessions(clientSessionManager.getAllSessions());
            return Response.ok((Object)sessions).build();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Exception while getting the session status", ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @GET
    @Path(value="/clustermaster")
    @BpcEndpoint
    @ApiResponses(value={@ApiResponse(responseCode="200", description="BPC is the master server"), @ApiResponse(responseCode="503", description="BPC is not the master server")})
    public Response getMasterServerStatus(@Context HttpHeaders hh) {
        LOG.info("getMasterServerStatus");
        try {
            CoreModule coreModule = (CoreModule)this.moduleManagerTracker.getService().getModuleById("_core");
            if (coreModule.isMasterServer()) {
                return Response.ok().build();
            }
            return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).build();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Exception while getting the master server status", ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }
}

