/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.resource.response;

import com.fasterxml.jackson.annotation.JsonProperty;
import de.virtimo.bpc.api.InstantiableModule;
import de.virtimo.bpc.api.Module;
import de.virtimo.bpc.api.ModuleConfiguration;
import de.virtimo.bpc.api.Setting;
import de.virtimo.bpc.api.SettingException;
import de.virtimo.bpc.api.Settings;
import de.virtimo.bpc.api.response.ModuleConfig;
import de.virtimo.bpc.core.SettingsImpl;
import de.virtimo.bpc.core.resource.response.SettingsBasedModuleInstanceConfigImpl;
import de.virtimo.bpc.module.DefaultModuleConfigurations;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SettingsBasedModuleConfigImpl
implements ModuleConfig {
    private final String moduleId;
    private final Module module;
    private final Settings moduleSettings;
    private final Map<String, Settings> groupedModuleInstanceSettings;

    public SettingsBasedModuleConfigImpl(String moduleId, Module module, Settings allSettingsOfModule) {
        this.moduleId = moduleId;
        this.module = module;
        this.moduleSettings = new SettingsImpl();
        this.groupedModuleInstanceSettings = new HashMap<String, Settings>();
        for (Setting setting : allSettingsOfModule) {
            if (ModuleConfiguration.isNoModuleInstanceId(setting.getInstanceId())) {
                this.moduleSettings.add(setting);
                continue;
            }
            Settings instanceSettings = this.groupedModuleInstanceSettings.get(setting.getInstanceId());
            if (instanceSettings == null) {
                instanceSettings = new SettingsImpl();
                this.groupedModuleInstanceSettings.put(setting.getInstanceId(), instanceSettings);
            }
            instanceSettings.add(setting);
        }
    }

    @Override
    @JsonProperty(value="moduleId")
    public String getModuleId() {
        return this.moduleId;
    }

    @Override
    @JsonProperty(value="moduleName")
    public String getModuleName() {
        return this.module != null ? this.module.getModuleName() : this.moduleId;
    }

    @Override
    @JsonProperty(value="settings")
    public List<Setting> getSettings() {
        return this.moduleSettings.maskPasswords();
    }

    @Override
    @JsonProperty(value="instances")
    public List<ModuleConfig> getInstances() {
        ArrayList<SettingsBasedModuleInstanceConfigImpl> result = null;
        if (!this.groupedModuleInstanceSettings.isEmpty()) {
            result = new ArrayList<SettingsBasedModuleInstanceConfigImpl>();
            for (String instanceId : this.groupedModuleInstanceSettings.keySet()) {
                Settings instanceSettings = this.groupedModuleInstanceSettings.get(instanceId);
                SettingsBasedModuleInstanceConfigImpl moduleInstanceConfig = new SettingsBasedModuleInstanceConfigImpl(this.getModuleName(), instanceId, instanceSettings);
                result.add(moduleInstanceConfig);
            }
        }
        return result;
    }

    @Override
    @JsonProperty(value="defaultConfiguration")
    public Object getDefaultConfiguration() throws SettingException {
        if (this.module == null) {
            return null;
        }
        ModuleConfiguration defaultConfig = DefaultModuleConfigurations.getInstance().getForModule(this.module);
        return new ArrayList<Setting>(defaultConfig.getSettings().values());
    }

    @Override
    @JsonProperty(value="instancesDefaultConfiguration")
    public Object getInstancesDefaultConfiguration() throws SettingException {
        if (this.module == null) {
            return null;
        }
        if (this.module instanceof InstantiableModule) {
            InstantiableModule instantiableModule = (InstantiableModule)this.module;
            if (!instantiableModule.usesInstanceTypes()) {
                ModuleConfiguration defaultConfig = DefaultModuleConfigurations.getInstance().getForModuleInstance(instantiableModule, "none");
                return new ArrayList<Setting>(defaultConfig.getSettings().values());
            }
            HashMap<String, ArrayList<Setting>> result = new HashMap<String, ArrayList<Setting>>();
            for (String supportedInstanceType : instantiableModule.getSupportedInstanceTypes()) {
                ModuleConfiguration defaultConfig = DefaultModuleConfigurations.getInstance().getForModuleInstance(instantiableModule, supportedInstanceType);
                result.put(supportedInstanceType, new ArrayList<Setting>(defaultConfig.getSettings().values()));
            }
            return result;
        }
        return null;
    }
}

