/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.flow;

import de.virtimo.bpc.api.BpcService;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.CoreBundleConfiguration;
import de.virtimo.bpc.api.ModuleConfiguration;
import de.virtimo.bpc.api.ModuleManager;
import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.api.exception.HttpProxyException;
import de.virtimo.bpc.api.exception.ModuleInstanceNotFoundException;
import de.virtimo.bpc.api.exception.ModuleNotFoundException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.service.FlowService;
import de.virtimo.bpc.core.httpproxy.HttpProxyCall;
import de.virtimo.bpc.core.httpproxy.HttpProxyServiceImpl;
import de.virtimo.bpc.flow.FlowModule;
import de.virtimo.bpc.flow.FlowModuleInstance;
import de.virtimo.bpc.flow.HttpProxyCallConfigFromFlowInstance;
import java.util.logging.Logger;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.osgi.framework.BundleContext;

public class FlowServiceImpl
implements FlowService,
BpcService {
    private static final Logger LOG = Logger.getLogger(HttpProxyServiceImpl.class.getName());
    private final BundleContext bundleContext;
    private final BpcServicesTracker<ModuleManager> moduleManagerTracker;
    private final BpcServicesTracker<CoreBundleConfiguration> coreBundleConfigurationTracker;

    public FlowServiceImpl(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.moduleManagerTracker = new BpcServicesTracker<ModuleManager>(bundleContext, ModuleManager.class);
        this.coreBundleConfigurationTracker = new BpcServicesTracker<CoreBundleConfiguration>(bundleContext, CoreBundleConfiguration.class);
    }

    @Override
    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    @Override
    public void shutdownService() {
        LOG.info("shutdownService");
        BpcServicesTracker.stopAll(this);
    }

    @Override
    public ModuleConfiguration getConfig(String flowInstanceId) throws ServiceNotFoundException, ModuleNotFoundException, ModuleInstanceNotFoundException {
        FlowModule flowModule = (FlowModule)this.moduleManagerTracker.getService().getModuleById("flow");
        FlowModuleInstance flowInstance = (FlowModuleInstance)flowModule.getModuleInstanceById(flowInstanceId);
        return flowInstance.getConfiguration();
    }

    private HttpProxyCall getHttpProxyCallForFlowInstance(String flowInstanceId) throws ServiceNotFoundException, ModuleNotFoundException, ModuleInstanceNotFoundException {
        FlowModule flowModule = (FlowModule)this.moduleManagerTracker.getService().getModuleById("flow");
        FlowModuleInstance flowInstance = (FlowModuleInstance)flowModule.getModuleInstanceById(flowInstanceId);
        HttpProxyCallConfigFromFlowInstance config = new HttpProxyCallConfigFromFlowInstance(flowInstance);
        config.addAdditionalHttpHeader("X-BPC-Server-UUID", this.coreBundleConfigurationTracker.getService().getServerUUID());
        return new HttpProxyCall(config);
    }

    @Override
    public Response doGet(String flowInstanceId, String targetPath, String targetUrl, UriInfo uriInfo, HttpHeaders headers, UserSession userSession, boolean forceJson) throws HttpProxyException, ServiceNotFoundException, ModuleNotFoundException, ModuleInstanceNotFoundException {
        LOG.info("doGet flowInstanceId=" + flowInstanceId + ", targetPath=" + targetPath + ", targetUrl=" + targetUrl + ", uriInfo=" + uriInfo + ", headers=..., userSession=..., forceJson=" + forceJson);
        return this.getHttpProxyCallForFlowInstance(flowInstanceId).doGet(targetPath, targetUrl, uriInfo, headers, userSession, forceJson);
    }

    @Override
    public Response doPost(String flowInstanceId, String targetPath, String targetUrl, UriInfo uriInfo, HttpHeaders headers, UserSession userSession, byte[] body, boolean forceJson) throws HttpProxyException, ServiceNotFoundException, ModuleNotFoundException, ModuleInstanceNotFoundException {
        LOG.info("doPost flowInstanceId=" + flowInstanceId + ", targetPath=" + targetPath + ", targetUrl=" + targetUrl + ", uriInfo=" + uriInfo + ", headers=..., userSession=..., body=..., forceJson=" + forceJson);
        return this.getHttpProxyCallForFlowInstance(flowInstanceId).doPost(targetPath, targetUrl, uriInfo, headers, userSession, body, forceJson);
    }

    @Override
    public Response doPut(String flowInstanceId, String targetPath, String targetUrl, UriInfo uriInfo, HttpHeaders headers, UserSession userSession, byte[] body, boolean forceJson) throws HttpProxyException, ServiceNotFoundException, ModuleNotFoundException, ModuleInstanceNotFoundException {
        LOG.info("doPut flowInstanceId=" + flowInstanceId + ", targetPath=" + targetPath + ", targetUrl=" + targetUrl + ", uriInfo=" + uriInfo + ", headers=..., userSession=..., body=..., forceJson=" + forceJson);
        return this.getHttpProxyCallForFlowInstance(flowInstanceId).doPut(targetPath, targetUrl, uriInfo, headers, userSession, body, forceJson);
    }

    @Override
    public Response doDelete(String flowInstanceId, String targetPath, String targetUrl, UriInfo uriInfo, HttpHeaders headers, UserSession userSession, boolean forceJson) throws HttpProxyException, ServiceNotFoundException, ModuleNotFoundException, ModuleInstanceNotFoundException {
        LOG.info("doDelete flowInstanceId=" + flowInstanceId + ", targetPath=" + targetPath + ", targetUrl=" + targetUrl + ", uriInfo=" + uriInfo + ", headers=..., userSession=..., forceJson=" + forceJson);
        return this.getHttpProxyCallForFlowInstance(flowInstanceId).doDelete(targetPath, targetUrl, uriInfo, headers, userSession, forceJson);
    }
}

