/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.logservice;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.InstantiableModule;
import de.virtimo.bpc.api.ModuleConfiguration;
import de.virtimo.bpc.api.Setting;
import de.virtimo.bpc.api.exception.BpcErrorCode;
import de.virtimo.bpc.api.exception.LogServiceSettingsException;
import de.virtimo.bpc.core.lookupjoins.LookupJoins;
import de.virtimo.bpc.logservice.LogServiceModule;
import de.virtimo.bpc.logservice.db.DatabaseTableDataCache;
import de.virtimo.bpc.module.AbstractModuleInstance;
import de.virtimo.bpc.util.JsonUtil;
import de.virtimo.bpc.util.MapUtil;
import de.virtimo.bpc.util.StringUtil;
import java.beans.PropertyChangeEvent;
import java.sql.Timestamp;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class LogServiceModuleInstance
extends AbstractModuleInstance {
    private static final Logger LOG = Logger.getLogger(LogServiceModuleInstance.class.getName());
    public static final String SETTING_MAINTENANCE_ENABLED = "maintenanceEnabled";
    public static final String SETTING_OPENSEARCH_LOGGING_ENABLED = "openSearchLoggingEnabled";
    public static final String SETTING_OPENSEARCH = "openSearch";
    public static final String SETTING_RDMS_LOGGING_ENABLED = "rdmsLoggingEnabled";
    public static final String SETTING_RDMS = "rdms";
    public static final String SETTING_KEYS = "keys";
    public static final String SETTING_FIELDS = "fields";
    public static final String SETTING_JOINS = "joins";
    private final DatabaseTableDataCache databaseTableDataCache = new DatabaseTableDataCache();
    private LookupJoins lookupJoins = null;

    public LogServiceModuleInstance(InstantiableModule pm, ModuleConfiguration mc, String instanceId) {
        super(pm, mc, instanceId);
    }

    @Override
    public void destroy() {
        LOG.info("destroy");
        super.destroy();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
        if (evt.getSource() instanceof ModuleConfiguration) {
            LogServiceModule logServiceModule;
            if (SETTING_OPENSEARCH.equalsIgnoreCase(evt.getPropertyName())) {
                LOG.info(this.getModuleId() + ": 'openSearch' setting changed: resetting prepare indices flags");
                InstantiableModule parentModule = this.getParentModule();
                if (parentModule instanceof LogServiceModule) {
                    LogServiceModule logServiceModule2 = (LogServiceModule)parentModule;
                    logServiceModule2.restartBackupJob(this);
                }
            }
            if (SETTING_RDMS.equalsIgnoreCase(evt.getPropertyName())) {
                LOG.info(this.getModuleId() + ": 'rdms' setting changed: clearing the database table datas cache");
                this.databaseTableDataCache.clear();
            }
            if (SETTING_JOINS.equalsIgnoreCase(evt.getPropertyName())) {
                LOG.info(this.getModuleId() + ": 'joins' setting changed: resetting the lookup joins");
                this.lookupJoins = null;
            }
            if (SETTING_FIELDS.equalsIgnoreCase(evt.getPropertyName())) {
                LOG.info(this.getModuleId() + ": 'fields' setting changed: updating the index mappings");
                if (!this.isMaintenanceEnabled() && this.isOpenSearchLoggingEnabled()) {
                    logServiceModule = (LogServiceModule)this.getParentModule();
                    logServiceModule.updateOpenSearchIndexMappings(this);
                }
            }
            if (SETTING_MAINTENANCE_ENABLED.equalsIgnoreCase(evt.getPropertyName())) {
                LOG.info(this.getModuleId() + ": 'maintenanceEnabled' setting changed: updating the index mappings");
                if (!this.isMaintenanceEnabled()) {
                    logServiceModule = (LogServiceModule)this.getParentModule();
                    logServiceModule.updateOpenSearchIndexMappings(this);
                }
            }
            if (SETTING_OPENSEARCH_LOGGING_ENABLED.equalsIgnoreCase(evt.getPropertyName())) {
                LOG.info(this.getModuleId() + ": 'openSearchLoggingEnabled' setting changed: updating the index mappings");
                if (this.isOpenSearchLoggingEnabled()) {
                    logServiceModule = (LogServiceModule)this.getParentModule();
                    logServiceModule.updateOpenSearchIndexMappings(this);
                }
            }
        }
    }

    public DatabaseTableDataCache getDatabaseTableDataCache() {
        return this.databaseTableDataCache;
    }

    public boolean isMaintenanceEnabled() {
        return (Boolean)this.getConfiguration().getSetting(SETTING_MAINTENANCE_ENABLED).getValue();
    }

    public boolean isOpenSearchLoggingEnabled() {
        return (Boolean)this.getConfiguration().getSetting(SETTING_OPENSEARCH_LOGGING_ENABLED).getValue();
    }

    public boolean isDatabaseLoggingEnabled() {
        return (Boolean)this.getConfiguration().getSetting(SETTING_RDMS_LOGGING_ENABLED).getValue();
    }

    private <T> T convertJsonSetting(String settingName, Class<T> toClazz) throws LogServiceSettingsException {
        LOG.fine("convertJsonSetting setting=" + settingName + ", toClazz=" + toClazz);
        Setting setting = this.getConfiguration().getSetting(settingName);
        if (setting == null) {
            throw new LogServiceSettingsException((ErrorCode)BpcErrorCode.VALIDATION_MISSING_INPUT, "Converting setting to JSON failed. The requested setting '${setting}' is null.", MapUtil.mapOf("setting", settingName));
        }
        try {
            return JsonUtil.getInstance().convertJavaContainerToPojo(setting.getValue(), toClazz);
        }
        catch (Exception ex) {
            throw new LogServiceSettingsException((ErrorCode)BpcErrorCode.VALIDATION_INVALID_INPUT, "Converting setting to JSON failed. The setting '${setting}' has an invalid value.", MapUtil.mapOf("setting", setting.getName()), (Throwable)ex);
        }
    }

    public OpenSearchConfig getOpenSearchConfig() throws LogServiceSettingsException {
        LOG.fine("getOpenSearchConfig");
        return this.convertJsonSetting(SETTING_OPENSEARCH, OpenSearchConfig.class);
    }

    public RdmsConfig getRdmsConfig() throws LogServiceSettingsException {
        LOG.fine("getRdmsConfig");
        return this.convertJsonSetting(SETTING_RDMS, RdmsConfig.class);
    }

    public KeysConfig getKeysConfig() throws LogServiceSettingsException {
        LOG.fine("getKeysConfig");
        return this.convertJsonSetting(SETTING_KEYS, KeysConfig.class);
    }

    public FieldsConfig getFieldsConfig() throws LogServiceSettingsException {
        LOG.fine("getFieldsConfig");
        return this.convertJsonSetting(SETTING_FIELDS, FieldsConfig.class);
    }

    public LookupJoins getLookupJoins() {
        LOG.fine("getLookupJoins");
        if (this.lookupJoins == null) {
            this.lookupJoins = new LookupJoins(this.getConfiguration().getSetting(SETTING_JOINS));
        }
        return this.lookupJoins;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class OpenSearchConfig {
        public OpenSearchConfigEntry parent;
        public OpenSearchConfigEntry child;

        public String toString() {
            return "OpenSearchConfig{parent=" + this.parent + ", child=" + this.child + "}";
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static class OpenSearchConfigEntry {
            public String index;

            public void setIndex(String index) {
                this.index = index.toLowerCase();
            }

            public String toString() {
                return "OpenSearchConfigEntry{index='" + this.index + "'}";
            }
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class RdmsConfig {
        public String rdmsDataSourceName;
        public String rdmsTimeZone;
        public RdmsConfigEntry parent;
        public RdmsConfigEntry child;

        public ZoneId getRdmsTimeZoneAsZoneId() {
            return StringUtil.isNullOrEmpty(this.rdmsTimeZone) ? null : ZoneId.of(this.rdmsTimeZone);
        }

        public String toString() {
            return "RdmsConfig{rdmsDataSourceName='" + this.rdmsDataSourceName + "', rdmsTimeZone='" + this.rdmsTimeZone + "', parent=" + this.parent + ", child=" + this.child + "}";
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static class RdmsConfigEntry {
            public String table;

            public String toString() {
                return "RdmsConfigEntry{table='" + this.table + "'}";
            }
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class KeysConfig {
        public KeysConfigEntry parent;
        public KeysConfigEntry child;

        public String toString() {
            return "KeysConfig{parent=" + this.parent + ", child=" + this.child + "}";
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static class KeysConfigEntry {
            public String idColumns;

            public List<String> getIdColumnsAsList() {
                return StringUtil.explode(this.idColumns, ",");
            }

            public String toString() {
                return "KeysConfigEntry{idColumns='" + this.idColumns + "'}";
            }
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class FieldsConfig {
        public Map<String, Field> parent;
        public Map<String, Field> child;

        public static Map<String, Object> createDataContainerWithoutFieldsToSkip(Map<String, Object> data, Set<String> fieldsToSkip) {
            if (fieldsToSkip == null || fieldsToSkip.isEmpty()) {
                return data;
            }
            HashMap<String, Object> result = new HashMap<String, Object>(data);
            for (String fieldToSkip : fieldsToSkip) {
                result.remove(fieldToSkip);
            }
            return result;
        }

        public static Map<String, Object> createDataContainerWithReplacedSysdatePlaceholders(Map<String, Object> data, Set<String> timestampFieldsInLowerCase, ZonedDateTime currentDateTime, ZoneId targetTimeZoneId) {
            if (timestampFieldsInLowerCase == null || timestampFieldsInLowerCase.isEmpty()) {
                return data;
            }
            HashMap<String, Object> result = new HashMap<String, Object>();
            data.forEach((key, value) -> {
                if (timestampFieldsInLowerCase.contains(key.toLowerCase()) && value instanceof String && "SYSDATE".equals(value)) {
                    ZonedDateTime targetDateTime = targetTimeZoneId == null ? currentDateTime : currentDateTime.withZoneSameInstant(targetTimeZoneId);
                    result.put((String)key, Timestamp.valueOf(targetDateTime.toLocalDateTime()));
                } else {
                    result.put((String)key, value);
                }
            });
            return result;
        }

        private static Set<String> getFieldsToSkip(Map<String, Field> container, SkipFieldChecker skipFieldChecker) {
            HashSet<String> result = null;
            if (container != null) {
                for (Map.Entry<String, Field> stringFieldEntry : container.entrySet()) {
                    String fieldName = stringFieldEntry.getKey();
                    Field field = stringFieldEntry.getValue();
                    if (!skipFieldChecker.skipField(field)) continue;
                    if (result == null) {
                        result = new HashSet<String>();
                    }
                    result.add(fieldName);
                }
            }
            return result;
        }

        public Set<String> getOpenSearchParentFieldsToSkip() {
            return FieldsConfig.getFieldsToSkip(this.parent, new SkipOpenSearchFieldChecker());
        }

        public Set<String> getOpenSearchChildFieldsToSkip() {
            return FieldsConfig.getFieldsToSkip(this.child, new SkipOpenSearchFieldChecker());
        }

        public Set<String> getDbParentFieldsToSkip() {
            return FieldsConfig.getFieldsToSkip(this.parent, new SkipDbFieldChecker());
        }

        public Set<String> getDbChildFieldsToSkip() {
            return FieldsConfig.getFieldsToSkip(this.child, new SkipDbFieldChecker());
        }

        private static Set<String> getTimestampFieldsInLowerCase(Map<String, Field> container) {
            HashSet<String> result = null;
            if (container != null) {
                for (Map.Entry<String, Field> stringFieldEntry : container.entrySet()) {
                    String fieldName = stringFieldEntry.getKey();
                    Field field = stringFieldEntry.getValue();
                    if (!"timestamp".equalsIgnoreCase(field.type)) continue;
                    if (result == null) {
                        result = new HashSet<String>();
                    }
                    result.add(fieldName.toLowerCase());
                }
            }
            return result;
        }

        public Set<String> getParentTimestampFieldsInLowerCase() {
            return FieldsConfig.getTimestampFieldsInLowerCase(this.parent);
        }

        public Set<String> getChildTimestampFieldsInLowerCase() {
            return FieldsConfig.getTimestampFieldsInLowerCase(this.child);
        }

        public String toString() {
            return "Fields{parent=" + this.parent + ", child=" + this.child + "}";
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static class Field {
            public String type;
            public String dbFormat;
            public boolean skipOS;
            public boolean skipDB;

            public Field() {
            }

            public Field(String type) {
                this.type = type;
            }

            public String toString() {
                return "Field{type='" + this.type + "', dbFormat='" + this.dbFormat + "', skipOS=" + this.skipOS + ", skipDB=" + this.skipDB + "}";
            }
        }
    }

    private static class SkipDbFieldChecker
    implements SkipFieldChecker {
        private SkipDbFieldChecker() {
        }

        @Override
        public boolean skipField(FieldsConfig.Field field) {
            return field.skipDB;
        }
    }

    private static class SkipOpenSearchFieldChecker
    implements SkipFieldChecker {
        private SkipOpenSearchFieldChecker() {
        }

        @Override
        public boolean skipField(FieldsConfig.Field field) {
            return field.skipOS;
        }
    }

    private static interface SkipFieldChecker {
        public boolean skipField(FieldsConfig.Field var1);
    }
}

