/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.module;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.virtimo.bpc.util.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.Bundle;

public class JsonDefaultsUtil {
    private static final Logger LOG = Logger.getLogger(JsonDefaultsUtil.class.getName());

    private static ObjectMapper createCustomizedObjectMapper() {
        ObjectMapper om = new ObjectMapper();
        om.getFactory().disable(JsonFactory.Feature.USE_THREAD_LOCAL_FOR_BUFFER_RECYCLING);
        return om;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object loadJsonFileAsListOrMap(Bundle bundle, String fileName) {
        LOG.finest("loadJsonFileAsListOrMap bundle:" + bundle + " - fileName: " + fileName);
        long startTime = System.currentTimeMillis();
        Object result = new Object();
        InputStream inputStream = null;
        try {
            URL bundleResourcesURL = bundle.getResource(fileName);
            inputStream = bundleResourcesURL.openStream();
            ObjectMapper mapper = JsonDefaultsUtil.createCustomizedObjectMapper();
            result = mapper.readValue(inputStream, Object.class);
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Error parsing JSON from resources file: " + fileName + " in bundle " + bundle.getSymbolicName(), ex);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            LOG.info(fileName + " loading and parse time: " + (System.currentTimeMillis() - startTime) + "ms");
        }
        return result;
    }

    public static List<Object> loadJsonFileAsList(Bundle bundle, String fileName) {
        LOG.finest("loadJsonFileAsList bundle:" + bundle + " - fileName: " + fileName);
        ArrayList<Object> result = null;
        try {
            Object parsingResult = JsonDefaultsUtil.loadJsonFileAs(bundle.getResource(fileName), List.class);
            result = parsingResult == null ? new ArrayList<Object>() : (ArrayList<Object>)parsingResult;
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Error parsing JSON from resources file: " + fileName + " in bundle " + bundle.getSymbolicName(), ex);
        }
        return result;
    }

    public static Map<String, Object> loadJsonFileAsMap(Bundle bundle, String fileName) {
        LOG.finest("loadJsonFileAsMap bundle:" + bundle + " - fileName: " + fileName);
        HashMap<String, Object> result = null;
        try {
            Object parsingResult = JsonDefaultsUtil.loadJsonFileAs(bundle.getResource(fileName), Map.class);
            result = parsingResult == null ? new HashMap<String, Object>() : (HashMap<String, Object>)parsingResult;
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Error parsing JSON from resources file: " + fileName + " in bundle " + bundle.getSymbolicName(), ex);
        }
        return result;
    }

    public static Map<String, Object> loadJsonFileAsMap(String fileName) {
        LOG.finest("loadJsonFileAsMap fileName: " + fileName);
        HashMap result = null;
        try {
            Object parsingResult = JsonDefaultsUtil.loadJsonFileAs(JsonDefaultsUtil.class.getClassLoader().getResource(fileName), Map.class);
            result = parsingResult == null ? new HashMap() : (HashMap)parsingResult;
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Error parsing JSON from resources file: " + fileName, ex);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object loadJsonFileAs(URL bundleResourcesURL, Class mappingClass) {
        LOG.finest("loadJsonFileAs ResourcesURL=" + bundleResourcesURL + ", mappingClass=" + mappingClass);
        long startTime = System.currentTimeMillis();
        Object result = null;
        InputStream inputStream = null;
        try {
            inputStream = bundleResourcesURL.openStream();
            ObjectMapper mapper = JsonDefaultsUtil.createCustomizedObjectMapper();
            result = mapper.readValue(inputStream, mappingClass);
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Error parsing JSON from resources file: " + bundleResourcesURL.getFile(), ex);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            LOG.info(bundleResourcesURL.getFile() + " loading and parse time: " + (System.currentTimeMillis() - startTime) + "ms");
        }
        return result;
    }

    public static Map<String, Object> parseJsonStringAsMap(String jsonString) {
        LOG.finest("parseJsonStringAsMap");
        Map<String, Object> result = new HashMap<String, Object>();
        if (jsonString == null) {
            jsonString = "";
        }
        try {
            ObjectMapper mapper = JsonDefaultsUtil.createCustomizedObjectMapper();
            result = (Map)mapper.readValue(jsonString, Map.class);
        }
        catch (IOException e) {
            LOG.severe("Error parsing json: " + jsonString);
        }
        return result;
    }

    public static Object parseJsonStringAsListOrMap(String jsonString) {
        LOG.finest("parseJsonStringAsListOrMap");
        if (!StringUtil.isNullOrEmpty(jsonString)) {
            try {
                ObjectMapper mapper = JsonDefaultsUtil.createCustomizedObjectMapper();
                return mapper.readValue(jsonString, Object.class);
            }
            catch (IOException e) {
                LOG.severe("Error parsing json: " + jsonString);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadJsonFileAsString(Bundle bundle, String fileName) {
        LOG.finest("loadJsonFileAsString bundle:" + bundle + " - fileName: " + fileName);
        long startTime = System.currentTimeMillis();
        InputStream inputStream = null;
        String result = null;
        try {
            URL bundleResourcesURL = bundle.getResource(fileName);
            inputStream = bundleResourcesURL.openStream();
            Scanner s = new Scanner(inputStream).useDelimiter("\\A");
            result = s.hasNext() ? s.next() : "";
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Error loading JSONString from resources file: " + fileName, ex);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            LOG.info(fileName + " loading and parse time: " + (System.currentTimeMillis() - startTime) + "ms");
        }
        return result;
    }
}

