/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.util;

import de.virtimo.bpc.util.StringUtil;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalUnit;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DateUtil {
    private DateUtil() {
    }

    public static Date getDateAddingRelativeValue(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Could not get the date from 'null'.");
        }
        Pattern p = Pattern.compile("(\\d+)\\s+(.*?)s?");
        Matcher m = p.matcher(value);
        if (m.matches()) {
            int amount = Integer.parseInt(m.group(1));
            String unit = m.group(2).toLowerCase();
            HashMap<String, Integer> fields = new HashMap<String, Integer>();
            fields.put("second", 13);
            fields.put("minute", 12);
            fields.put("hour", 10);
            fields.put("day", 5);
            fields.put("week", 3);
            fields.put("month", 2);
            fields.put("year", 1);
            if (fields.containsKey(unit)) {
                Integer calendarField = (Integer)fields.get(unit);
                Calendar cal = Calendar.getInstance();
                cal.add(calendarField, amount);
                return cal.getTime();
            }
            throw new IllegalArgumentException("Invalid unit '" + unit + "' in given relative date value '" + value + "'.");
        }
        throw new IllegalArgumentException("Invalid relative date format '" + value + "'. Must be 'n seconds|minutes|hours|days|weeks|months|years");
    }

    public static Date getDateForRelativeValue(String value) throws IllegalArgumentException {
        if (value == null) {
            throw new IllegalArgumentException("Could not get the date from 'null'.");
        }
        Pattern p = Pattern.compile("(\\d+)\\s+(.*?)s? ago");
        Matcher m = p.matcher(value);
        if (m.matches()) {
            int amount = Integer.parseInt(m.group(1));
            String unit = m.group(2).toLowerCase();
            HashMap<String, Integer> fields = new HashMap<String, Integer>();
            fields.put("second", 13);
            fields.put("minute", 12);
            fields.put("hour", 10);
            fields.put("day", 5);
            fields.put("week", 3);
            fields.put("month", 2);
            fields.put("year", 1);
            if (fields.containsKey(unit)) {
                Integer calendarField = (Integer)fields.get(unit);
                Calendar cal = Calendar.getInstance();
                cal.add(calendarField, -amount);
                return cal.getTime();
            }
            throw new IllegalArgumentException("Invalid unit '" + unit + "' in given relative date value '" + value + "'.");
        }
        throw new IllegalArgumentException("Invalid relative date format '" + value + "'. Must be 'n seconds|minutes|hours|days|weeks|months|years ago");
    }

    public static LocalDateTime addRelativeValue(String value, LocalDateTime localDateTime) {
        if (value == null) {
            return localDateTime;
        }
        return (LocalDateTime)DateUtil.addRelativeValue(value, (Temporal)localDateTime);
    }

    public static Temporal addRelativeValue(String value, Temporal localDateTime) {
        if (value == null) {
            return localDateTime;
        }
        Pattern p = Pattern.compile("(\\d+)\\s+(.*?)s?");
        Matcher m = p.matcher(value);
        if (m.matches()) {
            long amount = Long.parseLong(m.group(1));
            String unit = m.group(2).toLowerCase();
            HashMap<String, ChronoUnit> fields = new HashMap<String, ChronoUnit>();
            fields.put("second", ChronoUnit.SECONDS);
            fields.put("minute", ChronoUnit.MINUTES);
            fields.put("hour", ChronoUnit.HOURS);
            fields.put("day", ChronoUnit.DAYS);
            fields.put("week", ChronoUnit.WEEKS);
            fields.put("month", ChronoUnit.MONTHS);
            fields.put("year", ChronoUnit.YEARS);
            if (fields.containsKey(unit)) {
                return localDateTime.plus(amount, (TemporalUnit)fields.get(unit));
            }
            throw new IllegalArgumentException("Invalid unit '" + unit + "' in given relative date value '" + value + "'.");
        }
        throw new IllegalArgumentException("Invalid relative date format '" + value + "'. Must be 'n seconds|minutes|hours|days|weeks|months|years");
    }

    public static Timestamp addDaysToTimestamp(int days, Timestamp timestamp) {
        return DateUtil.addDurationToTimestamp(5, days, timestamp);
    }

    public static Timestamp addDurationToTimestamp(int durationField, int duration, Timestamp timestamp) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(timestamp);
        cal.add(durationField, duration);
        Timestamp result = new Timestamp(cal.getTimeInMillis());
        if (durationField != 14) {
            result.setNanos(timestamp.getNanos());
        }
        return result;
    }

    public static Timestamp cloneTimestampWithNanos(Timestamp timestamp) {
        Timestamp result = new Timestamp(timestamp.getTime());
        result.setNanos(timestamp.getNanos());
        return result;
    }

    public static Timestamp cloneTimestampAndMaximizeNanos(Timestamp timestamp) {
        String nanosString = Integer.toString(timestamp.getNanos());
        Object s = nanosString.length() == 9 ? nanosString.substring(0, 3) + "999999" : (nanosString.length() == 8 ? nanosString.substring(0, 2) + "999999" : (nanosString.length() == 7 ? nanosString.substring(0, 1) + "999999" : nanosString));
        Timestamp result = new Timestamp(timestamp.getTime());
        result.setNanos(Integer.valueOf((String)s));
        return result;
    }

    public static Calendar getCalendar(String timeZoneId) {
        if (!StringUtil.isNullOrEmpty(timeZoneId)) {
            TimeZone timeZone = TimeZone.getTimeZone(timeZoneId);
            return Calendar.getInstance(timeZone);
        }
        return null;
    }
}

