/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.misc.search;

import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Weight;

public final class HumanReadableQuery
extends Query {
    private final Query in;
    private final String description;

    public HumanReadableQuery(Query in, String description) {
        this.in = in;
        this.description = description;
    }

    public Query getWrappedQuery() {
        return this.in;
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public Query rewrite(IndexSearcher indexSearcher) {
        return this.in;
    }

    @Override
    public String toString(String field) {
        return this.getDescription() + ":" + this.in.toString(field);
    }

    @Override
    public void visit(QueryVisitor visitor) {
        this.in.visit(visitor);
    }

    @Override
    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.in.equals(((HumanReadableQuery)other).in);
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, ScoreMode scoreMode, float boost) {
        throw new UnsupportedOperationException("HumanReadableQuery does not support #createWeight()");
    }

    @Override
    public int hashCode() {
        return 31 * this.classHash() + this.in.hashCode();
    }
}

