/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.join;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.KnnCollector;
import org.apache.lucene.search.join.BitSetProducer;
import org.apache.lucene.search.join.DiversifyingNearestChildrenKnnCollector;
import org.apache.lucene.search.knn.KnnCollectorManager;
import org.apache.lucene.search.knn.MultiLeafKnnCollector;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.hnsw.BlockingFloatHeap;

public class DiversifyingNearestChildrenKnnCollectorManager
implements KnnCollectorManager {
    private final int k;
    private final BitSetProducer parentsFilter;
    private final BlockingFloatHeap globalScoreQueue;

    public DiversifyingNearestChildrenKnnCollectorManager(int k, BitSetProducer parentsFilter, IndexSearcher indexSearcher) {
        this.k = k;
        this.parentsFilter = parentsFilter;
        this.globalScoreQueue = indexSearcher.getIndexReader().leaves().size() > 1 ? new BlockingFloatHeap(k) : null;
    }

    @Override
    public KnnCollector newCollector(int visitedLimit, LeafReaderContext context) throws IOException {
        BitSet parentBitSet = this.parentsFilter.getBitSet(context);
        if (parentBitSet == null) {
            return null;
        }
        if (this.globalScoreQueue == null) {
            return new DiversifyingNearestChildrenKnnCollector(this.k, visitedLimit, parentBitSet);
        }
        return new MultiLeafKnnCollector(this.k, this.globalScoreQueue, new DiversifyingNearestChildrenKnnCollector(this.k, visitedLimit, parentBitSet));
    }
}

