/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action;

import java.io.IOException;
import java.util.Objects;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.transport.TransportResponse;
import org.opensearch.transport.TransportException;
import org.opensearch.transport.TransportResponseHandler;

public class ActionListenerResponseHandler<Response extends TransportResponse>
implements TransportResponseHandler<Response> {
    private final ActionListener<? super Response> listener;
    private final Writeable.Reader<Response> reader;
    private final String executor;

    public ActionListenerResponseHandler(ActionListener<? super Response> listener, Writeable.Reader<Response> reader, String executor) {
        this.listener = Objects.requireNonNull(listener);
        this.reader = Objects.requireNonNull(reader);
        this.executor = Objects.requireNonNull(executor);
    }

    public ActionListenerResponseHandler(ActionListener<? super Response> listener, Writeable.Reader<Response> reader) {
        this(listener, reader, "same");
    }

    @Override
    public void handleResponse(Response response) {
        this.listener.onResponse(response);
    }

    @Override
    public void handleException(TransportException e) {
        this.listener.onFailure(e);
    }

    @Override
    public String executor() {
        return this.executor;
    }

    @Override
    public Response read(StreamInput in) throws IOException {
        return (Response)((TransportResponse)this.reader.read(in));
    }

    public String toString() {
        return super.toString() + "/" + String.valueOf(this.listener);
    }
}

