/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action;

import java.io.IOException;
import org.opensearch.OpenSearchException;
import org.opensearch.common.Nullable;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.core.rest.RestStatus;

public class UnavailableShardsException
extends OpenSearchException {
    public UnavailableShardsException(@Nullable ShardId shardId, String message, Object ... args) {
        super(UnavailableShardsException.buildMessage(shardId, message), args);
    }

    public UnavailableShardsException(String index, int shardId, String message, Object ... args) {
        super(UnavailableShardsException.buildMessage(index, shardId, message), args);
    }

    private static String buildMessage(ShardId shardId, String message) {
        if (shardId == null) {
            return message;
        }
        return UnavailableShardsException.buildMessage(shardId.getIndexName(), shardId.id(), message);
    }

    private static String buildMessage(String index, int shardId, String message) {
        return "[" + index + "][" + shardId + "] " + message;
    }

    public UnavailableShardsException(StreamInput in) throws IOException {
        super(in);
    }

    @Override
    public RestStatus status() {
        return RestStatus.SERVICE_UNAVAILABLE;
    }
}

