/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.cluster.decommission.awareness.get;

import java.io.IOException;
import java.util.Locale;
import java.util.Objects;
import org.opensearch.OpenSearchParseException;
import org.opensearch.cluster.decommission.DecommissionStatus;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;

@PublicApi(since="2.4.0")
public class GetDecommissionStateResponse
extends ActionResponse
implements ToXContentObject {
    private String attributeValue;
    private DecommissionStatus status;

    GetDecommissionStateResponse() {
        this(null, null);
    }

    GetDecommissionStateResponse(String attributeValue, DecommissionStatus status) {
        this.attributeValue = attributeValue;
        this.status = status;
    }

    GetDecommissionStateResponse(StreamInput in) throws IOException {
        if (in.readBoolean()) {
            this.attributeValue = in.readString();
            this.status = DecommissionStatus.fromString(in.readString());
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (this.attributeValue == null || this.status == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeString(this.attributeValue);
            out.writeString(this.status.status());
        }
    }

    public String getAttributeValue() {
        return this.attributeValue;
    }

    public DecommissionStatus getDecommissionStatus() {
        return this.status;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.attributeValue != null && this.status != null) {
            builder.field(this.attributeValue, (Object)this.status);
        }
        builder.endObject();
        return builder;
    }

    public static GetDecommissionStateResponse fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.nextToken(), parser);
        String attributeValue = null;
        DecommissionStatus status = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                attributeValue = parser.currentName();
                if (parser.nextToken() != XContentParser.Token.VALUE_STRING) {
                    throw new OpenSearchParseException("failed to parse status of decommissioning, expected string but found unknown type", new Object[0]);
                }
                status = DecommissionStatus.fromString(parser.text().toLowerCase(Locale.ROOT));
                continue;
            }
            throw new OpenSearchParseException("failed to parse decommission state, expected [{}] but found [{}]", new Object[]{XContentParser.Token.FIELD_NAME, token});
        }
        return new GetDecommissionStateResponse(attributeValue, status);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetDecommissionStateResponse that = (GetDecommissionStateResponse)o;
        if (!Objects.equals(this.attributeValue, that.attributeValue)) {
            return false;
        }
        return Objects.equals((Object)this.status, (Object)that.status);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.attributeValue, this.status});
    }
}

