/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.bulk;

import java.io.IOException;
import java.util.HashMap;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import org.opensearch.action.delete.DeleteRequest;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.update.UpdateRequest;
import org.opensearch.common.Nullable;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.bytes.BytesArray;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.MediaTypeRegistry;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContent;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.VersionType;
import org.opensearch.search.fetch.subphase.FetchSourceContext;

public final class BulkRequestParser {
    private static final ParseField INDEX = new ParseField("_index", new String[0]);
    private static final ParseField ID = new ParseField("_id", new String[0]);
    private static final ParseField ROUTING = new ParseField("routing", new String[0]);
    private static final ParseField OP_TYPE = new ParseField("op_type", new String[0]);
    private static final ParseField VERSION = new ParseField("version", new String[0]);
    private static final ParseField VERSION_TYPE = new ParseField("version_type", new String[0]);
    private static final ParseField RETRY_ON_CONFLICT = new ParseField("retry_on_conflict", new String[0]);
    private static final ParseField PIPELINE = new ParseField("pipeline", new String[0]);
    private static final ParseField SOURCE = new ParseField("_source", new String[0]);
    private static final ParseField IF_SEQ_NO = new ParseField("if_seq_no", new String[0]);
    private static final ParseField IF_PRIMARY_TERM = new ParseField("if_primary_term", new String[0]);
    private static final ParseField REQUIRE_ALIAS = new ParseField("require_alias", new String[0]);
    private static final Set<String> VALID_ACTIONS = Set.of("create", "delete", "index", "update");

    private static int findNextMarker(byte marker, int from, BytesReference data) {
        int res = data.indexOf(marker, from);
        if (res != -1) {
            assert (res >= 0);
            return res;
        }
        if (from != data.length()) {
            throw new IllegalArgumentException("The bulk request must be terminated by a newline [\\n]");
        }
        return res;
    }

    private static BytesReference sliceTrimmingCarriageReturn(BytesReference bytesReference, int from, int nextMarker, MediaType mediaType) {
        int length = MediaTypeRegistry.JSON == mediaType && bytesReference.get(nextMarker - 1) == 13 ? nextMarker - from - 1 : nextMarker - from;
        return bytesReference.slice(from, length);
    }

    public void parse(BytesReference data, @Nullable String defaultIndex, @Nullable String defaultRouting, @Nullable FetchSourceContext defaultFetchSourceContext, @Nullable String defaultPipeline, @Nullable Boolean defaultRequireAlias, boolean allowExplicitIndex, MediaType mediaType, Consumer<IndexRequest> indexRequestConsumer, Consumer<UpdateRequest> updateRequestConsumer, Consumer<DeleteRequest> deleteRequestConsumer) throws IOException {
        int nextMarker;
        XContent xContent = mediaType.xContent();
        int line = 0;
        int from = 0;
        byte marker = xContent.streamSeparator();
        HashMap stringDeduplicator = new HashMap();
        while ((nextMarker = BulkRequestParser.findNextMarker(marker, from, data)) != -1) {
            ++line;
            XContentParser parser = BulkRequestParser.createParser(data, xContent, from, nextMarker);
            try {
                from = nextMarker + 1;
                XContentParser.Token token = parser.nextToken();
                if (token == null) continue;
                if (token != XContentParser.Token.START_OBJECT) {
                    throw new IllegalArgumentException("Malformed action/metadata line [" + line + "], expected " + String.valueOf((Object)XContentParser.Token.START_OBJECT) + " but found [" + String.valueOf((Object)token) + "]");
                }
                token = parser.nextToken();
                if (token != XContentParser.Token.FIELD_NAME) {
                    throw new IllegalArgumentException("Malformed action/metadata line [" + line + "], expected " + String.valueOf((Object)XContentParser.Token.FIELD_NAME) + " but found [" + String.valueOf((Object)token) + "]");
                }
                String action = parser.currentName();
                if (action == null || !VALID_ACTIONS.contains(action)) {
                    throw new IllegalArgumentException("Malformed action/metadata line [" + line + "], expected one of [create, delete, index, update] but found [" + action + "]");
                }
                String index = defaultIndex;
                String id = null;
                String routing = defaultRouting;
                FetchSourceContext fetchSourceContext = defaultFetchSourceContext;
                String opType = null;
                long version = -3L;
                VersionType versionType = VersionType.INTERNAL;
                long ifSeqNo = -2L;
                long ifPrimaryTerm = 0L;
                int retryOnConflict = 0;
                String pipeline = defaultPipeline;
                boolean requireAlias = defaultRequireAlias != null && defaultRequireAlias != false;
                token = parser.nextToken();
                if (token == XContentParser.Token.START_OBJECT) {
                    String currentFieldName = null;
                    while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                        if (token == XContentParser.Token.FIELD_NAME) {
                            currentFieldName = parser.currentName();
                            continue;
                        }
                        if (token.isValue()) {
                            if (INDEX.match(currentFieldName, parser.getDeprecationHandler())) {
                                if (!allowExplicitIndex) {
                                    throw new IllegalArgumentException("explicit index in bulk is not allowed");
                                }
                                index = (String)stringDeduplicator.computeIfAbsent(parser.text(), Function.identity());
                                continue;
                            }
                            if (ID.match(currentFieldName, parser.getDeprecationHandler())) {
                                id = parser.text();
                                continue;
                            }
                            if (ROUTING.match(currentFieldName, parser.getDeprecationHandler())) {
                                routing = (String)stringDeduplicator.computeIfAbsent(parser.text(), Function.identity());
                                continue;
                            }
                            if (OP_TYPE.match(currentFieldName, parser.getDeprecationHandler())) {
                                opType = parser.text();
                                continue;
                            }
                            if (VERSION.match(currentFieldName, parser.getDeprecationHandler())) {
                                version = parser.longValue();
                                continue;
                            }
                            if (VERSION_TYPE.match(currentFieldName, parser.getDeprecationHandler())) {
                                versionType = VersionType.fromString(parser.text());
                                continue;
                            }
                            if (IF_SEQ_NO.match(currentFieldName, parser.getDeprecationHandler())) {
                                ifSeqNo = parser.longValue();
                                continue;
                            }
                            if (IF_PRIMARY_TERM.match(currentFieldName, parser.getDeprecationHandler())) {
                                ifPrimaryTerm = parser.longValue();
                                continue;
                            }
                            if (RETRY_ON_CONFLICT.match(currentFieldName, parser.getDeprecationHandler())) {
                                retryOnConflict = parser.intValue();
                                continue;
                            }
                            if (PIPELINE.match(currentFieldName, parser.getDeprecationHandler())) {
                                pipeline = (String)stringDeduplicator.computeIfAbsent(parser.text(), Function.identity());
                                continue;
                            }
                            if (SOURCE.match(currentFieldName, parser.getDeprecationHandler())) {
                                fetchSourceContext = FetchSourceContext.fromXContent(parser);
                                continue;
                            }
                            if (REQUIRE_ALIAS.match(currentFieldName, parser.getDeprecationHandler())) {
                                requireAlias = parser.booleanValue();
                                continue;
                            }
                            throw new IllegalArgumentException("Action/metadata line [" + line + "] contains an unknown parameter [" + currentFieldName + "]");
                        }
                        if (token == XContentParser.Token.START_ARRAY) {
                            throw new IllegalArgumentException("Malformed action/metadata line [" + line + "], expected a simple value for field [" + currentFieldName + "] but found [" + String.valueOf((Object)token) + "]");
                        }
                        if (token == XContentParser.Token.START_OBJECT && SOURCE.match(currentFieldName, parser.getDeprecationHandler())) {
                            fetchSourceContext = FetchSourceContext.fromXContent(parser);
                            continue;
                        }
                        if (token == XContentParser.Token.VALUE_NULL) continue;
                        throw new IllegalArgumentException("Malformed action/metadata line [" + line + "], expected a simple value for field [" + currentFieldName + "] but found [" + String.valueOf((Object)token) + "]");
                    }
                } else if (token != XContentParser.Token.END_OBJECT) {
                    throw new IllegalArgumentException("Malformed action/metadata line [" + line + "], expected " + String.valueOf((Object)XContentParser.Token.START_OBJECT) + " or " + String.valueOf((Object)XContentParser.Token.END_OBJECT) + " but found [" + String.valueOf((Object)token) + "]");
                }
                if ("delete".equals(action)) {
                    deleteRequestConsumer.accept(new DeleteRequest(index).id(id).routing(routing).version(version).versionType(versionType).setIfSeqNo(ifSeqNo).setIfPrimaryTerm(ifPrimaryTerm));
                    continue;
                }
                nextMarker = BulkRequestParser.findNextMarker(marker, from, data);
                if (nextMarker == -1) break;
                ++line;
                if ("index".equals(action)) {
                    if (opType == null) {
                        indexRequestConsumer.accept(new IndexRequest(index).id(id).routing(routing).version(version).versionType(versionType).setPipeline(pipeline).setIfSeqNo(ifSeqNo).setIfPrimaryTerm(ifPrimaryTerm).source(BulkRequestParser.sliceTrimmingCarriageReturn(data, from, nextMarker, mediaType), mediaType).setRequireAlias(requireAlias));
                    } else {
                        indexRequestConsumer.accept(new IndexRequest(index).id(id).routing(routing).version(version).versionType(versionType).create("create".equals(opType)).setPipeline(pipeline).setIfSeqNo(ifSeqNo).setIfPrimaryTerm(ifPrimaryTerm).source(BulkRequestParser.sliceTrimmingCarriageReturn(data, from, nextMarker, mediaType), mediaType).setRequireAlias(requireAlias));
                    }
                } else if ("create".equals(action)) {
                    indexRequestConsumer.accept(new IndexRequest(index).id(id).routing(routing).version(version).versionType(versionType).create(true).setPipeline(pipeline).setIfSeqNo(ifSeqNo).setIfPrimaryTerm(ifPrimaryTerm).source(BulkRequestParser.sliceTrimmingCarriageReturn(data, from, nextMarker, mediaType), mediaType).setRequireAlias(requireAlias));
                } else if ("update".equals(action)) {
                    IndexRequest upsertRequest;
                    if (version != -3L || versionType != VersionType.INTERNAL) {
                        throw new IllegalArgumentException("Update requests do not support versioning. Please use `if_seq_no` and `if_primary_term` instead");
                    }
                    UpdateRequest updateRequest = ((UpdateRequest)new UpdateRequest().index(index)).id(id).routing(routing).retryOnConflict(retryOnConflict).setIfSeqNo(ifSeqNo).setIfPrimaryTerm(ifPrimaryTerm).setRequireAlias(requireAlias).routing(routing);
                    try (XContentParser sliceParser = BulkRequestParser.createParser(BulkRequestParser.sliceTrimmingCarriageReturn(data, from, nextMarker, mediaType), xContent);){
                        updateRequest.fromXContent(sliceParser);
                    }
                    if (fetchSourceContext != null) {
                        updateRequest.fetchSource(fetchSourceContext);
                    }
                    if ((upsertRequest = updateRequest.upsertRequest()) != null) {
                        upsertRequest.setPipeline(pipeline);
                    }
                    updateRequestConsumer.accept(updateRequest);
                }
                from = nextMarker + 1;
            }
            finally {
                if (parser == null) continue;
                parser.close();
            }
        }
    }

    private static XContentParser createParser(BytesReference data, XContent xContent) throws IOException {
        if (data instanceof BytesArray) {
            return BulkRequestParser.parseBytesArray(xContent, (BytesArray)data, 0, data.length());
        }
        return xContent.createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, data.streamInput());
    }

    private static XContentParser createParser(BytesReference data, XContent xContent, int from, int nextMarker) throws IOException {
        if (data instanceof BytesArray) {
            return BulkRequestParser.parseBytesArray(xContent, (BytesArray)data, from, nextMarker);
        }
        int length = nextMarker - from;
        BytesReference slice = data.slice(from, length);
        if (slice instanceof BytesArray) {
            return BulkRequestParser.parseBytesArray(xContent, (BytesArray)slice, 0, length);
        }
        return xContent.createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, slice.streamInput());
    }

    private static XContentParser parseBytesArray(XContent xContent, BytesArray array, int from, int nextMarker) throws IOException {
        int offset = array.offset();
        return xContent.createParser(NamedXContentRegistry.EMPTY, LoggingDeprecationHandler.INSTANCE, array.array(), offset + from, nextMarker - from);
    }
}

