/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.metadata;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.opensearch.OpenSearchParseException;
import org.opensearch.cluster.AbstractDiffable;
import org.opensearch.cluster.Diff;
import org.opensearch.cluster.metadata.AliasMetadata;
import org.opensearch.common.Nullable;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.common.collect.MapBuilder;
import org.opensearch.common.compress.CompressedXContent;
import org.opensearch.common.logging.DeprecationLogger;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.set.Sets;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.json.JsonXContent;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.translog.BufferedChecksumStreamOutput;

@PublicApi(since="1.0.0")
public class IndexTemplateMetadata
extends AbstractDiffable<IndexTemplateMetadata> {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(IndexTemplateMetadata.class);
    private final String name;
    private final int order;
    @Nullable
    private final Integer version;
    private final List<String> patterns;
    private final Settings settings;
    private final Map<String, CompressedXContent> mappings;
    private final Map<String, AliasMetadata> aliases;

    public IndexTemplateMetadata(String name, int order, Integer version, List<String> patterns, Settings settings, Map<String, CompressedXContent> mappings, Map<String, AliasMetadata> aliases) {
        if (patterns == null || patterns.isEmpty()) {
            throw new IllegalArgumentException("Index patterns must not be null or empty; got " + String.valueOf(patterns));
        }
        this.name = name;
        this.order = order;
        this.version = version;
        this.patterns = patterns;
        this.settings = settings;
        this.mappings = Collections.unmodifiableMap(mappings);
        if (this.mappings.size() > 1) {
            deprecationLogger.deprecate("index-templates", "Index template {} contains multiple typed mappings; templates in 8x will only support a single mapping", name);
        }
        this.aliases = Collections.unmodifiableMap(aliases);
    }

    public String name() {
        return this.name;
    }

    public int order() {
        return this.order;
    }

    public int getOrder() {
        return this.order();
    }

    @Nullable
    public Integer getVersion() {
        return this.version();
    }

    @Nullable
    public Integer version() {
        return this.version;
    }

    public String getName() {
        return this.name;
    }

    public List<String> patterns() {
        return this.patterns;
    }

    public Settings settings() {
        return this.settings;
    }

    public CompressedXContent mappings() {
        if (this.mappings.isEmpty()) {
            return null;
        }
        return this.mappings.values().iterator().next();
    }

    public CompressedXContent getMappings() {
        return this.mappings();
    }

    public Map<String, AliasMetadata> aliases() {
        return this.aliases;
    }

    public Map<String, AliasMetadata> getAliases() {
        return this.aliases;
    }

    public static Builder builder(String name) {
        return new Builder(name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexTemplateMetadata that = (IndexTemplateMetadata)o;
        if (this.order != that.order) {
            return false;
        }
        if (!this.mappings.equals(that.mappings)) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (!this.settings.equals(that.settings)) {
            return false;
        }
        if (!this.patterns.equals(that.patterns)) {
            return false;
        }
        return Objects.equals(this.aliases, that.aliases) && Objects.equals(this.version, that.version);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.order;
        result = 31 * result + Objects.hashCode(this.version);
        result = 31 * result + this.patterns.hashCode();
        result = 31 * result + this.settings.hashCode();
        result = 31 * result + this.mappings.hashCode();
        result = 31 * result + this.aliases.hashCode();
        return result;
    }

    public static IndexTemplateMetadata readFrom(StreamInput in) throws IOException {
        Builder builder = new Builder(in.readString());
        builder.order(in.readInt());
        builder.patterns(in.readStringList());
        builder.settings(Settings.readSettingsFromStream(in));
        int mappingsSize = in.readVInt();
        for (int i = 0; i < mappingsSize; ++i) {
            builder.putMapping(in.readString(), CompressedXContent.readCompressedString(in));
        }
        int aliasesSize = in.readVInt();
        for (int i = 0; i < aliasesSize; ++i) {
            AliasMetadata aliasMd = new AliasMetadata(in);
            builder.putAlias(aliasMd);
        }
        builder.version(in.readOptionalVInt());
        return builder.build();
    }

    public static Diff<IndexTemplateMetadata> readDiffFrom(StreamInput in) throws IOException {
        return IndexTemplateMetadata.readDiffFrom(IndexTemplateMetadata::readFrom, in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeInt(this.order);
        out.writeStringCollection(this.patterns);
        Settings.writeSettingsToStream(this.settings, out);
        out.writeVInt(this.mappings.size());
        for (Map.Entry<String, CompressedXContent> entry : this.mappings.entrySet()) {
            out.writeString(entry.getKey());
            entry.getValue().writeTo(out);
        }
        out.writeVInt(this.aliases.size());
        for (AliasMetadata aliasMetadata : this.aliases.values()) {
            aliasMetadata.writeTo(out);
        }
        out.writeOptionalVInt(this.version);
    }

    public void writeVerifiableTo(BufferedChecksumStreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeInt(this.order);
        out.writeStringCollection(this.patterns);
        Settings.writeSettingsToStream(this.settings, out);
        out.writeMap(this.mappings, StreamOutput::writeString, (stream, val) -> val.writeTo(stream));
        out.writeMapValues(this.aliases, (stream, val) -> val.writeTo(stream));
        out.writeOptionalVInt(this.version);
    }

    public String toString() {
        try {
            XContentBuilder builder = JsonXContent.contentBuilder();
            builder.startObject();
            Builder.toXContentWithTypes(this, builder, ToXContent.EMPTY_PARAMS);
            builder.endObject();
            return builder.toString();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @PublicApi(since="1.0.0")
    public static class Builder {
        private static final Set<String> VALID_FIELDS = Sets.newHashSet("order", "mappings", "settings", "index_patterns", "aliases", "version");
        private String name;
        private int order;
        private Integer version;
        private List<String> indexPatterns;
        private Settings settings = Settings.Builder.EMPTY_SETTINGS;
        private final Map<String, CompressedXContent> mappings;
        private final Map<String, AliasMetadata> aliases;

        public Builder(String name) {
            this.name = name;
            this.mappings = new HashMap<String, CompressedXContent>();
            this.aliases = new HashMap<String, AliasMetadata>();
        }

        public Builder(IndexTemplateMetadata indexTemplateMetadata) {
            this.name = indexTemplateMetadata.name();
            this.order(indexTemplateMetadata.order());
            this.version(indexTemplateMetadata.version());
            this.patterns(indexTemplateMetadata.patterns());
            this.settings(indexTemplateMetadata.settings());
            this.mappings = new HashMap<String, CompressedXContent>(indexTemplateMetadata.mappings);
            this.aliases = new HashMap<String, AliasMetadata>(indexTemplateMetadata.aliases());
        }

        public Builder order(int order) {
            this.order = order;
            return this;
        }

        public Builder version(Integer version) {
            this.version = version;
            return this;
        }

        public Builder patterns(List<String> indexPatterns) {
            this.indexPatterns = indexPatterns;
            return this;
        }

        public Builder settings(Settings.Builder settings) {
            this.settings = settings.build();
            return this;
        }

        public Builder settings(Settings settings) {
            this.settings = settings;
            return this;
        }

        public Builder putMapping(String mappingType, CompressedXContent mappingSource) {
            this.mappings.put(mappingType, mappingSource);
            return this;
        }

        public Builder putMapping(String mappingType, String mappingSource) throws IOException {
            this.mappings.put(mappingType, new CompressedXContent(mappingSource));
            return this;
        }

        public Builder putAlias(AliasMetadata aliasMetadata) {
            this.aliases.put(aliasMetadata.alias(), aliasMetadata);
            return this;
        }

        public Builder putAlias(AliasMetadata.Builder aliasMetadata) {
            this.aliases.put(aliasMetadata.alias(), aliasMetadata.build());
            return this;
        }

        public IndexTemplateMetadata build() {
            return new IndexTemplateMetadata(this.name, this.order, this.version, this.indexPatterns, this.settings, this.mappings, this.aliases);
        }

        public static void toXContentWithTypes(IndexTemplateMetadata indexTemplateMetadata, XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject(indexTemplateMetadata.name());
            Builder.toInnerXContent(indexTemplateMetadata, builder, params, true);
            builder.endObject();
        }

        public static void toXContent(IndexTemplateMetadata indexTemplateMetadata, XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject(indexTemplateMetadata.name());
            Builder.toInnerXContent(indexTemplateMetadata, builder, params, false);
            builder.endObject();
        }

        static void toInnerXContentWithTypes(IndexTemplateMetadata indexTemplateMetadata, XContentBuilder builder, ToXContent.Params params) throws IOException {
            Builder.toInnerXContent(indexTemplateMetadata, builder, params, true);
        }

        private static void toInnerXContent(IndexTemplateMetadata indexTemplateMetadata, XContentBuilder builder, ToXContent.Params params, boolean includeTypeName) throws IOException {
            builder.field("order", indexTemplateMetadata.order());
            if (indexTemplateMetadata.version() != null) {
                builder.field("version", indexTemplateMetadata.version());
            }
            builder.field("index_patterns", indexTemplateMetadata.patterns());
            builder.startObject("settings");
            indexTemplateMetadata.settings().toXContent(builder, params);
            builder.endObject();
            includeTypeName &= !params.paramAsBoolean("reduce_mappings", false);
            CompressedXContent m = indexTemplateMetadata.mappings();
            if (m != null) {
                Map<String, Object> documentMapping = XContentHelper.convertToMap(m.uncompressed(), true).v2();
                documentMapping = !includeTypeName ? Builder.reduceMapping(documentMapping) : Builder.reduceEmptyMapping(documentMapping);
                builder.field("mappings");
                builder.map(documentMapping);
            } else {
                builder.startObject("mappings").endObject();
            }
            builder.startObject("aliases");
            for (AliasMetadata cursor : indexTemplateMetadata.aliases().values()) {
                AliasMetadata.Builder.toXContent(cursor, builder, params);
            }
            builder.endObject();
        }

        private static Map<String, Object> reduceEmptyMapping(Map<String, Object> mapping) {
            if (mapping.keySet().size() == 1 && mapping.containsKey("_doc") && ((Map)mapping.get("_doc")).size() == 0) {
                return (Map)mapping.values().iterator().next();
            }
            return mapping;
        }

        private static Map<String, Object> reduceMapping(Map<String, Object> mapping) {
            assert (mapping.keySet().size() == 1) : mapping.keySet();
            return (Map)mapping.values().iterator().next();
        }

        public static IndexTemplateMetadata fromXContent(XContentParser parser, String templateName) throws IOException {
            XContentParser.Token token;
            Builder builder = new Builder(templateName);
            String currentFieldName = Builder.skipTemplateName(parser);
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (token == XContentParser.Token.START_OBJECT) {
                    if ("settings".equals(currentFieldName)) {
                        Settings.Builder templateSettingsBuilder = Settings.builder();
                        templateSettingsBuilder.put(Settings.fromXContent(parser));
                        templateSettingsBuilder.normalizePrefix("index.");
                        builder.settings(templateSettingsBuilder.build());
                        continue;
                    }
                    if ("mappings".equals(currentFieldName)) {
                        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                            if (token == XContentParser.Token.FIELD_NAME) {
                                currentFieldName = parser.currentName();
                                continue;
                            }
                            if (token != XContentParser.Token.START_OBJECT) continue;
                            String mappingType = currentFieldName;
                            Map<String, Map<String, Object>> mappingSource = MapBuilder.newMapBuilder().put(mappingType, parser.mapOrdered()).map();
                            builder.putMapping(mappingType, XContentFactory.jsonBuilder().map(mappingSource).toString());
                        }
                        continue;
                    }
                    if ("aliases".equals(currentFieldName)) {
                        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                            builder.putAlias(AliasMetadata.Builder.fromXContent(parser));
                        }
                        continue;
                    }
                    throw new OpenSearchParseException("unknown key [{}] for index template", currentFieldName);
                }
                if (token == XContentParser.Token.START_ARRAY) {
                    if ("mappings".equals(currentFieldName)) {
                        while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                            Map<String, Object> mapping = parser.mapOrdered();
                            if (mapping.size() != 1) continue;
                            String mappingType = mapping.keySet().iterator().next();
                            String mappingSource = XContentFactory.jsonBuilder().map(mapping).toString();
                            if (mappingSource == null) continue;
                            builder.putMapping(mappingType, mappingSource);
                        }
                        continue;
                    }
                    if (!"index_patterns".equals(currentFieldName)) continue;
                    ArrayList<String> index_patterns = new ArrayList<String>();
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        index_patterns.add(parser.text());
                    }
                    builder.patterns(index_patterns);
                    continue;
                }
                if (!token.isValue()) continue;
                if ("order".equals(currentFieldName)) {
                    builder.order(parser.intValue());
                    continue;
                }
                if (!"version".equals(currentFieldName)) continue;
                builder.version(parser.intValue());
            }
            return builder.build();
        }

        private static String skipTemplateName(XContentParser parser) throws IOException {
            XContentParser.Token token = parser.nextToken();
            if (token == XContentParser.Token.START_OBJECT && (token = parser.nextToken()) == XContentParser.Token.FIELD_NAME) {
                String currentFieldName = parser.currentName();
                if (VALID_FIELDS.contains(currentFieldName)) {
                    return currentFieldName;
                }
                parser.nextToken();
            }
            return null;
        }
    }
}

