/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.metadata;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opensearch.cluster.AbstractDiffable;
import org.opensearch.cluster.metadata.AliasMetadata;
import org.opensearch.common.Nullable;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.common.compress.CompressedXContent;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ConstructingObjectParser;
import org.opensearch.core.xcontent.MediaTypeRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;

@PublicApi(since="1.0.0")
public class Template
extends AbstractDiffable<Template>
implements ToXContentObject {
    private static final ParseField SETTINGS = new ParseField("settings", new String[0]);
    private static final ParseField MAPPINGS = new ParseField("mappings", new String[0]);
    private static final ParseField ALIASES = new ParseField("aliases", new String[0]);
    public static final ConstructingObjectParser<Template, Void> PARSER = new ConstructingObjectParser("template", false, a -> new Template((Settings)a[0], (CompressedXContent)a[1], (Map)a[2]));
    @Nullable
    private final Settings settings;
    @Nullable
    private final CompressedXContent mappings;
    @Nullable
    private final Map<String, AliasMetadata> aliases;

    public Template(@Nullable Settings settings, @Nullable CompressedXContent mappings, @Nullable Map<String, AliasMetadata> aliases) {
        this.settings = settings;
        this.mappings = mappings;
        this.aliases = aliases;
    }

    public Template(StreamInput in) throws IOException {
        this.settings = in.readBoolean() ? Settings.readSettingsFromStream(in) : null;
        this.mappings = in.readBoolean() ? CompressedXContent.readCompressedString(in) : null;
        this.aliases = in.readBoolean() ? in.readMap(StreamInput::readString, AliasMetadata::new) : null;
    }

    public Settings settings() {
        return this.settings;
    }

    public CompressedXContent mappings() {
        return this.mappings;
    }

    public Map<String, AliasMetadata> aliases() {
        return this.aliases;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (this.settings == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            Settings.writeSettingsToStream(this.settings, out);
        }
        if (this.mappings == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.mappings.writeTo(out);
        }
        if (this.aliases == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeMap(this.aliases, StreamOutput::writeString, (stream, aliasMetadata) -> aliasMetadata.writeTo(stream));
        }
    }

    public int hashCode() {
        return Objects.hash(this.settings, this.mappings, this.aliases);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        Template other = (Template)obj;
        return Objects.equals(this.settings, other.settings) && Objects.equals(this.mappings, other.mappings) && Objects.equals(this.aliases, other.aliases);
    }

    public String toString() {
        return Strings.toString(MediaTypeRegistry.JSON, this);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        Map<String, Object> uncompressedMapping;
        builder.startObject();
        if (this.settings != null) {
            builder.startObject(SETTINGS.getPreferredName());
            this.settings.toXContent(builder, params);
            builder.endObject();
        }
        if (this.mappings != null && (uncompressedMapping = XContentHelper.convertToMap(this.mappings.uncompressed(), true, MediaTypeRegistry.JSON).v2()).size() > 0) {
            builder.field(MAPPINGS.getPreferredName());
            builder.map(Template.reduceMapping(uncompressedMapping));
        }
        if (this.aliases != null) {
            builder.startObject(ALIASES.getPreferredName());
            for (AliasMetadata alias : this.aliases.values()) {
                AliasMetadata.Builder.toXContent(alias, builder, params);
            }
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    private static Map<String, Object> reduceMapping(Map<String, Object> mapping) {
        if (mapping.size() == 1 && "_doc".equals(mapping.keySet().iterator().next())) {
            return (Map)mapping.values().iterator().next();
        }
        return mapping;
    }

    static {
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> Settings.fromXContent(p), SETTINGS);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> new CompressedXContent(MediaTypeRegistry.JSON.contentBuilder().map(p.mapOrdered()).toString()), MAPPINGS);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> {
            HashMap<String, AliasMetadata> aliasMap = new HashMap<String, AliasMetadata>();
            while (p.nextToken() != XContentParser.Token.END_OBJECT) {
                AliasMetadata alias = AliasMetadata.Builder.fromXContent(p);
                aliasMap.put(alias.alias(), alias);
            }
            return aliasMap;
        }, ALIASES);
    }
}

