/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.cache.stats;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.Stack;
import java.util.TreeMap;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.common.cache.stats.DefaultCacheStatsHolder;
import org.opensearch.common.cache.stats.ImmutableCacheStats;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;

@ExperimentalApi
public class ImmutableCacheStatsHolder
implements Writeable,
ToXContent {
    final Node statsRoot;
    final List<String> dimensionNames;
    final String storeName;
    public static String STORE_NAME_FIELD = "store_name";
    private static final String SERIALIZATION_CHILDREN_OPEN_BRACKET = "<";
    private static final String SERIALIZATION_CHILDREN_CLOSE_BRACKET = ">";
    private static final String SERIALIZATION_BEGIN_NODE = "_";
    private static final String SERIALIZATION_DONE = "end";

    ImmutableCacheStatsHolder(DefaultCacheStatsHolder.Node originalStatsRoot, String[] levels, List<String> originalDimensionNames, String storeName) {
        this.dimensionNames = this.filterLevels(levels, originalDimensionNames);
        this.storeName = storeName;
        this.statsRoot = this.aggregateByLevels(originalStatsRoot, originalDimensionNames);
        this.makeNodeUnmodifiable(this.statsRoot);
    }

    public ImmutableCacheStatsHolder(StreamInput in) throws IOException {
        this.dimensionNames = List.of(in.readStringArray());
        this.storeName = in.readString();
        this.statsRoot = this.deserializeTree(in);
        this.makeNodeUnmodifiable(this.statsRoot);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeStringArray(this.dimensionNames.toArray(new String[0]));
        out.writeString(this.storeName);
        this.writeNode(this.statsRoot, out);
        out.writeString(SERIALIZATION_DONE);
    }

    private void writeNode(Node node, StreamOutput out) throws IOException {
        out.writeString(SERIALIZATION_BEGIN_NODE);
        out.writeString(node.dimensionValue);
        out.writeBoolean(node.children.isEmpty());
        node.stats.writeTo(out);
        out.writeString(SERIALIZATION_CHILDREN_OPEN_BRACKET);
        for (Map.Entry<String, Node> entry : node.children.entrySet()) {
            out.writeString(entry.getKey());
            this.writeNode(entry.getValue(), out);
        }
        out.writeString(SERIALIZATION_CHILDREN_CLOSE_BRACKET);
    }

    private Node deserializeTree(StreamInput in) throws IOException {
        Node statsRoot;
        Stack<Node> stack = new Stack<Node>();
        in.readString();
        Node current = statsRoot = this.readSingleNode(in);
        stack.push(statsRoot);
        String nextSymbol = in.readString();
        while (!nextSymbol.equals(SERIALIZATION_DONE)) {
            switch (nextSymbol) {
                case "<": {
                    stack.push(current);
                    break;
                }
                case ">": {
                    stack.pop();
                    break;
                }
                case "_": {
                    current = this.readSingleNode(in);
                    ((Node)stack.peek()).children.put(current.dimensionValue, current);
                }
            }
            nextSymbol = in.readString();
        }
        return statsRoot;
    }

    private Node readSingleNode(StreamInput in) throws IOException {
        String dimensionValue = in.readString();
        boolean isLeafNode = in.readBoolean();
        ImmutableCacheStats stats = new ImmutableCacheStats(in);
        return new Node(dimensionValue, isLeafNode, stats);
    }

    private void makeNodeUnmodifiable(Node node) {
        if (!node.children.isEmpty()) {
            node.children = Collections.unmodifiableSortedMap(node.children);
        }
        for (Node child : node.children.values()) {
            this.makeNodeUnmodifiable(child);
        }
    }

    public ImmutableCacheStats getTotalStats() {
        return this.statsRoot.getStats();
    }

    public long getTotalHits() {
        return this.getTotalStats().getHits();
    }

    public long getTotalMisses() {
        return this.getTotalStats().getMisses();
    }

    public long getTotalEvictions() {
        return this.getTotalStats().getEvictions();
    }

    public long getTotalSizeInBytes() {
        return this.getTotalStats().getSizeInBytes();
    }

    public long getTotalItems() {
        return this.getTotalStats().getItems();
    }

    public ImmutableCacheStats getStatsForDimensionValues(List<String> dimensionValues) {
        Node current = this.statsRoot;
        for (String dimensionValue : dimensionValues) {
            current = (Node)current.children.get(dimensionValue);
            if (current != null) continue;
            return null;
        }
        return current.stats;
    }

    Node aggregateByLevels(DefaultCacheStatsHolder.Node originalStatsRoot, List<String> originalDimensionNames) {
        Node newRoot = new Node("", false, originalStatsRoot.getImmutableStats());
        for (DefaultCacheStatsHolder.Node child : originalStatsRoot.children.values()) {
            this.aggregateByLevelsHelper(newRoot, child, originalDimensionNames, 0);
        }
        return newRoot;
    }

    private void aggregateByLevelsHelper(Node parentInNewTree, DefaultCacheStatsHolder.Node currentInOriginalTree, List<String> allDimensions, int depth) {
        if (this.dimensionNames.contains(allDimensions.get(depth))) {
            String dimensionValue = currentInOriginalTree.getDimensionValue();
            Node nodeInNewTree = (Node)parentInNewTree.children.get(dimensionValue);
            if (nodeInNewTree == null) {
                int indexOfLastLevel = allDimensions.indexOf(this.dimensionNames.get(this.dimensionNames.size() - 1));
                boolean isLeafNode = depth == indexOfLastLevel;
                nodeInNewTree = new Node(dimensionValue, isLeafNode, currentInOriginalTree.getImmutableStats());
                parentInNewTree.addChild(dimensionValue, nodeInNewTree);
            } else {
                nodeInNewTree.incrementStats(currentInOriginalTree.getImmutableStats());
            }
            parentInNewTree = nodeInNewTree;
        }
        for (Map.Entry<String, DefaultCacheStatsHolder.Node> childEntry : currentInOriginalTree.children.entrySet()) {
            DefaultCacheStatsHolder.Node child = childEntry.getValue();
            this.aggregateByLevelsHelper(parentInNewTree, child, allDimensions, depth + 1);
        }
    }

    private List<String> filterLevels(String[] levels, List<String> originalDimensionNames) {
        if (levels == null) {
            return originalDimensionNames;
        }
        List<String> levelsList = Arrays.asList(levels);
        ArrayList<String> filtered = new ArrayList<String>();
        for (String dimensionName : originalDimensionNames) {
            if (!levelsList.contains(dimensionName)) continue;
            filtered.add(dimensionName);
        }
        return filtered;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        this.getTotalStats().toXContent(builder, params);
        List<String> filteredLevels = this.filterLevels(this.getLevels(params), this.dimensionNames);
        assert (filteredLevels.equals(this.dimensionNames));
        if (!filteredLevels.isEmpty()) {
            this.toXContentForLevels(-1, this.statsRoot, builder, params);
        }
        builder.field(STORE_NAME_FIELD, this.storeName);
        return builder;
    }

    private void toXContentForLevels(int depth, Node current, XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (depth >= 0) {
            builder.startObject(current.dimensionValue);
        }
        if (depth == this.dimensionNames.size() - 1) {
            current.getStats().toXContent(builder, params);
        } else {
            builder.startObject(this.dimensionNames.get(depth + 1));
            for (Node nextNode : current.children.values()) {
                this.toXContentForLevels(depth + 1, nextNode, builder, params);
            }
            builder.endObject();
        }
        if (depth >= 0) {
            builder.endObject();
        }
    }

    private String[] getLevels(ToXContent.Params params) {
        String levels = params.param("level");
        if (levels == null) {
            return null;
        }
        return levels.split(",");
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != ImmutableCacheStatsHolder.class) {
            return false;
        }
        ImmutableCacheStatsHolder other = (ImmutableCacheStatsHolder)o;
        if (!this.dimensionNames.equals(other.dimensionNames) || !this.storeName.equals(other.storeName)) {
            return false;
        }
        return this.equalsHelper(this.statsRoot, other.getStatsRoot());
    }

    private boolean equalsHelper(Node thisNode, Node otherNode) {
        if (otherNode == null) {
            return false;
        }
        if (!thisNode.getStats().equals(otherNode.getStats())) {
            return false;
        }
        boolean allChildrenMatch = true;
        for (String childValue : thisNode.getChildren().keySet()) {
            allChildrenMatch = this.equalsHelper((Node)thisNode.children.get(childValue), (Node)otherNode.children.get(childValue));
            if (allChildrenMatch) continue;
            return false;
        }
        return allChildrenMatch;
    }

    public int hashCode() {
        return Objects.hash(this.statsRoot.stats, this.dimensionNames);
    }

    Node getStatsRoot() {
        return this.statsRoot;
    }

    static class Node {
        private final String dimensionValue;
        SortedMap<String, Node> children;
        private ImmutableCacheStats stats;
        private static final SortedMap<String, Node> EMPTY_CHILDREN_MAP = Collections.unmodifiableSortedMap(new TreeMap());

        private Node(String dimensionValue, boolean isLeafNode, ImmutableCacheStats stats) {
            this.dimensionValue = dimensionValue;
            this.stats = stats;
            this.children = isLeafNode ? EMPTY_CHILDREN_MAP : new TreeMap<String, Node>();
        }

        Map<String, Node> getChildren() {
            return this.children;
        }

        public ImmutableCacheStats getStats() {
            return this.stats;
        }

        public String getDimensionValue() {
            return this.dimensionValue;
        }

        private void addChild(String dimensionValue, Node child) {
            this.children.putIfAbsent(dimensionValue, child);
        }

        private void incrementStats(ImmutableCacheStats toIncrement) {
            this.stats = ImmutableCacheStats.addSnapshots(this.stats, toIncrement);
        }
    }
}

