/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.xcontent;

import java.io.IOException;
import java.io.OutputStream;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.common.xcontent.json.JsonXContent;
import org.opensearch.common.xcontent.smile.SmileXContent;
import org.opensearch.common.xcontent.yaml.YamlXContent;
import org.opensearch.core.xcontent.MediaTypeRegistry;
import org.opensearch.core.xcontent.XContentBuilder;

public class XContentFactory {
    public static XContentBuilder jsonBuilder() throws IOException {
        return MediaTypeRegistry.contentBuilder(XContentType.JSON);
    }

    public static XContentBuilder jsonBuilder(OutputStream os) throws IOException {
        return new XContentBuilder(JsonXContent.jsonXContent, os);
    }

    public static XContentBuilder smileBuilder() throws IOException {
        return MediaTypeRegistry.contentBuilder(XContentType.SMILE);
    }

    public static XContentBuilder smileBuilder(OutputStream os) throws IOException {
        return new XContentBuilder(SmileXContent.smileXContent, os);
    }

    public static XContentBuilder yamlBuilder() throws IOException {
        return MediaTypeRegistry.contentBuilder(XContentType.YAML);
    }

    public static XContentBuilder yamlBuilder(OutputStream os) throws IOException {
        return new XContentBuilder(YamlXContent.yamlXContent, os);
    }

    public static XContentBuilder cborBuilder() throws IOException {
        return MediaTypeRegistry.contentBuilder(XContentType.CBOR);
    }
}

