/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.core.common.io.stream;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.file.AccessDeniedException;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystemException;
import java.nio.file.FileSystemLoopException;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.function.IntFunction;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexFormatTooNewException;
import org.apache.lucene.index.IndexFormatTooOldException;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.LockObtainFailedException;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BitUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRef;
import org.opensearch.Build;
import org.opensearch.OpenSearchException;
import org.opensearch.Version;
import org.opensearch.common.CharArrays;
import org.opensearch.common.Nullable;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.bytes.BytesArray;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.common.io.stream.InputStreamStreamInput;
import org.opensearch.core.common.io.stream.NamedWriteable;
import org.opensearch.core.common.io.stream.NamedWriteableRegistry;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.common.settings.SecureString;
import org.opensearch.core.common.text.Text;
import org.opensearch.core.concurrency.OpenSearchRejectedExecutionException;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.MediaTypeRegistry;
import org.opensearch.semver.SemverRange;

@PublicApi(since="1.0.0")
public abstract class StreamInput
extends InputStream {
    private Version version = Version.CURRENT;
    private static final int SMALL_STRING_LIMIT = 1024;
    private static final ThreadLocal<byte[]> stringReadBuffer = ThreadLocal.withInitial(() -> new byte[1024]);
    private static final ThreadLocal<CharsRef> smallSpare = ThreadLocal.withInitial(() -> new CharsRef(1024));
    private CharsRef largeSpare;
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    private static final long[] EMPTY_LONG_ARRAY = new long[0];
    private static final float[] EMPTY_FLOAT_ARRAY = new float[0];
    private static final double[] EMPTY_DOUBLE_ARRAY = new double[0];
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private static final TimeUnit[] TIME_UNITS = TimeUnit.values();

    public Version getVersion() {
        return this.version;
    }

    public void setVersion(Version version) {
        this.version = version;
    }

    public abstract byte readByte() throws IOException;

    public abstract void readBytes(byte[] var1, int var2, int var3) throws IOException;

    public BytesReference readBytesReference() throws IOException {
        int length = this.readArraySize();
        return this.readBytesReference(length);
    }

    @Nullable
    public BytesReference readOptionalBytesReference() throws IOException {
        int length = this.readVInt() - 1;
        if (length < 0) {
            return null;
        }
        return this.readBytesReference(length);
    }

    public BytesReference readBytesReference(int length) throws IOException {
        if (length == 0) {
            return BytesArray.EMPTY;
        }
        byte[] bytes = new byte[length];
        this.readBytes(bytes, 0, length);
        return new BytesArray(bytes, 0, length);
    }

    public BytesRef readBytesRef() throws IOException {
        int length = this.readArraySize();
        return this.readBytesRef(length);
    }

    public void readFully(byte[] b) throws IOException {
        this.readBytes(b, 0, b.length);
    }

    public BytesRef readBytesRef(int length) throws IOException {
        if (length == 0) {
            return new BytesRef();
        }
        byte[] bytes = new byte[length];
        this.readBytes(bytes, 0, length);
        return new BytesRef(bytes, 0, length);
    }

    public short readShort() throws IOException {
        return (short)((this.readByte() & 0xFF) << 8 | this.readByte() & 0xFF);
    }

    public int readInt() throws IOException {
        return (this.readByte() & 0xFF) << 24 | (this.readByte() & 0xFF) << 16 | (this.readByte() & 0xFF) << 8 | this.readByte() & 0xFF;
    }

    public int readVInt() throws IOException {
        byte b = this.readByte();
        int i = b & 0x7F;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        i |= (b & 0x7F) << 7;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        i |= (b & 0x7F) << 14;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        i |= (b & 0x7F) << 21;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        if ((b & 0x80) != 0) {
            throw new IOException("Invalid vInt ((" + Integer.toHexString(b) + " & 0x7f) << 28) | " + Integer.toHexString(i));
        }
        return i | (b & 0x7F) << 28;
    }

    public Integer readOptionalInt() throws IOException {
        if (this.readBoolean()) {
            return this.readInt();
        }
        return null;
    }

    public long readLong() throws IOException {
        return (long)this.readInt() << 32 | (long)this.readInt() & 0xFFFFFFFFL;
    }

    public long readVLong() throws IOException {
        byte b = this.readByte();
        long i = (long)b & 0x7FL;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        i |= ((long)b & 0x7FL) << 7;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        i |= ((long)b & 0x7FL) << 14;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        i |= ((long)b & 0x7FL) << 21;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        i |= ((long)b & 0x7FL) << 28;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        i |= ((long)b & 0x7FL) << 35;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        i |= ((long)b & 0x7FL) << 42;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        i |= ((long)b & 0x7FL) << 49;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        i |= ((long)b & 0x7FL) << 56;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        if (b != 0 && b != 1) {
            throw new IOException("Invalid vlong (" + Integer.toHexString(b) + " << 63) | " + Long.toHexString(i));
        }
        return i |= (long)b << 63;
    }

    @Nullable
    public Long readOptionalVLong() throws IOException {
        if (this.readBoolean()) {
            return this.readVLong();
        }
        return null;
    }

    public long readZLong() throws IOException {
        long currentByte;
        long accumulator = 0L;
        int i = 0;
        while (((currentByte = (long)this.readByte()) & 0x80L) != 0L) {
            accumulator |= (currentByte & 0x7FL) << i;
            if ((i += 7) <= 63) continue;
            throw new IOException("variable-length stream is too long");
        }
        return BitUtil.zigZagDecode(accumulator | currentByte << i);
    }

    @Nullable
    public Long readOptionalLong() throws IOException {
        if (this.readBoolean()) {
            return this.readLong();
        }
        return null;
    }

    public BigInteger readBigInteger() throws IOException {
        return new BigInteger(this.readString());
    }

    public MediaType readMediaType() throws IOException {
        return MediaTypeRegistry.fromMediaType(this.readString());
    }

    @Nullable
    public Text readOptionalText() throws IOException {
        int length = this.readInt();
        if (length == -1) {
            return null;
        }
        return new Text(this.readBytesReference(length));
    }

    public Text readText() throws IOException {
        int length = this.readInt();
        return new Text(this.readBytesReference(length));
    }

    @Nullable
    public String readOptionalString() throws IOException {
        if (this.readBoolean()) {
            return this.readString();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public SecureString readOptionalSecureString() throws IOException {
        SecureString value = null;
        BytesReference bytesRef = this.readOptionalBytesReference();
        if (bytesRef != null) {
            byte[] bytes = BytesReference.toBytes(bytesRef);
            try {
                value = new SecureString(CharArrays.utf8BytesToChars(bytes));
            }
            finally {
                Arrays.fill(bytes, (byte)0);
            }
        }
        return value;
    }

    @Nullable
    public Float readOptionalFloat() throws IOException {
        if (this.readBoolean()) {
            return Float.valueOf(this.readFloat());
        }
        return null;
    }

    @Nullable
    public Integer readOptionalVInt() throws IOException {
        if (this.readBoolean()) {
            return this.readVInt();
        }
        return null;
    }

    public String readString() throws IOException {
        CharsRef charsRef;
        int charCount = this.readArraySize();
        if (charCount > 1024) {
            if (this.largeSpare == null) {
                this.largeSpare = new CharsRef(ArrayUtil.oversize(charCount, 2));
            } else if (this.largeSpare.chars.length < charCount) {
                this.largeSpare.chars = new char[ArrayUtil.oversize(charCount, 2)];
            }
            charsRef = this.largeSpare;
        } else {
            charsRef = smallSpare.get();
        }
        charsRef.length = charCount;
        int charsOffset = 0;
        int offsetByteArray = 0;
        int sizeByteArray = 0;
        int missingFromPartial = 0;
        byte[] byteBuffer = stringReadBuffer.get();
        char[] charBuffer = charsRef.chars;
        while (charsOffset < charCount) {
            int toRead;
            int minRemainingBytes;
            int charsLeft = charCount - charsOffset;
            int bufferFree = byteBuffer.length - sizeByteArray;
            if (missingFromPartial > 0) {
                minRemainingBytes = missingFromPartial + charsLeft - 1;
                missingFromPartial = 0;
            } else {
                minRemainingBytes = charsLeft;
            }
            if (bufferFree < minRemainingBytes) {
                if (offsetByteArray > 0) {
                    switch (sizeByteArray -= offsetByteArray) {
                        case 1: {
                            byteBuffer[0] = byteBuffer[offsetByteArray];
                            break;
                        }
                        case 2: {
                            byteBuffer[0] = byteBuffer[offsetByteArray];
                            byteBuffer[1] = byteBuffer[offsetByteArray + 1];
                        }
                    }
                    assert (sizeByteArray <= 2) : "We never copy more than 2 bytes here since a char is 3 bytes max";
                    toRead = Math.min(bufferFree + offsetByteArray, minRemainingBytes);
                    offsetByteArray = 0;
                } else {
                    toRead = bufferFree;
                }
            } else {
                toRead = minRemainingBytes;
            }
            this.readBytes(byteBuffer, sizeByteArray, toRead);
            sizeByteArray += toRead;
            while (offsetByteArray < sizeByteArray - 2) {
                int c = byteBuffer[offsetByteArray] & 0xFF;
                switch (c >> 4) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        charBuffer[charsOffset++] = (char)c;
                        break;
                    }
                    case 12: 
                    case 13: {
                        charBuffer[charsOffset++] = (char)((c & 0x1F) << 6 | byteBuffer[++offsetByteArray] & 0x3F);
                        break;
                    }
                    case 14: {
                        charBuffer[charsOffset++] = (char)((c & 0xF) << 12 | (byteBuffer[++offsetByteArray] & 0x3F) << 6 | byteBuffer[++offsetByteArray] & 0x3F);
                        break;
                    }
                    default: {
                        StreamInput.throwOnBrokenChar(c);
                    }
                }
                ++offsetByteArray;
            }
            int bufferedBytesRemaining = sizeByteArray - offsetByteArray;
            block16: for (int i = 0; i < bufferedBytesRemaining; ++i) {
                int c = byteBuffer[offsetByteArray] & 0xFF;
                switch (c >> 4) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        charBuffer[charsOffset++] = (char)c;
                        ++offsetByteArray;
                        continue block16;
                    }
                    case 12: 
                    case 13: {
                        missingFromPartial = 2 - (bufferedBytesRemaining - i);
                        if (missingFromPartial == 0) {
                            int n = charsOffset++;
                            int n2 = ++offsetByteArray;
                            ++offsetByteArray;
                            charBuffer[n] = (char)((c & 0x1F) << 6 | byteBuffer[n2] & 0x3F);
                        }
                        ++i;
                        continue block16;
                    }
                    case 14: {
                        missingFromPartial = 3 - (bufferedBytesRemaining - i);
                        ++i;
                        continue block16;
                    }
                    default: {
                        StreamInput.throwOnBrokenChar(c);
                    }
                }
            }
        }
        return charsRef.toString();
    }

    private static void throwOnBrokenChar(int c) throws IOException {
        throw new IOException("Invalid string; unexpected character: " + c + " hex: " + Integer.toHexString(c));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SecureString readSecureString() throws IOException {
        BytesReference bytesRef = this.readBytesReference();
        byte[] bytes = BytesReference.toBytes(bytesRef);
        try {
            SecureString secureString = new SecureString(CharArrays.utf8BytesToChars(bytes));
            return secureString;
        }
        finally {
            Arrays.fill(bytes, (byte)0);
        }
    }

    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Nullable
    public final Double readOptionalDouble() throws IOException {
        if (this.readBoolean()) {
            return this.readDouble();
        }
        return null;
    }

    public final boolean readBoolean() throws IOException {
        return this.readBoolean(this.readByte());
    }

    private boolean readBoolean(byte value) {
        if (value == 0) {
            return false;
        }
        if (value == 1) {
            return true;
        }
        String message = String.format(Locale.ROOT, "unexpected byte [0x%02x]", value);
        throw new IllegalStateException(message);
    }

    @Nullable
    public final Boolean readOptionalBoolean() throws IOException {
        byte value = this.readByte();
        if (value == 2) {
            return null;
        }
        return this.readBoolean(value);
    }

    @Override
    public abstract void close() throws IOException;

    @Override
    public abstract int available() throws IOException;

    public String[] readStringArray() throws IOException {
        int size = this.readArraySize();
        if (size == 0) {
            return Strings.EMPTY_ARRAY;
        }
        String[] ret = new String[size];
        for (int i = 0; i < size; ++i) {
            ret[i] = this.readString();
        }
        return ret;
    }

    @Nullable
    public String[] readOptionalStringArray() throws IOException {
        if (this.readBoolean()) {
            return this.readStringArray();
        }
        return null;
    }

    public <K, V> Map<K, V> readMap(Writeable.Reader<K> keyReader, Writeable.Reader<V> valueReader) throws IOException {
        int size = this.readArraySize();
        if (size == 0) {
            return Collections.emptyMap();
        }
        HashMap map = new HashMap(size);
        this.readIntoMap(keyReader, valueReader, map, size);
        return map;
    }

    public <K extends Comparable<K>, V> SortedMap<K, V> readOrderedMap(Writeable.Reader<K> keyReader, Writeable.Reader<V> valueReader) throws IOException {
        return this.readOrderedMap(keyReader, valueReader, null);
    }

    public <K extends Comparable<K>, V> SortedMap<K, V> readOrderedMap(Writeable.Reader<K> keyReader, Writeable.Reader<V> valueReader, @Nullable Comparator<K> keyComparator) throws IOException {
        int size = this.readArraySize();
        if (size == 0) {
            return Collections.emptySortedMap();
        }
        TreeMap sortedMap = keyComparator == null ? new TreeMap() : new TreeMap(keyComparator);
        this.readIntoMap(keyReader, valueReader, sortedMap, size);
        return sortedMap;
    }

    private <K, V> void readIntoMap(Writeable.Reader<K> keyReader, Writeable.Reader<V> valueReader, Map<K, V> map, int size) throws IOException {
        for (int i = 0; i < size; ++i) {
            K key = keyReader.read(this);
            V value = valueReader.read(this);
            map.put(key, value);
        }
    }

    public <K, V> Map<K, List<V>> readMapOfLists(Writeable.Reader<K> keyReader, Writeable.Reader<V> valueReader) throws IOException {
        int size = this.readArraySize();
        if (size == 0) {
            return Collections.emptyMap();
        }
        HashMap<K, List<V>> map = new HashMap<K, List<V>>(size);
        for (int i = 0; i < size; ++i) {
            map.put(keyReader.read(this), this.readList(valueReader));
        }
        return map;
    }

    @Nullable
    public Map<String, Object> readMap() throws IOException {
        return (Map)this.readGenericValue();
    }

    @Nullable
    public Object readGenericValue() throws IOException {
        byte type = this.readByte();
        Object r = Writeable.WriteableRegistry.getReader(type);
        if (r != null) {
            return r.read(this);
        }
        switch (type) {
            case -1: {
                return null;
            }
            case 0: {
                return this.readString();
            }
            case 1: {
                return this.readInt();
            }
            case 2: {
                return this.readLong();
            }
            case 3: {
                return Float.valueOf(this.readFloat());
            }
            case 4: {
                return this.readDouble();
            }
            case 5: {
                return this.readBoolean();
            }
            case 6: {
                return this.readByteArray();
            }
            case 7: {
                return this.readArrayList();
            }
            case 8: {
                return this.readArray();
            }
            case 9: {
                return this.readLinkedHashMap();
            }
            case 10: {
                return this.readHashMap();
            }
            case 11: {
                return this.readByte();
            }
            case 12: {
                return this.readDate();
            }
            case 14: {
                return this.readBytesReference();
            }
            case 15: {
                return this.readText();
            }
            case 16: {
                return this.readShort();
            }
            case 17: {
                return this.readIntArray();
            }
            case 18: {
                return this.readLongArray();
            }
            case 19: {
                return this.readFloatArray();
            }
            case 20: {
                return this.readDoubleArray();
            }
            case 21: {
                return this.readBytesRef();
            }
            case 23: {
                return this.readZonedDateTime();
            }
            case 24: {
                return this.readCollection(StreamInput::readGenericValue, LinkedHashSet::new, Collections.emptySet());
            }
            case 25: {
                return this.readCollection(StreamInput::readGenericValue, HashSet::new, Collections.emptySet());
            }
            case 26: {
                return this.readBigInteger();
            }
            case 27: {
                return this.readSemverRange();
            }
        }
        throw new IOException("Can't read unknown type [" + type + "]");
    }

    public final Instant readInstant() throws IOException {
        return Instant.ofEpochSecond(this.readLong(), this.readInt());
    }

    @Nullable
    public final Instant readOptionalInstant() throws IOException {
        boolean present = this.readBoolean();
        return present ? this.readInstant() : null;
    }

    private List readArrayList() throws IOException {
        int size = this.readArraySize();
        if (size == 0) {
            return Collections.emptyList();
        }
        ArrayList<Object> list = new ArrayList<Object>(size);
        for (int i = 0; i < size; ++i) {
            list.add(this.readGenericValue());
        }
        return list;
    }

    private ZonedDateTime readZonedDateTime() throws IOException {
        String timeZoneId = this.readString();
        return ZonedDateTime.ofInstant(Instant.ofEpochMilli(this.readLong()), ZoneId.of(timeZoneId));
    }

    private Object[] readArray() throws IOException {
        int size8 = this.readArraySize();
        if (size8 == 0) {
            return EMPTY_OBJECT_ARRAY;
        }
        Object[] list8 = new Object[size8];
        for (int i = 0; i < size8; ++i) {
            list8[i] = this.readGenericValue();
        }
        return list8;
    }

    private Map readLinkedHashMap() throws IOException {
        int size9 = this.readArraySize();
        if (size9 == 0) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Object> map9 = new LinkedHashMap<String, Object>(size9);
        for (int i = 0; i < size9; ++i) {
            map9.put(this.readString(), this.readGenericValue());
        }
        return map9;
    }

    private Map readHashMap() throws IOException {
        int size10 = this.readArraySize();
        if (size10 == 0) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> map10 = new HashMap<String, Object>(size10);
        for (int i = 0; i < size10; ++i) {
            map10.put(this.readString(), this.readGenericValue());
        }
        return map10;
    }

    private Date readDate() throws IOException {
        return new Date(this.readLong());
    }

    public ZoneId readZoneId() throws IOException {
        return ZoneId.of(this.readString());
    }

    public ZoneId readOptionalZoneId() throws IOException {
        if (this.readBoolean()) {
            return ZoneId.of(this.readString());
        }
        return null;
    }

    public int[] readIntArray() throws IOException {
        int length = this.readArraySize();
        if (length == 0) {
            return EMPTY_INT_ARRAY;
        }
        int[] values = new int[length];
        for (int i = 0; i < length; ++i) {
            values[i] = this.readInt();
        }
        return values;
    }

    public int[] readVIntArray() throws IOException {
        int length = this.readArraySize();
        if (length == 0) {
            return EMPTY_INT_ARRAY;
        }
        int[] values = new int[length];
        for (int i = 0; i < length; ++i) {
            values[i] = this.readVInt();
        }
        return values;
    }

    public long[] readLongArray() throws IOException {
        int length = this.readArraySize();
        if (length == 0) {
            return EMPTY_LONG_ARRAY;
        }
        long[] values = new long[length];
        for (int i = 0; i < length; ++i) {
            values[i] = this.readLong();
        }
        return values;
    }

    public long[] readVLongArray() throws IOException {
        int length = this.readArraySize();
        if (length == 0) {
            return EMPTY_LONG_ARRAY;
        }
        long[] values = new long[length];
        for (int i = 0; i < length; ++i) {
            values[i] = this.readVLong();
        }
        return values;
    }

    public float[] readFloatArray() throws IOException {
        int length = this.readArraySize();
        if (length == 0) {
            return EMPTY_FLOAT_ARRAY;
        }
        float[] values = new float[length];
        for (int i = 0; i < length; ++i) {
            values[i] = this.readFloat();
        }
        return values;
    }

    public double[] readDoubleArray() throws IOException {
        int length = this.readArraySize();
        if (length == 0) {
            return EMPTY_DOUBLE_ARRAY;
        }
        double[] values = new double[length];
        for (int i = 0; i < length; ++i) {
            values[i] = this.readDouble();
        }
        return values;
    }

    public byte[] readByteArray() throws IOException {
        int length = this.readArraySize();
        if (length == 0) {
            return EMPTY_BYTE_ARRAY;
        }
        byte[] bytes = new byte[length];
        this.readBytes(bytes, 0, bytes.length);
        return bytes;
    }

    public <T> T[] readArray(Writeable.Reader<T> reader, IntFunction<T[]> arraySupplier) throws IOException {
        int length = this.readArraySize();
        T[] values = arraySupplier.apply(length);
        for (int i = 0; i < length; ++i) {
            values[i] = reader.read(this);
        }
        return values;
    }

    public <T> T[] readOptionalArray(Writeable.Reader<T> reader, IntFunction<T[]> arraySupplier) throws IOException {
        return this.readBoolean() ? this.readArray(reader, arraySupplier) : null;
    }

    @Nullable
    public <T extends Writeable> T readOptionalWriteable(Writeable.Reader<T> reader) throws IOException {
        if (this.readBoolean()) {
            Writeable t = (Writeable)reader.read(this);
            if (t == null) {
                throw new IOException("Writeable.Reader [" + String.valueOf(reader) + "] returned null which is not allowed and probably means it screwed up the stream.");
            }
            return (T)t;
        }
        return null;
    }

    @Nullable
    public <T extends Exception> T readException() throws IOException {
        if (this.readBoolean()) {
            int key = this.readVInt();
            switch (key) {
                case 0: {
                    int ord = this.readVInt();
                    return (T)OpenSearchException.readException(this, ord);
                }
                case 1: {
                    String msg1 = this.readOptionalString();
                    String resource1 = this.readOptionalString();
                    return (T)OpenSearchException.readStackTrace(new CorruptIndexException(msg1, resource1, (Throwable)this.readException()), this);
                }
                case 2: {
                    String resource2 = this.readOptionalString();
                    int version2 = this.readInt();
                    int minVersion2 = this.readInt();
                    int maxVersion2 = this.readInt();
                    return (T)OpenSearchException.readStackTrace(new IndexFormatTooNewException(resource2, version2, minVersion2, maxVersion2), this);
                }
                case 3: {
                    String resource3 = this.readOptionalString();
                    if (this.readBoolean()) {
                        int version3 = this.readInt();
                        int minVersion3 = this.readInt();
                        int maxVersion3 = this.readInt();
                        return (T)OpenSearchException.readStackTrace(new IndexFormatTooOldException(resource3, version3, minVersion3, maxVersion3), this);
                    }
                    String version3 = this.readOptionalString();
                    return (T)OpenSearchException.readStackTrace(new IndexFormatTooOldException(resource3, version3), this);
                }
                case 4: {
                    return (T)OpenSearchException.readStackTrace(new NullPointerException(this.readOptionalString()), this);
                }
                case 5: {
                    return (T)OpenSearchException.readStackTrace(new NumberFormatException(this.readOptionalString()), this);
                }
                case 6: {
                    return (T)OpenSearchException.readStackTrace(new IllegalArgumentException(this.readOptionalString(), (Throwable)this.readException()), this);
                }
                case 7: {
                    return (T)OpenSearchException.readStackTrace(new AlreadyClosedException(this.readOptionalString(), (Throwable)this.readException()), this);
                }
                case 8: {
                    return (T)OpenSearchException.readStackTrace(new EOFException(this.readOptionalString()), this);
                }
                case 9: {
                    return (T)OpenSearchException.readStackTrace(new SecurityException(this.readOptionalString(), (Throwable)this.readException()), this);
                }
                case 10: {
                    return (T)OpenSearchException.readStackTrace(new StringIndexOutOfBoundsException(this.readOptionalString()), this);
                }
                case 11: {
                    return (T)OpenSearchException.readStackTrace(new ArrayIndexOutOfBoundsException(this.readOptionalString()), this);
                }
                case 12: {
                    return (T)OpenSearchException.readStackTrace(new FileNotFoundException(this.readOptionalString()), this);
                }
                case 13: {
                    FileSystemException exception;
                    int subclass = this.readVInt();
                    String file = this.readOptionalString();
                    String other = this.readOptionalString();
                    String reason = this.readOptionalString();
                    this.readOptionalString();
                    switch (subclass) {
                        case 0: {
                            exception = new NoSuchFileException(file, other, reason);
                            break;
                        }
                        case 1: {
                            exception = new NotDirectoryException(file);
                            break;
                        }
                        case 2: {
                            exception = new DirectoryNotEmptyException(file);
                            break;
                        }
                        case 3: {
                            exception = new AtomicMoveNotSupportedException(file, other, reason);
                            break;
                        }
                        case 4: {
                            exception = new FileAlreadyExistsException(file, other, reason);
                            break;
                        }
                        case 5: {
                            exception = new AccessDeniedException(file, other, reason);
                            break;
                        }
                        case 6: {
                            exception = new FileSystemLoopException(file);
                            break;
                        }
                        case 7: {
                            exception = new FileSystemException(file, other, reason);
                            break;
                        }
                        default: {
                            throw new IllegalStateException("unknown FileSystemException with index " + subclass);
                        }
                    }
                    return (T)OpenSearchException.readStackTrace(exception, this);
                }
                case 14: {
                    return (T)OpenSearchException.readStackTrace(new IllegalStateException(this.readOptionalString(), (Throwable)this.readException()), this);
                }
                case 15: {
                    return (T)OpenSearchException.readStackTrace(new LockObtainFailedException(this.readOptionalString(), (Throwable)this.readException()), this);
                }
                case 16: {
                    return (T)OpenSearchException.readStackTrace(new InterruptedException(this.readOptionalString()), this);
                }
                case 17: {
                    return (T)OpenSearchException.readStackTrace(new IOException(this.readOptionalString(), (Throwable)this.readException()), this);
                }
                case 18: {
                    boolean isExecutorShutdown = this.readBoolean();
                    return (T)OpenSearchException.readStackTrace(new OpenSearchRejectedExecutionException(this.readOptionalString(), isExecutorShutdown), this);
                }
            }
            throw new IOException("no such exception for id: " + key);
        }
        return null;
    }

    public Version readVersion() throws IOException {
        return Version.fromId(this.readVInt());
    }

    public SemverRange readSemverRange() throws IOException {
        return SemverRange.fromString(this.readString());
    }

    public Build readBuild() throws IOException {
        String distribution = this.readString();
        Build.Type type = Build.Type.fromDisplayName(this.readString(), false);
        String hash = this.readString();
        String date = this.readString();
        boolean snapshot = this.readBoolean();
        String version = this.readString();
        return new Build(type, hash, date, snapshot, version, distribution);
    }

    public NamedWriteableRegistry namedWriteableRegistry() {
        return null;
    }

    @Nullable
    public <C extends NamedWriteable> C readNamedWriteable(Class<C> categoryClass) throws IOException {
        throw new UnsupportedOperationException("can't read named writeable from StreamInput");
    }

    @Nullable
    public <C extends NamedWriteable> C readNamedWriteable(Class<C> categoryClass, String name) throws IOException {
        throw new UnsupportedOperationException("can't read named writeable from StreamInput");
    }

    @Nullable
    public <C extends NamedWriteable> C readOptionalNamedWriteable(Class<C> categoryClass) throws IOException {
        if (this.readBoolean()) {
            return this.readNamedWriteable(categoryClass);
        }
        return null;
    }

    public <T> List<T> readList(Writeable.Reader<T> reader) throws IOException {
        return this.readCollection(reader, ArrayList::new, Collections.emptyList());
    }

    public List<String> readStringList() throws IOException {
        return this.readList(StreamInput::readString);
    }

    public List<String> readOptionalStringList() throws IOException {
        boolean isPresent = this.readBoolean();
        if (isPresent) {
            return this.readList(StreamInput::readString);
        }
        return null;
    }

    public <T> Set<T> readSet(Writeable.Reader<T> reader) throws IOException {
        return this.readCollection(reader, HashSet::new, Collections.emptySet());
    }

    private <T, C extends Collection<? super T>> C readCollection(Writeable.Reader<T> reader, IntFunction<C> constructor, C empty) throws IOException {
        int count = this.readArraySize();
        if (count == 0) {
            return empty;
        }
        Collection builder = (Collection)constructor.apply(count);
        for (int i = 0; i < count; ++i) {
            builder.add(reader.read(this));
        }
        return (C)builder;
    }

    public <T extends NamedWriteable> List<T> readNamedWriteableList(Class<T> categoryClass) throws IOException {
        int count = this.readArraySize();
        if (count == 0) {
            return Collections.emptyList();
        }
        ArrayList<T> builder = new ArrayList<T>(count);
        for (int i = 0; i < count; ++i) {
            builder.add(this.readNamedWriteable(categoryClass));
        }
        return builder;
    }

    public <E extends Enum<E>> E readEnum(Class<E> enumClass) throws IOException {
        return (E)this.readEnum(enumClass, (Enum[])enumClass.getEnumConstants());
    }

    private <E extends Enum<E>> E readEnum(Class<E> enumClass, E[] values) throws IOException {
        int ordinal = this.readVInt();
        if (ordinal < 0 || ordinal >= values.length) {
            throw new IOException("Unknown " + enumClass.getSimpleName() + " ordinal [" + ordinal + "]");
        }
        return values[ordinal];
    }

    public <E extends Enum<E>> EnumSet<E> readEnumSet(Class<E> enumClass) throws IOException {
        int size = this.readVInt();
        EnumSet<Enum> res = EnumSet.noneOf(enumClass);
        if (size == 0) {
            return res;
        }
        Enum[] values = (Enum[])enumClass.getEnumConstants();
        for (int i = 0; i < size; ++i) {
            res.add(this.readEnum(enumClass, values));
        }
        return res;
    }

    public static StreamInput wrap(byte[] bytes) {
        return StreamInput.wrap(bytes, 0, bytes.length);
    }

    public static StreamInput wrap(byte[] bytes, int offset, int length) {
        return new InputStreamStreamInput(new ByteArrayInputStream(bytes, offset, length), length);
    }

    private int readArraySize() throws IOException {
        int arraySize = this.readVInt();
        if (arraySize > ArrayUtil.MAX_ARRAY_LENGTH) {
            throw new IllegalStateException("array length must be <= to " + ArrayUtil.MAX_ARRAY_LENGTH + " but was: " + arraySize);
        }
        if (arraySize < 0) {
            throw new NegativeArraySizeException("array size must be positive but was: " + arraySize);
        }
        this.ensureCanReadBytes(arraySize);
        return arraySize;
    }

    protected abstract void ensureCanReadBytes(int var1) throws EOFException;

    public TimeValue readTimeValue() throws IOException {
        long duration = this.readZLong();
        TimeUnit timeUnit = TIME_UNITS[this.readByte()];
        return new TimeValue(duration, timeUnit);
    }

    @Nullable
    public TimeValue readOptionalTimeValue() throws IOException {
        if (this.readBoolean()) {
            return this.readTimeValue();
        }
        return null;
    }

    static {
        if (!Arrays.equals((Object[])TIME_UNITS, (Object[])new TimeUnit[]{TimeUnit.NANOSECONDS, TimeUnit.MICROSECONDS, TimeUnit.MILLISECONDS, TimeUnit.SECONDS, TimeUnit.MINUTES, TimeUnit.HOURS, TimeUnit.DAYS})) {
            throw new AssertionError((Object)"Incompatible JDK version used that breaks assumptions on the structure of the TimeUnit enum");
        }
    }
}

