/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gateway.remote.model;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.opensearch.cluster.ClusterState;
import org.opensearch.common.io.Streams;
import org.opensearch.common.remote.AbstractClusterMetadataWriteableBlobEntity;
import org.opensearch.common.remote.BlobPathParameters;
import org.opensearch.core.common.io.stream.NamedWriteableRegistry;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.compress.Compressor;
import org.opensearch.gateway.remote.ClusterMetadataManifest;
import org.opensearch.index.remote.RemoteStoreUtils;
import org.opensearch.repositories.blobstore.ChecksumWritableBlobStoreFormat;

public class RemoteClusterStateCustoms
extends AbstractClusterMetadataWriteableBlobEntity<ClusterState.Custom> {
    public static final String CLUSTER_STATE_CUSTOM = "cluster-state-custom";
    public final ChecksumWritableBlobStoreFormat<ClusterState.Custom> clusterStateCustomsFormat;
    private long stateVersion;
    private final String customType;
    private ClusterState.Custom custom;
    private final NamedWriteableRegistry namedWriteableRegistry;

    public RemoteClusterStateCustoms(ClusterState.Custom custom, String customType, long stateVersion, String clusterUUID, Compressor compressor, NamedWriteableRegistry namedWriteableRegistry) {
        super(clusterUUID, compressor, null);
        this.stateVersion = stateVersion;
        this.customType = customType;
        this.custom = custom;
        this.namedWriteableRegistry = namedWriteableRegistry;
        this.clusterStateCustomsFormat = new ChecksumWritableBlobStoreFormat<ClusterState.Custom>(CLUSTER_STATE_CUSTOM, is -> RemoteClusterStateCustoms.readFrom(is, namedWriteableRegistry, customType));
    }

    public RemoteClusterStateCustoms(String blobName, String customType, String clusterUUID, Compressor compressor, NamedWriteableRegistry namedWriteableRegistry) {
        super(clusterUUID, compressor, null);
        this.blobName = blobName;
        this.customType = customType;
        this.namedWriteableRegistry = namedWriteableRegistry;
        this.clusterStateCustomsFormat = new ChecksumWritableBlobStoreFormat<ClusterState.Custom>(CLUSTER_STATE_CUSTOM, is -> RemoteClusterStateCustoms.readFrom(is, namedWriteableRegistry, customType));
    }

    @Override
    public BlobPathParameters getBlobPathParameters() {
        String prefix = String.join((CharSequence)"--", CLUSTER_STATE_CUSTOM, this.customType);
        return new BlobPathParameters(List.of("ephemeral"), prefix);
    }

    @Override
    public String getType() {
        return CLUSTER_STATE_CUSTOM;
    }

    @Override
    public String generateBlobFileName() {
        String blobFileName;
        this.blobFileName = blobFileName = String.join((CharSequence)"__", this.getBlobPathParameters().getFilePrefix(), RemoteStoreUtils.invertLong(this.stateVersion), RemoteStoreUtils.invertLong(System.currentTimeMillis()), String.valueOf(1));
        return blobFileName;
    }

    @Override
    public ClusterMetadataManifest.UploadedMetadata getUploadedMetadata() {
        assert (this.blobName != null);
        return new ClusterMetadataManifest.UploadedMetadataAttribute(String.join((CharSequence)"--", CLUSTER_STATE_CUSTOM, this.customType), this.blobName);
    }

    @Override
    public InputStream serialize() throws IOException {
        return this.clusterStateCustomsFormat.serialize(this.custom, this.generateBlobFileName(), this.getCompressor()).streamInput();
    }

    @Override
    public ClusterState.Custom deserialize(InputStream inputStream) throws IOException {
        return this.clusterStateCustomsFormat.deserialize(this.blobName, Streams.readFully(inputStream));
    }

    public static ClusterState.Custom readFrom(StreamInput streamInput, NamedWriteableRegistry namedWriteableRegistry, String customType) throws IOException {
        return namedWriteableRegistry.getReader(ClusterState.Custom.class, customType).read(streamInput);
    }
}

