/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.http;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.opensearch.common.Nullable;
import org.opensearch.common.io.stream.BytesStreamOutput;
import org.opensearch.common.io.stream.ReleasableBytesStreamOutput;
import org.opensearch.common.lease.Releasable;
import org.opensearch.common.lease.Releasables;
import org.opensearch.common.util.BigArrays;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.http.CorsHandler;
import org.opensearch.http.DefaultRestChannel;
import org.opensearch.http.HttpChunk;
import org.opensearch.http.HttpHandlingSettings;
import org.opensearch.http.HttpRequest;
import org.opensearch.http.HttpTracer;
import org.opensearch.http.StreamingHttpChannel;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.StreamingRestChannel;
import org.reactivestreams.Subscriber;

class DefaultStreamingRestChannel
extends DefaultRestChannel
implements StreamingRestChannel {
    private final StreamingHttpChannel streamingHttpChannel;
    @Nullable
    private final HttpTracer tracerLog;

    DefaultStreamingRestChannel(StreamingHttpChannel streamingHttpChannel, HttpRequest httpRequest, RestRequest request, BigArrays bigArrays, HttpHandlingSettings settings, ThreadContext threadContext, CorsHandler corsHandler, @Nullable HttpTracer tracerLog) {
        super(streamingHttpChannel, httpRequest, request, bigArrays, settings, threadContext, corsHandler, tracerLog);
        this.streamingHttpChannel = streamingHttpChannel;
        this.tracerLog = tracerLog;
    }

    public void subscribe(Subscriber<? super HttpChunk> subscriber) {
        this.streamingHttpChannel.subscribe(subscriber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendChunk(HttpChunk chunk) {
        String opaque = null;
        boolean success = false;
        ArrayList<Releasable> toClose = new ArrayList<Releasable>(3);
        String contentLength = null;
        try {
            opaque = this.request.header("X-Opaque-Id");
            contentLength = String.valueOf(chunk.content().length());
            toClose.add(chunk);
            BytesStreamOutput bytesStreamOutput = this.newBytesOutput();
            if (bytesStreamOutput instanceof ReleasableBytesStreamOutput) {
                toClose.add((Releasable)((Object)bytesStreamOutput));
            }
            ActionListener<Void> listener = ActionListener.wrap(() -> Releasables.close(toClose));
            this.streamingHttpChannel.sendChunk(chunk, listener);
            success = true;
        }
        finally {
            if (!success) {
                Releasables.close(toClose);
            }
            if (this.tracerLog != null) {
                this.tracerLog.traceChunk(chunk, this.streamingHttpChannel, contentLength, opaque, this.request.getRequestId(), success);
            }
        }
    }

    @Override
    public void prepareResponse(RestStatus status, Map<String, List<String>> headers) {
        this.streamingHttpChannel.prepareResponse(status.getStatus(), headers);
    }

    @Override
    public boolean isReadable() {
        return this.streamingHttpChannel.isReadable();
    }

    @Override
    public boolean isWritable() {
        return this.streamingHttpChannel.isWritable();
    }
}

