/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.compositeindex.datacube.startree.builder;

import java.io.Closeable;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.RandomAccessInput;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.common.util.io.IOUtils;
import org.opensearch.index.compositeindex.datacube.startree.StarTreeDocument;
import org.opensearch.index.compositeindex.datacube.startree.StarTreeField;
import org.opensearch.index.compositeindex.datacube.startree.aggregators.MetricAggregatorInfo;
import org.opensearch.index.compositeindex.datacube.startree.builder.AbstractDocumentsFileManager;

@ExperimentalApi
public class StarTreeDocsFileManager
extends AbstractDocumentsFileManager
implements Closeable {
    private static final Logger logger = LogManager.getLogger(StarTreeDocsFileManager.class);
    private static final String STAR_TREE_DOC_FILE_NAME = "star-tree.documents";
    public static final int DEFAULT_FILE_COUNT_MERGE_THRESHOLD = 5;
    private IndexInput starTreeDocsFileInput;
    private RandomAccessInput starTreeDocsFileRandomInput;
    private IndexOutput starTreeDocsFileOutput;
    private final Map<String, Integer> fileToEndDocIdMap = new LinkedHashMap<String, Integer>();
    private int currentFileStartDocId;
    private int numReadableStarTreeDocuments;
    private int starTreeFileCount = -1;
    private final int fileCountMergeThreshold;
    private int numStarTreeDocs = 0;

    public StarTreeDocsFileManager(SegmentWriteState state, StarTreeField starTreeField, List<MetricAggregatorInfo> metricAggregatorInfos, int numDimensions) throws IOException {
        this(state, starTreeField, metricAggregatorInfos, 5, numDimensions);
    }

    public StarTreeDocsFileManager(SegmentWriteState state, StarTreeField starTreeField, List<MetricAggregatorInfo> metricAggregatorInfos, int fileCountThreshold, int numDimensions) throws IOException {
        super(state, starTreeField, metricAggregatorInfos, numDimensions);
        try {
            this.starTreeDocsFileOutput = this.createStarTreeDocumentsFileOutput();
        }
        catch (IOException e) {
            IOUtils.closeWhileHandlingException((Closeable)this.starTreeDocsFileOutput);
            IOUtils.closeWhileHandlingException((Closeable)this);
            throw e;
        }
        this.fileCountMergeThreshold = fileCountThreshold;
    }

    IndexOutput createStarTreeDocumentsFileOutput() throws IOException {
        ++this.starTreeFileCount;
        return this.tmpDirectory.createTempOutput(STAR_TREE_DOC_FILE_NAME + this.starTreeFileCount, this.state.segmentSuffix, this.state.context);
    }

    @Override
    public void writeStarTreeDocument(StarTreeDocument starTreeDocument, boolean isAggregatedDoc) throws IOException {
        assert (isAggregatedDoc);
        int numBytes = this.writeStarTreeDocument(starTreeDocument, this.starTreeDocsFileOutput, true);
        if (this.docSizeInBytes == -1) {
            this.docSizeInBytes = numBytes;
        } else assert (this.docSizeInBytes == numBytes);
        ++this.numStarTreeDocs;
    }

    @Override
    public StarTreeDocument readStarTreeDocument(int docId, boolean isAggregatedDoc) throws IOException {
        assert (isAggregatedDoc);
        this.ensureDocumentReadable(docId);
        return this.readStarTreeDocument(this.starTreeDocsFileRandomInput, this.getOffset(docId), true);
    }

    private long getOffset(int docId) {
        return (long)(docId - this.currentFileStartDocId) * (long)this.docSizeInBytes;
    }

    @Override
    public Long getDimensionValue(int docId, int dimensionId) throws IOException {
        Long[] dims = this.readDimensions(docId);
        return dims[dimensionId];
    }

    @Override
    public Long[] readDimensions(int docId) throws IOException {
        this.ensureDocumentReadable(docId);
        Long[] dims = new Long[this.numDimensions];
        this.readDimensions(dims, this.starTreeDocsFileRandomInput, this.getOffset(docId));
        return dims;
    }

    private void ensureDocumentReadable(int docId) throws IOException {
        this.ensureDocumentReadable(docId, true);
    }

    private void ensureDocumentReadable(int docId, boolean shouldCreateFileOutput) throws IOException {
        try {
            if (docId >= this.currentFileStartDocId && docId < this.numReadableStarTreeDocuments) {
                return;
            }
            IOUtils.closeWhileHandlingException((Closeable)this.starTreeDocsFileInput);
            this.starTreeDocsFileInput = null;
            if (docId < this.numStarTreeDocs) {
                this.loadStarTreeDocumentFile(docId);
            }
            if (this.starTreeDocsFileInput != null) {
                return;
            }
            this.closeAndMaybeCreateNewFile(shouldCreateFileOutput, this.numStarTreeDocs);
            this.loadStarTreeDocumentFile(docId);
        }
        catch (IOException ex) {
            IOUtils.closeWhileHandlingException((Closeable)this);
            throw ex;
        }
    }

    private void loadStarTreeDocumentFile(int docId) throws IOException {
        int currentFileStartDocId = 0;
        for (Map.Entry<String, Integer> entry : this.fileToEndDocIdMap.entrySet()) {
            if (docId < entry.getValue()) {
                this.starTreeDocsFileInput = this.tmpDirectory.openInput(entry.getKey(), this.state.context);
                this.starTreeDocsFileRandomInput = this.starTreeDocsFileInput.randomAccessSlice(this.starTreeDocsFileInput.getFilePointer(), this.starTreeDocsFileInput.length() - this.starTreeDocsFileInput.getFilePointer());
                this.numReadableStarTreeDocuments = entry.getValue();
                break;
            }
            currentFileStartDocId = entry.getValue();
        }
        this.currentFileStartDocId = currentFileStartDocId;
    }

    private void closeAndMaybeCreateNewFile(boolean shouldCreateFileForAppend, int numStarTreeDocs) throws IOException {
        if (this.starTreeDocsFileOutput != null) {
            this.fileToEndDocIdMap.put(this.starTreeDocsFileOutput.getName(), numStarTreeDocs);
            IOUtils.close((Closeable)this.starTreeDocsFileOutput);
        }
        if (shouldCreateFileForAppend) {
            this.starTreeDocsFileOutput = this.createStarTreeDocumentsFileOutput();
            if (this.fileToEndDocIdMap.size() >= this.fileCountMergeThreshold) {
                this.mergeFiles(numStarTreeDocs);
            }
        }
        if (this.starTreeDocsFileRandomInput != null) {
            this.starTreeDocsFileRandomInput = null;
        }
    }

    private void mergeFiles(int numStarTreeDocs) throws IOException {
        long st = System.currentTimeMillis();
        try (IndexOutput mergedOutput = this.createStarTreeDocumentsFileOutput();){
            long mergeBytes = this.mergeFilesToOutput(mergedOutput);
            logger.debug("Created merge file : {} in : {} ms with size of : {} KB", (Object)this.starTreeDocsFileOutput.getName(), (Object)(System.currentTimeMillis() - st), (Object)(mergeBytes / 1024L));
            this.deleteOldFiles();
            this.fileToEndDocIdMap.clear();
            this.fileToEndDocIdMap.put(mergedOutput.getName(), numStarTreeDocs);
        }
    }

    private long mergeFilesToOutput(IndexOutput mergedOutput) throws IOException {
        long mergeBytes = 0L;
        for (Map.Entry<String, Integer> entry : this.fileToEndDocIdMap.entrySet()) {
            IndexInput input = this.tmpDirectory.openInput(entry.getKey(), this.state.context);
            mergedOutput.copyBytes(input, input.length());
            mergeBytes += input.length();
            input.close();
        }
        return mergeBytes;
    }

    private void deleteOldFiles() throws IOException {
        for (String fileName : this.fileToEndDocIdMap.keySet()) {
            this.tmpDirectory.deleteFile(fileName);
        }
    }

    @Override
    public void close() {
        block7: {
            try {
                if (this.starTreeDocsFileOutput == null) break block7;
                IOUtils.closeWhileHandlingException((Closeable)this.starTreeDocsFileOutput);
                try {
                    this.tmpDirectory.deleteFile(this.starTreeDocsFileOutput.getName());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeWhileHandlingException(this.starTreeDocsFileInput, this.starTreeDocsFileOutput);
                throw throwable;
            }
        }
        IOUtils.closeWhileHandlingException(this.starTreeDocsFileInput, this.starTreeDocsFileOutput);
        for (String file : this.fileToEndDocIdMap.keySet()) {
            try {
                this.tmpDirectory.deleteFile(file);
            }
            catch (IOException iOException) {}
        }
        this.fileToEndDocIdMap.clear();
    }
}

