/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.query;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.LongSupplier;
import org.opensearch.client.Client;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.common.util.concurrent.CountDown;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.io.stream.NamedWriteableRegistry;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.index.query.QueryCoordinatorContext;
import org.opensearch.index.query.QueryShardContext;

@PublicApi(since="1.0.0")
public class QueryRewriteContext {
    private final NamedXContentRegistry xContentRegistry;
    private final NamedWriteableRegistry writeableRegistry;
    protected final Client client;
    protected final LongSupplier nowInMillis;
    private final List<BiConsumer<Client, ActionListener<?>>> asyncActions = new ArrayList();
    private final boolean validate;

    public QueryRewriteContext(NamedXContentRegistry xContentRegistry, NamedWriteableRegistry writeableRegistry, Client client, LongSupplier nowInMillis) {
        this(xContentRegistry, writeableRegistry, client, nowInMillis, false);
    }

    public QueryRewriteContext(NamedXContentRegistry xContentRegistry, NamedWriteableRegistry writeableRegistry, Client client, LongSupplier nowInMillis, boolean validate) {
        this.xContentRegistry = xContentRegistry;
        this.writeableRegistry = writeableRegistry;
        this.client = client;
        this.nowInMillis = nowInMillis;
        this.validate = validate;
    }

    public NamedXContentRegistry getXContentRegistry() {
        return this.xContentRegistry;
    }

    public long nowInMillis() {
        return this.nowInMillis.getAsLong();
    }

    public NamedWriteableRegistry getWriteableRegistry() {
        return this.writeableRegistry;
    }

    public QueryShardContext convertToShardContext() {
        return null;
    }

    public QueryCoordinatorContext convertToCoordinatorContext() {
        return null;
    }

    public void registerAsyncAction(BiConsumer<Client, ActionListener<?>> asyncAction) {
        this.asyncActions.add(asyncAction);
    }

    public boolean hasAsyncActions() {
        return !this.asyncActions.isEmpty();
    }

    public void executeAsyncActions(final ActionListener listener) {
        if (this.asyncActions.isEmpty()) {
            listener.onResponse(null);
            return;
        }
        final CountDown countDown = new CountDown(this.asyncActions.size());
        ActionListener internalListener = new ActionListener(){

            public void onResponse(Object o) {
                if (countDown.countDown()) {
                    listener.onResponse(null);
                }
            }

            @Override
            public void onFailure(Exception e) {
                if (countDown.fastForward()) {
                    listener.onFailure(e);
                }
            }
        };
        ArrayList biConsumers = new ArrayList(this.asyncActions);
        this.asyncActions.clear();
        for (BiConsumer biConsumer : biConsumers) {
            biConsumer.accept(this.client, internalListener);
        }
    }

    public boolean validate() {
        return this.validate;
    }
}

