/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.search.stats;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.opensearch.Version;
import org.opensearch.action.search.SearchPhaseName;
import org.opensearch.action.search.SearchRequestStats;
import org.opensearch.common.Nullable;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.MediaTypeRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;

@PublicApi(since="1.0.0")
public class SearchStats
implements Writeable,
ToXContentFragment {
    private final Stats totalStats;
    private long openContexts;
    @Nullable
    private Map<String, Stats> groupStats;

    public SearchStats() {
        this.totalStats = new Stats();
    }

    public void setSearchRequestStats(SearchRequestStats searchRequestStats) {
        if (this.totalStats.requestStatsLongHolder == null) {
            this.totalStats.requestStatsLongHolder = new RequestStatsLongHolder();
        }
        this.totalStats.requestStatsLongHolder.requestStatsHolder.put("took", new PhaseStatsLongHolder(searchRequestStats.getTookCurrent(), searchRequestStats.getTookTotal(), searchRequestStats.getTookMetric()));
        for (SearchPhaseName searchPhaseName : SearchPhaseName.values()) {
            this.totalStats.requestStatsLongHolder.requestStatsHolder.put(searchPhaseName.getName(), new PhaseStatsLongHolder(searchRequestStats.getPhaseCurrent(searchPhaseName), searchRequestStats.getPhaseTotal(searchPhaseName), searchRequestStats.getPhaseMetric(searchPhaseName)));
        }
    }

    public SearchStats(Stats totalStats, long openContexts, @Nullable Map<String, Stats> groupStats) {
        this.totalStats = totalStats;
        this.openContexts = openContexts;
        this.groupStats = groupStats;
    }

    public SearchStats(StreamInput in) throws IOException {
        this.totalStats = Stats.readStats(in);
        this.openContexts = in.readVLong();
        if (in.readBoolean()) {
            this.groupStats = in.readMap(StreamInput::readString, Stats::readStats);
        }
    }

    public void add(SearchStats searchStats) {
        if (searchStats == null) {
            return;
        }
        this.addTotals(searchStats);
        this.openContexts += searchStats.openContexts;
        if (searchStats.groupStats != null && !searchStats.groupStats.isEmpty()) {
            if (this.groupStats == null) {
                this.groupStats = new HashMap<String, Stats>(searchStats.groupStats.size());
            }
            for (Map.Entry<String, Stats> entry : searchStats.groupStats.entrySet()) {
                this.groupStats.putIfAbsent(entry.getKey(), new Stats());
                this.groupStats.get(entry.getKey()).add(entry.getValue());
            }
        }
    }

    public void addTotals(SearchStats searchStats) {
        if (searchStats == null) {
            return;
        }
        this.totalStats.add(searchStats.totalStats);
    }

    public void addTotalsForClosingShard(SearchStats searchStats) {
        if (searchStats == null) {
            return;
        }
        this.totalStats.addForClosingShard(searchStats.totalStats);
    }

    public Stats getTotal() {
        return this.totalStats;
    }

    public long getOpenContexts() {
        return this.openContexts;
    }

    @Nullable
    public Map<String, Stats> getGroupStats() {
        return this.groupStats != null ? Collections.unmodifiableMap(this.groupStats) : null;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("search");
        builder.field("open_contexts", this.openContexts);
        this.totalStats.toXContent(builder, params);
        if (this.groupStats != null && !this.groupStats.isEmpty()) {
            builder.startObject("groups");
            for (Map.Entry<String, Stats> entry : this.groupStats.entrySet()) {
                builder.startObject(entry.getKey());
                entry.getValue().toXContent(builder, params);
                builder.endObject();
            }
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    public String toString() {
        return Strings.toString(MediaTypeRegistry.JSON, this, true, true);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.totalStats.writeTo(out);
        out.writeVLong(this.openContexts);
        if (this.groupStats == null || this.groupStats.isEmpty()) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeMap(this.groupStats, StreamOutput::writeString, (stream, stats) -> stats.writeTo(stream));
        }
    }

    @PublicApi(since="1.0.0")
    public static class Stats
    implements Writeable,
    ToXContentFragment {
        private long queryCount;
        private long queryTimeInMillis;
        private long queryCurrent;
        private long concurrentQueryCount;
        private long concurrentQueryTimeInMillis;
        private long concurrentQueryCurrent;
        private long queryConcurrency;
        private long fetchCount;
        private long fetchTimeInMillis;
        private long fetchCurrent;
        private long scrollCount;
        private long scrollTimeInMillis;
        private long scrollCurrent;
        private long suggestCount;
        private long suggestTimeInMillis;
        private long suggestCurrent;
        private long pitCount;
        private long pitTimeInMillis;
        private long pitCurrent;
        private long searchIdleReactivateCount;
        @Nullable
        private RequestStatsLongHolder requestStatsLongHolder;

        public RequestStatsLongHolder getRequestStatsLongHolder() {
            return this.requestStatsLongHolder;
        }

        private Stats() {
        }

        public Stats(long queryCount, long queryTimeInMillis, long queryCurrent, long concurrentQueryCount, long concurrentQueryTimeInMillis, long concurrentQueryCurrent, long queryConcurrency, long fetchCount, long fetchTimeInMillis, long fetchCurrent, long scrollCount, long scrollTimeInMillis, long scrollCurrent, long pitCount, long pitTimeInMillis, long pitCurrent, long suggestCount, long suggestTimeInMillis, long suggestCurrent, long searchIdleReactivateCount) {
            this.requestStatsLongHolder = new RequestStatsLongHolder();
            this.queryCount = queryCount;
            this.queryTimeInMillis = queryTimeInMillis;
            this.queryCurrent = queryCurrent;
            this.concurrentQueryCount = concurrentQueryCount;
            this.concurrentQueryTimeInMillis = concurrentQueryTimeInMillis;
            this.concurrentQueryCurrent = concurrentQueryCurrent;
            this.queryConcurrency = queryConcurrency;
            this.fetchCount = fetchCount;
            this.fetchTimeInMillis = fetchTimeInMillis;
            this.fetchCurrent = fetchCurrent;
            this.scrollCount = scrollCount;
            this.scrollTimeInMillis = scrollTimeInMillis;
            this.scrollCurrent = scrollCurrent;
            this.suggestCount = suggestCount;
            this.suggestTimeInMillis = suggestTimeInMillis;
            this.suggestCurrent = suggestCurrent;
            this.pitCount = pitCount;
            this.pitTimeInMillis = pitTimeInMillis;
            this.pitCurrent = pitCurrent;
            this.searchIdleReactivateCount = searchIdleReactivateCount;
        }

        private Stats(StreamInput in) throws IOException {
            this.queryCount = in.readVLong();
            this.queryTimeInMillis = in.readVLong();
            this.queryCurrent = in.readVLong();
            this.fetchCount = in.readVLong();
            this.fetchTimeInMillis = in.readVLong();
            this.fetchCurrent = in.readVLong();
            this.scrollCount = in.readVLong();
            this.scrollTimeInMillis = in.readVLong();
            this.scrollCurrent = in.readVLong();
            this.suggestCount = in.readVLong();
            this.suggestTimeInMillis = in.readVLong();
            this.suggestCurrent = in.readVLong();
            if (in.getVersion().onOrAfter(Version.V_2_4_0)) {
                this.pitCount = in.readVLong();
                this.pitTimeInMillis = in.readVLong();
                this.pitCurrent = in.readVLong();
            }
            if (in.getVersion().onOrAfter(Version.V_2_11_0)) {
                this.requestStatsLongHolder = new RequestStatsLongHolder();
                this.requestStatsLongHolder.requestStatsHolder = in.readMap(StreamInput::readString, PhaseStatsLongHolder::new);
            }
            if (in.getVersion().onOrAfter(Version.V_2_10_0)) {
                this.concurrentQueryCount = in.readVLong();
                this.concurrentQueryTimeInMillis = in.readVLong();
                this.concurrentQueryCurrent = in.readVLong();
                this.queryConcurrency = in.readVLong();
            }
            if (in.getVersion().onOrAfter(Version.V_2_14_0)) {
                this.searchIdleReactivateCount = in.readVLong();
            }
        }

        public void add(Stats stats) {
            this.queryCount += stats.queryCount;
            this.queryTimeInMillis += stats.queryTimeInMillis;
            this.queryCurrent += stats.queryCurrent;
            this.concurrentQueryCount += stats.concurrentQueryCount;
            this.concurrentQueryTimeInMillis += stats.concurrentQueryTimeInMillis;
            this.concurrentQueryCurrent += stats.concurrentQueryCurrent;
            this.queryConcurrency += stats.queryConcurrency;
            this.fetchCount += stats.fetchCount;
            this.fetchTimeInMillis += stats.fetchTimeInMillis;
            this.fetchCurrent += stats.fetchCurrent;
            this.scrollCount += stats.scrollCount;
            this.scrollTimeInMillis += stats.scrollTimeInMillis;
            this.scrollCurrent += stats.scrollCurrent;
            this.suggestCount += stats.suggestCount;
            this.suggestTimeInMillis += stats.suggestTimeInMillis;
            this.suggestCurrent += stats.suggestCurrent;
            this.pitCount += stats.pitCount;
            this.pitTimeInMillis += stats.pitTimeInMillis;
            this.pitCurrent += stats.pitCurrent;
            this.searchIdleReactivateCount += stats.searchIdleReactivateCount;
        }

        public void addForClosingShard(Stats stats) {
            this.queryCount += stats.queryCount;
            this.queryTimeInMillis += stats.queryTimeInMillis;
            this.concurrentQueryCount += stats.concurrentQueryCount;
            this.concurrentQueryTimeInMillis += stats.concurrentQueryTimeInMillis;
            this.fetchCount += stats.fetchCount;
            this.fetchTimeInMillis += stats.fetchTimeInMillis;
            this.scrollCount += stats.scrollCount;
            this.scrollTimeInMillis += stats.scrollTimeInMillis;
            this.scrollCount += stats.scrollCurrent;
            this.suggestCount += stats.suggestCount;
            this.suggestTimeInMillis += stats.suggestTimeInMillis;
            this.pitCount += stats.pitCount;
            this.pitTimeInMillis += stats.pitTimeInMillis;
            this.pitCurrent += stats.pitCurrent;
            this.queryConcurrency += stats.queryConcurrency;
            this.searchIdleReactivateCount += stats.searchIdleReactivateCount;
        }

        public long getQueryCount() {
            return this.queryCount;
        }

        public TimeValue getQueryTime() {
            return new TimeValue(this.queryTimeInMillis);
        }

        public long getQueryTimeInMillis() {
            return this.queryTimeInMillis;
        }

        public long getQueryCurrent() {
            return this.queryCurrent;
        }

        public long getConcurrentQueryCount() {
            return this.concurrentQueryCount;
        }

        public TimeValue getConcurrentQueryTime() {
            return new TimeValue(this.concurrentQueryTimeInMillis);
        }

        public double getConcurrentAvgSliceCount() {
            if (this.concurrentQueryCount == 0L) {
                return 0.0;
            }
            return (double)this.queryConcurrency / (double)this.concurrentQueryCount;
        }

        public long getConcurrentQueryTimeInMillis() {
            return this.concurrentQueryTimeInMillis;
        }

        public long getConcurrentQueryCurrent() {
            return this.concurrentQueryCurrent;
        }

        public long getFetchCount() {
            return this.fetchCount;
        }

        public TimeValue getFetchTime() {
            return new TimeValue(this.fetchTimeInMillis);
        }

        public long getFetchTimeInMillis() {
            return this.fetchTimeInMillis;
        }

        public long getFetchCurrent() {
            return this.fetchCurrent;
        }

        public long getScrollCount() {
            return this.scrollCount;
        }

        public TimeValue getScrollTime() {
            return new TimeValue(this.scrollTimeInMillis);
        }

        public long getScrollTimeInMillis() {
            return this.scrollTimeInMillis;
        }

        public long getScrollCurrent() {
            return this.scrollCurrent;
        }

        public long getPitCount() {
            return this.pitCount;
        }

        public TimeValue getPitTime() {
            return new TimeValue(this.pitTimeInMillis);
        }

        public long getPitTimeInMillis() {
            return this.pitTimeInMillis;
        }

        public long getPitCurrent() {
            return this.pitCurrent;
        }

        public long getSuggestCount() {
            return this.suggestCount;
        }

        public long getSuggestTimeInMillis() {
            return this.suggestTimeInMillis;
        }

        public TimeValue getSuggestTime() {
            return new TimeValue(this.suggestTimeInMillis);
        }

        public long getSuggestCurrent() {
            return this.suggestCurrent;
        }

        public long getSearchIdleReactivateCount() {
            return this.searchIdleReactivateCount;
        }

        public static Stats readStats(StreamInput in) throws IOException {
            return new Stats(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVLong(this.queryCount);
            out.writeVLong(this.queryTimeInMillis);
            out.writeVLong(this.queryCurrent);
            out.writeVLong(this.fetchCount);
            out.writeVLong(this.fetchTimeInMillis);
            out.writeVLong(this.fetchCurrent);
            out.writeVLong(this.scrollCount);
            out.writeVLong(this.scrollTimeInMillis);
            out.writeVLong(this.scrollCurrent);
            out.writeVLong(this.suggestCount);
            out.writeVLong(this.suggestTimeInMillis);
            out.writeVLong(this.suggestCurrent);
            if (out.getVersion().onOrAfter(Version.V_2_4_0)) {
                out.writeVLong(this.pitCount);
                out.writeVLong(this.pitTimeInMillis);
                out.writeVLong(this.pitCurrent);
            }
            if (out.getVersion().onOrAfter(Version.V_2_11_0)) {
                if (this.requestStatsLongHolder == null) {
                    this.requestStatsLongHolder = new RequestStatsLongHolder();
                }
                out.writeMap(this.requestStatsLongHolder.getRequestStatsHolder(), StreamOutput::writeString, (stream, stats) -> stats.writeTo(stream));
            }
            if (out.getVersion().onOrAfter(Version.V_2_10_0)) {
                out.writeVLong(this.concurrentQueryCount);
                out.writeVLong(this.concurrentQueryTimeInMillis);
                out.writeVLong(this.concurrentQueryCurrent);
                out.writeVLong(this.queryConcurrency);
            }
            if (out.getVersion().onOrAfter(Version.V_2_14_0)) {
                out.writeVLong(this.searchIdleReactivateCount);
            }
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field("query_total", this.queryCount);
            builder.humanReadableField("query_time_in_millis", "query_time", this.getQueryTime());
            builder.field("query_current", this.queryCurrent);
            builder.field("concurrent_query_total", this.concurrentQueryCount);
            builder.humanReadableField("concurrent_query_time_in_millis", "concurrent_query_time", this.getConcurrentQueryTime());
            builder.field("concurrent_query_current", this.concurrentQueryCurrent);
            builder.field("concurrent_avg_slice_count", this.getConcurrentAvgSliceCount());
            builder.field("fetch_total", this.fetchCount);
            builder.humanReadableField("fetch_time_in_millis", "fetch_time", this.getFetchTime());
            builder.field("fetch_current", this.fetchCurrent);
            builder.field("scroll_total", this.scrollCount);
            builder.humanReadableField("scroll_time_in_millis", "scroll_time", this.getScrollTime());
            builder.field("scroll_current", this.scrollCurrent);
            builder.field("point_in_time_total", this.pitCount);
            builder.humanReadableField("point_in_time_time_in_millis", "point_in_time_time", this.getPitTime());
            builder.field("point_in_time_current", this.pitCurrent);
            builder.field("suggest_total", this.suggestCount);
            builder.humanReadableField("suggest_time_in_millis", "suggest_time", this.getSuggestTime());
            builder.field("suggest_current", this.suggestCurrent);
            builder.field("search_idle_reactivate_count_total", this.searchIdleReactivateCount);
            if (this.requestStatsLongHolder != null) {
                builder.startObject("request");
                PhaseStatsLongHolder tookStatsLongHolder = this.requestStatsLongHolder.requestStatsHolder.get("took");
                if (tookStatsLongHolder != null) {
                    builder.startObject("took");
                    builder.humanReadableField("time_in_millis", "time", new TimeValue(tookStatsLongHolder.timeInMillis));
                    builder.field("current", tookStatsLongHolder.current);
                    builder.field("total", tookStatsLongHolder.total);
                    builder.endObject();
                }
                for (SearchPhaseName searchPhaseName : SearchPhaseName.values()) {
                    PhaseStatsLongHolder statsLongHolder = this.requestStatsLongHolder.requestStatsHolder.get(searchPhaseName.getName());
                    if (statsLongHolder == null) continue;
                    builder.startObject(searchPhaseName.getName());
                    builder.humanReadableField("time_in_millis", "time", new TimeValue(statsLongHolder.timeInMillis));
                    builder.field("current", statsLongHolder.current);
                    builder.field("total", statsLongHolder.total);
                    builder.endObject();
                }
                builder.endObject();
            }
            return builder;
        }
    }

    @PublicApi(since="1.0.0")
    public static class RequestStatsLongHolder {
        Map<String, PhaseStatsLongHolder> requestStatsHolder = new HashMap<String, PhaseStatsLongHolder>();

        public Map<String, PhaseStatsLongHolder> getRequestStatsHolder() {
            return this.requestStatsHolder;
        }

        RequestStatsLongHolder() {
            this.requestStatsHolder.put("took", new PhaseStatsLongHolder());
            for (SearchPhaseName searchPhaseName : SearchPhaseName.values()) {
                this.requestStatsHolder.put(searchPhaseName.getName(), new PhaseStatsLongHolder());
            }
        }
    }

    static final class Fields {
        static final String SEARCH = "search";
        static final String OPEN_CONTEXTS = "open_contexts";
        static final String GROUPS = "groups";
        static final String QUERY_TOTAL = "query_total";
        static final String QUERY_TIME = "query_time";
        static final String QUERY_TIME_IN_MILLIS = "query_time_in_millis";
        static final String QUERY_CURRENT = "query_current";
        static final String CONCURRENT_QUERY_TOTAL = "concurrent_query_total";
        static final String CONCURRENT_QUERY_TIME = "concurrent_query_time";
        static final String CONCURRENT_QUERY_TIME_IN_MILLIS = "concurrent_query_time_in_millis";
        static final String CONCURRENT_QUERY_CURRENT = "concurrent_query_current";
        static final String CONCURRENT_AVG_SLICE_COUNT = "concurrent_avg_slice_count";
        static final String FETCH_TOTAL = "fetch_total";
        static final String FETCH_TIME = "fetch_time";
        static final String FETCH_TIME_IN_MILLIS = "fetch_time_in_millis";
        static final String FETCH_CURRENT = "fetch_current";
        static final String SCROLL_TOTAL = "scroll_total";
        static final String SCROLL_TIME = "scroll_time";
        static final String SCROLL_TIME_IN_MILLIS = "scroll_time_in_millis";
        static final String SCROLL_CURRENT = "scroll_current";
        static final String PIT_TOTAL = "point_in_time_total";
        static final String PIT_TIME = "point_in_time_time";
        static final String PIT_TIME_IN_MILLIS = "point_in_time_time_in_millis";
        static final String PIT_CURRENT = "point_in_time_current";
        static final String SUGGEST_TOTAL = "suggest_total";
        static final String SUGGEST_TIME = "suggest_time";
        static final String SUGGEST_TIME_IN_MILLIS = "suggest_time_in_millis";
        static final String SUGGEST_CURRENT = "suggest_current";
        static final String REQUEST = "request";
        static final String TIME_IN_MILLIS = "time_in_millis";
        static final String TIME = "time";
        static final String CURRENT = "current";
        static final String TOTAL = "total";
        static final String SEARCH_IDLE_REACTIVATE_COUNT_TOTAL = "search_idle_reactivate_count_total";
        static final String TOOK = "took";

        Fields() {
        }
    }

    @PublicApi(since="1.0.0")
    public static class PhaseStatsLongHolder
    implements Writeable {
        long current;
        long total;
        long timeInMillis;

        public long getCurrent() {
            return this.current;
        }

        public long getTotal() {
            return this.total;
        }

        public long getTimeInMillis() {
            return this.timeInMillis;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVLong(this.current);
            out.writeVLong(this.total);
            out.writeVLong(this.timeInMillis);
        }

        PhaseStatsLongHolder() {
            this(0L, 0L, 0L);
        }

        PhaseStatsLongHolder(long current, long total, long timeInMillis) {
            this.current = current;
            this.total = total;
            this.timeInMillis = timeInMillis;
        }

        PhaseStatsLongHolder(StreamInput in) throws IOException {
            this.current = in.readVLong();
            this.total = in.readVLong();
            this.timeInMillis = in.readVLong();
        }
    }
}

