/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.snapshots.blobstore;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.IntStream;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.Version;
import org.opensearch.OpenSearchParseException;
import org.opensearch.common.lucene.Lucene;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.unit.ByteSizeValue;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.index.snapshots.IndexShardSnapshotStatus;
import org.opensearch.index.snapshots.blobstore.IndexShardSnapshot;
import org.opensearch.index.store.StoreFileMetadata;

public class BlobStoreIndexShardSnapshot
implements ToXContentFragment,
IndexShardSnapshot {
    private final String snapshot;
    private final long indexVersion;
    private final long startTime;
    private final long time;
    private final int incrementalFileCount;
    private final long incrementalSize;
    private final List<FileInfo> indexFiles;
    private static final String NAME = "name";
    private static final String INDEX_VERSION = "index_version";
    private static final String START_TIME = "start_time";
    private static final String TIME = "time";
    private static final String FILES = "files";
    private static final String INCREMENTAL_FILE_COUNT = "number_of_files";
    private static final String INCREMENTAL_SIZE = "total_size";
    private static final ParseField PARSE_NAME = new ParseField("name", new String[0]);
    private static final ParseField PARSE_INDEX_VERSION = new ParseField("index_version", "index-version");
    private static final ParseField PARSE_START_TIME = new ParseField("start_time", new String[0]);
    private static final ParseField PARSE_TIME = new ParseField("time", new String[0]);
    private static final ParseField PARSE_INCREMENTAL_FILE_COUNT = new ParseField("number_of_files", new String[0]);
    private static final ParseField PARSE_INCREMENTAL_SIZE = new ParseField("total_size", new String[0]);
    private static final ParseField PARSE_FILES = new ParseField("files", new String[0]);

    public BlobStoreIndexShardSnapshot(String snapshot, long indexVersion, List<FileInfo> indexFiles, long startTime, long time, int incrementalFileCount, long incrementalSize) {
        assert (snapshot != null);
        assert (indexVersion >= 0L);
        this.snapshot = snapshot;
        this.indexVersion = indexVersion;
        this.indexFiles = Collections.unmodifiableList(new ArrayList<FileInfo>(indexFiles));
        this.startTime = startTime;
        this.time = time;
        this.incrementalFileCount = incrementalFileCount;
        this.incrementalSize = incrementalSize;
    }

    public BlobStoreIndexShardSnapshot asClone(String targetSnapshotName, long startTime, long time) {
        return new BlobStoreIndexShardSnapshot(targetSnapshotName, this.indexVersion, this.indexFiles, startTime, time, 0, 0L);
    }

    public String snapshot() {
        return this.snapshot;
    }

    public List<FileInfo> indexFiles() {
        return this.indexFiles;
    }

    public long startTime() {
        return this.startTime;
    }

    public long time() {
        return this.time;
    }

    public int incrementalFileCount() {
        return this.incrementalFileCount;
    }

    public int totalFileCount() {
        return this.indexFiles.size();
    }

    public long incrementalSize() {
        return this.incrementalSize;
    }

    public long totalSize() {
        return this.indexFiles.stream().mapToLong(fi -> fi.metadata().length()).sum();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(NAME, this.snapshot);
        builder.field(INDEX_VERSION, this.indexVersion);
        builder.field(START_TIME, this.startTime);
        builder.field(TIME, this.time);
        builder.field(INCREMENTAL_FILE_COUNT, this.incrementalFileCount);
        builder.field(INCREMENTAL_SIZE, this.incrementalSize);
        builder.startArray(FILES);
        for (FileInfo fileInfo : this.indexFiles) {
            FileInfo.toXContent(fileInfo, builder, params);
        }
        builder.endArray();
        return builder;
    }

    public static BlobStoreIndexShardSnapshot fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        String snapshot = null;
        long indexVersion = -1L;
        long startTime = 0L;
        long time = 0L;
        int incrementalFileCount = 0;
        long incrementalSize = 0L;
        ArrayList<FileInfo> indexFiles = new ArrayList<FileInfo>();
        if (parser.currentToken() == null) {
            parser.nextToken();
        }
        if ((token = parser.currentToken()) == XContentParser.Token.START_OBJECT) {
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                XContentParserUtils.ensureExpectedToken(XContentParser.Token.FIELD_NAME, token, parser);
                String currentFieldName = parser.currentName();
                token = parser.nextToken();
                if (token.isValue()) {
                    if (PARSE_NAME.match(currentFieldName, parser.getDeprecationHandler())) {
                        snapshot = parser.text();
                        continue;
                    }
                    if (PARSE_INDEX_VERSION.match(currentFieldName, parser.getDeprecationHandler())) {
                        indexVersion = parser.longValue();
                        continue;
                    }
                    if (PARSE_START_TIME.match(currentFieldName, parser.getDeprecationHandler())) {
                        startTime = parser.longValue();
                        continue;
                    }
                    if (PARSE_TIME.match(currentFieldName, parser.getDeprecationHandler())) {
                        time = parser.longValue();
                        continue;
                    }
                    if (PARSE_INCREMENTAL_FILE_COUNT.match(currentFieldName, parser.getDeprecationHandler())) {
                        incrementalFileCount = parser.intValue();
                        continue;
                    }
                    if (PARSE_INCREMENTAL_SIZE.match(currentFieldName, parser.getDeprecationHandler())) {
                        incrementalSize = parser.longValue();
                        continue;
                    }
                    throw new OpenSearchParseException("unknown parameter [{}]", currentFieldName);
                }
                if (token == XContentParser.Token.START_ARRAY) {
                    if (PARSE_FILES.match(currentFieldName, parser.getDeprecationHandler())) {
                        while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                            indexFiles.add(FileInfo.fromXContent(parser));
                        }
                        continue;
                    }
                    throw new OpenSearchParseException("unknown parameter [{}]", currentFieldName);
                }
                throw new OpenSearchParseException("unexpected token [{}]", new Object[]{token});
            }
        }
        return new BlobStoreIndexShardSnapshot(snapshot, indexVersion, Collections.unmodifiableList(indexFiles), startTime, time, incrementalFileCount, incrementalSize);
    }

    @Override
    public IndexShardSnapshotStatus getIndexShardSnapshotStatus() {
        return IndexShardSnapshotStatus.newDone(this.startTime, this.time, this.incrementalFileCount, this.totalFileCount(), this.incrementalSize, this.totalSize(), null);
    }

    public static class FileInfo {
        private final String name;
        private final ByteSizeValue partSize;
        private final long partBytes;
        private final int numberOfParts;
        private final StoreFileMetadata metadata;
        static final String NAME = "name";
        static final String PHYSICAL_NAME = "physical_name";
        static final String LENGTH = "length";
        static final String CHECKSUM = "checksum";
        static final String PART_SIZE = "part_size";
        static final String WRITTEN_BY = "written_by";
        static final String META_HASH = "meta_hash";

        public FileInfo(String name, StoreFileMetadata metadata, ByteSizeValue partSize) {
            this.name = name;
            this.metadata = metadata;
            long partBytes = Long.MAX_VALUE;
            if (partSize != null && partSize.getBytes() > 0L) {
                partBytes = partSize.getBytes();
            }
            if (metadata.length() == 0L) {
                this.numberOfParts = 1;
            } else {
                long longNumberOfParts = 1L + (metadata.length() - 1L) / partBytes;
                this.numberOfParts = (int)longNumberOfParts;
                if ((long)this.numberOfParts != longNumberOfParts) {
                    throw new IllegalArgumentException("part size [" + String.valueOf(partSize) + "] too small for file [" + String.valueOf(metadata) + "]");
                }
            }
            this.partSize = partSize;
            this.partBytes = partBytes;
            assert (IntStream.range(0, this.numberOfParts).mapToLong(this::partBytes).sum() == metadata.length());
        }

        public String name() {
            return this.name;
        }

        public String partName(int part) {
            if (this.numberOfParts > 1) {
                return this.name + ".part" + part;
            }
            return this.name;
        }

        public static String canonicalName(String blobName) {
            if (blobName.contains(".part")) {
                return blobName.substring(0, blobName.indexOf(".part"));
            }
            return blobName;
        }

        public String physicalName() {
            return this.metadata.name();
        }

        public long length() {
            return this.metadata.length();
        }

        public ByteSizeValue partSize() {
            return this.partSize;
        }

        public long partBytes(int part) {
            assert (0 <= part && part < this.numberOfParts) : part + " vs " + this.numberOfParts;
            if (this.numberOfParts == 1) {
                return this.length();
            }
            if (part < this.numberOfParts - 1) {
                return this.partBytes;
            }
            long lastPartBytes = this.length() - this.partBytes * (long)(this.numberOfParts - 1);
            assert (0L < lastPartBytes && lastPartBytes <= this.partBytes) : lastPartBytes + " vs " + this.partBytes;
            return lastPartBytes;
        }

        public int numberOfParts() {
            return this.numberOfParts;
        }

        public String checksum() {
            return this.metadata.checksum();
        }

        public StoreFileMetadata metadata() {
            return this.metadata;
        }

        public boolean isSame(StoreFileMetadata md) {
            return this.metadata.isSame(md);
        }

        public boolean isSame(FileInfo fileInfo) {
            if (this.numberOfParts != fileInfo.numberOfParts) {
                return false;
            }
            if (this.partBytes != fileInfo.partBytes) {
                return false;
            }
            if (!this.name.equals(fileInfo.name)) {
                return false;
            }
            if (this.partSize != null ? !this.partSize.equals(fileInfo.partSize) : fileInfo.partSize != null) {
                return false;
            }
            return this.metadata.isSame(fileInfo.metadata);
        }

        public static void toXContent(FileInfo file, XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("name", file.name);
            builder.field(PHYSICAL_NAME, file.metadata.name());
            builder.field(LENGTH, file.metadata.length());
            builder.field(CHECKSUM, file.metadata.checksum());
            if (file.partSize != null) {
                builder.field(PART_SIZE, file.partSize.getBytes());
            }
            if (file.metadata.writtenBy() != null) {
                builder.field(WRITTEN_BY, file.metadata.writtenBy());
            }
            if (file.metadata.hash() != null && file.metadata().hash().length > 0) {
                BytesRef br = file.metadata.hash();
                builder.field(META_HASH, br.bytes, br.offset, br.length);
            }
            builder.endObject();
        }

        public static FileInfo fromXContent(XContentParser parser) throws IOException {
            XContentParser.Token token = parser.currentToken();
            String name = null;
            String physicalName = null;
            long length = -1L;
            String checksum = null;
            ByteSizeValue partSize = null;
            Version writtenBy = null;
            String writtenByStr = null;
            BytesRef metaHash = new BytesRef();
            if (token == XContentParser.Token.START_OBJECT) {
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        String currentFieldName = parser.currentName();
                        token = parser.nextToken();
                        if (token.isValue()) {
                            if ("name".equals(currentFieldName)) {
                                name = parser.text();
                                continue;
                            }
                            if (PHYSICAL_NAME.equals(currentFieldName)) {
                                physicalName = parser.text();
                                continue;
                            }
                            if (LENGTH.equals(currentFieldName)) {
                                length = parser.longValue();
                                continue;
                            }
                            if (CHECKSUM.equals(currentFieldName)) {
                                checksum = parser.text();
                                continue;
                            }
                            if (PART_SIZE.equals(currentFieldName)) {
                                partSize = new ByteSizeValue(parser.longValue());
                                continue;
                            }
                            if (WRITTEN_BY.equals(currentFieldName)) {
                                writtenByStr = parser.text();
                                writtenBy = Lucene.parseVersionLenient(writtenByStr, null);
                                continue;
                            }
                            if (META_HASH.equals(currentFieldName)) {
                                metaHash.bytes = parser.binaryValue();
                                metaHash.offset = 0;
                                metaHash.length = metaHash.bytes.length;
                                continue;
                            }
                            throw new OpenSearchParseException("unknown parameter [{}]", currentFieldName);
                        }
                        throw new OpenSearchParseException("unexpected token  [{}]", new Object[]{token});
                    }
                    throw new OpenSearchParseException("unexpected token [{}]", new Object[]{token});
                }
            }
            if (name == null || !Strings.validFileName(name)) {
                throw new OpenSearchParseException("missing or invalid file name [" + name + "]", new Object[0]);
            }
            if (physicalName == null || !Strings.validFileName(physicalName)) {
                throw new OpenSearchParseException("missing or invalid physical file name [" + physicalName + "]", new Object[0]);
            }
            if (length < 0L) {
                throw new OpenSearchParseException("missing or invalid file length", new Object[0]);
            }
            if (writtenBy == null) {
                throw new OpenSearchParseException("missing or invalid written_by [" + writtenByStr + "]", new Object[0]);
            }
            if (checksum == null) {
                throw new OpenSearchParseException("missing checksum for name [" + name + "]", new Object[0]);
            }
            return new FileInfo(name, new StoreFileMetadata(physicalName, length, checksum, writtenBy, metaHash), partSize);
        }

        public String toString() {
            return "[name: " + this.name + ", numberOfParts: " + this.numberOfParts + ", partSize: " + String.valueOf(this.partSize) + ", partBytes: " + this.partBytes + ", metadata: " + String.valueOf(this.metadata) + "]";
        }
    }
}

