/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest.action.document;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.bulk.BulkItemResponse;
import org.opensearch.action.bulk.BulkRequest;
import org.opensearch.action.bulk.BulkResponse;
import org.opensearch.action.bulk.BulkShardRequest;
import org.opensearch.action.support.ActiveShardCount;
import org.opensearch.client.Requests;
import org.opensearch.client.node.NodeClient;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.common.collect.Tuple;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.xcontent.support.XContentHttpChunk;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.http.HttpChunk;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.StreamingRestChannel;
import org.opensearch.search.fetch.subphase.FetchSourceContext;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@ExperimentalApi
public class RestBulkStreamingAction
extends BaseRestHandler {
    private static final BulkResponse EMPTY = new BulkResponse(new BulkItemResponse[0], 0L);
    private final boolean allowExplicitIndex;

    public RestBulkStreamingAction(Settings settings) {
        this.allowExplicitIndex = (Boolean)MULTI_ALLOW_EXPLICIT_INDEX.get(settings);
    }

    @Override
    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.POST, "/_bulk/stream"), new RestHandler.Route(RestRequest.Method.PUT, "/_bulk/stream"), new RestHandler.Route(RestRequest.Method.POST, "/{index}/_bulk/stream"), new RestHandler.Route(RestRequest.Method.PUT, "/{index}/_bulk/stream")));
    }

    @Override
    public String getName() {
        return "streaming_bulk_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String defaultIndex = request.param("index");
        String defaultRouting = request.param("routing");
        String defaultPipeline = request.param("pipeline");
        String waitForActiveShards = request.param("wait_for_active_shards");
        Boolean defaultRequireAlias = request.paramAsBoolean("require_alias", null);
        TimeValue timeout = request.paramAsTime("timeout", BulkShardRequest.DEFAULT_TIMEOUT);
        String refresh = request.param("refresh");
        TimeValue batchInterval = request.paramAsTime("batch_interval", null);
        int batchSize = request.paramAsInt("batch_size", 1);
        boolean hasBatchSize = request.hasParam("batch_size");
        if (batchInterval != null && batchInterval.duration() <= 0L) {
            throw new IllegalArgumentException("The batch_interval value should be non-negative [" + batchInterval.millis() + "ms].");
        }
        if (batchSize <= 0) {
            throw new IllegalArgumentException("The batch_size value should be non-negative [" + batchSize + "].");
        }
        BaseRestHandler.StreamingRestChannelConsumer consumer = channel -> {
            MediaType mediaType = request.getMediaType();
            FetchSourceContext defaultFetchSourceContext = FetchSourceContext.parseFromRestRequest(request);
            BulkRequest prepareBulkRequest = Requests.bulkRequest();
            if (waitForActiveShards != null) {
                prepareBulkRequest.waitForActiveShards(ActiveShardCount.parseString(waitForActiveShards));
            }
            prepareBulkRequest.timeout(timeout);
            prepareBulkRequest.setRefreshPolicy(refresh);
            channel.prepareResponse(RestStatus.OK, Map.of("Content-Type", List.of(mediaType.mediaTypeWithoutParameters())));
            this.createBufferedFlux(batchInterval, batchSize, hasBatchSize, (StreamingRestChannel)channel).zipWith((Publisher)Flux.fromStream(Stream.generate(() -> {
                BulkRequest bulkRequest = Requests.bulkRequest();
                bulkRequest.waitForActiveShards(prepareBulkRequest.waitForActiveShards());
                bulkRequest.timeout(prepareBulkRequest.timeout());
                bulkRequest.setRefreshPolicy(prepareBulkRequest.getRefreshPolicy());
                return bulkRequest;
            }))).map(t -> {
                boolean isLast = false;
                List chunks = (List)t.getT1();
                BulkRequest bulkRequest = (BulkRequest)t.getT2();
                for (HttpChunk chunk : chunks) {
                    isLast |= chunk.isLast();
                    try {
                        HttpChunk httpChunk = chunk;
                        try {
                            bulkRequest.add(chunk.content(), defaultIndex, defaultRouting, defaultFetchSourceContext, defaultPipeline, defaultRequireAlias, this.allowExplicitIndex, request.getMediaType());
                        }
                        finally {
                            if (httpChunk == null) continue;
                            httpChunk.close();
                        }
                    }
                    catch (IOException ex) {
                        throw new UncheckedIOException(ex);
                    }
                }
                return Tuple.tuple(isLast, bulkRequest);
            }).flatMap(tuple -> {
                final CompletableFuture<BulkResponse> f = new CompletableFuture<BulkResponse>();
                if (((BulkRequest)tuple.v2()).requests().isEmpty()) {
                    f.complete(EMPTY);
                } else {
                    client.bulk((BulkRequest)tuple.v2(), new ActionListener<BulkResponse>(){

                        @Override
                        public void onResponse(BulkResponse response) {
                            f.complete(response);
                        }

                        @Override
                        public void onFailure(Exception ex) {
                            f.completeExceptionally(ex);
                        }
                    });
                    if (((Boolean)tuple.v1()).booleanValue()) {
                        return Flux.just((Object[])new CompletableFuture[]{f, CompletableFuture.completedFuture(EMPTY)});
                    }
                }
                return Mono.just(f);
            }).concatMap(f -> Mono.fromFuture((CompletableFuture)f).doOnNext(r -> {
                block9: {
                    try {
                        if (r == EMPTY) {
                            channel.sendChunk(XContentHttpChunk.last());
                            break block9;
                        }
                        try (XContentBuilder builder = channel.newBuilder(mediaType, true);){
                            channel.sendChunk(XContentHttpChunk.from(r.toXContent(builder, ToXContent.EMPTY_PARAMS)));
                        }
                    }
                    catch (IOException ex) {
                        throw new UncheckedIOException(ex);
                    }
                }
            })).onErrorComplete(ex -> {
                if (ex instanceof Error) {
                    return false;
                }
                try {
                    channel.sendResponse(new BytesRestResponse((RestChannel)channel, (Exception)ex));
                    return true;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }).subscribe();
        };
        return channel -> {
            if (channel instanceof StreamingRestChannel) {
                consumer.accept((StreamingRestChannel)channel);
            } else {
                ActionRequestValidationException validationError = new ActionRequestValidationException();
                validationError.addValidationError("Unable to initiate request / response streaming over non-streaming channel");
                channel.sendResponse(new BytesRestResponse((RestChannel)channel, validationError));
            }
        };
    }

    @Override
    public boolean supportsContentStream() {
        return true;
    }

    @Override
    public boolean supportsStreaming() {
        return true;
    }

    @Override
    public boolean allowsUnsafeBuffers() {
        return true;
    }

    private Flux<List<HttpChunk>> createBufferedFlux(TimeValue batchInterval, int batchSize, boolean hasBatchSize, StreamingRestChannel channel) {
        if (batchInterval != null) {
            if (hasBatchSize) {
                return Flux.from((Publisher)channel).bufferTimeout(batchSize, Duration.ofMillis(batchInterval.millis()));
            }
            return Flux.from((Publisher)channel).buffer(Duration.ofMillis(batchInterval.millis()));
        }
        return Flux.from((Publisher)channel).buffer(batchSize);
    }
}

