/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.pipeline;

import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.opensearch.LegacyESVersion;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ConstructingObjectParser;
import org.opensearch.core.xcontent.ObjectParser;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.script.Script;
import org.opensearch.search.DocValueFormat;
import org.opensearch.search.aggregations.PipelineAggregationBuilder;
import org.opensearch.search.aggregations.pipeline.AbstractPipelineAggregationBuilder;
import org.opensearch.search.aggregations.pipeline.BucketHelpers;
import org.opensearch.search.aggregations.pipeline.MovFnPipelineAggregator;
import org.opensearch.search.aggregations.pipeline.PipelineAggregator;

public class MovFnPipelineAggregationBuilder
extends AbstractPipelineAggregationBuilder<MovFnPipelineAggregationBuilder> {
    public static final String NAME = "moving_fn";
    private static final ParseField WINDOW = new ParseField("window", new String[0]);
    private static final ParseField SHIFT = new ParseField("shift", new String[0]);
    private final Script script;
    private final String bucketsPathString;
    private String format = null;
    private BucketHelpers.GapPolicy gapPolicy = BucketHelpers.GapPolicy.SKIP;
    private int window;
    private int shift;
    public static final ConstructingObjectParser<MovFnPipelineAggregationBuilder, String> PARSER = new ConstructingObjectParser<MovFnPipelineAggregationBuilder, String>("moving_fn", false, (args, name) -> new MovFnPipelineAggregationBuilder((String)name, (String)args[0], (Script)args[1], (Integer)args[2]));

    public MovFnPipelineAggregationBuilder(String name, String bucketsPath, Script script, int window) {
        super(name, NAME, new String[]{bucketsPath});
        this.bucketsPathString = bucketsPath;
        this.script = script;
        if (window <= 0) {
            throw new IllegalArgumentException("[" + WINDOW.getPreferredName() + "] must be a positive, non-zero integer.");
        }
        this.window = window;
    }

    public MovFnPipelineAggregationBuilder(StreamInput in) throws IOException {
        super(in, NAME);
        this.bucketsPathString = in.readString();
        this.script = new Script(in);
        this.format = in.readOptionalString();
        this.gapPolicy = BucketHelpers.GapPolicy.readFrom(in);
        this.window = in.readInt();
        this.shift = in.getVersion().onOrAfter(LegacyESVersion.V_7_4_0) ? in.readInt() : 0;
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeString(this.bucketsPathString);
        this.script.writeTo(out);
        out.writeOptionalString(this.format);
        this.gapPolicy.writeTo(out);
        out.writeInt(this.window);
        if (out.getVersion().onOrAfter(LegacyESVersion.V_7_4_0)) {
            out.writeInt(this.shift);
        }
    }

    public MovFnPipelineAggregationBuilder format(String format) {
        if (Strings.isNullOrEmpty(format)) {
            throw new IllegalArgumentException("[" + PipelineAggregator.Parser.FORMAT.getPreferredName() + "] must not be null or an empty string.");
        }
        this.format = format;
        return this;
    }

    public String format() {
        return this.format;
    }

    protected DocValueFormat formatter() {
        if (this.format != null) {
            return new DocValueFormat.Decimal(this.format);
        }
        return DocValueFormat.RAW;
    }

    public MovFnPipelineAggregationBuilder gapPolicy(BucketHelpers.GapPolicy gapPolicy) {
        if (gapPolicy == null) {
            throw new IllegalArgumentException("[" + PipelineAggregator.Parser.GAP_POLICY.getPreferredName() + "] must not be null.");
        }
        this.gapPolicy = gapPolicy;
        return this;
    }

    public BucketHelpers.GapPolicy gapPolicy() {
        return this.gapPolicy;
    }

    public int getWindow() {
        return this.window;
    }

    public void setWindow(int window) {
        if (window <= 0) {
            throw new IllegalArgumentException("[" + WINDOW.getPreferredName() + "] must be a positive, non-zero integer.");
        }
        this.window = window;
    }

    public void setShift(int shift) {
        this.shift = shift;
    }

    @Override
    protected void validate(PipelineAggregationBuilder.ValidationContext context) {
        if (this.window <= 0) {
            context.addValidationError("[" + WINDOW.getPreferredName() + "] must be a positive, non-zero integer.");
        }
        context.validateParentAggSequentiallyOrdered(NAME, this.name);
    }

    @Override
    protected PipelineAggregator createInternal(Map<String, Object> metadata) {
        return new MovFnPipelineAggregator(this.name, this.bucketsPathString, this.script, this.window, this.shift, this.formatter(), this.gapPolicy, metadata);
    }

    @Override
    protected XContentBuilder internalXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(PipelineAggregator.Parser.BUCKETS_PATH.getPreferredName(), this.bucketsPathString);
        builder.field(Script.SCRIPT_PARSE_FIELD.getPreferredName(), this.script);
        if (this.format != null) {
            builder.field(PipelineAggregator.Parser.FORMAT.getPreferredName(), this.format);
        }
        builder.field(PipelineAggregator.Parser.GAP_POLICY.getPreferredName(), this.gapPolicy.getName());
        builder.field(WINDOW.getPreferredName(), this.window);
        builder.field(SHIFT.getPreferredName(), this.shift);
        return builder;
    }

    static MovFnPipelineAggregationBuilder parse(XContentParser parser) throws IOException {
        parser.nextToken();
        if (parser.currentToken().equals((Object)XContentParser.Token.START_OBJECT)) {
            parser.nextToken();
            if (parser.currentToken().equals((Object)XContentParser.Token.FIELD_NAME)) {
                String aggName = parser.currentName();
                parser.nextToken();
                parser.nextToken();
                return PARSER.apply(parser, aggName);
            }
        }
        throw new IllegalStateException("Expected aggregation name but none found");
    }

    @Override
    protected boolean overrideBucketsPath() {
        return true;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.bucketsPathString, this.script, this.format, this.gapPolicy, this.window, this.shift);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        MovFnPipelineAggregationBuilder other = (MovFnPipelineAggregationBuilder)obj;
        return Objects.equals(this.bucketsPathString, other.bucketsPathString) && Objects.equals(this.script, other.script) && Objects.equals(this.format, other.format) && Objects.equals(this.gapPolicy, other.gapPolicy) && Objects.equals(this.window, other.window) && Objects.equals(this.shift, other.shift);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), BUCKETS_PATH_FIELD);
        PARSER.declareField(ConstructingObjectParser.constructorArg(), (p, c) -> Script.parse(p), Script.SCRIPT_PARSE_FIELD, ObjectParser.ValueType.OBJECT_OR_STRING);
        PARSER.declareInt(ConstructingObjectParser.constructorArg(), WINDOW);
        PARSER.declareInt(MovFnPipelineAggregationBuilder::setShift, SHIFT);
        PARSER.declareString(MovFnPipelineAggregationBuilder::format, PipelineAggregator.Parser.FORMAT);
        PARSER.declareField(MovFnPipelineAggregationBuilder::gapPolicy, p -> {
            if (p.currentToken() == XContentParser.Token.VALUE_STRING) {
                return BucketHelpers.GapPolicy.parse(p.text().toLowerCase(Locale.ROOT), p.getTokenLocation());
            }
            throw new IllegalArgumentException("Unsupported token [" + String.valueOf((Object)p.currentToken()) + "]");
        }, PipelineAggregator.Parser.GAP_POLICY, ObjectParser.ValueType.STRING);
    }
}

