/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.dfs;

import java.io.IOException;
import java.util.HashMap;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.CollectionStatistics;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.TermStatistics;
import org.opensearch.core.tasks.TaskCancelledException;
import org.opensearch.search.dfs.DfsPhaseExecutionException;
import org.opensearch.search.internal.SearchContext;
import org.opensearch.search.rescore.RescoreContext;

public class DfsPhase {
    public void execute(final SearchContext context) {
        try {
            final HashMap<String, CollectionStatistics> fieldStatistics = new HashMap<String, CollectionStatistics>();
            final HashMap stats = new HashMap();
            IndexSearcher searcher = new IndexSearcher(context.searcher().getIndexReader()){

                @Override
                public TermStatistics termStatistics(Term term, int docFreq, long totalTermFreq) throws IOException {
                    if (context.isCancelled()) {
                        throw new TaskCancelledException("cancelled task with reason: " + context.getTask().getReasonCancelled());
                    }
                    TermStatistics ts = super.termStatistics(term, docFreq, totalTermFreq);
                    if (ts != null) {
                        stats.put(term, ts);
                    }
                    return ts;
                }

                @Override
                public CollectionStatistics collectionStatistics(String field) throws IOException {
                    if (context.isCancelled()) {
                        throw new TaskCancelledException("cancelled task with reason: " + context.getTask().getReasonCancelled());
                    }
                    CollectionStatistics cs = super.collectionStatistics(field);
                    if (cs != null) {
                        fieldStatistics.put(field, cs);
                    }
                    return cs;
                }
            };
            searcher.createWeight(context.searcher().rewrite(context.query()), ScoreMode.COMPLETE, 1.0f);
            for (RescoreContext rescoreContext : context.rescore()) {
                for (Query query : rescoreContext.getQueries()) {
                    searcher.createWeight(context.searcher().rewrite(query), ScoreMode.COMPLETE, 1.0f);
                }
            }
            Term[] terms = stats.keySet().toArray(new Term[0]);
            TermStatistics[] termStatistics = new TermStatistics[terms.length];
            for (int i = 0; i < terms.length; ++i) {
                termStatistics[i] = (TermStatistics)stats.get(terms[i]);
            }
            context.dfsResult().termsStatistics(terms, termStatistics).fieldStatistics(fieldStatistics).maxDoc(context.searcher().getIndexReader().maxDoc());
        }
        catch (Exception e) {
            throw new DfsPhaseExecutionException(context.shardTarget(), "Exception during dfs phase", e);
        }
    }
}

