/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.query;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.document.IntPoint;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefIterator;
import org.apache.lucene.util.DocIdSetBuilder;
import org.apache.lucene.util.RamUsageEstimator;
import org.roaringbitmap.PeekableIntIterator;
import org.roaringbitmap.RoaringBitmap;

public class BitmapIndexQuery
extends Query
implements Accountable {
    private final RoaringBitmap bitmap;
    private final String field;

    public BitmapIndexQuery(String field, RoaringBitmap bitmap) {
        BitmapIndexQuery.checkArgs(field, bitmap);
        this.bitmap = bitmap;
        this.field = field;
    }

    static void checkArgs(String field, RoaringBitmap bitmap) {
        if (field == null) {
            throw new IllegalArgumentException("field must not be null");
        }
        if (bitmap == null) {
            throw new IllegalArgumentException("bitmap must not be null");
        }
    }

    private static BitmapIterator bitmapEncodedIterator(final RoaringBitmap bitmap) {
        return new BitmapIterator(){
            private final PeekableIntIterator iterator;
            private final BytesRef encoded;
            {
                this.iterator = bitmap.getIntIterator();
                this.encoded = new BytesRef(new byte[4]);
            }

            @Override
            public BytesRef next() {
                if (!this.iterator.hasNext()) {
                    return null;
                }
                int value = this.iterator.next();
                IntPoint.encodeDimension(value, this.encoded.bytes, 0);
                return this.encoded;
            }

            @Override
            public void advance(byte[] target) {
                this.iterator.advanceIfNeeded(IntPoint.decodeDimension(target, 0));
            }
        };
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, float boost) throws IOException {
        return new ConstantScoreWeight(this, boost){
            final long cardinality;
            {
                super(query, score);
                this.cardinality = BitmapIndexQuery.this.bitmap.getLongCardinality();
            }

            @Override
            public Scorer scorer(LeafReaderContext context) throws IOException {
                ScorerSupplier scorerSupplier = this.scorerSupplier(context);
                if (scorerSupplier == null) {
                    return null;
                }
                return scorerSupplier.get(Long.MAX_VALUE);
            }

            @Override
            public ScorerSupplier scorerSupplier(LeafReaderContext context) throws IOException {
                final 2 weight = this;
                final LeafReader reader = context.reader();
                final PointValues values = reader.getPointValues(BitmapIndexQuery.this.field);
                if (values == null) {
                    return null;
                }
                if (values.getNumIndexDimensions() != 1) {
                    throw new IllegalArgumentException("field must have only one dimension");
                }
                return new ScorerSupplier(){
                    long cost = -1L;
                    final DocIdSetBuilder result;
                    final MergePointVisitor visitor;
                    {
                        this.result = new DocIdSetBuilder(reader.maxDoc(), values, BitmapIndexQuery.this.field);
                        this.visitor = new MergePointVisitor(this.result);
                    }

                    @Override
                    public Scorer get(long leadCost) throws IOException {
                        values.intersect(this.visitor);
                        return new ConstantScoreScorer(weight, this.score(), scoreMode, this.result.build().iterator());
                    }

                    @Override
                    public long cost() {
                        if (this.cost == -1L) {
                            this.cost = cardinality * 20L;
                        }
                        return this.cost;
                    }
                };
            }

            @Override
            public boolean isCacheable(LeafReaderContext ctx) {
                return true;
            }
        };
    }

    @Override
    public Query rewrite(IndexSearcher indexSearcher) throws IOException {
        if (this.bitmap.isEmpty()) {
            return new MatchNoDocsQuery();
        }
        return super.rewrite(indexSearcher);
    }

    @Override
    public String toString(String field) {
        return "BitmapIndexQuery(field=" + this.field + ")";
    }

    @Override
    public void visit(QueryVisitor visitor) {
        if (visitor.acceptField(this.field)) {
            visitor.visitLeaf(this);
        }
    }

    @Override
    public boolean equals(Object other) {
        if (!this.sameClassAs(other)) {
            return false;
        }
        BitmapIndexQuery that = (BitmapIndexQuery)other;
        return this.field.equals(that.field) && this.bitmap.equals((Object)that.bitmap);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.classHash(), this.field, this.bitmap);
    }

    @Override
    public long ramBytesUsed() {
        return RamUsageEstimator.shallowSizeOfInstance(BitmapIndexQuery.class) + RamUsageEstimator.sizeOf(this.field) + this.bitmap.getLongSizeInBytes();
    }

    private class MergePointVisitor
    implements PointValues.IntersectVisitor {
        private final DocIdSetBuilder result;
        private final BitmapIterator iterator;
        private BytesRef nextQueryPoint;
        private final ArrayUtil.ByteArrayComparator comparator;
        private DocIdSetBuilder.BulkAdder adder;

        public MergePointVisitor(DocIdSetBuilder result) throws IOException {
            this.result = result;
            this.comparator = ArrayUtil.getUnsignedComparator(4);
            this.iterator = BitmapIndexQuery.bitmapEncodedIterator(BitmapIndexQuery.this.bitmap);
            this.nextQueryPoint = this.iterator.next();
        }

        @Override
        public void grow(int count) {
            this.adder = this.result.grow(count);
        }

        @Override
        public void visit(int docID) {
            this.adder.add(docID);
        }

        @Override
        public void visit(DocIdSetIterator iterator) throws IOException {
            this.adder.add(iterator);
        }

        @Override
        public void visit(int docID, byte[] packedValue) {
            if (this.matches(packedValue)) {
                this.visit(docID);
            }
        }

        @Override
        public void visit(DocIdSetIterator iterator, byte[] packedValue) throws IOException {
            if (this.matches(packedValue)) {
                this.adder.add(iterator);
            }
        }

        private boolean matches(byte[] packedValue) {
            while (this.nextQueryPoint != null) {
                int cmp = this.comparator.compare(this.nextQueryPoint.bytes, this.nextQueryPoint.offset, packedValue, 0);
                if (cmp == 0) {
                    return true;
                }
                if (cmp >= 0) break;
                this.iterator.advance(packedValue);
                this.nextQueryPoint = this.iterator.next();
            }
            return false;
        }

        @Override
        public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
            while (this.nextQueryPoint != null) {
                int cmpMin = this.comparator.compare(this.nextQueryPoint.bytes, this.nextQueryPoint.offset, minPackedValue, 0);
                if (cmpMin < 0) {
                    this.iterator.advance(minPackedValue);
                    this.nextQueryPoint = this.iterator.next();
                    continue;
                }
                int cmpMax = this.comparator.compare(this.nextQueryPoint.bytes, this.nextQueryPoint.offset, maxPackedValue, 0);
                if (cmpMax > 0) {
                    return PointValues.Relation.CELL_OUTSIDE_QUERY;
                }
                if (cmpMin == 0 && cmpMax == 0) {
                    return PointValues.Relation.CELL_INSIDE_QUERY;
                }
                return PointValues.Relation.CELL_CROSSES_QUERY;
            }
            return PointValues.Relation.CELL_OUTSIDE_QUERY;
        }
    }

    static interface BitmapIterator
    extends BytesRefIterator {
        @Override
        public BytesRef next();

        public void advance(byte[] var1);
    }
}

