/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.opensearch.plugin;

import de.virtimo.bpc.opensearch.plugin.dto.OpenSearchPluginDTO;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.opensearch.common.util.set.Sets;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;

public class ChangesFilter
implements OpenSearchPluginDTO {
    private final String index;
    private final boolean sendIndexEventsOnlyForModifiedSources;
    private final Set<String> serverUUIDs;

    public static String getKey(String index) {
        return "[" + index + "]";
    }

    public ChangesFilter(String index, boolean sendIndexEventsOnlyForModifiedSources) {
        Objects.requireNonNull(index, "'index' must not be null");
        this.index = index;
        this.sendIndexEventsOnlyForModifiedSources = sendIndexEventsOnlyForModifiedSources;
        this.serverUUIDs = new HashSet<String>();
    }

    public ChangesFilter(Map<String, Object> map) {
        Objects.requireNonNull(map, "'map' must not be null");
        this.index = (String)map.get("index");
        Objects.requireNonNull(this.index, "'map' must contain the 'index' field");
        this.sendIndexEventsOnlyForModifiedSources = (Boolean)map.get("sendIndexEventsOnlyForModifiedSources");
        this.serverUUIDs = map.containsKey("serverUUIDs") ? new HashSet((List)map.get("serverUUIDs")) : new HashSet();
    }

    public ChangesFilter(StreamInput in) throws IOException {
        this.index = in.readString();
        this.sendIndexEventsOnlyForModifiedSources = in.readBoolean();
        this.serverUUIDs = Sets.newHashSet((Object[])in.readStringArray());
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.index);
        out.writeBoolean(this.sendIndexEventsOnlyForModifiedSources);
        out.writeStringCollection(this.serverUUIDs);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("index", this.index);
        builder.field("sendIndexEventsOnlyForModifiedSources", this.sendIndexEventsOnlyForModifiedSources);
        builder.field("serverUUIDs", this.serverUUIDs);
        builder.endObject();
        return builder;
    }

    public static ChangesFilter fromXContent(XContentParser parser) throws IOException {
        return new ChangesFilter(parser.map());
    }

    public String getKey() {
        return ChangesFilter.getKey(this.index);
    }

    public String getIndex() {
        return this.index;
    }

    public boolean isSendIndexEventsOnlyForModifiedSources() {
        return this.sendIndexEventsOnlyForModifiedSources;
    }

    public boolean addServerUUID(String serverUUID) {
        if (serverUUID != null && !this.serverUUIDs.contains(serverUUID)) {
            this.serverUUIDs.add(serverUUID);
            return true;
        }
        return false;
    }

    public void removeServerUUID(String serverUUID) {
        if (serverUUID != null) {
            this.serverUUIDs.remove(serverUUID);
        }
    }

    public boolean hasServerUUIDs() {
        return !this.serverUUIDs.isEmpty();
    }

    public boolean belongsToServerUUID(String serverUUID) {
        return this.serverUUIDs.contains(serverUUID);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChangesFilter that = (ChangesFilter)o;
        return this.sendIndexEventsOnlyForModifiedSources == that.sendIndexEventsOnlyForModifiedSources && Objects.equals(this.index, that.index) && Objects.equals(this.serverUUIDs, that.serverUUIDs);
    }

    public int hashCode() {
        return this.index.hashCode();
    }

    public String toString() {
        return "ChangesFilter{index='" + this.index + "', sendIndexEventsOnlyForModifiedSources=" + this.sendIndexEventsOnlyForModifiedSources + ", serverUUIDs=" + this.serverUUIDs + "}";
    }
}

