/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.module.monitor.resource;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.jaxrs.annotation.JacksonFeatures;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.ErrorResponse;
import de.virtimo.bpc.api.ModuleInstance;
import de.virtimo.bpc.api.Setting;
import de.virtimo.bpc.api.SystemException;
import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.api.exception.ModuleInstanceNotFoundException;
import de.virtimo.bpc.api.exception.OpenSearchIndexMappingNotFoundException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.opensearch.querybuilder.BpcDataFilter;
import de.virtimo.bpc.api.opensearch.querybuilder.BpcDataFilterBuilder;
import de.virtimo.bpc.api.opensearch.querybuilder.BpcIndexMapping;
import de.virtimo.bpc.api.opensearch.querybuilder.BpcQueryBuilder;
import de.virtimo.bpc.api.opensearch.querybuilder.BpcSortBuilder;
import de.virtimo.bpc.api.service.ErrorResponseService;
import de.virtimo.bpc.api.service.HttpProxyService;
import de.virtimo.bpc.api.service.InternationalizationService;
import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.jaxrs.BpcUserSessionRequired;
import de.virtimo.bpc.module.monitor.MonitorErrorCode;
import de.virtimo.bpc.module.monitor.MonitorModule;
import de.virtimo.bpc.module.monitor.MonitorModuleInstance;
import de.virtimo.bpc.module.monitor.OpenSearch;
import de.virtimo.bpc.module.monitor.api.service.MonitorService;
import de.virtimo.bpc.module.monitor.exception.FilterLengthLimitException;
import de.virtimo.bpc.module.monitor.exception.IndexAccessNotAllowedException;
import de.virtimo.bpc.module.monitor.exception.ProcessAccessNotAllowedException;
import de.virtimo.bpc.module.monitor.exception.ResourceUnavailableInResourceSavingModeException;
import de.virtimo.bpc.module.monitor.query.DateRangeQuery;
import de.virtimo.bpc.module.monitor.query.SessionBasedQuery;
import de.virtimo.bpc.module.monitor.query.ViewQuery;
import de.virtimo.bpc.module.monitor.resource.MonitorDataCsvExporter;
import de.virtimo.bpc.module.monitor.resource.MonitorDataJsonExporter;
import de.virtimo.bpc.module.monitor.resource.MonitorDataXlsxExporter;
import de.virtimo.bpc.module.monitor.resource.response.MonitorDataImpl;
import de.virtimo.bpc.module.monitor.resource.response.MonitorTimeseriesAggregationDataImpl;
import de.virtimo.bpc.module.monitor.service.MonitorServiceImpl;
import de.virtimo.bpc.util.JsonUtil;
import de.virtimo.bpc.util.MapUtil;
import de.virtimo.bpc.util.StringUtil;
import de.virtimo.bpc.util.TimeZoneUtil;
import de.virtimo.bpc.util.UriQueryUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.Encoded;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.StreamingOutput;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.codec.binary.Base64;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.opensearch.action.admin.indices.settings.put.UpdateSettingsRequest;
import org.opensearch.action.search.SearchPhaseExecutionException;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.client.RequestOptions;
import org.opensearch.client.RestHighLevelClient;
import org.opensearch.cluster.metadata.MappingMetadata;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.search.SearchHit;
import org.opensearch.search.aggregations.AggregationBuilder;
import org.opensearch.search.aggregations.AggregationBuilders;
import org.opensearch.search.aggregations.BucketOrder;
import org.opensearch.search.aggregations.bucket.filter.Filter;
import org.opensearch.search.aggregations.bucket.filter.FilterAggregationBuilder;
import org.opensearch.search.aggregations.bucket.histogram.DateHistogramAggregationBuilder;
import org.opensearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import org.opensearch.search.aggregations.bucket.histogram.LongBounds;
import org.opensearch.search.aggregations.bucket.terms.IncludeExclude;
import org.opensearch.search.aggregations.bucket.terms.Terms;
import org.opensearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.search.sort.SortBuilder;
import org.osgi.framework.BundleContext;

@Path(value="monitor")
public class Monitor {
    private static final Logger LOG = Logger.getLogger(Monitor.class.getName());
    private static final int FILTER_LENGTH_LIMIT = 10000;
    private final BundleContext bundleContext;
    private BpcServicesTracker<InternationalizationService> internationalizationServiceTracker;
    private BpcServicesTracker<HttpProxyService> httpProxyServiceTracker;
    private BpcServicesTracker<ErrorResponseService> errorResponseServiceTracker;
    private BpcServicesTracker<MonitorService> monitorServiceTracker;
    private final ObjectMapper om;

    public Monitor(BundleContext bundleContext) {
        LOG.info("Monitor bundleContext=" + bundleContext);
        this.bundleContext = bundleContext;
        this.om = new ObjectMapper();
    }

    public void onStartup() {
        LOG.info("onStartup");
        this.internationalizationServiceTracker = new BpcServicesTracker(this.bundleContext, InternationalizationService.class);
        this.httpProxyServiceTracker = new BpcServicesTracker(this.bundleContext, HttpProxyService.class);
        this.errorResponseServiceTracker = new BpcServicesTracker(this.bundleContext, ErrorResponseService.class);
        this.monitorServiceTracker = new BpcServicesTracker(this.bundleContext, MonitorService.class);
    }

    public void onShutdown() {
        LOG.info("onShutdown");
        BpcServicesTracker.stopAll((Object)this);
    }

    private MonitorModuleInstance getMonitorModuleInstance(String instanceId, UserSession userSession) throws ModuleInstanceNotFoundException {
        ModuleInstance mi = MonitorModule.getInstance().getModuleInstance(instanceId);
        if (mi == null || !userSession.hasUseModuleInstanceRight(mi)) {
            throw new ModuleInstanceNotFoundException("monitor", instanceId);
        }
        return (MonitorModuleInstance)mi;
    }

    private String createExportFilename(ModuleInstance mi, Map<String, Object> translations) {
        Object moduleName;
        try {
            Object translatedModuleName;
            moduleName = (String)mi.getConfiguration().getSetting("module_name").getValue();
            if (translations != null && moduleName != null && (translatedModuleName = translations.get(moduleName)) instanceof String) {
                moduleName = (String)translatedModuleName;
            }
        }
        catch (Exception ex) {
            moduleName = null;
        }
        if (moduleName == null || ((String)moduleName).equals("")) {
            moduleName = "Monitor" + mi.getModuleId();
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss");
        return (String)moduleName + "_" + dateFormat.format(Calendar.getInstance().getTime());
    }

    @Produces(value={"application/json"})
    @GET
    @Path(value="/{instanceId}/{recordId}")
    @BpcUserSessionRequired
    public Response getMonitorRecord(@Context HttpHeaders httpHeaders, @PathParam(value="instanceId") String instanceId, @PathParam(value="recordId") String recordId, @Context UserSession userSession) {
        LOG.info("getMonitorRecord instanceId:" + instanceId + ", recordId:" + recordId);
        try {
            MonitorModuleInstance mi = this.getMonitorModuleInstance(instanceId, userSession);
            OpenSearch openSearch = MonitorModule.getInstance().getOpenSearch();
            RestHighLevelClient osClient = openSearch.getClient();
            MonitorService monitorService = (MonitorService)this.monitorServiceTracker.getService();
            String index = mi.getConfiguration().getSettingValue("data_index").asString("").toLowerCase();
            LOG.info("index: " + index);
            String idField = (String)mi.getConfiguration().getSetting("column_id").getValue();
            LOG.info("idField: " + idField);
            if (!monitorService.isIndexAccessAllowed(index)) {
                throw new IndexAccessNotAllowedException(index);
            }
            SearchRequest sr = new SearchRequest().indices(new String[]{index}).source(new SearchSourceBuilder().query((QueryBuilder)QueryBuilders.termQuery((String)idField, (String)recordId)));
            LOG.info("query: " + sr);
            SearchResponse searchResponse = osClient.search(sr, RequestOptions.DEFAULT);
            LOG.info("TotalHits: " + searchResponse.getHits().getTotalHits());
            return Response.ok((Object)new MonitorDataImpl(searchResponse, index)).build();
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "getMonitorRecord query could not be executed.", e);
            return ErrorResponse.forException((Exception)e).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @POST
    @Consumes(value={"application/json"})
    @Path(value="/accessible/{instanceId}")
    @BpcUserSessionRequired(skipCsrfCheck="false")
    public Response isAccessible(@PathParam(value="instanceId") String instanceId, Set<String> processes, @Context HttpHeaders hh, @Context UserSession userSession) {
        LOG.info("isAccessible");
        try {
            boolean accessible = ((MonitorService)this.monitorServiceTracker.getService()).isAccessible(instanceId, processes, userSession);
            if (accessible) {
                return Response.ok().build();
            }
            throw new ProcessAccessNotAllowedException();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Exception while checking the accessibility.", ex);
            return ErrorResponse.forException((Exception)ex).usingTracker(this.errorResponseServiceTracker).languageFrom(hh).build();
        }
    }

    @Produces(value={"application/json", "text/csv", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"})
    @GET
    @Path(value="/{instanceId}")
    @BpcUserSessionRequired
    public Response getMonitorDataGET(@Context HttpHeaders httpHeaders, @PathParam(value="instanceId") String instanceId, @QueryParam(value="start") Integer start, @QueryParam(value="limit") Integer limit, @QueryParam(value="query") String query, @QueryParam(value="filter") String filter, @QueryParam(value="sort") String sort, @QueryParam(value="group") String group, @QueryParam(value="view") String view, @QueryParam(value="queryId") String queryId, @QueryParam(value="format") String format, @QueryParam(value="timezoneOffset") String timezoneOffset, @QueryParam(value="timezoneName") String timezoneName, @QueryParam(value="collaboration") String collaboration, @QueryParam(value="exportColumns") String exportColumns, @QueryParam(value="exportChildren") Boolean exportChildren, @QueryParam(value="bpcLanguage") String bpcLanguage, @Context UserSession userSession) {
        return this.getMonitorData(httpHeaders, instanceId, start, limit, query, filter, sort, group, view, queryId, format, timezoneOffset, timezoneName, collaboration, exportColumns, exportChildren, bpcLanguage, userSession);
    }

    @Produces(value={"application/json", "text/csv", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"})
    @POST
    @Path(value="/{instanceId}")
    @BpcUserSessionRequired
    public Response getMonitorDataPOST(@Context HttpHeaders httpHeaders, @PathParam(value="instanceId") String instanceId, @FormParam(value="start") Integer start, @FormParam(value="limit") Integer limit, @FormParam(value="query") String query, @FormParam(value="filter") String filter, @FormParam(value="sort") String sort, @FormParam(value="group") String group, @FormParam(value="view") String view, @FormParam(value="queryId") String queryId, @FormParam(value="format") String format, @FormParam(value="timezoneOffset") String timezoneOffset, @FormParam(value="timezoneName") String timezoneName, @FormParam(value="collaboration") String collaboration, @FormParam(value="exportColumns") String exportColumns, @FormParam(value="exportChildren") Boolean exportChildren, @FormParam(value="bpcLanguage") String bpcLanguage, @Context UserSession userSession) {
        return this.getMonitorData(httpHeaders, instanceId, start, limit, query, filter, sort, group, view, queryId, format, timezoneOffset, timezoneName, collaboration, exportColumns, exportChildren, bpcLanguage, userSession);
    }

    private Map<String, Object> getTranslationsForBpcLanguage(String bpcLanguage) throws ServiceNotFoundException {
        InternationalizationService internationalizationService;
        if (bpcLanguage != null && (internationalizationService = (InternationalizationService)this.internationalizationServiceTracker.getService()).getKeysOfUsedLanguages().contains(bpcLanguage)) {
            return internationalizationService.getTranslationsForLanguage(bpcLanguage);
        }
        return null;
    }

    public Response getMonitorData(HttpHeaders httpHeaders, String instanceId, Integer start, Integer limit, String query, String filtersAsJsonArray, String sort, String group, String view, String queryId, String format, String timezoneOffset, String timezoneName, String collaboration, String exportColumns, Boolean exportChildren, String bpcLanguage, UserSession userSession) {
        LOG.info("getMonitorData() instanceId:" + instanceId + ", start:" + start + ", limit:" + limit + ", query:" + query + ", filtersAsJsonArray:" + filtersAsJsonArray + ", group:" + group + ", sort:" + (String)sort + ", view:" + view + ", format:" + format + ", timezoneOffset:" + timezoneOffset + ", timezoneName:" + timezoneName + ", exportColumns=" + exportColumns + ", exportChildren=" + exportChildren + ", bpcLanguage=" + bpcLanguage);
        String index = null;
        String dataIndex = null;
        try {
            OpenSearch openSearch = MonitorModule.getInstance().getOpenSearch();
            long currentTimestamp = System.currentTimeMillis();
            String searchIdPrefix = MonitorModule.getInstance().createSearchIdPrefix(httpHeaders, "monitor", queryId != null && queryId.length() > 0 ? queryId : instanceId);
            MonitorModule.getInstance().cancelRunningSearchTasks(openSearch, searchIdPrefix, currentTimestamp);
            if (format == null) {
                if (start == null || start < 0) {
                    start = 0;
                    LOG.finest("Not start parameter or out of range. Set start to " + start);
                }
                if (limit == null || limit < 0 || limit > 10000) {
                    limit = 300;
                    LOG.finest("Not limit parameter or out of range. Set limit to " + limit);
                }
            } else {
                start = 0;
            }
            filtersAsJsonArray = SessionBasedQuery.prepareFilterString(userSession, filtersAsJsonArray);
            query = SessionBasedQuery.prepareFilterString(userSession, query);
            final Integer exportLimit = limit == null || limit == 0 ? null : limit;
            LOG.info("Export limit: " + exportLimit);
            if (filtersAsJsonArray != null && filtersAsJsonArray.length() > 10000) {
                throw new FilterLengthLimitException(10000, filtersAsJsonArray.length());
            }
            final MonitorModuleInstance mi = this.getMonitorModuleInstance(instanceId, userSession);
            if (format != null && exportChildren != null && exportChildren == Boolean.TRUE) {
                index = mi.getConfiguration().getSettingValue("data_historyIndex").asString("").toLowerCase();
                dataIndex = mi.getConfiguration().getSettingValue("data_historyIndex").asString("");
                String childHistoryId = (String)mi.getConfiguration().getSetting("column_historyId").getValue();
                String childHistorySubId = (String)mi.getConfiguration().getSetting("column_historySubId").getValue();
                sort = "[{\"property\":\"" + childHistoryId + "\",\"direction\":\"ASC\"},{\"property\":\"" + childHistorySubId + "\",\"direction\":\"ASC\"}]";
                query = null;
                filtersAsJsonArray = null;
                group = null;
                view = null;
                exportColumns = null;
            } else {
                index = mi.getConfiguration().getSettingValue("data_index").asString("").toLowerCase();
                dataIndex = mi.getConfiguration().getSettingValue("data_index").asString("");
            }
            LOG.info("index: " + index);
            LOG.info("dataIndex: " + dataIndex);
            final String timeZoneId = TimeZoneUtil.evalTimeZoneId((String)timezoneOffset, (String)timezoneName);
            final OpenSearchService oss = openSearch.getOpenSearchService();
            final RestHighLevelClient osClient = openSearch.getClient();
            BpcIndexMapping indexMapping = new BpcIndexMapping(openSearch.getOpenSearchService().getMappingMetaData(index));
            int maxResultWindowSize = (Integer)mi.getConfiguration().getSetting("instance_data_view_limit").getValue();
            int maxDataCount = (Integer)mi.getConfiguration().getSetting("instance_data_count_limit").getValue();
            if (maxResultWindowSize == -1) {
                maxResultWindowSize = (Integer)MonitorModule.getInstance().getConfiguration().getSetting("monitor_data_view_limit").getValue();
            }
            if (maxDataCount == -1) {
                maxDataCount = (Integer)MonitorModule.getInstance().getConfiguration().getSetting("monitor_data_count_limit").getValue();
            }
            try {
                Map<String, Integer> settings = Map.of("max_result_window", maxResultWindowSize);
                osClient.indices().putSettings(new UpdateSettingsRequest(new String[]{index}).settings(settings), RequestOptions.DEFAULT);
            }
            catch (Exception e) {
                LOG.warning(e.getLocalizedMessage());
            }
            if (!((MonitorService)this.monitorServiceTracker.getService()).isIndexAccessAllowed(index)) {
                throw new IndexAccessNotAllowedException(index);
            }
            SearchSourceBuilder ssb = new SearchSourceBuilder();
            SearchRequest sr = new SearchRequest().indices(new String[]{index}).source(ssb);
            List excludedFields = mi.getConfiguration().getSettingValue("data_excludedFields").asList();
            if (excludedFields != null) {
                String[] excludedFieldsArray = excludedFields.toArray(new String[0]);
                ssb.fetchSource(null, excludedFieldsArray);
            }
            if (format == null) {
                ssb.from(start.intValue());
                ssb.size(limit.intValue());
                ssb.trackTotalHitsUpTo(maxDataCount);
                if (start + limit > maxResultWindowSize) {
                    throw new SystemException((ErrorCode)MonitorErrorCode.QUERY_RANGE_LIMIT, "Requested range ${from} - ${to} is breaking the configured limit (${settingName}) of ${maxResultWindowSize}", MapUtil.mapOf((Object[])new Object[]{"from", start, "to", start + limit, "settingName", "monitor_data_view_limit", "maxResultWindowSize", maxResultWindowSize}));
                }
            } else {
                ssb.from(start.intValue());
                ssb.size(2500);
                ssb.trackTotalHits(true);
                sr.scroll(new TimeValue(60000L));
            }
            String dataFilterOperator = mi.getConfiguration().getSettingValue("data_filter_operator").asString("").toLowerCase();
            QueryBuilder queryBuilder = new BpcQueryBuilder().addQueryBuilder(SessionBasedQuery.getQueryBuilder(userSession, mi.getConfiguration().getSettingValue("data_filter").asMap(null), dataFilterOperator)).addQueryBuilder(ViewQuery.getQueryBuilder((ModuleInstance)mi, view, userSession)).addSkipPercolatorDocumentsQuery().addStringBasedQuery(query).addQueriesForFilters(filtersAsJsonArray, indexMapping, timeZoneId).buildAsBoolFilterQuery();
            ssb.query(queryBuilder);
            if (StringUtil.isNullOrEmpty((String)sort) && StringUtil.isNullOrEmpty((String)group)) {
                Iterator sortField = (String)mi.getConfiguration().getSetting("column_timeseries").getValue();
                for (SortBuilder sortBuilder : BpcSortBuilder.init((BpcIndexMapping)indexMapping).addSort(sortField, "DESC").build()) {
                    ssb.sort(sortBuilder);
                }
            } else {
                if (!StringUtil.isNullOrEmpty((String)group)) {
                    for (SortBuilder sortBuilder : BpcSortBuilder.init((BpcIndexMapping)indexMapping).addSortFromJsonArray("[" + group + "]").build()) {
                        ssb.sort(sortBuilder);
                    }
                }
                if (!StringUtil.isNullOrEmpty((String)sort)) {
                    for (SortBuilder sortBuilder : BpcSortBuilder.init((BpcIndexMapping)indexMapping).addSortFromJsonArray((String)sort).build()) {
                        ssb.sort(sortBuilder);
                    }
                }
            }
            LOG.info("query: " + sr);
            final SearchResponse searchResponse = osClient.search(sr, MonitorModule.getInstance().getRequestOptionsWithXOpaqueIdHeader(searchIdPrefix, currentTimestamp));
            LOG.info("TotalHits: " + searchResponse.getHits().getTotalHits());
            if (format != null) {
                final MappingMetadata mappingMetaData = indexMapping.getMappingMetaData();
                if (mappingMetaData != null) {
                    final List exportOnlyThisColumns = JsonUtil.getInstance().jsonStringAsList(exportColumns);
                    final Map<String, Object> translationsForBpcLanguage = this.getTranslationsForBpcLanguage(bpcLanguage);
                    if (format.equals("json")) {
                        final Boolean jsonExportInclHidden = (Boolean)mi.getConfiguration().getSetting("function_exportConfigJsonInclHidden").getValue();
                        final Boolean jsonExportUseCustomColumnHeaders = (Boolean)mi.getConfiguration().getSetting("function_exportConfigJsonUseCustomColumnHeaders").getValue();
                        final Boolean jsonExportUseUtcDateFormat = (Boolean)mi.getConfiguration().getSetting("function_exportConfigJsonUseUTCDateFormat").getValue();
                        StreamingOutput stream = new StreamingOutput(){

                            public void write(OutputStream out) throws IOException, WebApplicationException {
                                try {
                                    MonitorDataJsonExporter jsonExporter = new MonitorDataJsonExporter((ModuleInstance)mi, mappingMetaData, exportOnlyThisColumns, jsonExportInclHidden, timeZoneId, translationsForBpcLanguage);
                                    jsonExporter.setUseCustomColumnHeaders(jsonExportUseCustomColumnHeaders);
                                    jsonExporter.setUseUtcDateFormat(jsonExportUseUtcDateFormat);
                                    jsonExporter.writeSearchResponseToOutputStream(osClient, searchResponse, exportLimit, out);
                                }
                                catch (Exception ex) {
                                    LOG.log(Level.SEVERE, "Failed to create the JSON export response.", ex);
                                    throw ex;
                                }
                                finally {
                                    oss.releaseScrollId(searchResponse.getScrollId());
                                }
                            }
                        };
                        return Response.ok((Object)stream, (String)"application/json").header("Content-Disposition", (Object)("attachment; filename=\"" + this.createExportFilename((ModuleInstance)mi, translationsForBpcLanguage) + ".json\"")).build();
                    }
                    if (format.equals("csv")) {
                        final String csvSeparator = (String)mi.getConfiguration().getSetting("function_exportConfigCsvSeparator").getValue();
                        final Boolean csvExportInclHidden = (Boolean)mi.getConfiguration().getSetting("function_exportConfigCsvInclHidden").getValue();
                        final Boolean csvExportUseCustomColumnHeaders = (Boolean)mi.getConfiguration().getSetting("function_exportConfigCsvUseCustomColumnHeaders").getValue();
                        StreamingOutput stream = new StreamingOutput(){

                            public void write(OutputStream out) throws IOException, WebApplicationException {
                                try {
                                    MonitorDataCsvExporter csvExporter = new MonitorDataCsvExporter((ModuleInstance)mi, mappingMetaData, exportOnlyThisColumns, csvExportInclHidden, timeZoneId, translationsForBpcLanguage);
                                    csvExporter.setFormattingConvention(0);
                                    csvExporter.setColumnSeparator(csvSeparator);
                                    csvExporter.setUseCustomColumnHeaders(csvExportUseCustomColumnHeaders);
                                    csvExporter.writeSearchResponseToOutputStream(osClient, searchResponse, exportLimit, out);
                                }
                                catch (Exception ex) {
                                    LOG.log(Level.SEVERE, "Failed to create the CSV export response.", ex);
                                    throw ex;
                                }
                                finally {
                                    oss.releaseScrollId(searchResponse.getScrollId());
                                }
                            }
                        };
                        return Response.ok((Object)stream, (String)"text/csv").header("Content-Disposition", (Object)("attachment; filename=\"" + this.createExportFilename((ModuleInstance)mi, translationsForBpcLanguage) + ".csv\"")).build();
                    }
                    if (format.equals("xlsx")) {
                        final Boolean xlsxExportInclHidden = (Boolean)mi.getConfiguration().getSetting("function_exportConfigXlsxInclHidden").getValue();
                        final Boolean xlsxExportUseCustomColumnHeaders = (Boolean)mi.getConfiguration().getSetting("function_exportConfigXlsxUseCustomColumnHeaders").getValue();
                        final Boolean xlsxExportAutoResizeColumns = (Boolean)mi.getConfiguration().getSetting("function_exportConfigXlsxAutoResizeColumns").getValue();
                        StreamingOutput stream = new StreamingOutput(){

                            public void write(OutputStream out) throws IOException, WebApplicationException {
                                try {
                                    MonitorDataXlsxExporter xlsxExporter = new MonitorDataXlsxExporter((ModuleInstance)mi, mappingMetaData, exportOnlyThisColumns, xlsxExportInclHidden, translationsForBpcLanguage);
                                    xlsxExporter.setUseCustomColumnHeaders(xlsxExportUseCustomColumnHeaders);
                                    xlsxExporter.setAutoResizeColumns(xlsxExportAutoResizeColumns);
                                    xlsxExporter.writeSearchResponseToOutputStream(osClient, searchResponse, exportLimit, out);
                                }
                                catch (Exception ex) {
                                    LOG.log(Level.SEVERE, "Failed to create the XLSX export response.", ex);
                                    throw ex;
                                }
                                finally {
                                    oss.releaseScrollId(searchResponse.getScrollId());
                                }
                            }
                        };
                        return Response.ok((Object)stream, (String)"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet").header("Content-Disposition", (Object)("attachment; filename=\"" + this.createExportFilename((ModuleInstance)mi, translationsForBpcLanguage) + ".xlsx\"")).build();
                    }
                    throw new SystemException((ErrorCode)MonitorErrorCode.WRONG_DOWNLOAD_FORMAT, "Wrong download format: ${format}", MapUtil.mapOf((Object[])new Object[]{"format", format}));
                }
                throw new OpenSearchIndexMappingNotFoundException(index);
            }
            MonitorModule.getInstance().keepOpenSearchQueryForWebsocketUpdates(httpHeaders, "monitor", queryId != null && queryId.length() > 0 ? queryId : instanceId, openSearch.getOpenSearchService(), index, queryBuilder);
            collaboration = collaboration != null && collaboration.equals("true") ? (String)mi.getConfiguration().getSetting("column_id").getValue() : null;
            return Response.ok((Object)new MonitorDataImpl(searchResponse, dataIndex, collaboration, instanceId, userSession)).build();
        }
        catch (SearchPhaseExecutionException ex) {
            return Response.ok((Object)new MonitorDataImpl(null, dataIndex, collaboration, instanceId)).build();
        }
        catch (Exception ex) {
            if (MonitorModule.getInstance().isTaskCancelledException(ex)) {
                return Response.ok((Object)new MonitorDataImpl(null, dataIndex, collaboration, instanceId)).build();
            }
            LOG.log(Level.SEVERE, "getMonitorData query could not be executed.", ex);
            return ErrorResponse.forException((Exception)ex).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @Produces(value={"application/json"})
    @GET
    @Path(value="/tsAggregation/{instanceId}")
    @BpcUserSessionRequired
    public Response getMonitorTimeseriesAggregation(@Context HttpHeaders httpHeaders, @PathParam(value="instanceId") String instanceId, @QueryParam(value="queryId") String queryId, @QueryParam(value="view") String view, @QueryParam(value="field") String groupedField, @QueryParam(value="interval") String interval, @QueryParam(value="startDate") String startDate, @QueryParam(value="endDate") String endDate, @QueryParam(value="timeseriesColumn") String timeseriesColumn, @QueryParam(value="timezoneOffset") String timezoneOffset, @QueryParam(value="timezoneName") String timezoneName, @QueryParam(value="showPreviousData") @DefaultValue(value="false") boolean showPreviousData, @QueryParam(value="showFollowingData") @DefaultValue(value="false") boolean showFollowingData, @QueryParam(value="filter") String filter, @Context UserSession userSession) {
        LOG.info("getMonitorTimeseriesAggregation");
        try {
            Boolean resourceSavingMode;
            HashMap<String, DateHistogramInterval> allowedInterval = new HashMap<String, DateHistogramInterval>();
            allowedInterval.put("second", DateHistogramInterval.SECOND);
            allowedInterval.put("minute", DateHistogramInterval.MINUTE);
            allowedInterval.put("hour", DateHistogramInterval.HOUR);
            allowedInterval.put("day", DateHistogramInterval.DAY);
            allowedInterval.put("week", DateHistogramInterval.WEEK);
            allowedInterval.put("month", DateHistogramInterval.MONTH);
            allowedInterval.put("quarter", DateHistogramInterval.QUARTER);
            allowedInterval.put("year", DateHistogramInterval.YEAR);
            if (interval == null || !allowedInterval.containsKey(interval)) {
                interval = "day";
                LOG.finest("Not parameter interval. Set interval to " + interval);
            }
            if (startDate == null) {
                startDate = "now-7d/d";
                LOG.finest("Not parameter startDate. Set startDate to " + startDate);
            }
            if (endDate == null) {
                endDate = "now";
                LOG.finest("Not parameter endDate. Set endDate to " + endDate);
            }
            if (groupedField == null) {
                groupedField = "STATUS";
                LOG.finest("Not parameter groupedField. Set groupedField to " + groupedField);
            }
            String timeZoneId = TimeZoneUtil.evalTimeZoneId((String)timezoneOffset, (String)timezoneName);
            if ((filter = SessionBasedQuery.prepareFilterString(userSession, filter)) != null && filter.length() > 10000) {
                throw new FilterLengthLimitException(10000, filter.length());
            }
            MonitorModuleInstance mi = this.getMonitorModuleInstance(instanceId, userSession);
            OpenSearch openSearch = MonitorModule.getInstance().getOpenSearch();
            RestHighLevelClient osClient = openSearch.getClient();
            Setting setting = mi.getConfiguration().getSetting("resource_saving_mode");
            if (setting != null && (resourceSavingMode = (Boolean)setting.getValue()).equals(Boolean.TRUE)) {
                throw new ResourceUnavailableInResourceSavingModeException();
            }
            String index = mi.getConfiguration().getSettingValue("data_index").asString("").toLowerCase();
            LOG.info("index: " + index);
            if (timeseriesColumn == null) {
                timeseriesColumn = (String)mi.getConfiguration().getSetting("column_timeseries").getValue();
            }
            LOG.info("timeseriesColumn: " + timeseriesColumn);
            if (!((MonitorService)this.monitorServiceTracker.getService()).isIndexAccessAllowed(index)) {
                throw new IndexAccessNotAllowedException(index);
            }
            BpcIndexMapping indexMapping = new BpcIndexMapping(openSearch.getOpenSearchService().getMappingMetaData(index));
            Map dataFilterSetting = mi.getConfiguration().getSettingValue("data_filter").asMap(null);
            String dataFilterOperator = mi.getConfiguration().getSettingValue("data_filter_operator").asString("").toLowerCase();
            QueryBuilder finalQuery = this.createTsAggregationQuery(view, startDate, endDate, timeseriesColumn, userSession, timeZoneId, (ModuleInstance)mi, dataFilterSetting, filter, indexMapping, dataFilterOperator);
            String groupedFieldType = indexMapping.getFieldType(groupedField = indexMapping.getPreferredQueryFieldForSortOrAggregation(groupedField));
            Object missingValue = "long".equalsIgnoreCase(groupedFieldType) ? Long.valueOf(Long.MIN_VALUE) : ("integer".equalsIgnoreCase(groupedFieldType) ? Integer.valueOf(Integer.MIN_VALUE) : ("double".equalsIgnoreCase(groupedFieldType) ? Double.valueOf(Double.MIN_VALUE) : ("float".equalsIgnoreCase(groupedFieldType) ? Float.valueOf(Float.MIN_VALUE) : "!")));
            SearchRequest srb = new SearchRequest().indices(new String[]{index}).source(new SearchSourceBuilder().size(0).query(finalQuery).aggregation((AggregationBuilder)((DateHistogramAggregationBuilder)((DateHistogramAggregationBuilder)((DateHistogramAggregationBuilder)AggregationBuilders.dateHistogram((String)"tsAgg").field(timeseriesColumn)).calendarInterval((DateHistogramInterval)allowedInterval.get(interval)).format("yyyy-MM-dd HH:mm:ss||strict_date_optional_time||epoch_millis")).timeZone(ZoneId.of(timeZoneId))).minDocCount(0L).extendedBounds(new LongBounds(startDate, endDate)).subAggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"fieldAgg").field(groupedField)).missing(missingValue))).aggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"distinctValues").field(groupedField)).missing(missingValue)));
            LOG.info("getMonitorTimeseriesAggregation SearchRequest: " + srb);
            SearchResponse searchResponse = osClient.search(srb, RequestOptions.DEFAULT);
            SearchResponse allBeforeStartDateResponse = null;
            if (showPreviousData) {
                QueryBuilder showPreviousDataQuery = this.createTsAggregationQuery(view, null, startDate, timeseriesColumn, userSession, timeZoneId, (ModuleInstance)mi, dataFilterSetting, filter, indexMapping, dataFilterOperator);
                SearchRequest allBeforeStartDateRequest = new SearchRequest().indices(new String[]{index}).source(new SearchSourceBuilder().size(0).query(showPreviousDataQuery).aggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"distinctValues").field(groupedField)).missing(missingValue)));
                allBeforeStartDateResponse = osClient.search(allBeforeStartDateRequest, RequestOptions.DEFAULT);
            }
            SearchResponse allAfterEndDateResponse = null;
            if (showFollowingData) {
                QueryBuilder showFollowingDataQuery = this.createTsAggregationQuery(view, endDate, null, timeseriesColumn, userSession, timeZoneId, (ModuleInstance)mi, dataFilterSetting, filter, indexMapping, dataFilterOperator);
                SearchRequest allAfterEndDateRequest = new SearchRequest().indices(new String[]{index}).source(new SearchSourceBuilder().size(0).query(showFollowingDataQuery).aggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"distinctValues").field(groupedField)).missing(missingValue)));
                allAfterEndDateResponse = osClient.search(allAfterEndDateRequest, RequestOptions.DEFAULT);
            }
            LOG.info("TotalHits: " + searchResponse.getHits().getTotalHits());
            MonitorModule.getInstance().keepOpenSearchQueryForWebsocketUpdates(httpHeaders, "monitor_ts_agg", queryId != null && queryId.length() > 0 ? queryId : instanceId, openSearch.getOpenSearchService(), index, finalQuery);
            return Response.ok((Object)new MonitorTimeseriesAggregationDataImpl(searchResponse, allBeforeStartDateResponse, allAfterEndDateResponse)).build();
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "getMonitorTimeseriesAggregation query could not be executed.", e);
            return ErrorResponse.forException((Exception)e).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    private QueryBuilder createTsAggregationQuery(String view, String startDate, String endDate, String timeseriesColumn, UserSession userSession, String timeZoneId, ModuleInstance mi, Map<String, Object> dataFilterSetting, String filtersAsJsonArray, BpcIndexMapping indexMapping, String dataFilterOperator) throws IOException {
        return QueryBuilders.boolQuery().must(new BpcQueryBuilder().addQueryBuilder(DateRangeQuery.getQueryBuilder(view, startDate, endDate, timeseriesColumn, userSession, timeZoneId, mi, dataFilterSetting, dataFilterOperator)).buildAsBoolMustQuery()).must(new BpcQueryBuilder().addSkipPercolatorDocumentsQuery().addQueriesForFilters(filtersAsJsonArray, indexMapping, timeZoneId).buildAsBoolFilterQuery());
    }

    @Produces(value={"application/json"})
    @GET
    @Path(value="/{instanceId}/details/{processId:.+}")
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcUserSessionRequired
    public Response getMonitorDetailData(@Context HttpHeaders httpHeaders, @PathParam(value="instanceId") String instanceId, @PathParam(value="processId") String processId, @QueryParam(value="start") Integer start, @QueryParam(value="limit") Integer limit, @QueryParam(value="view") String view, @QueryParam(value="timezoneOffset") String timezoneOffset, @QueryParam(value="timezoneName") String timezoneName, @QueryParam(value="sort") String sort, @QueryParam(value="queryId") String queryId, @Context UserSession userSession) {
        LOG.info("getMonitorDetailData");
        try {
            if (start == null || start < 0) {
                start = 0;
                LOG.finest("Not start parameter or out of range. Set start to " + start);
            }
            if (limit == null || limit < 0 || limit > 10000) {
                limit = 300;
                LOG.finest("Not limit parameter or out of range. Set limit to " + limit);
            }
            MonitorModuleInstance mi = this.getMonitorModuleInstance(instanceId, userSession);
            MonitorServiceImpl monitorService = (MonitorServiceImpl)this.monitorServiceTracker.getService();
            if (!monitorService.hasUserAccessToProcesses(userSession, (ModuleInstance)mi, Collections.singleton(processId))) {
                throw new ProcessAccessNotAllowedException(processId);
            }
            String timeZoneId = TimeZoneUtil.evalTimeZoneId((String)timezoneOffset, (String)timezoneName);
            OpenSearch openSearch = MonitorModule.getInstance().getOpenSearch();
            RestHighLevelClient osClient = openSearch.getClient();
            String index = mi.getConfiguration().getSettingValue("data_historyIndex").asString("").toLowerCase();
            LOG.info("history index: " + index);
            if (!monitorService.isIndexAccessAllowed(index)) {
                throw new IndexAccessNotAllowedException(index);
            }
            BpcIndexMapping indexMapping = new BpcIndexMapping(openSearch.getOpenSearchService().getMappingMetaData(index));
            String idField = (String)mi.getConfiguration().getSetting("column_historyId").getValue();
            String idQueryField = indexMapping.getPreferredQueryFieldForIDs(idField);
            BpcDataFilter detailFilter = new BpcDataFilterBuilder().withOperator("term").withProperty(idQueryField).withValue(processId).build();
            QueryBuilder osQuery = new BpcQueryBuilder().addQueryForFilter(detailFilter, indexMapping, timeZoneId).addSkipPercolatorDocumentsQuery().buildAsBoolFilterQuery();
            SearchSourceBuilder ssb = new SearchSourceBuilder().from(start.intValue()).size(limit.intValue()).query(osQuery);
            for (SortBuilder sortBuilder : BpcSortBuilder.init((BpcIndexMapping)indexMapping).addSortFromJsonArray(sort).build()) {
                ssb.sort(sortBuilder);
            }
            SearchRequest sr = new SearchRequest().indices(new String[]{index}).source(ssb);
            LOG.info("query: " + sr);
            SearchResponse searchResponse = osClient.search(sr, RequestOptions.DEFAULT);
            LOG.info("TotalHits: " + searchResponse.getHits().getTotalHits());
            MonitorModule.getInstance().keepOpenSearchQueryForWebsocketUpdates(httpHeaders, "monitor_details", (String)(queryId != null && queryId.length() > 0 ? queryId : instanceId + ":::" + processId), openSearch.getOpenSearchService(), index, osQuery);
            return Response.ok((Object)new MonitorDataImpl(searchResponse, index)).build();
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "getMonitorDetailData query could not be executed.", e);
            return ErrorResponse.forException((Exception)e).usingTracker(this.errorResponseServiceTracker).languageFrom(httpHeaders).build();
        }
    }

    @Produces(value={"application/json"})
    @GET
    @Path(value="/{instanceId}/distinctFieldValues/{fieldName}")
    @BpcUserSessionRequired
    public Response getDistinctFieldValues(@Context HttpHeaders httpHeaders, @PathParam(value="instanceId") String instanceId, @PathParam(value="fieldName") String fieldName, @QueryParam(value="size") Integer size, @QueryParam(value="view") String view, @QueryParam(value="query") String query, @QueryParam(value="filter") String filtersAsJsonArray, @QueryParam(value="order") String order, @QueryParam(value="queryId") String queryId, @QueryParam(value="startDate") String startDate, @QueryParam(value="endDate") String endDate, @QueryParam(value="timeseriesColumn") String timeseriesColumn, @QueryParam(value="timezoneOffset") String timezoneOffset, @QueryParam(value="timezoneName") String timezoneName, @QueryParam(value="source") String source, @DefaultValue(value="") @QueryParam(value="fromChild") String fromChild, @Context UserSession userSession) {
        LOG.info("getDistinctFieldValues instanceId=" + instanceId + ", fieldName=" + fieldName + ", query=" + query);
        try {
            Terms distinctValues;
            TermsAggregationBuilder aggregation;
            Boolean resourceSavingMode;
            OpenSearch openSearch = MonitorModule.getInstance().getOpenSearch();
            long currentTimestamp = System.currentTimeMillis();
            String searchIdPrefix = MonitorModule.getInstance().createSearchIdPrefix(httpHeaders, "monitor_distinct", queryId != null && queryId.length() > 0 ? queryId : instanceId);
            MonitorModule.getInstance().cancelRunningSearchTasks(openSearch, searchIdPrefix, currentTimestamp);
            if (size == null || size < 1 || size > 1000) {
                size = 50;
                LOG.info("No start parameter or out of range. Set start to " + size);
            }
            if (query == null) {
                query = "";
            }
            BucketOrder osOrder = BucketOrder.key((boolean)true);
            if (order != null && order.equalsIgnoreCase("count")) {
                osOrder = BucketOrder.count((boolean)false);
            }
            filtersAsJsonArray = SessionBasedQuery.prepareFilterString(userSession, filtersAsJsonArray);
            query = SessionBasedQuery.prepareFilterString(userSession, query);
            if (filtersAsJsonArray != null && filtersAsJsonArray.length() > 10000) {
                throw new FilterLengthLimitException(10000, filtersAsJsonArray.length());
            }
            MonitorModuleInstance mi = this.getMonitorModuleInstance(instanceId, userSession);
            Setting setting = mi.getConfiguration().getSetting("resource_saving_mode");
            if (setting != null && (resourceSavingMode = (Boolean)setting.getValue()).equals(Boolean.TRUE)) {
                throw new ResourceUnavailableInResourceSavingModeException();
            }
            String timeZoneId = TimeZoneUtil.evalTimeZoneId((String)timezoneOffset, (String)timezoneName);
            RestHighLevelClient osClient = openSearch.getClient();
            boolean childRequest = fromChild != null && fromChild.length() > 0 && fromChild.equals("true");
            String requestIndexSettingField = childRequest ? "data_historyIndex" : "data_index";
            String index = mi.getConfiguration().getSettingValue(requestIndexSettingField).asString("").toLowerCase();
            LOG.finest("index: " + index);
            if (!((MonitorService)this.monitorServiceTracker.getService()).isIndexAccessAllowed(index)) {
                throw new IndexAccessNotAllowedException(index);
            }
            BpcIndexMapping indexMapping = new BpcIndexMapping(openSearch.getOpenSearchService().getMappingMetaData(index));
            Object targetFieldName = fieldName;
            if (source != null && source.length() > 0 && indexMapping.hasMultiField(fieldName, source)) {
                targetFieldName = fieldName + "." + source;
                if (!source.equalsIgnoreCase("raw")) {
                    query = query.toLowerCase();
                }
            }
            if (indexMapping.getFieldType(fieldName).equalsIgnoreCase("text")) {
                if (!query.isEmpty()) {
                    FilterAggregationBuilder filterAggregation = AggregationBuilders.filter((String)"filteredValues", (QueryBuilder)QueryBuilders.wildcardQuery((String)(fieldName + ".lowercase"), (String)("*" + query.toLowerCase() + "*")));
                    aggregation = ((TermsAggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"distinctValues").field((String)targetFieldName)).missing((Object)"!")).size(size.intValue()).order(osOrder);
                    filterAggregation.subAggregation((AggregationBuilder)aggregation);
                    aggregation = filterAggregation;
                } else {
                    aggregation = ((TermsAggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"distinctValues").field((String)targetFieldName)).missing((Object)"!")).size(size.intValue()).includeExclude(new IncludeExclude(".*" + QueryParser.escape((String)query) + ".*", null)).order(osOrder);
                }
            } else {
                aggregation = ((TermsAggregationBuilder)AggregationBuilders.terms((String)"distinctValues").field((String)targetFieldName)).size(size.intValue()).order(osOrder);
            }
            SearchSourceBuilder ssb = new SearchSourceBuilder().size(0).aggregation((AggregationBuilder)aggregation);
            SearchRequest sr = new SearchRequest().indices(new String[]{index}).source(ssb);
            if (!childRequest) {
                String dataFilterOperator = mi.getConfiguration().getSettingValue("data_filter_operator").asString("").toLowerCase();
                BoolQueryBuilder finalQuery = QueryBuilders.boolQuery().must(new BpcQueryBuilder().addQueryBuilder(SessionBasedQuery.getQueryBuilder(userSession, mi.getConfiguration().getSettingValue("data_filter").asMap(null), dataFilterOperator)).addQueryBuilder(ViewQuery.getQueryBuilder((ModuleInstance)mi, view, userSession)).addDateRangeQuery(timeseriesColumn, startDate, endDate, timeZoneId).buildAsBoolMustQuery()).must(new BpcQueryBuilder().addSkipPercolatorDocumentsQuery().addQueriesForFilters(filtersAsJsonArray, indexMapping, timeZoneId).buildAsBoolFilterQuery());
                ssb.query((QueryBuilder)finalQuery);
                LOG.finest("Query: " + ssb.toString());
                MonitorModule.getInstance().keepOpenSearchQueryForWebsocketUpdates(httpHeaders, "monitor_distinct", queryId != null && queryId.length() > 0 ? queryId : instanceId, openSearch.getOpenSearchService(), index, (QueryBuilder)finalQuery);
            }
            SearchResponse searchResponse = osClient.search(sr, MonitorModule.getInstance().getRequestOptionsWithXOpaqueIdHeader(searchIdPrefix, currentTimestamp));
            LOG.finest("TotalHits: " + searchResponse.getHits().getTotalHits());
            if (!query.isEmpty()) {
                Filter filteredValues = (Filter)searchResponse.getAggregations().get("filteredValues");
                distinctValues = (Terms)filteredValues.getAggregations().get("distinctValues");
            } else {
                distinctValues = (Terms)searchResponse.getAggregations().get("distinctValues");
            }
            ArrayNode resultArray = this.om.createArrayNode();
            for (Terms.Bucket entry : distinctValues.getBuckets()) {
                ObjectNode resultEntry = this.om.createObjectNode();
                resultEntry.put("value", entry.getKeyAsString());
                resultEntry.put("count", entry.getDocCount());
                resultArray.add((JsonNode)resultEntry);
            }
            ObjectNode resultDocument = this.om.createObjectNode();
            resultDocument.putArray("values").addAll(resultArray);
            return Response.ok((Object)resultDocument).build();
        }
        catch (Exception e) {
            if (MonitorModule.getInstance().isTaskCancelledException(e)) {
                ObjectNode resultDocument = this.om.createObjectNode();
                resultDocument.putArray("values");
                return Response.ok((Object)resultDocument).build();
            }
            LOG.log(Level.SEVERE, "getDistinctFieldValues query could not be executed.", e);
            return ErrorResponse.forException((Exception)e).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @Produces(value={"application/json"})
    @GET
    @Path(value="/{instanceId}/data/{parentId}/{childId}/{fieldName}")
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcUserSessionRequired
    public Response getChildData(@PathParam(value="instanceId") String instanceId, @PathParam(value="parentId") String parentId, @PathParam(value="childId") String childId, @PathParam(value="fieldName") String fieldName, @QueryParam(value="noContentDisposition") String noContentDisposition, @Context UriInfo uriInfo, @Context SecurityContext secContext, @Context UserSession userSession, @Context HttpHeaders headers) {
        LOG.finest("getChildData");
        try {
            BoolQueryBuilder getDocumentQuery;
            MonitorModuleInstance mi = this.getMonitorModuleInstance(instanceId, userSession);
            MonitorServiceImpl monitorService = (MonitorServiceImpl)this.monitorServiceTracker.getService();
            if (!monitorService.hasUserAccessToProcesses(userSession, (ModuleInstance)mi, Collections.singleton(parentId))) {
                throw new ProcessAccessNotAllowedException(parentId);
            }
            OpenSearch openSearch = MonitorModule.getInstance().getOpenSearch();
            RestHighLevelClient osClient = openSearch.getClient();
            String index = childId.equals("undefined") || childId.equals("null") ? mi.getConfiguration().getSettingValue("data_index").asString("").toLowerCase() : mi.getConfiguration().getSettingValue("data_historyIndex").asString("").toLowerCase();
            if (!monitorService.isIndexAccessAllowed(index)) {
                throw new IndexAccessNotAllowedException(index);
            }
            String childHistoryId = (String)mi.getConfiguration().getSetting("column_historyId").getValue();
            String idColumn = (String)mi.getConfiguration().getSetting("column_id").getValue();
            String childHistorySubId = (String)mi.getConfiguration().getSetting("column_historySubId").getValue();
            String inubitProxyId = (String)mi.getConfiguration().getSetting("inubit_proxyId").getValue();
            String baseUrl = (String)mi.getConfiguration().getSetting("inubit_baseUrl").getValue();
            String tablePrefix = (String)mi.getConfiguration().getSetting("inubit_dbTablePrefix").getValue();
            String referenceEndpoint = (String)mi.getConfiguration().getSetting("inubit_referenceEndpoint").getValue();
            String fileField = (String)mi.getConfiguration().getSetting("column_file").getValue();
            BpcIndexMapping indexMapping = new BpcIndexMapping(openSearch.getOpenSearchService().getMappingMetaData(index));
            if (childId.equals("undefined") || childId.equals("null")) {
                String idColumnQueryField = indexMapping.getPreferredQueryFieldForIDs(idColumn);
                getDocumentQuery = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.existsQuery((String)idColumnQueryField)).must((QueryBuilder)QueryBuilders.matchQuery((String)idColumnQueryField, (Object)parentId));
            } else {
                String childHistoryIdQueryField = indexMapping.getPreferredQueryFieldForIDs(childHistoryId);
                String childHistorySubIdQueryField = indexMapping.getPreferredQueryFieldForIDs(childHistorySubId);
                getDocumentQuery = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.existsQuery((String)childHistoryIdQueryField)).must((QueryBuilder)QueryBuilders.matchQuery((String)childHistoryIdQueryField, (Object)parentId)).must((QueryBuilder)QueryBuilders.existsQuery((String)childHistorySubIdQueryField)).must((QueryBuilder)QueryBuilders.matchQuery((String)childHistorySubIdQueryField, (Object)childId));
            }
            QueryBuilder query = new BpcQueryBuilder().addSkipPercolatorDocumentsQuery().addQueryBuilder((QueryBuilder)getDocumentQuery).buildAsBoolMustQuery();
            SearchRequest searchReq = new SearchRequest().indices(new String[]{index}).source(new SearchSourceBuilder().from(0).size(1).query(query));
            SearchResponse sr = osClient.search(searchReq, RequestOptions.DEFAULT);
            if (sr.isTimedOut() || sr.getHits().getTotalHits().value == 0L) {
                LOG.log(Level.SEVERE, "Elastic search response does not exist");
                return Response.noContent().status(Response.Status.NOT_FOUND).build();
            }
            SearchHit searchHit = sr.getHits().getHits()[0];
            LoadedOpenSearchData dataFromOpenSearch = this.getDownloadableDataFromSearchHit(searchHit, fieldName);
            if (dataFromOpenSearch != null) {
                LOG.info("File loaded from OpenSearch");
                Response.ResponseBuilder responseBuilder = Response.ok((Object)dataFromOpenSearch.data, (String)dataFromOpenSearch.contentType);
                if (!"true".equalsIgnoreCase(noContentDisposition)) {
                    responseBuilder = responseBuilder.header("Content-Disposition", (Object)("attachment; filename=\"" + dataFromOpenSearch.filename + "\""));
                }
                return responseBuilder.build();
            }
            Map source = searchHit.getSourceAsMap();
            String directory = (String)source.get(fileField);
            Object fallbackQuery = uriInfo.getRequestUri().getQuery();
            fallbackQuery = fallbackQuery == null ? "" : (String)fallbackQuery + "&";
            if (childId.equals("undefined") || childId.equals("null")) {
                fallbackQuery = (String)fallbackQuery + "directory=" + URLEncoder.encode(directory, StandardCharsets.UTF_8);
                fallbackQuery = (String)fallbackQuery + "&processid=" + URLEncoder.encode(parentId, StandardCharsets.UTF_8);
                fallbackQuery = (String)fallbackQuery + "&prefix=" + URLEncoder.encode(tablePrefix, StandardCharsets.UTF_8);
            } else {
                fallbackQuery = (String)fallbackQuery + "directory=" + URLEncoder.encode(directory, StandardCharsets.UTF_8);
                fallbackQuery = (String)fallbackQuery + "&processid=" + URLEncoder.encode(parentId, StandardCharsets.UTF_8);
                fallbackQuery = (String)fallbackQuery + "&childid=" + URLEncoder.encode(childId, StandardCharsets.UTF_8);
                fallbackQuery = (String)fallbackQuery + "&prefix=" + URLEncoder.encode(tablePrefix, StandardCharsets.UTF_8);
            }
            String targetPath = StringUtil.glue((String)baseUrl, (String)referenceEndpoint, (char)'/') + "?" + (String)fallbackQuery;
            LOG.info("Get file content by using the http proxy ... inubitProxyId=" + inubitProxyId + ", targetPath=" + targetPath);
            return ((HttpProxyService)this.httpProxyServiceTracker.getService()).doGet(inubitProxyId, targetPath, null, null, headers, userSession, false);
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "failed to retrieve item - Exception", e);
            return ErrorResponse.forException((Exception)e).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    private LoadedOpenSearchData getDownloadableDataFromSearchHit(SearchHit searchHit, String fieldName) {
        if (searchHit != null && fieldName != null) {
            Map source = searchHit.getSourceAsMap();
            String contentType = (String)source.get("contentType");
            String filename = (String)source.get("filename");
            String fieldData = (String)source.get(fieldName);
            if (contentType != null && filename != null && fieldData != null && Base64.isBase64((String)fieldData)) {
                return new LoadedOpenSearchData(contentType, filename, Base64.decodeBase64((String)fieldData));
            }
        }
        return null;
    }

    private String getMultipartFormDataBoundary(HttpHeaders headers) {
        Pattern boundaryPattern;
        Matcher m;
        LOG.info("getMultipartFormDataBoundary headers=" + headers);
        String boundary = null;
        String contentType = headers.getHeaderString("Content-Type");
        if (contentType != null && contentType.contains("boundary") && (m = (boundaryPattern = Pattern.compile("boundary=\"?([^\";]*)")).matcher(contentType)).find()) {
            boundary = "--" + m.group(1);
        }
        return boundary;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String extractSingleLineFieldValueFromMultipartFormData(String fieldName, String boundary, byte[] body) {
        Monitor.LOG.info("extractSingleLineFieldValueFromMultipartFormData fieldName=" + fieldName + ", boundary=" + boundary + ", body=...");
        if (fieldName == null) return null;
        if (boundary == null) return null;
        if (body == null) {
            return null;
        }
        try {
            reader = new BufferedReader(new StringReader(new String(body)));
            try {
                block8: while (true) {
                    if ((line = reader.readLine()) == null) return null;
                    if (!line.equals(boundary) || !(line = reader.readLine()).startsWith("Content-Disposition:")) continue;
                    contentDispositionValue = line.substring(line.indexOf(":") + 1);
                    values = StringUtil.explode((String)contentDispositionValue, (String)";");
                    var8_11 = values.iterator();
                    do {
                        if (var8_11.hasNext()) ** break;
                        continue block8;
                    } while (!(value = (String)var8_11.next()).equals(formFieldName = "name=\"" + fieldName + "\""));
                    break;
                }
                line = reader.readLine();
                var11_14 = line = reader.readLine();
                return var11_14;
            }
            finally {
                reader.close();
            }
        }
        catch (Exception ex) {
            Monitor.LOG.log(Level.SEVERE, "Failed to parse the given multipart form data.", ex);
        }
        return null;
    }

    @POST
    @Path(value="/httpProxy/{instanceId}{targetPath: (/.*)?}")
    @BpcUserSessionRequired(skipCsrfCheck="true")
    public Response proxyPost(@PathParam(value="instanceId") String proxyInstanceId, @PathParam(value="targetPath") @Encoded @DefaultValue(value="") String targetPath, @QueryParam(value="targetUrl") String targetUrl, @DefaultValue(value="false") @QueryParam(value="forceJson") boolean forceJson, @Context HttpHeaders headers, @Context UriInfo uriInfo, @Context UserSession userSession, byte[] body) {
        LOG.log(Level.FINEST, "proxyPost : proxyInstanceId={1} uriInfo={0} ", new Object[]{uriInfo, proxyInstanceId});
        try {
            Set<String> processIDs;
            boolean isMultipartFormDataBody = false;
            String monitorInstanceId = headers.getHeaderString("X-BPC-ModuleId");
            if (monitorInstanceId == null) {
                String multiPartFormDataBoundary = this.getMultipartFormDataBoundary(headers);
                if (multiPartFormDataBoundary != null) {
                    isMultipartFormDataBody = true;
                    monitorInstanceId = this.extractSingleLineFieldValueFromMultipartFormData("X-BPC-ModuleId", multiPartFormDataBoundary, body);
                } else {
                    LOG.info("Did not found the mandatory 'boundary' (multipart form data) in the given 'Content-Type' header value.");
                }
            }
            MonitorServiceImpl monitorService = (MonitorServiceImpl)this.monitorServiceTracker.getService();
            MonitorModuleInstance mi = this.getMonitorModuleInstance(monitorInstanceId, userSession);
            String index = mi.getConfiguration().getSettingValue("data_index").asString("").toLowerCase();
            LOG.info("index: " + index);
            if (!monitorService.isIndexAccessAllowed(index)) {
                throw new IndexAccessNotAllowedException(index);
            }
            String processIdField = (String)mi.getConfiguration().getSetting("column_id").getValue();
            LOG.info("processIdField: " + processIdField);
            processIdField = processIdField.toLowerCase();
            LOG.info("processIdField (like set/used by the frontend): " + processIdField);
            if (!(isMultipartFormDataBody || (processIDs = this.getProcessIDs(body, processIdField)).isEmpty() || monitorService.hasUserAccessToProcesses(userSession, (ModuleInstance)mi, processIDs))) {
                throw new ProcessAccessNotAllowedException(processIDs);
            }
            return ((HttpProxyService)this.httpProxyServiceTracker.getService()).doPost(proxyInstanceId, targetPath, targetUrl, uriInfo, headers, userSession, body, forceJson);
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, "Exception backend connection: ", ex);
            return ErrorResponse.forException((Exception)ex).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    private Set<String> getProcessIDs(byte[] body, String processIdField) throws UnsupportedEncodingException {
        String singleProcessId;
        HashSet<String> result = new HashSet<String>();
        String bodyAsString = new String(body);
        Map bodyParams = UriQueryUtil.getQueryParams((String)bodyAsString);
        if (result.isEmpty() && bodyParams.containsKey("command") && ((String)bodyParams.get("command")).equals("StatusChange")) {
            String processes = (String)bodyParams.get("processes");
            List processIDs = StringUtil.explode((String)processes, (String)";");
            result.addAll(processIDs);
        }
        if (result.isEmpty() && (singleProcessId = (String)bodyParams.get(processIdField)) != null) {
            result.add(singleProcessId);
        }
        if (result.isEmpty()) {
            String multipleSelectedProcessIdField;
            String multipleSelectedProcessId;
            for (int index = 0; index < Integer.MAX_VALUE && (multipleSelectedProcessId = (String)bodyParams.get(multipleSelectedProcessIdField = "index" + index + "_" + processIdField)) != null; ++index) {
                result.add(multipleSelectedProcessId);
            }
        }
        if (result.isEmpty() && bodyParams.containsKey("request")) {
            String string = (String)bodyParams.get("request");
        }
        return result;
    }

    private static class LoadedOpenSearchData {
        String contentType;
        String filename;
        byte[] data;

        public LoadedOpenSearchData(String contentType, String filename, byte[] data) {
            this.contentType = contentType;
            this.filename = filename;
            this.data = data;
        }
    }
}

